/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.input;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DAreaListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;

class AreaManager {
    private static final int LIST_START_SIZE = 25;
    private static final int LIST_INCREMENT = 25;
    private BranchGroup worldRoot;
    private HashSet activeObjects;
    private HashSet newObjects;
    private J3DAreaListener[] list;
    private int lastListener = 0;
    private PickPoint picker = new PickPoint();

    AreaManager() {
        this.activeObjects = new HashSet();
        this.newObjects = new HashSet();
        this.list = new J3DAreaListener[25];
    }

    public void addSensor(VRMLSensorNodeType vRMLSensorNodeType) {
    }

    public void removeSensor(VRMLSensorNodeType vRMLSensorNodeType) {
    }

    public void setWorldRoot(BranchGroup branchGroup) {
        this.worldRoot = branchGroup;
    }

    public void clear() {
        this.activeObjects.clear();
        this.newObjects.clear();
    }

    public void processFrame(Point3d point3d, Vector3d vector3d, Transform3D transform3D, float f, float f2) {
        Object object;
        int n;
        if (this.worldRoot == null) {
            return;
        }
        this.picker.set(point3d);
        SceneGraphPath[] sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.picker);
        if (sceneGraphPathArray != null && sceneGraphPathArray.length != 0) {
            this.newObjects.clear();
            for (n = 0; n < sceneGraphPathArray.length; ++n) {
                Node node = sceneGraphPathArray[n].getObject();
                object = (J3DUserData)((Object)node.getUserData());
                if (object == null || object.areaListener == null) continue;
                J3DAreaListener j3DAreaListener = object.areaListener;
                Transform3D transform3D2 = sceneGraphPathArray[n].getTransform();
                if (this.activeObjects.contains((Object)j3DAreaListener)) {
                    j3DAreaListener.userPositionChanged(point3d, vector3d, transform3D, transform3D2);
                    this.activeObjects.remove((Object)j3DAreaListener);
                } else {
                    j3DAreaListener.areaEntry(point3d, vector3d, transform3D, transform3D2);
                }
                this.newObjects.add((Object)j3DAreaListener);
            }
        }
        if ((n = this.activeObjects.size()) != 0) {
            this.resizeList(n);
            this.activeObjects.toArray((Object[])this.list);
            for (int i = 0; i < n && this.list[i] != null; ++i) {
                object = this.list[i];
                object.areaExit();
                this.activeObjects.remove(object);
            }
        }
        HashSet hashSet = this.activeObjects;
        this.activeObjects = this.newObjects;
        this.newObjects = hashSet;
    }

    private final void resizeList(int n) {
        if (this.list.length < n) {
            int n2 = this.list.length;
            int n3 = n2 + 25;
            J3DAreaListener[] j3DAreaListenerArray = new J3DAreaListener[n3];
            System.arraycopy(this.list, 0, j3DAreaListenerArray, 0, n2);
            this.list = j3DAreaListenerArray;
        }
    }
}

