/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.input;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.j3d.geom.GeometryData;
import org.j3d.renderer.java3d.util.J3DIntersectionUtils;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.j3d.input.J3DPickingManager;
import org.web3d.vrml.renderer.j3d.nodes.J3DPickingSensorNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;
import org.web3d.vrml.util.NodeArray;

public class DefaultPickingManager
implements J3DPickingManager {
    private static final int ARRAY_INC = 50;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private NodeArray sensorList = new NodeArray();
    private HashSet activeSensors = new HashSet();
    private HashMap activePaths = new HashMap();
    private HashMap pathLinkStatus = new HashMap();
    private BranchGroup worldRoot;
    private PickConeSegment conePicker;
    private PickBounds boxPicker;
    private BoundingBox boxBounds = new BoundingBox();
    private PickBounds spherePicker;
    private BoundingSphere sphereBounds = new BoundingSphere();
    private PickCylinderSegment cylinderPicker;
    private PickSegment linePicker;
    private PickPoint pointPicker;
    private int lastNodeIndex;
    private int lastCoordIndex;
    private VRMLNodeType[] nodeList;
    private float[] coordList;
    private float[] normalList;
    private float[] textureList;
    private Point3d tmpPoint1;
    private Point3d tmpPoint2;
    private Point3d wkPoint;
    private Vector3d wkDirection;
    private Transform3D pickTransform;
    private J3DIntersectionUtils iutils;
    private float[] hitPoint;
    private float[] hitNormal;
    private float[] hitTexCoord;
    private Vector3d diffVec;

    public DefaultPickingManager() {
        this.conePicker = new PickConeSegment();
        this.boxPicker = new PickBounds((Bounds)this.boxBounds);
        this.spherePicker = new PickBounds((Bounds)this.sphereBounds);
        this.cylinderPicker = new PickCylinderSegment();
        this.linePicker = new PickSegment();
        this.pointPicker = new PickPoint();
        this.nodeList = new VRMLNodeType[100];
        this.coordList = new float[300];
        this.normalList = new float[300];
        this.textureList = new float[300];
        this.hitPoint = new float[3];
        this.hitNormal = new float[3];
        this.hitTexCoord = new float[3];
        this.tmpPoint1 = new Point3d();
        this.tmpPoint2 = new Point3d();
        this.wkPoint = new Point3d();
        this.wkDirection = new Vector3d();
        this.diffVec = new Vector3d();
        this.pickTransform = new Transform3D();
        this.iutils = new J3DIntersectionUtils();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setWorldRoot(BranchGroup branchGroup) {
        this.worldRoot = branchGroup;
    }

    public void processPickSensors(double d) {
        int n = this.sensorList.size();
        for (int i = 0; i < n; ++i) {
            Map map;
            J3DPickingSensorNodeType j3DPickingSensorNodeType = (J3DPickingSensorNodeType)this.sensorList.get(i);
            if (!j3DPickingSensorNodeType.getEnabled() || (map = j3DPickingSensorNodeType.getTargetGroups()).size() == 0) continue;
            this.checkIntersections(j3DPickingSensorNodeType, map);
        }
    }

    public void addSensor(VRMLPickingSensorNodeType vRMLPickingSensorNodeType) {
        this.sensorList.add((VRMLNode)vRMLPickingSensorNodeType);
    }

    public void removeSensor(VRMLPickingSensorNodeType vRMLPickingSensorNodeType) {
        this.sensorList.remove((VRMLNode)vRMLPickingSensorNodeType);
    }

    public void loadScene(BasicScene basicScene) {
        ArrayList arrayList = basicScene.getByPrimaryType(73);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.sensorList.add((VRMLNode)((VRMLNodeType)arrayList.get(i)));
        }
    }

    public void unloadScene(BasicScene basicScene) {
        ArrayList arrayList = basicScene.getByPrimaryType(73);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.sensorList.remove((VRMLNode)((VRMLNodeType)arrayList.get(i)));
        }
    }

    public void clear() {
        this.sensorList.clear();
        this.activeSensors.clear();
    }

    private void checkIntersections(VRMLPickingSensorNodeType vRMLPickingSensorNodeType, Map map) {
        Boolean bl;
        VRMLNodeType vRMLNodeType = vRMLPickingSensorNodeType.getPickingGeometry();
        VRMLGeometryNodeType vRMLGeometryNodeType = this.findRealGeometry(vRMLNodeType);
        int n = vRMLPickingSensorNodeType.getSortOrder();
        int n2 = vRMLPickingSensorNodeType.getIntersectionType();
        J3DPickingSensorNodeType j3DPickingSensorNodeType = (J3DPickingSensorNodeType)vRMLPickingSensorNodeType;
        SceneGraphPath sceneGraphPath = null;
        if (this.activeSensors.contains((Object)vRMLPickingSensorNodeType)) {
            if (j3DPickingSensorNodeType.hasScenePathChanged()) {
                sceneGraphPath = j3DPickingSensorNodeType.getSceneGraphPath();
                bl = this.checkForLinks(sceneGraphPath) ? Boolean.TRUE : Boolean.FALSE;
                this.activePaths.put(vRMLPickingSensorNodeType, sceneGraphPath);
                this.pathLinkStatus.put(sceneGraphPath, bl);
            } else {
                sceneGraphPath = (SceneGraphPath)this.activePaths.get(vRMLPickingSensorNodeType);
            }
        } else {
            sceneGraphPath = j3DPickingSensorNodeType.getSceneGraphPath();
            bl = this.checkForLinks(sceneGraphPath) ? Boolean.TRUE : Boolean.FALSE;
            this.activePaths.put(vRMLPickingSensorNodeType, sceneGraphPath);
            this.pathLinkStatus.put(sceneGraphPath, bl);
        }
        switch (vRMLPickingSensorNodeType.getPickingType()) {
            case 1: {
                this.processPointPicking(sceneGraphPath, n2, n, vRMLGeometryNodeType, map);
                break;
            }
            case 2: {
                this.processLinePicking(sceneGraphPath, n2, n, vRMLGeometryNodeType, map);
                break;
            }
            case 3: {
                this.processSpherePicking(sceneGraphPath, n2, n, vRMLGeometryNodeType, map);
                break;
            }
            case 4: {
                this.processBoxPicking(sceneGraphPath, n2, n, vRMLGeometryNodeType, map);
                break;
            }
            case 5: {
                this.processConePicking(sceneGraphPath, n2, n, vRMLGeometryNodeType, map);
                break;
            }
            case 6: {
                this.processCylinderPicking(sceneGraphPath, n2, n, vRMLGeometryNodeType, map);
                break;
            }
            case 7: {
                this.processVolumePicking(sceneGraphPath, n2, n, vRMLGeometryNodeType, map);
                break;
            }
            default: {
                this.errorReporter.warningReport("Unknown picking type defined", null);
            }
        }
        try {
            if (this.lastNodeIndex != 0) {
                if (this.activeSensors.contains((Object)vRMLPickingSensorNodeType)) {
                    vRMLPickingSensorNodeType.notifyPickChange(this.lastNodeIndex, this.nodeList, this.coordList, this.normalList, this.textureList);
                } else {
                    this.activeSensors.add((Object)vRMLPickingSensorNodeType);
                    vRMLPickingSensorNodeType.notifyPickStart(this.lastNodeIndex, this.nodeList, this.coordList, this.normalList, this.textureList);
                }
            } else if (this.activeSensors.contains((Object)vRMLPickingSensorNodeType)) {
                vRMLPickingSensorNodeType.notifyPickEnd();
                this.activeSensors.remove((Object)vRMLPickingSensorNodeType);
                this.activePaths.remove(vRMLPickingSensorNodeType);
                this.pathLinkStatus.remove(sceneGraphPath);
            }
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Sending output to PickingSensor", exception);
        }
    }

    private void processPointPicking(SceneGraphPath sceneGraphPath, int n, int n2, VRMLGeometryNodeType vRMLGeometryNodeType, Map map) {
        VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType = (VRMLComponentGeometryNodeType)vRMLGeometryNodeType;
        VRMLNodeType[] vRMLNodeTypeArray = vRMLComponentGeometryNodeType.getComponents();
        if (vRMLNodeTypeArray == null || vRMLNodeTypeArray.length == 0) {
            return;
        }
        VRMLCoordinateNodeType vRMLCoordinateNodeType = null;
        for (int i = 0; i < vRMLNodeTypeArray.length && vRMLCoordinateNodeType == null; ++i) {
            vRMLCoordinateNodeType = this.findRealCoordinates(vRMLNodeTypeArray[i]);
        }
        if (vRMLCoordinateNodeType == null) {
            return;
        }
        this.lastNodeIndex = 0;
        this.lastCoordIndex = 0;
        float[] fArray = vRMLCoordinateNodeType.getPointRef();
        int n3 = vRMLCoordinateNodeType.getNumPoints() / 3;
        int n4 = 0;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (sceneGraphPath == null) {
            this.pickTransform.setIdentity();
        } else {
            Node node = sceneGraphPath.getObject();
            Boolean bl = (Boolean)this.pathLinkStatus.get(sceneGraphPath);
            if (bl.booleanValue()) {
                node.getLocalToVworld(sceneGraphPath, this.pickTransform);
            } else {
                node.getLocalToVworld(this.pickTransform);
            }
        }
        for (int i = 0; i < n3; ++i) {
            this.tmpPoint1.x = fArray[n4++];
            this.tmpPoint1.y = fArray[n4++];
            this.tmpPoint1.z = fArray[n4++];
            this.pickTransform.transform(this.tmpPoint1);
            this.pointPicker.set(this.tmpPoint1);
            sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.pointPicker);
            if (sceneGraphPathArray == null || sceneGraphPathArray.length == 0) continue;
            boolean bl = false;
            for (int j = 0; j < sceneGraphPathArray.length; ++j) {
                SceneGraphPath sceneGraphPath2 = sceneGraphPathArray[j];
                int n5 = sceneGraphPath2.nodeCount();
                bl = false;
                block7: for (int k = 0; !bl && k < n5; ++k) {
                    Node node = sceneGraphPath2.getNode(k);
                    if (!map.containsKey(node)) continue;
                    VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(node);
                    switch (n2) {
                        case 2: 
                        case 3: {
                            this.checkArraySize(1);
                            this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                            bl = false;
                            continue block7;
                        }
                        case 1: 
                        case 4: {
                            this.checkArraySize(1);
                            this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                            bl = true;
                        }
                    }
                }
            }
            if (bl) break;
        }
    }

    private void processLinePicking(SceneGraphPath sceneGraphPath, int n, int n2, VRMLGeometryNodeType vRMLGeometryNodeType, Map map) {
        VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType = (VRMLComponentGeometryNodeType)vRMLGeometryNodeType;
        VRMLNodeType[] vRMLNodeTypeArray = vRMLComponentGeometryNodeType.getComponents();
        if (vRMLNodeTypeArray == null || vRMLNodeTypeArray.length == 0) {
            return;
        }
        VRMLCoordinateNodeType vRMLCoordinateNodeType = null;
        for (int i = 0; i < vRMLNodeTypeArray.length && vRMLCoordinateNodeType == null; ++i) {
            vRMLCoordinateNodeType = this.findRealCoordinates(vRMLNodeTypeArray[i]);
        }
        if (vRMLCoordinateNodeType == null) {
            return;
        }
        int n3 = vRMLGeometryNodeType.getFieldIndex("coordIndex");
        int[] nArray = null;
        int n4 = 0;
        if (n3 != -1) {
            VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n3);
            nArray = vRMLFieldData.intArrayValue;
            n4 = vRMLFieldData.numElements;
        }
        this.lastNodeIndex = 0;
        this.lastCoordIndex = 0;
        float[] fArray = vRMLCoordinateNodeType.getPointRef();
        int n5 = vRMLCoordinateNodeType.getNumPoints() / 3;
        int n6 = 0;
        SceneGraphPath[] sceneGraphPathArray = null;
        if (sceneGraphPath == null) {
            this.pickTransform.setIdentity();
        } else {
            Node node = sceneGraphPath.getObject();
            Boolean bl = (Boolean)this.pathLinkStatus.get(sceneGraphPath);
            if (bl.booleanValue()) {
                node.getLocalToVworld(sceneGraphPath, this.pickTransform);
            } else {
                node.getLocalToVworld(this.pickTransform);
            }
        }
        if (n4 == 0) {
            boolean bl = false;
            block17: for (int i = 0; i < n5 && !bl; ++i) {
                VRMLNodeType vRMLNodeType;
                Node node;
                int n7;
                int n8;
                SceneGraphPath sceneGraphPath2;
                int n9;
                boolean bl2;
                int n10;
                this.tmpPoint1.x = fArray[n6++];
                this.tmpPoint1.y = fArray[n6++];
                this.tmpPoint1.z = fArray[n6++];
                this.tmpPoint2.x = fArray[n6++];
                this.tmpPoint2.y = fArray[n6++];
                this.tmpPoint2.z = fArray[n6++];
                this.pickTransform.transform(this.tmpPoint1);
                this.pickTransform.transform(this.tmpPoint2);
                this.linePicker.set(this.tmpPoint1, this.tmpPoint2);
                if (n != 1) {
                    sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.linePicker);
                    n10 = sceneGraphPathArray == null ? 0 : sceneGraphPathArray.length;
                    bl2 = false;
                    for (n9 = 0; n9 < sceneGraphPathArray.length; ++n9) {
                        sceneGraphPath2 = sceneGraphPathArray[n9];
                        n8 = sceneGraphPath2.nodeCount();
                        bl2 = false;
                        block19: for (n7 = 0; !bl2 && n7 < n8; ++n7) {
                            node = sceneGraphPath2.getNode(n7);
                            if (!map.containsKey(node)) continue;
                            vRMLNodeType = (VRMLNodeType)map.get(node);
                            this.wkDirection.x = this.tmpPoint2.x - this.tmpPoint1.x;
                            this.wkDirection.y = this.tmpPoint2.y - this.tmpPoint1.y;
                            this.wkDirection.z = this.tmpPoint2.z - this.tmpPoint1.z;
                            double d = this.detailLinePick(sceneGraphPath2);
                            if (d < 0.0) {
                                bl2 = true;
                                continue;
                            }
                            switch (n2) {
                                case 2: 
                                case 3: {
                                    this.checkArraySize(1);
                                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                    this.coordList[this.lastCoordIndex] = this.hitPoint[0];
                                    this.coordList[this.lastCoordIndex + 1] = this.hitPoint[1];
                                    this.coordList[this.lastCoordIndex + 2] = this.hitPoint[2];
                                    this.normalList[this.lastCoordIndex] = this.hitNormal[0];
                                    this.normalList[this.lastCoordIndex + 1] = this.hitNormal[1];
                                    this.normalList[this.lastCoordIndex + 2] = this.hitNormal[2];
                                    this.textureList[this.lastCoordIndex] = this.hitTexCoord[0];
                                    this.textureList[this.lastCoordIndex + 1] = this.hitTexCoord[1];
                                    this.textureList[this.lastCoordIndex + 2] = this.hitTexCoord[2];
                                    this.lastCoordIndex += 3;
                                    bl2 = false;
                                    continue block19;
                                }
                                case 1: 
                                case 4: {
                                    this.checkArraySize(1);
                                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                    this.coordList[this.lastCoordIndex] = this.hitPoint[0];
                                    this.coordList[this.lastCoordIndex + 1] = this.hitPoint[1];
                                    this.coordList[this.lastCoordIndex + 2] = this.hitPoint[2];
                                    this.normalList[this.lastCoordIndex] = this.hitNormal[0];
                                    this.normalList[this.lastCoordIndex + 1] = this.hitNormal[1];
                                    this.normalList[this.lastCoordIndex + 2] = this.hitNormal[2];
                                    this.textureList[this.lastCoordIndex] = this.hitTexCoord[0];
                                    this.textureList[this.lastCoordIndex + 1] = this.hitTexCoord[1];
                                    this.textureList[this.lastCoordIndex + 2] = this.hitTexCoord[2];
                                    this.lastCoordIndex += 3;
                                    bl2 = true;
                                }
                            }
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    continue;
                }
                switch (n2) {
                    case 1: 
                    case 3: {
                        sceneGraphPathArray = this.worldRoot.pickAllSorted((PickShape)this.linePicker);
                        n10 = sceneGraphPathArray == null ? 0 : sceneGraphPathArray.length;
                        bl2 = false;
                        block20: for (n9 = 0; !bl2 && n9 < n10; ++n9) {
                            sceneGraphPath2 = sceneGraphPathArray[n9];
                            n8 = sceneGraphPath2.nodeCount();
                            bl2 = false;
                            for (n7 = 0; !bl2 && n7 < n8; ++n7) {
                                node = sceneGraphPath2.getNode(n7);
                                if (!map.containsKey(node)) continue;
                                vRMLNodeType = (VRMLNodeType)map.get(node);
                                this.checkArraySize(1);
                                this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                if (n2 != 1) continue block20;
                                bl2 = true;
                                continue block20;
                            }
                        }
                        continue block17;
                    }
                    case 2: 
                    case 4: {
                        sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.linePicker);
                        n10 = sceneGraphPathArray == null ? 0 : sceneGraphPathArray.length;
                        bl2 = false;
                        block22: for (n9 = 0; !bl2 && n9 < n10; ++n9) {
                            sceneGraphPath2 = sceneGraphPathArray[n9];
                            n8 = sceneGraphPath2.nodeCount();
                            bl2 = false;
                            for (n7 = 0; !bl2 && n7 < n8; ++n7) {
                                node = sceneGraphPath2.getNode(n7);
                                if (!map.containsKey(node)) continue;
                                vRMLNodeType = (VRMLNodeType)map.get(node);
                                this.checkArraySize(1);
                                this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                bl = true;
                                if (n2 != 4) continue block22;
                                bl2 = true;
                                continue block22;
                            }
                        }
                        continue block17;
                    }
                }
            }
        } else {
            for (int i = 0; i < n4 - 1; ++i) {
                VRMLNodeType vRMLNodeType;
                Node node;
                int n11;
                int n12;
                SceneGraphPath sceneGraphPath3;
                int n13;
                boolean bl;
                int n14;
                int n15 = nArray[i] * 3;
                int n16 = nArray[i + 1] * 3;
                if (n16 < 0) {
                    ++i;
                    continue;
                }
                this.tmpPoint1.x = fArray[n15];
                this.tmpPoint1.y = fArray[n15 + 1];
                this.tmpPoint1.z = fArray[n15 + 2];
                this.tmpPoint2.x = fArray[n16];
                this.tmpPoint2.y = fArray[n16 + 1];
                this.tmpPoint2.z = fArray[n16 + 2];
                this.pickTransform.transform(this.tmpPoint1);
                this.pickTransform.transform(this.tmpPoint2);
                this.linePicker.set(this.tmpPoint1, this.tmpPoint2);
                if (n != 1) {
                    sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.linePicker);
                    n14 = sceneGraphPathArray == null ? 0 : sceneGraphPathArray.length;
                    bl = false;
                    for (n13 = 0; n13 < n14; ++n13) {
                        sceneGraphPath3 = sceneGraphPathArray[n13];
                        n12 = sceneGraphPath3.nodeCount();
                        bl = false;
                        block26: for (n11 = 0; !bl && n11 < n12; ++n11) {
                            node = sceneGraphPath3.getNode(n11);
                            if (!map.containsKey(node)) continue;
                            vRMLNodeType = (VRMLNodeType)map.get(node);
                            this.wkDirection.x = this.tmpPoint2.x - this.tmpPoint1.x;
                            this.wkDirection.y = this.tmpPoint2.y - this.tmpPoint1.y;
                            this.wkDirection.z = this.tmpPoint2.z - this.tmpPoint1.z;
                            double d = this.detailLinePick(sceneGraphPath3);
                            if (d < 0.0) continue;
                            switch (n2) {
                                case 2: 
                                case 3: {
                                    this.checkArraySize(1);
                                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                    this.coordList[this.lastCoordIndex] = this.hitPoint[0];
                                    this.coordList[this.lastCoordIndex + 1] = this.hitPoint[1];
                                    this.coordList[this.lastCoordIndex + 2] = this.hitPoint[2];
                                    this.normalList[this.lastCoordIndex] = this.hitNormal[0];
                                    this.normalList[this.lastCoordIndex + 1] = this.hitNormal[1];
                                    this.normalList[this.lastCoordIndex + 2] = this.hitNormal[2];
                                    this.textureList[this.lastCoordIndex] = this.hitTexCoord[0];
                                    this.textureList[this.lastCoordIndex + 1] = this.hitTexCoord[1];
                                    this.textureList[this.lastCoordIndex + 2] = this.hitTexCoord[2];
                                    this.lastCoordIndex += 3;
                                    bl = false;
                                    continue block26;
                                }
                                case 1: 
                                case 4: {
                                    this.checkArraySize(1);
                                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                    this.coordList[this.lastCoordIndex] = this.hitPoint[0];
                                    this.coordList[this.lastCoordIndex + 1] = this.hitPoint[1];
                                    this.coordList[this.lastCoordIndex + 2] = this.hitPoint[2];
                                    this.normalList[this.lastCoordIndex] = this.hitNormal[0];
                                    this.normalList[this.lastCoordIndex + 1] = this.hitNormal[1];
                                    this.normalList[this.lastCoordIndex + 2] = this.hitNormal[2];
                                    this.textureList[this.lastCoordIndex] = this.hitTexCoord[0];
                                    this.textureList[this.lastCoordIndex + 1] = this.hitTexCoord[1];
                                    this.textureList[this.lastCoordIndex + 2] = this.hitTexCoord[2];
                                    this.lastCoordIndex += 3;
                                    bl = true;
                                }
                            }
                        }
                    }
                    if (!bl) continue;
                    break;
                }
                sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.linePicker);
                n14 = sceneGraphPathArray == null ? 0 : sceneGraphPathArray.length;
                bl = false;
                for (n13 = 0; n13 < n14; ++n13) {
                    sceneGraphPath3 = sceneGraphPathArray[n13];
                    n12 = sceneGraphPath3.nodeCount();
                    bl = false;
                    block28: for (n11 = 0; !bl && n11 < n12; ++n11) {
                        node = sceneGraphPath3.getNode(n11);
                        if (!map.containsKey(node)) continue;
                        vRMLNodeType = (VRMLNodeType)map.get(node);
                        switch (n2) {
                            case 2: 
                            case 3: {
                                this.checkArraySize(1);
                                this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                bl = false;
                                continue block28;
                            }
                            case 1: 
                            case 4: {
                                this.checkArraySize(1);
                                this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
    }

    private void processSpherePicking(SceneGraphPath sceneGraphPath, int n, int n2, VRMLGeometryNodeType vRMLGeometryNodeType, Map map) {
        SceneGraphPath[] sceneGraphPathArray;
        int n3 = vRMLGeometryNodeType.getFieldIndex("radius");
        VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n3);
        this.sphereBounds.setRadius((double)vRMLFieldData.floatValue);
        this.tmpPoint1.x = 0.0;
        this.tmpPoint1.y = 0.0;
        this.tmpPoint1.z = 0.0;
        if (sceneGraphPath != null) {
            sceneGraphPathArray = sceneGraphPath.getObject();
            Boolean bl = (Boolean)this.pathLinkStatus.get(sceneGraphPath);
            if (bl.booleanValue()) {
                sceneGraphPathArray.getLocalToVworld(sceneGraphPath, this.pickTransform);
            } else {
                sceneGraphPathArray.getLocalToVworld(this.pickTransform);
            }
            this.pickTransform.transform(this.tmpPoint1);
        }
        this.sphereBounds.setCenter(this.tmpPoint1);
        this.lastNodeIndex = 0;
        this.lastCoordIndex = 0;
        sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.spherePicker);
        if (sceneGraphPathArray == null) {
            return;
        }
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            SceneGraphPath sceneGraphPath2 = sceneGraphPathArray[i];
            int n4 = sceneGraphPath2.nodeCount();
            boolean bl = false;
            block5: for (int j = 0; !bl && j < n4; ++j) {
                Node node = sceneGraphPath2.getNode(j);
                if (!map.containsKey(node)) continue;
                VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(node);
                switch (n2) {
                    case 2: 
                    case 3: {
                        this.checkArraySize(1);
                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                        bl = false;
                        continue block5;
                    }
                    case 1: 
                    case 4: {
                        this.checkArraySize(1);
                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                        bl = true;
                    }
                }
            }
        }
    }

    private void processBoxPicking(SceneGraphPath sceneGraphPath, int n, int n2, VRMLGeometryNodeType vRMLGeometryNodeType, Map map) {
        SceneGraphPath[] sceneGraphPathArray;
        int n3 = vRMLGeometryNodeType.getFieldIndex("size");
        VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n3);
        float f = vRMLFieldData.floatArrayValue[0] * 0.5f;
        float f2 = vRMLFieldData.floatArrayValue[1] * 0.5f;
        float f3 = vRMLFieldData.floatArrayValue[2] * 0.5f;
        this.tmpPoint1.x = -f;
        this.tmpPoint1.y = -f2;
        this.tmpPoint1.z = -f3;
        this.tmpPoint2.x = f;
        this.tmpPoint2.y = f2;
        this.tmpPoint2.z = f3;
        if (sceneGraphPath != null) {
            sceneGraphPathArray = sceneGraphPath.getObject();
            Boolean bl = (Boolean)this.pathLinkStatus.get(sceneGraphPath);
            if (bl.booleanValue()) {
                sceneGraphPathArray.getLocalToVworld(sceneGraphPath, this.pickTransform);
            } else {
                sceneGraphPathArray.getLocalToVworld(this.pickTransform);
            }
            this.pickTransform.transform(this.tmpPoint1);
            this.pickTransform.transform(this.tmpPoint2);
        }
        this.boxBounds.setLower(this.tmpPoint1);
        this.boxBounds.setUpper(this.tmpPoint2);
        this.lastNodeIndex = 0;
        this.lastCoordIndex = 0;
        sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.boxPicker);
        if (sceneGraphPathArray == null) {
            return;
        }
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            SceneGraphPath sceneGraphPath2 = sceneGraphPathArray[i];
            int n4 = sceneGraphPath2.nodeCount();
            boolean bl = false;
            block5: for (int j = 0; !bl && j < n4; ++j) {
                Node node = sceneGraphPath2.getNode(j);
                if (!map.containsKey(node)) continue;
                VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(node);
                switch (n2) {
                    case 2: 
                    case 3: {
                        this.checkArraySize(1);
                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                        bl = false;
                        continue block5;
                    }
                    case 1: 
                    case 4: {
                        this.checkArraySize(1);
                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                        bl = true;
                    }
                }
            }
        }
    }

    private void processConePicking(SceneGraphPath sceneGraphPath, int n, int n2, VRMLGeometryNodeType vRMLGeometryNodeType, Map map) {
        SceneGraphPath[] sceneGraphPathArray;
        int n3 = vRMLGeometryNodeType.getFieldIndex("height");
        VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n3);
        this.tmpPoint1.y = vRMLFieldData.floatValue;
        n3 = vRMLGeometryNodeType.getFieldIndex("bottomRadius");
        vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n3);
        double d = Math.tan((double)vRMLFieldData.floatValue / this.tmpPoint1.y);
        this.tmpPoint1.x = 0.0;
        this.tmpPoint1.y *= 0.5;
        this.tmpPoint1.z = 0.0;
        this.tmpPoint2.x = 0.0;
        this.tmpPoint2.y = -this.tmpPoint1.y;
        this.tmpPoint2.x = 0.0;
        if (sceneGraphPath != null) {
            sceneGraphPathArray = sceneGraphPath.getObject();
            Boolean bl = (Boolean)this.pathLinkStatus.get(sceneGraphPath);
            if (bl.booleanValue()) {
                sceneGraphPathArray.getLocalToVworld(sceneGraphPath, this.pickTransform);
            } else {
                sceneGraphPathArray.getLocalToVworld(this.pickTransform);
            }
            this.pickTransform.transform(this.tmpPoint1);
            this.pickTransform.transform(this.tmpPoint2);
        }
        this.conePicker.set(this.tmpPoint1, this.tmpPoint2, d);
        this.lastNodeIndex = 0;
        this.lastCoordIndex = 0;
        sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.conePicker);
        if (sceneGraphPathArray == null) {
            return;
        }
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            SceneGraphPath sceneGraphPath2 = sceneGraphPathArray[i];
            int n4 = sceneGraphPath2.nodeCount();
            boolean bl = false;
            block5: for (int j = 0; !bl && j < n4; ++j) {
                Node node = sceneGraphPath2.getNode(j);
                if (!map.containsKey(node)) continue;
                VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(node);
                switch (n2) {
                    case 2: 
                    case 3: {
                        this.checkArraySize(1);
                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                        bl = false;
                        continue block5;
                    }
                    case 1: 
                    case 4: {
                        this.checkArraySize(1);
                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                        bl = true;
                    }
                }
            }
        }
    }

    private void processCylinderPicking(SceneGraphPath sceneGraphPath, int n, int n2, VRMLGeometryNodeType vRMLGeometryNodeType, Map map) {
        SceneGraphPath[] sceneGraphPathArray;
        int n3 = vRMLGeometryNodeType.getFieldIndex("height");
        VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n3);
        this.tmpPoint1.x = 0.0;
        this.tmpPoint1.y = vRMLFieldData.floatValue * 0.5f;
        this.tmpPoint1.z = 0.0;
        this.tmpPoint2.x = 0.0;
        this.tmpPoint2.y = -this.tmpPoint1.y;
        this.tmpPoint2.x = 0.0;
        n3 = vRMLGeometryNodeType.getFieldIndex("radius");
        vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n3);
        this.lastNodeIndex = 0;
        this.lastCoordIndex = 0;
        if (sceneGraphPath != null) {
            sceneGraphPathArray = sceneGraphPath.getObject();
            Boolean bl = (Boolean)this.pathLinkStatus.get(sceneGraphPath);
            if (bl.booleanValue()) {
                sceneGraphPathArray.getLocalToVworld(sceneGraphPath, this.pickTransform);
            } else {
                sceneGraphPathArray.getLocalToVworld(this.pickTransform);
            }
            this.pickTransform.transform(this.tmpPoint1);
            this.pickTransform.transform(this.tmpPoint2);
        }
        this.cylinderPicker.set(this.tmpPoint1, this.tmpPoint2, (double)vRMLFieldData.floatValue);
        sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.cylinderPicker);
        if (sceneGraphPathArray == null) {
            return;
        }
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            SceneGraphPath sceneGraphPath2 = sceneGraphPathArray[i];
            int n4 = sceneGraphPath2.nodeCount();
            boolean bl = false;
            block5: for (int j = 0; !bl && j < n4; ++j) {
                Node node = sceneGraphPath2.getNode(j);
                if (!map.containsKey(node)) continue;
                VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(node);
                switch (n2) {
                    case 2: 
                    case 3: {
                        this.checkArraySize(1);
                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                        bl = false;
                        continue block5;
                    }
                    case 1: 
                    case 4: {
                        this.checkArraySize(1);
                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                        bl = true;
                    }
                }
            }
        }
    }

    private void processVolumePicking(SceneGraphPath sceneGraphPath, int n, int n2, VRMLGeometryNodeType vRMLGeometryNodeType, Map map) {
    }

    private VRMLGeometryNodeType findRealGeometry(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType instanceof VRMLGeometryNodeType) {
            return (VRMLGeometryNodeType)vRMLNodeType;
        }
        VRMLGeometryNodeType vRMLGeometryNodeType = null;
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        while (vRMLGeometryNodeType == null) {
            if (vRMLNodeType2 instanceof VRMLGeometryNodeType) {
                vRMLGeometryNodeType = (VRMLGeometryNodeType)vRMLNodeType2;
                continue;
            }
            if (vRMLNodeType2 instanceof VRMLProtoInstance) {
                VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType2;
                vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
                continue;
            }
            System.out.println("Non-geometry proto found. Maybe extern proto?");
            break;
        }
        return vRMLGeometryNodeType;
    }

    private VRMLCoordinateNodeType findRealCoordinates(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType instanceof VRMLCoordinateNodeType) {
            return (VRMLCoordinateNodeType)vRMLNodeType;
        }
        VRMLCoordinateNodeType vRMLCoordinateNodeType = null;
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        while (vRMLCoordinateNodeType == null) {
            if (vRMLNodeType2 instanceof VRMLCoordinateNodeType) {
                vRMLCoordinateNodeType = (VRMLCoordinateNodeType)vRMLNodeType2;
                continue;
            }
            if (vRMLNodeType2 instanceof VRMLProtoInstance) {
                VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType2;
                vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
                continue;
            }
            System.out.println("Non-coordinate proto found. Maybe extern proto?");
            break;
        }
        return vRMLCoordinateNodeType;
    }

    private void checkArraySize(int n) {
        if (this.lastNodeIndex + n < this.nodeList.length) {
            return;
        }
        int n2 = this.nodeList.length + 50;
        if (n2 < this.lastNodeIndex + n) {
            n2 += n;
        }
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n2];
        float[] fArray = new float[n2 * 3];
        float[] fArray2 = new float[n2 * 3];
        float[] fArray3 = new float[n2 * 3];
        System.arraycopy(this.nodeList, 0, vRMLNodeTypeArray, 0, this.lastNodeIndex);
        System.arraycopy(this.coordList, 0, fArray, 0, this.lastCoordIndex);
        System.arraycopy(this.normalList, 0, fArray2, 0, this.lastCoordIndex);
        System.arraycopy(this.textureList, 0, fArray3, 0, this.lastCoordIndex);
        this.nodeList = vRMLNodeTypeArray;
        this.coordList = fArray;
        this.normalList = fArray2;
        this.textureList = fArray3;
    }

    private boolean checkForLinks(SceneGraphPath sceneGraphPath) {
        boolean bl = false;
        if (sceneGraphPath == null) {
            return false;
        }
        int n = sceneGraphPath.nodeCount();
        for (int i = 0; i < n && !bl; ++i) {
            if (!(sceneGraphPath.getNode(i) instanceof Link)) continue;
            bl = true;
        }
        return bl;
    }

    private double detailLinePick(SceneGraphPath sceneGraphPath) {
        Node node = sceneGraphPath.getObject();
        double d = Double.POSITIVE_INFINITY;
        boolean bl = false;
        int n = -1;
        if (node instanceof Shape3D) {
            Enumeration enumeration;
            Transform3D transform3D = sceneGraphPath.getTransform();
            try {
                enumeration = ((Shape3D)node).getAllGeometries();
            }
            catch (CapabilityNotSetException capabilityNotSetException) {
                return -1.0;
            }
            while (enumeration.hasMoreElements()) {
                GeometryArray geometryArray = (GeometryArray)enumeration.nextElement();
                J3DUserData j3DUserData = (J3DUserData)((Object)geometryArray.getUserData());
                boolean bl2 = false;
                if (j3DUserData != null && j3DUserData.geometryData != null && j3DUserData.geometryData instanceof GeometryData) {
                    GeometryData geometryData = (GeometryData)j3DUserData.geometryData;
                    bl2 = this.iutils.rayUnknownGeometry(this.tmpPoint1, this.wkDirection, 0.0f, geometryData, transform3D, this.wkPoint, true);
                } else {
                    bl2 = this.iutils.rayUnknownGeometry(this.tmpPoint1, this.wkDirection, 0.0f, geometryArray, transform3D, this.wkPoint, true);
                }
                if (!bl2) continue;
                this.diffVec.sub((Tuple3d)this.tmpPoint1, (Tuple3d)this.wkPoint);
                if (!(this.diffVec.lengthSquared() < d)) continue;
                d = this.diffVec.lengthSquared();
                this.hitPoint[0] = (float)this.wkPoint.x;
                this.hitPoint[1] = (float)this.wkPoint.y;
                this.hitPoint[2] = (float)this.wkPoint.z;
                bl = true;
            }
        }
        return bl ? d : -1.0;
    }
}

