/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.input;

import java.awt.event.KeyEvent;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Link;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.runtime.BindableNodeManager;
import org.web3d.vrml.nodes.runtime.PickingManager;
import org.web3d.vrml.renderer.common.input.BaseSensorManager;
import org.web3d.vrml.renderer.j3d.input.AreaManager;
import org.web3d.vrml.renderer.j3d.input.DefaultUserInputHandler;
import org.web3d.vrml.renderer.j3d.input.J3DGlobalEffectsHandler;
import org.web3d.vrml.renderer.j3d.input.J3DPickingManager;
import org.web3d.vrml.renderer.j3d.input.J3DRendererEffectsHandler;
import org.web3d.vrml.renderer.j3d.input.J3DSensorManager;
import org.web3d.vrml.renderer.j3d.input.J3DUserInputHandler;
import org.web3d.vrml.renderer.j3d.input.VisibilityManager;
import org.web3d.vrml.renderer.j3d.nodes.J3DBackgroundNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DFogNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DViewpointNodeType;

public class DefaultSensorManager
extends BaseSensorManager
implements J3DSensorManager {
    private static final Vector3d Z_AXIS = new Vector3d(0.0, 0.0, -1.0);
    private J3DViewpointNodeType currentViewpoint;
    private J3DBackgroundNodeType currentBackground;
    private J3DFogNodeType currentFog;
    private Transform3D vpMatrix;
    private Transform3D localMatrix;
    private Vector3d t3dPosition;
    private Point3d position;
    private Vector3d orientation;
    private AxisAngle4d oriAxisAngle;
    private Matrix4d mat;
    private VisibilityManager visibilityHandler;
    private J3DGlobalEffectsHandler globalEffects;
    private J3DRendererEffectsHandler rendererEffects;
    private AreaManager areaHandler;
    private J3DPickingManager pickManager;
    private Texture2D[] tmpTextures;
    private boolean[] tmpTextureFlags;
    private float[] tmpColor;
    private float[] tmpAngle;
    private SceneGraphPath viewpointPath;
    private SceneGraphPath backgroundPath;
    private SceneGraphPath fogPath;
    private boolean viewpointSharedPath;
    private boolean backgroundSharedPath;
    private boolean fogSharedPath;

    public DefaultSensorManager() {
        this.inputHandler = new DefaultUserInputHandler();
        this.inputHandler.setVRMLClock((VRMLClock)this.timeSensors);
        this.keyEvents = new KeyEvent[128];
        this.vpMatrix = new Transform3D();
        this.localMatrix = new Transform3D();
        this.t3dPosition = new Vector3d();
        this.position = new Point3d();
        this.orientation = new Vector3d();
        this.oriAxisAngle = new AxisAngle4d();
        this.visibilityHandler = new VisibilityManager();
        this.areaHandler = new AreaManager();
        this.tmpTextures = new Texture2D[6];
        this.tmpTextureFlags = new boolean[6];
        this.tmpColor = new float[24];
        this.tmpAngle = new float[7];
        this.mat = new Matrix4d();
    }

    public void setPickingManager(PickingManager pickingManager) {
        if (pickingManager != null && !(pickingManager instanceof J3DPickingManager)) {
            throw new IllegalArgumentException("Pick manager not suitable for Java3D");
        }
        this.pickManager = (J3DPickingManager)pickingManager;
        if (pickingManager != null) {
            pickingManager.setErrorReporter(this.errorReporter);
        }
    }

    public void setNavigationStacks(BindableNodeManager bindableNodeManager, BindableNodeManager bindableNodeManager2, BindableNodeManager bindableNodeManager3, BindableNodeManager bindableNodeManager4) {
        this.viewStack = bindableNodeManager;
        this.navInfoStack = bindableNodeManager2;
        this.backgroundStack = bindableNodeManager3;
        this.fogStack = bindableNodeManager4;
    }

    public void setGlobalEffectsHandler(J3DGlobalEffectsHandler j3DGlobalEffectsHandler) {
        this.globalEffects = j3DGlobalEffectsHandler;
    }

    public void setRendererEffectsHandler(J3DRendererEffectsHandler j3DRendererEffectsHandler) {
        this.rendererEffects = j3DRendererEffectsHandler;
    }

    public void setWorldRoot(BranchGroup branchGroup) {
        this.areaHandler.setWorldRoot(branchGroup);
        this.visibilityHandler.setWorldRoot(branchGroup);
        if (this.pickManager != null) {
            this.pickManager.setWorldRoot(branchGroup);
        }
    }

    public void setWorldScale(float f) {
        this.worldScale = f;
        this.invWorldScale = 1.0f / f;
    }

    public void processUserInput(long l) {
        Object object;
        J3DViewpointNodeType j3DViewpointNodeType;
        this.timeSensors.clockTick(l);
        if (!this.navigationEnabled) {
            return;
        }
        if (!this.initialised) {
            this.initialise();
        }
        if ((j3DViewpointNodeType = (J3DViewpointNodeType)this.viewStack.getBoundNode()) != this.currentViewpoint) {
            this.inputHandler.setCenterOfRotation(j3DViewpointNodeType.getCenterOfRotation());
            this.currentViewpoint = j3DViewpointNodeType;
            this.viewpointPath = this.currentViewpoint.getSceneGraphPath();
            this.viewpointSharedPath = this.checkForLinks(this.viewpointPath);
            ((J3DUserInputHandler)this.inputHandler).setViewPath(this.viewpointSharedPath ? this.viewpointPath : null);
        } else if (this.currentViewpoint.hasScenePathChanged()) {
            this.viewpointPath = this.currentViewpoint.getSceneGraphPath();
            this.viewpointSharedPath = this.checkForLinks(this.viewpointPath);
            ((J3DUserInputHandler)this.inputHandler).setViewPath(this.viewpointSharedPath ? this.viewpointPath : null);
        }
        J3DBackgroundNodeType j3DBackgroundNodeType = (J3DBackgroundNodeType)this.backgroundStack.getBoundNode();
        if (j3DBackgroundNodeType != this.currentBackground) {
            object = j3DBackgroundNodeType.getBackgroundTextures();
            for (int i = 0; i < 6; ++i) {
                this.tmpTextureFlags[i] = true;
            }
            this.globalEffects.updateBackgroundTextures((Texture2D[])object, this.tmpTextureFlags);
            this.backgroundSkyChanged = true;
            this.backgroundGroundChanged = true;
            this.updateBackgroundSphere(j3DBackgroundNodeType);
            if (this.currentBackground != null) {
                this.currentBackground.removeNodeListener(this.backgroundListener);
            }
            j3DBackgroundNodeType.addNodeListener(this.backgroundListener);
            this.currentBackground = j3DBackgroundNodeType;
            this.backgroundPath = this.currentBackground.getSceneGraphPath();
            this.backgroundSharedPath = this.checkForLinks(this.backgroundPath);
        } else {
            if (j3DBackgroundNodeType.getChangedTextures(this.tmpTextures, this.tmpTextureFlags)) {
                this.globalEffects.updateBackgroundTextures(this.tmpTextures, this.tmpTextureFlags);
            }
            this.updateBackgroundSphere(this.currentBackground);
            if (this.currentBackground.hasScenePathChanged()) {
                this.backgroundPath = this.currentBackground.getSceneGraphPath();
                this.backgroundSharedPath = this.checkForLinks(this.backgroundPath);
            }
        }
        object = (J3DFogNodeType)this.fogStack.getBoundNode();
        float f = object.getVisibilityRange();
        object.getColor(this.tmpColor);
        int n = object.getFogType();
        if (object != this.currentFog) {
            this.globalEffects.enableFog(n);
            this.globalEffects.setFogDetails(f, this.tmpColor[0], this.tmpColor[1], this.tmpColor[2]);
            if (this.currentFog != null) {
                this.currentFog.removeNodeListener(this.fogListener);
            }
            object.addNodeListener((VRMLNodeListener)this.fogListener);
            this.currentFog = object;
            this.fogPath = this.currentFog.getSceneGraphPath();
            this.fogSharedPath = this.checkForLinks(this.fogPath);
        } else {
            if (this.fogTypeChanged) {
                this.globalEffects.enableFog(n);
            }
            if (this.fogDetailsChanged) {
                this.globalEffects.setFogDetails(f, this.tmpColor[0], this.tmpColor[1], this.tmpColor[2]);
            }
            if (this.currentFog.hasScenePathChanged()) {
                this.fogPath = this.currentFog.getSceneGraphPath();
                this.fogSharedPath = this.checkForLinks(this.fogPath);
            }
        }
        this.clearChangeFlags();
        if (this.inputManager != null) {
            this.inputManager.processTrackers();
            int n2 = this.inputManager.getKeyEvents(this.keyEvents);
            if (n2 != 0) {
                this.keySensors.sendEvents(this.keyEvents, n2);
            }
        }
        VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType = (VRMLNavigationInfoNodeType)this.navInfoStack.getBoundNode();
        TransformGroup transformGroup = this.currentViewpoint.getPlatformGroup();
        try {
            if (this.viewpointSharedPath) {
                transformGroup.getLocalToVworld(this.viewpointPath, this.vpMatrix);
            } else {
                transformGroup.getLocalToVworld(this.vpMatrix);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        transformGroup.getTransform(this.localMatrix);
        this.vpMatrix.mul(this.localMatrix);
        this.vpMatrix.transform(Z_AXIS, this.orientation);
        this.vpMatrix.get(this.t3dPosition);
        this.position.set((Tuple3d)this.t3dPosition);
        if (this.globalEffects != null) {
            this.globalEffects.setViewMatrix(this.vpMatrix);
        }
        if (this.rendererEffects != null) {
            this.rendererEffects.setViewMatrix(this.vpMatrix);
        }
        float f2 = vRMLNavigationInfoNodeType.getVisibilityLimit();
        float f3 = j3DViewpointNodeType.getFieldOfView();
        if (this.numAreaListeners > 0) {
            this.vpMatrix.invert();
            this.areaHandler.processFrame(this.position, this.orientation, this.vpMatrix, f2, f3);
        }
        BranchGroup branchGroup = (BranchGroup)this.currentBackground.getSceneGraphObject();
        if (this.backgroundSharedPath) {
            branchGroup.getLocalToVworld(this.backgroundPath, this.vpMatrix);
        } else {
            branchGroup.getLocalToVworld(this.vpMatrix);
        }
        if (this.globalEffects != null) {
            this.globalEffects.setBackgroundMatrix(this.vpMatrix);
        }
        branchGroup = (BranchGroup)this.currentFog.getSceneGraphObject();
        if (this.fogSharedPath) {
            branchGroup.getLocalToVworld(this.fogPath, this.vpMatrix);
        } else {
            branchGroup.getLocalToVworld(this.vpMatrix);
        }
        if (this.globalEffects != null) {
            this.globalEffects.setFogMatrix(this.vpMatrix);
        }
        if (this.numVisibilityListeners > 0) {
            this.vpMatrix.get(this.mat);
            this.oriAxisAngle.set(this.mat);
            this.visibilityHandler.processFrame(this.position, this.orientation, this.oriAxisAngle, f2, f3);
        }
        this.pickManager.processPickSensors(l);
    }

    public void updateViewMatrix() {
        try {
            if (!this.navigationEnabled) {
                return;
            }
            TransformGroup transformGroup = this.currentViewpoint.getPlatformGroup();
            if (this.viewpointSharedPath) {
                transformGroup.getLocalToVworld(this.viewpointPath, this.vpMatrix);
            } else {
                transformGroup.getLocalToVworld(this.vpMatrix);
            }
            transformGroup.getTransform(this.localMatrix);
            this.vpMatrix.mul(this.localMatrix);
            if (this.globalEffects != null) {
                this.globalEffects.setViewMatrix(this.vpMatrix);
            }
            if (this.rendererEffects != null) {
                this.rendererEffects.setViewMatrix(this.vpMatrix);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private boolean checkForLinks(SceneGraphPath sceneGraphPath) {
        boolean bl = false;
        if (sceneGraphPath == null) {
            return false;
        }
        int n = sceneGraphPath.nodeCount();
        for (int i = 0; i < n && !bl; ++i) {
            if (!(sceneGraphPath.getNode(i) instanceof Link)) continue;
            bl = true;
        }
        return bl;
    }

    private void updateBackgroundSphere(VRMLBackgroundNodeType vRMLBackgroundNodeType) {
        int n;
        if (this.backgroundGroundChanged) {
            n = vRMLBackgroundNodeType.getNumGroundColors();
            if (n * 3 > this.tmpColor.length) {
                this.tmpColor = new float[n * 3];
                this.tmpAngle = new float[n - 1];
            }
            if (n != 0) {
                vRMLBackgroundNodeType.getGroundValues(this.tmpColor, this.tmpAngle);
            }
            this.globalEffects.updateBackgroundGround(this.tmpColor, this.tmpAngle, n);
        }
        if (this.backgroundSkyChanged) {
            n = vRMLBackgroundNodeType.getNumSkyColors();
            if (n * 3 > this.tmpColor.length) {
                this.tmpColor = new float[n * 3];
                this.tmpAngle = new float[n - 1];
            }
            if (n != 0) {
                vRMLBackgroundNodeType.getSkyValues(this.tmpColor, this.tmpAngle);
            }
            this.globalEffects.updateBackgroundSky(this.tmpColor, this.tmpAngle, n);
        }
    }
}

