/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.input;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.renderer.java3d.navigation.NavigationProcessor;
import org.j3d.renderer.java3d.util.J3DIntersectionUtils;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.util.HashSet;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.device.TrackerState;
import org.web3d.vrml.nodes.NavigationInfoChangeListener;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLDragSensorNodeType;
import org.web3d.vrml.nodes.VRMLLinkNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLTouchSensorNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.renderer.j3d.input.CollisionListener;
import org.web3d.vrml.renderer.j3d.input.CollisionListenerAdapter;
import org.web3d.vrml.renderer.j3d.input.J3DUserInputHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;

public class DefaultUserInputHandler
implements J3DUserInputHandler,
NavigationInfoChangeListener {
    private static final double PICK_SIZE = 0.1;
    private static final int NO_STATE = 0;
    private static final int NAVIGATION_STATE = 1;
    private static final int ANCHOR_STATE = 2;
    private static final int TOUCH_STATE = 3;
    private static final String DEFAULT_NAV_STRING = "WALK";
    private static final int DEFAULT_NAV_INT = 1;
    private static final HashMap navigationTypes = new HashMap();
    private int currentState = 0;
    private int[] trackerState;
    private boolean anyAllowed = true;
    private NavigationProcessor navHandler;
    private VRMLNavigationInfoNodeType currentNavInfo;
    private VRMLViewpointNodeType currentViewpoint;
    private ArrayList navigationStateListeners;
    private ArrayList sensorStatusListeners;
    private PickRay mousePickShape;
    private Vector3d mousePickDirection = new Vector3d(0.0, 0.0, -1.0);
    private Point3d mouseEyePosition = new Point3d();
    private Point3d mousePosition = new Point3d();
    private Point3d mouseSensorPosition = new Point3d();
    private Transform3D viewTransform;
    private TransformGroup viewTg;
    private BranchGroup pickableWorld;
    private VRMLClock clock;
    private boolean doPicking = false;
    private J3DIntersectionUtils iutils;
    private VRMLLinkNodeType currentLink;
    private SceneGraphPath currentPickedPath;
    private int currentPickedNodeIndex;
    private boolean hasTouchSensor = false;
    private boolean hasDragSensor = false;
    private CollisionListener collisionListener;
    private Point3d wkPoint;
    private Point3d pointTrans;
    private Transform3D wkTrans;
    private HashSet activeSensors;
    private HashSet workingSensors;
    private ObjectArray activeTouchSensors;
    private ObjectArray activeDragSensors;
    private Transform3D sensorTransform;
    private Transform3D dragParentTransform;
    private SceneGraphPath sensorPath;
    private float[] sensorHitPoint;
    private float[] sensorHitNormal;
    private float[] sensorHitTexCoord;
    private Object[] tmpSensors;
    private Vector3d diffVec;
    private boolean navigationEnabled;
    private float[] navStart;
    private float[] tmpVec;
    private int[] navMode;
    private int[] boundNavModes;
    private String[] nav_types;
    private int num_nav_types;
    private boolean[] lastButtonState;
    private int prevNavMode;
    private int prevNavModeIdx;
    private boolean testPointingDevices = true;

    public DefaultUserInputHandler() {
        this.mousePickShape = new PickRay();
        this.viewTransform = new Transform3D();
        this.navHandler = new NavigationProcessor();
        this.activeSensors = new HashSet();
        this.workingSensors = new HashSet();
        this.activeDragSensors = new ObjectArray();
        this.activeTouchSensors = new ObjectArray();
        this.dragParentTransform = new Transform3D();
        this.sensorTransform = new Transform3D();
        this.sensorPath = new SceneGraphPath();
        this.sensorHitPoint = new float[3];
        this.sensorHitNormal = new float[3];
        this.sensorHitTexCoord = new float[3];
        this.tmpSensors = new Object[10];
        this.iutils = new J3DIntersectionUtils();
        this.pointTrans = new Point3d();
        this.wkPoint = new Point3d();
        this.wkTrans = new Transform3D();
        this.diffVec = new Vector3d();
        this.navStart = new float[3];
        this.tmpVec = new float[3];
        this.navMode = new int[16];
        this.lastButtonState = new boolean[128];
        this.boundNavModes = new int[8];
        this.nav_types = new String[0];
        this.navigationStateListeners = new ArrayList(1);
        this.sensorStatusListeners = new ArrayList(1);
    }

    public void notifyNavigationModesChanged(String[] stringArray, int n) {
        this.nav_types = stringArray;
        this.num_nav_types = n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.fireNavigationListChanged(this.nav_types, this.num_nav_types);
        if (this.num_nav_types > 0) {
            if (this.nav_types[0].equals("ANY")) {
                this.setNavigationMode(DEFAULT_NAV_STRING);
            } else {
                this.setNavigationMode(this.nav_types[0]);
            }
        }
        this.anyAllowed = false;
        for (int i = 0; i < this.num_nav_types; ++i) {
            String string = this.nav_types[i];
            Integer n2 = (Integer)navigationTypes.get(string);
            if (n2 != null) {
                this.boundNavModes[i] = n2;
                continue;
            }
            if (string.equals("ANY")) {
                this.boundNavModes[i] = 1;
                this.anyAllowed = true;
                continue;
            }
            System.out.println("Unknown navigation mode: " + string);
            this.boundNavModes[i] = 0;
        }
        this.navHandler.setNavigationState(this.boundNavModes[0]);
    }

    public void notifyAvatarSizeChanged(float[] fArray, int n) {
        if (n != 3) {
            System.err.println("Unsupported number of avatar dimensions");
        } else {
            this.navHandler.setAvatarInfo(fArray[1], fArray[0], fArray[2]);
        }
    }

    public void notifyNavigationSpeedChanged(float f) {
        this.navHandler.setNavigationSpeed(f);
    }

    public boolean getNavigationEnabled() {
        return this.navigationEnabled;
    }

    public void setNavigationEnabled(boolean bl) {
        this.navigationEnabled = bl;
    }

    public void setPickableScene(BranchGroup branchGroup) {
        this.pickableWorld = branchGroup;
        this.doPicking = this.pickableWorld != null && this.viewTg != null;
        this.navHandler.setWorldInfo(branchGroup, branchGroup);
    }

    public void setViewInfo(View view, TransformGroup transformGroup, SceneGraphPath sceneGraphPath) {
        this.viewTg = transformGroup;
        this.navHandler.setViewInfo(view, transformGroup, sceneGraphPath);
        this.doPicking = this.pickableWorld != null && this.viewTg != null;
    }

    public void setViewPath(SceneGraphPath sceneGraphPath) {
        this.navHandler.setViewPath(sceneGraphPath);
    }

    public void setCenterOfRotation(float[] fArray) {
        this.navHandler.setCenterOfRotation(fArray, null);
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.clock = vRMLClock;
    }

    public void setCollisionListener(CollisionListener collisionListener) {
        if (collisionListener == null) {
            this.navHandler.setCollisionListener(null);
        } else {
            this.navHandler.setCollisionListener((org.j3d.renderer.java3d.navigation.CollisionListener)new CollisionListenerAdapter(collisionListener));
        }
    }

    public void setViewpoint(VRMLViewpointNodeType vRMLViewpointNodeType) {
        this.currentViewpoint = vRMLViewpointNodeType;
    }

    public void setNavigationInfo(VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType) {
        if (this.currentNavInfo != null) {
            this.currentNavInfo.setNavigationChangedListener(null);
        }
        vRMLNavigationInfoNodeType.setNavigationChangedListener((NavigationInfoChangeListener)this);
        this.currentNavInfo = vRMLNavigationInfoNodeType;
        float[] fArray = vRMLNavigationInfoNodeType.getAvatarSize();
        float f = vRMLNavigationInfoNodeType.getSpeed();
        this.navHandler.setAvatarInfo(fArray[1], fArray[0], fArray[2]);
        this.navHandler.setNavigationSpeed(f);
        this.nav_types = vRMLNavigationInfoNodeType.getType();
        this.num_nav_types = vRMLNavigationInfoNodeType.getNumTypes();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.fireNavigationListChanged(this.nav_types, this.num_nav_types);
        if (this.num_nav_types > 0) {
            if (this.nav_types[0].equals("ANY")) {
                this.setNavigationMode(DEFAULT_NAV_STRING);
            } else {
                this.setNavigationMode(this.nav_types[0]);
            }
        }
        this.anyAllowed = false;
        for (int i = 0; i < this.num_nav_types; ++i) {
            String string = this.nav_types[i];
            Integer n = (Integer)navigationTypes.get(string);
            if (n != null) {
                this.boundNavModes[i] = n;
                continue;
            }
            if (string.equals("ANY")) {
                this.boundNavModes[i] = 1;
                this.anyAllowed = true;
                continue;
            }
            System.out.println("Unknown navigation mode: " + string);
            this.boundNavModes[i] = 0;
        }
        this.navHandler.setNavigationState(this.boundNavModes[0]);
    }

    public void trackerButton(int n, TrackerState trackerState) {
        this.processButtons(n, trackerState);
    }

    public void trackerPressed(int n, TrackerState trackerState) {
        if (this.doPicking) {
            SceneGraphPath sceneGraphPath = null;
            boolean bl = false;
            for (int i = 0; i < trackerState.numButtons; ++i) {
                if (!trackerState.pickingEnabled[i] || !trackerState.buttonState[i]) continue;
                bl = true;
                break;
            }
            if (bl && this.testPointingDevices) {
                sceneGraphPath = this.doPick(trackerState);
            }
            if (sceneGraphPath == null) {
                this.navStart[0] = trackerState.devicePos[0];
                this.navStart[1] = trackerState.devicePos[1];
                this.navStart[2] = trackerState.devicePos[2];
                this.setNavMode(n, trackerState);
                if (this.navMode[n] == 6) {
                    this.updateCenterOfRotation(trackerState);
                    this.currentState = 1;
                    this.navHandler.startMove();
                } else if (this.navMode[n] != 0) {
                    this.currentState = 1;
                    this.navHandler.startMove();
                } else {
                    this.currentState = 0;
                }
            } else {
                int n2 = sceneGraphPath.nodeCount();
                boolean bl2 = false;
                int n3 = n2;
                while (--n3 >= 0) {
                    Node node = sceneGraphPath.getNode(n3);
                    if (!this.processNodePress((SceneGraphObject)node)) continue;
                    bl2 = true;
                    this.currentPickedPath = sceneGraphPath;
                    this.currentPickedNodeIndex = n3;
                    break;
                }
                if (!bl2) {
                    this.navStart[0] = trackerState.devicePos[0];
                    this.navStart[1] = trackerState.devicePos[1];
                    this.navStart[2] = trackerState.devicePos[2];
                    this.setNavMode(n, trackerState);
                    if (this.navMode[n] == 6) {
                        this.updateCenterOfRotation(trackerState);
                        this.currentState = 1;
                        this.navHandler.startMove();
                    } else if (this.navMode[n] != 0) {
                        this.currentState = 1;
                        this.navHandler.startMove();
                    } else {
                        this.currentState = 0;
                    }
                } else {
                    VRMLTouchSensorNodeType vRMLTouchSensorNodeType;
                    n3 = this.activeTouchSensors.size();
                    if (n3 != 0) {
                        double d = this.clock.getTime();
                        for (int i = 0; i < n3; ++i) {
                            vRMLTouchSensorNodeType = (VRMLTouchSensorNodeType)this.activeTouchSensors.get(i);
                            vRMLTouchSensorNodeType.notifyPressed(1, d, this.sensorHitPoint, this.sensorHitNormal, this.sensorHitTexCoord);
                            this.fireDeviceActivated(vRMLTouchSensorNodeType);
                        }
                    }
                    if ((n3 = this.activeDragSensors.size()) != 0) {
                        this.calcSensorGroupVWorld(this.currentPickedPath, this.currentPickedNodeIndex, this.dragParentTransform);
                        this.dragParentTransform.invert();
                        this.dragParentTransform.transform(this.mousePosition, this.wkPoint);
                        this.sensorHitNormal[0] = (float)this.wkPoint.x;
                        this.sensorHitNormal[1] = (float)this.wkPoint.y;
                        this.sensorHitNormal[2] = (float)this.wkPoint.z;
                        this.wkPoint.x = this.sensorHitPoint[0];
                        this.wkPoint.y = this.sensorHitPoint[1];
                        this.wkPoint.z = this.sensorHitPoint[2];
                        this.dragParentTransform.transform(this.wkPoint, this.pointTrans);
                        this.sensorHitPoint[0] = (float)this.pointTrans.x;
                        this.sensorHitPoint[1] = (float)this.pointTrans.y;
                        this.sensorHitPoint[2] = (float)this.pointTrans.z;
                        for (int i = 0; i < n3; ++i) {
                            vRMLTouchSensorNodeType = (VRMLDragSensorNodeType)this.activeDragSensors.get(i);
                            vRMLTouchSensorNodeType.notifySensorDragStart(this.sensorHitPoint, this.sensorHitNormal);
                            this.fireDeviceActivated(vRMLTouchSensorNodeType);
                        }
                    }
                }
            }
        } else {
            this.navStart[0] = trackerState.devicePos[0];
            this.navStart[1] = trackerState.devicePos[1];
            this.navStart[2] = trackerState.devicePos[2];
            this.setNavMode(n, trackerState);
            if (this.navMode[n] == 6) {
                this.updateCenterOfRotation(trackerState);
                this.currentState = 1;
                this.navHandler.startMove();
            } else if (this.navMode[n] != 0) {
                this.currentState = 1;
                this.navHandler.startMove();
            } else {
                this.currentState = 0;
            }
        }
    }

    public void setTestPointingDevices(boolean bl) {
        this.testPointingDevices = bl;
    }

    public void trackerMoved(int n, TrackerState trackerState) {
        Object object;
        int n2;
        if (!this.doPicking) {
            return;
        }
        SceneGraphPath sceneGraphPath = null;
        if (this.testPointingDevices) {
            sceneGraphPath = this.doPick(trackerState);
        }
        if (sceneGraphPath == null) {
            int n3 = this.activeSensors.size();
            if (n3 != 0) {
                this.tmpSensors = this.activeSensors.toArray(this.tmpSensors);
                for (int i = 0; i < n3; ++i) {
                    Object object2 = this.tmpSensors[i];
                    if (object2 instanceof VRMLPointingDeviceSensorNodeType) {
                        ((VRMLPointingDeviceSensorNodeType)object2).setIsOver(false);
                    }
                    this.fireDeviceNotOver(object2);
                }
                this.activeSensors.clear();
            }
            return;
        }
        int n4 = sceneGraphPath.nodeCount();
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            int n5;
            Node node = sceneGraphPath.getNode(n2);
            J3DUserData j3DUserData = (J3DUserData)((Object)node.getUserData());
            if (j3DUserData == null) continue;
            if (j3DUserData.linkReference != null) {
                VRMLLinkNodeType vRMLLinkNodeType = j3DUserData.linkReference;
                if (this.activeSensors.contains((Object)vRMLLinkNodeType)) {
                    this.activeSensors.remove((Object)vRMLLinkNodeType);
                } else {
                    this.fireDeviceOver(vRMLLinkNodeType);
                }
                this.activeSensors.add((Object)vRMLLinkNodeType);
                bl = true;
            }
            if (j3DUserData.sensors == null) continue;
            this.pointTrans.x = this.sensorHitPoint[0];
            this.pointTrans.y = this.sensorHitPoint[1];
            this.pointTrans.z = this.sensorHitPoint[2];
            this.calcHitPoint(sceneGraphPath, n2, this.pointTrans);
            this.sensorHitPoint[0] = (float)this.pointTrans.x;
            this.sensorHitPoint[1] = (float)this.pointTrans.y;
            this.sensorHitPoint[2] = (float)this.pointTrans.z;
            for (n5 = 0; n5 < j3DUserData.sensors.length; ++n5) {
                object = j3DUserData.sensors[n5];
                if (object instanceof VRMLDragSensorNodeType) {
                    this.workingSensors.add(object);
                    if (this.activeSensors.contains(object)) {
                        this.activeSensors.remove(object);
                    } else {
                        ((VRMLDragSensorNodeType)object).setIsOver(true);
                        this.fireDeviceOver(object);
                    }
                    bl = true;
                    continue;
                }
                if (!(object instanceof VRMLTouchSensorNodeType) || !((VRMLTouchSensorNodeType)object).getEnabled()) continue;
                bl = true;
                if (bl2) continue;
                VRMLTouchSensorNodeType vRMLTouchSensorNodeType = (VRMLTouchSensorNodeType)object;
                if (this.activeSensors.contains(object)) {
                    this.activeSensors.remove(object);
                } else {
                    vRMLTouchSensorNodeType.setIsOver(true);
                    this.fireDeviceOver(vRMLTouchSensorNodeType);
                }
                vRMLTouchSensorNodeType.notifyHitChanged(this.sensorHitPoint, this.sensorHitNormal, this.sensorHitTexCoord);
                bl2 = true;
                this.workingSensors.add((Object)vRMLTouchSensorNodeType);
            }
            n5 = this.activeSensors.size();
            if (n5 != 0) {
                this.tmpSensors = this.activeSensors.toArray(this.tmpSensors);
                for (int i = 0; i < n5; ++i) {
                    object = this.tmpSensors[i];
                    if (object instanceof VRMLPointingDeviceSensorNodeType) {
                        ((VRMLPointingDeviceSensorNodeType)object).setIsOver(false);
                    }
                    this.fireDeviceNotOver(object);
                }
                this.activeSensors.clear();
            }
            this.activeSensors.addAll(this.workingSensors);
            this.workingSensors.clear();
        }
        n2 = this.activeSensors.size();
        if (!bl && n2 != 0) {
            this.tmpSensors = this.activeSensors.toArray(this.tmpSensors);
            for (int i = 0; i < n2; ++i) {
                object = this.tmpSensors[i];
                if (object instanceof VRMLPointingDeviceSensorNodeType) {
                    ((VRMLPointingDeviceSensorNodeType)object).setIsOver(false);
                }
                this.fireDeviceNotOver(object);
            }
            this.activeSensors.clear();
        }
    }

    public void trackerDragged(int n, TrackerState trackerState) {
        float f = this.navStart[0] - trackerState.devicePos[0];
        float f2 = trackerState.devicePos[1] - this.navStart[1];
        switch (this.currentState) {
            case 1: {
                switch (this.navMode[n]) {
                    case 1: {
                        this.tmpVec[0] = f;
                        this.tmpVec[1] = 0.0f;
                        this.tmpVec[2] = f2;
                        break;
                    }
                    case 3: {
                        this.tmpVec[0] = -f;
                        this.tmpVec[1] = -f2;
                        this.tmpVec[2] = 0.0f;
                        break;
                    }
                    case 2: {
                        this.tmpVec[0] = f;
                        this.tmpVec[1] = -f2;
                        this.tmpVec[2] = 0.0f;
                        break;
                    }
                    case 4: {
                        this.tmpVec[0] = f;
                        this.tmpVec[1] = 0.0f;
                        this.tmpVec[2] = f2;
                        break;
                    }
                    case 5: {
                        this.tmpVec[0] = f;
                        this.tmpVec[1] = 0.0f;
                        this.tmpVec[2] = f2;
                    }
                }
                float f3 = (float)Math.sqrt(this.tmpVec[0] * this.tmpVec[0] + this.tmpVec[1] * this.tmpVec[1] + this.tmpVec[2] * this.tmpVec[2]);
                if (f3 != 0.0f) {
                    this.tmpVec[0] = this.tmpVec[0] / f3;
                    this.tmpVec[1] = this.tmpVec[1] / f3;
                    this.tmpVec[2] = this.tmpVec[2] / f3;
                } else {
                    this.tmpVec[0] = 0.0f;
                    this.tmpVec[1] = 1.0f;
                    this.tmpVec[2] = 0.0f;
                }
                this.navHandler.move(this.tmpVec, f3);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                VRMLTouchSensorNodeType vRMLTouchSensorNodeType;
                int n2;
                int n3 = this.activeTouchSensors.size();
                if (n3 != 0) {
                    System.out.println("Warning: does not update dragged mouse correctly for TouchSensors. Must fix");
                    for (n2 = 0; n2 < n3; ++n2) {
                        vRMLTouchSensorNodeType = (VRMLTouchSensorNodeType)this.activeTouchSensors.get(n2);
                        vRMLTouchSensorNodeType.notifyHitChanged(this.sensorHitPoint, this.sensorHitNormal, this.sensorHitTexCoord);
                    }
                }
                if ((n3 = this.activeDragSensors.size()) == 0) break;
                this.mouseEyePosition.x = trackerState.worldPos[0];
                this.mouseEyePosition.y = trackerState.worldPos[1];
                this.mouseEyePosition.z = trackerState.worldPos[2];
                this.mousePickDirection.x = trackerState.worldOri[0];
                this.mousePickDirection.y = trackerState.worldOri[1];
                this.mousePickDirection.z = trackerState.worldOri[2];
                this.mousePickShape.set(this.mouseEyePosition, this.mousePickDirection);
                this.dragParentTransform.transform(this.mouseEyePosition, this.wkPoint);
                this.dragParentTransform.transform(this.mousePickDirection, this.diffVec);
                this.sensorHitPoint[0] = (float)this.wkPoint.x;
                this.sensorHitPoint[1] = (float)this.wkPoint.y;
                this.sensorHitPoint[2] = (float)this.wkPoint.z;
                this.sensorHitNormal[0] = (float)this.diffVec.x;
                this.sensorHitNormal[1] = (float)this.diffVec.y;
                this.sensorHitNormal[2] = (float)this.diffVec.z;
                for (n2 = 0; n2 < n3; ++n2) {
                    vRMLTouchSensorNodeType = (VRMLDragSensorNodeType)this.activeDragSensors.get(n2);
                    vRMLTouchSensorNodeType.notifySensorDragChange(this.sensorHitPoint, this.sensorHitNormal);
                }
                break;
            }
        }
    }

    public void trackerReleased(int n, TrackerState trackerState) {
        switch (this.currentState) {
            case 1: {
                this.navHandler.stopMove();
                if (this.navMode[n] != 6) break;
                this.fireNavigationStateChanged(this.prevNavModeIdx);
                this.navHandler.setNavigationState(this.prevNavMode);
                this.boundNavModes[0] = this.prevNavMode;
                break;
            }
            case 2: {
                this.fireLinkActivated(this.currentLink);
                this.currentLink = null;
                break;
            }
            case 3: {
                VRMLTouchSensorNodeType vRMLTouchSensorNodeType;
                int n2;
                int n3 = this.activeTouchSensors.size();
                if (n3 != 0) {
                    double d = this.clock.getTime();
                    System.out.println("Warning: does not update released mouse correctly for TouchSensors. Must fix");
                    for (n2 = 0; n2 < n3; ++n2) {
                        vRMLTouchSensorNodeType = (VRMLTouchSensorNodeType)this.activeTouchSensors.get(n2);
                        vRMLTouchSensorNodeType.notifyReleased(1, d, this.sensorHitPoint, this.sensorHitNormal, this.sensorHitTexCoord);
                    }
                }
                if ((n3 = this.activeDragSensors.size()) != 0) {
                    this.mousePosition.x = trackerState.worldPos[0];
                    this.mousePosition.y = trackerState.worldPos[1];
                    this.mousePosition.z = trackerState.worldPos[2];
                    this.mousePickDirection.x = trackerState.worldOri[0];
                    this.mousePickDirection.y = trackerState.worldOri[1];
                    this.mousePickDirection.z = trackerState.worldOri[2];
                    this.dragParentTransform.transform(this.mousePosition, this.wkPoint);
                    this.dragParentTransform.transform(this.mousePickDirection, this.diffVec);
                    this.sensorHitPoint[0] = (float)this.wkPoint.x;
                    this.sensorHitPoint[1] = (float)this.wkPoint.y;
                    this.sensorHitPoint[2] = (float)this.wkPoint.z;
                    this.sensorHitNormal[0] = (float)this.diffVec.x;
                    this.sensorHitNormal[1] = (float)this.diffVec.y;
                    this.sensorHitNormal[2] = (float)this.diffVec.z;
                    for (n2 = 0; n2 < n3; ++n2) {
                        vRMLTouchSensorNodeType = (VRMLDragSensorNodeType)this.activeDragSensors.get(n2);
                        vRMLTouchSensorNodeType.notifySensorDragEnd(this.sensorHitPoint, this.sensorHitNormal);
                    }
                }
                this.currentPickedPath = null;
                this.currentPickedNodeIndex = -1;
                this.activeTouchSensors.clear();
                this.activeDragSensors.clear();
                this.hasDragSensor = false;
                this.hasTouchSensor = false;
            }
        }
        this.currentState = 0;
    }

    public void trackerClicked(int n, TrackerState trackerState) {
        if (!this.doPicking) {
            return;
        }
        this.trackerPressed(n, trackerState);
        this.trackerReleased(n, trackerState);
        this.currentState = 0;
    }

    public void trackerOrientation(int n, TrackerState trackerState) {
        this.navHandler.orient(trackerState.deviceOri);
    }

    public void processNavigation() {
        if (!this.navigationEnabled && this.currentState == 1) {
            this.navHandler.processNextFrame();
        }
    }

    public void addNavigationStateListener(NavigationStateListener navigationStateListener) {
        if (navigationStateListener != null && !this.navigationStateListeners.contains(navigationStateListener)) {
            this.navigationStateListeners.add(navigationStateListener);
        }
    }

    public void removeNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.navigationStateListeners.remove(navigationStateListener);
    }

    public void addSensorStatusListener(SensorStatusListener sensorStatusListener) {
        if (sensorStatusListener != null && !this.sensorStatusListeners.contains(sensorStatusListener)) {
            this.sensorStatusListeners.add(sensorStatusListener);
        }
    }

    public void removeSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.sensorStatusListeners.remove(sensorStatusListener);
    }

    public void getPosition(Vector3f vector3f) {
    }

    public void setWorldScale(float f) {
    }

    public boolean setNavigationMode(String string) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        for (n = 0; n < this.nav_types.length; ++n) {
            if (this.nav_types[n].equals(string)) {
                bl = true;
                break;
            }
            if (!this.nav_types[n].equals("ANY")) continue;
            bl2 = true;
        }
        if (!bl && bl2) {
            object = new String[this.num_nav_types + 1];
            for (n = 0; n < this.num_nav_types; ++n) {
                object[n] = this.nav_types[n];
            }
            object[n] = string;
            this.fireNavigationListChanged((String[])object, ((Object)object).length);
            bl = true;
            this.nav_types = object;
        }
        if (bl) {
            this.fireNavigationStateChanged(n);
            object = (Integer)navigationTypes.get(string);
            if (object != null) {
                int n2 = (Integer)object;
                this.navHandler.setNavigationState(n2);
                if (n2 == 6) {
                    this.prevNavMode = this.boundNavModes[0];
                } else {
                    this.prevNavModeIdx = n;
                }
                this.boundNavModes[0] = n2;
            } else if (bl2) {
                this.navHandler.setNavigationState(1);
            }
        }
        return bl;
    }

    private SceneGraphPath doPick(TrackerState trackerState) {
        this.mouseEyePosition.x = trackerState.worldPos[0];
        this.mouseEyePosition.y = trackerState.worldPos[1];
        this.mouseEyePosition.z = trackerState.worldPos[2];
        this.mousePickDirection.x = trackerState.worldOri[0];
        this.mousePickDirection.y = trackerState.worldOri[1];
        this.mousePickDirection.z = trackerState.worldOri[2];
        this.mousePickShape.set(this.mouseEyePosition, this.mousePickDirection);
        SceneGraphPath[] sceneGraphPathArray = this.pickableWorld.pickAllSorted((PickShape)this.mousePickShape);
        if (sceneGraphPathArray == null) {
            return null;
        }
        double d = -1.0;
        int n = -1;
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            Enumeration enumeration;
            Node node = sceneGraphPathArray[i].getObject();
            if (!(node instanceof Shape3D)) continue;
            Transform3D transform3D = sceneGraphPathArray[i].getTransform();
            try {
                enumeration = ((Shape3D)node).getAllGeometries();
            }
            catch (CapabilityNotSetException capabilityNotSetException) {
                continue;
            }
            while (enumeration.hasMoreElements()) {
                GeometryArray geometryArray = (GeometryArray)enumeration.nextElement();
                J3DUserData j3DUserData = (J3DUserData)((Object)geometryArray.getUserData());
                boolean bl = false;
                if (j3DUserData != null && j3DUserData.geometryData != null && j3DUserData.geometryData instanceof GeometryData) {
                    GeometryData geometryData = (GeometryData)j3DUserData.geometryData;
                    bl = this.iutils.rayUnknownGeometry(this.mouseEyePosition, this.mousePickDirection, 0.0f, geometryData, transform3D, this.wkPoint, false);
                } else {
                    bl = this.iutils.rayUnknownGeometry(this.mouseEyePosition, this.mousePickDirection, 0.0f, geometryArray, transform3D, this.wkPoint, false);
                }
                if (!bl) continue;
                this.diffVec.sub((Tuple3d)this.mouseEyePosition, (Tuple3d)this.wkPoint);
                if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) continue;
                n = i;
                d = this.diffVec.lengthSquared();
                this.sensorHitPoint[0] = (float)this.wkPoint.x;
                this.sensorHitPoint[1] = (float)this.wkPoint.y;
                this.sensorHitPoint[2] = (float)this.wkPoint.z;
            }
        }
        if (n == -1) {
            return null;
        }
        return sceneGraphPathArray[n];
    }

    private boolean processNodePress(SceneGraphObject sceneGraphObject) {
        Object object = sceneGraphObject.getUserData();
        if (object == null || !(object instanceof J3DUserData)) {
            return false;
        }
        boolean bl = false;
        double d = this.clock.getTime();
        J3DUserData j3DUserData = (J3DUserData)((Object)object);
        if (j3DUserData.linkReference != null) {
            this.currentLink = j3DUserData.linkReference;
            this.currentState = 2;
            bl = true;
        }
        if (j3DUserData.sensors != null) {
            VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = j3DUserData.sensors;
            for (int i = 0; i < vRMLPointingDeviceSensorNodeTypeArray.length; ++i) {
                boolean bl2 = vRMLPointingDeviceSensorNodeTypeArray[i].getEnabled();
                if (!bl2) continue;
                if (vRMLPointingDeviceSensorNodeTypeArray[i] instanceof VRMLTouchSensorNodeType) {
                    VRMLTouchSensorNodeType vRMLTouchSensorNodeType = (VRMLTouchSensorNodeType)vRMLPointingDeviceSensorNodeTypeArray[i];
                    this.activeTouchSensors.add((Object)vRMLTouchSensorNodeType);
                    this.hasTouchSensor = true;
                    continue;
                }
                VRMLDragSensorNodeType vRMLDragSensorNodeType = (VRMLDragSensorNodeType)vRMLPointingDeviceSensorNodeTypeArray[i];
                this.activeDragSensors.add((Object)vRMLDragSensorNodeType);
                this.hasDragSensor = true;
            }
            if (this.hasTouchSensor || this.hasDragSensor) {
                this.currentState = 3;
                bl = true;
            }
        }
        return bl;
    }

    private void calcSensorGroupVWorld(SceneGraphPath sceneGraphPath, int n, Transform3D transform3D) {
        Node node;
        int n2;
        Node[] nodeArray;
        int n3 = sceneGraphPath.nodeCount();
        boolean bl = false;
        for (int i = n3 - 1; i >= n && !bl; --i) {
            nodeArray = sceneGraphPath.getNode(i);
            J3DUserData j3DUserData = (J3DUserData)((Object)nodeArray.getUserData());
            if (j3DUserData == null) continue;
            bl = j3DUserData.isTransform;
        }
        if (!bl) {
            transform3D.setIdentity();
            return;
        }
        Node node2 = sceneGraphPath.getNode(n);
        nodeArray = new Node[n];
        boolean bl2 = false;
        for (n2 = 0; n2 < n; ++n2) {
            node = sceneGraphPath.getNode(n2);
            if (node instanceof Link) {
                bl2 = true;
            }
            nodeArray[n2] = node;
        }
        n2 = 0;
        node = sceneGraphPath.getNode(n);
        if (node instanceof TransformGroup) {
            n2 = 1;
            ((TransformGroup)node).getTransform(this.wkTrans);
        }
        if (bl2) {
            this.sensorPath.setLocale(sceneGraphPath.getLocale());
            this.sensorPath.setNodes(nodeArray);
            this.sensorPath.setObject(node2);
            node2.getLocalToVworld(this.sensorPath, transform3D);
        } else {
            node2.getLocalToVworld(transform3D);
        }
        if (n2 != 0) {
            transform3D.mul(transform3D, this.wkTrans);
        }
    }

    private void calcHitPoint(SceneGraphPath sceneGraphPath, int n, Point3d point3d) {
        this.calcSensorGroupVWorld(sceneGraphPath, n, this.sensorTransform);
        this.sensorTransform.invert();
        this.sensorTransform.transform(point3d);
    }

    private void setNavMode(int n, TrackerState trackerState) {
        for (int i = 0; i < trackerState.buttonState.length; ++i) {
            if (!trackerState.buttonState[i]) continue;
            switch (trackerState.buttonMode[i]) {
                case 10: {
                    this.navMode[n] = this.boundNavModes[0];
                    break;
                }
                case 11: {
                    this.navMode[n] = this.boundNavModes[1];
                    break;
                }
                case 12: {
                    this.navMode[n] = this.boundNavModes[2];
                }
            }
            if (!this.anyAllowed) {
                int n2 = this.boundNavModes.length;
                boolean bl = false;
                for (int j = 0; j < n2; ++j) {
                    if (trackerState.buttonMode[i] == 2 && this.boundNavModes[j] == 1) {
                        bl = true;
                        break;
                    }
                    if (trackerState.buttonMode[i] == 3 && this.boundNavModes[j] == 4) {
                        bl = true;
                        break;
                    }
                    if (trackerState.buttonMode[i] == 5 && this.boundNavModes[j] == 3) {
                        bl = true;
                        break;
                    }
                    if (trackerState.buttonMode[i] != 4 || this.boundNavModes[j] != 5) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.navMode[n] = 0;
                    continue;
                }
            }
            switch (trackerState.buttonMode[i]) {
                case 2: {
                    this.navMode[n] = 1;
                    break;
                }
                case 3: {
                    this.navMode[n] = 4;
                    break;
                }
                case 5: {
                    this.navMode[n] = 3;
                    break;
                }
                case 6: {
                    this.navMode[n] = 2;
                    break;
                }
                case 0: {
                    this.navMode[n] = 0;
                }
            }
            break;
        }
        this.navHandler.setNavigationState(this.navMode[n]);
    }

    private void processButtons(int n, TrackerState trackerState) {
        for (int i = 0; i < trackerState.buttonState.length; ++i) {
            int n2 = n * 8 + i;
            if (!trackerState.buttonState[i] || trackerState.buttonState[i] == this.lastButtonState[n2]) continue;
            switch (trackerState.buttonMode[i]) {
                case 18: {
                    System.out.println("GOTO Viewpoint next");
                }
            }
            this.lastButtonState[n2] = trackerState.buttonState[i];
        }
    }

    private void fireNavigationStateChanged(int n) {
        int n2 = this.navigationStateListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                NavigationStateListener navigationStateListener = (NavigationStateListener)this.navigationStateListeners.get(i);
                navigationStateListener.navigationStateChanged(n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation state changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireNavigationListChanged(String[] stringArray, int n) {
        int n2 = this.navigationStateListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                NavigationStateListener navigationStateListener = (NavigationStateListener)this.navigationStateListeners.get(i);
                navigationStateListener.navigationListChanged(stringArray, n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDeviceOver(Object object) {
        String string;
        int n = 0;
        if (object instanceof VRMLTouchSensorNodeType) {
            n = 1;
            string = ((VRMLTouchSensorNodeType)object).getDescription();
        } else if (object instanceof VRMLDragSensorNodeType) {
            n = 2;
            string = ((VRMLDragSensorNodeType)object).getDescription();
        } else if (object instanceof VRMLLinkNodeType) {
            n = 0;
            string = ((VRMLLinkNodeType)object).getDescription();
        } else {
            System.out.println("Unhandled sensor type in fireDeviceOver: " + object);
            return;
        }
        int n2 = this.sensorStatusListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                SensorStatusListener sensorStatusListener = (SensorStatusListener)this.sensorStatusListeners.get(i);
                sensorStatusListener.deviceOver(n, string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDeviceNotOver(Object object) {
        int n = 0;
        if (object instanceof VRMLTouchSensorNodeType) {
            n = 1;
        } else if (object instanceof VRMLDragSensorNodeType) {
            n = 2;
        } else if (object instanceof VRMLLinkNodeType) {
            n = 0;
        } else {
            System.out.println("Unhandled sensor type in fireDeviceNotOver: " + object);
            return;
        }
        int n2 = this.sensorStatusListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                SensorStatusListener sensorStatusListener = (SensorStatusListener)this.sensorStatusListeners.get(i);
                sensorStatusListener.deviceNotOver(n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDeviceActivated(Object object) {
        int n = 0;
        if (object instanceof VRMLTouchSensorNodeType) {
            n = 1;
        } else if (object instanceof VRMLDragSensorNodeType) {
            n = 2;
        } else if (object instanceof VRMLLinkNodeType) {
            n = 0;
        } else {
            System.out.println("Unhandled sensor type in fireDeviceActivated: " + object);
            return;
        }
        int n2 = this.sensorStatusListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                SensorStatusListener sensorStatusListener = (SensorStatusListener)this.sensorStatusListeners.get(i);
                sensorStatusListener.deviceActivated(n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireLinkActivated(VRMLLinkNodeType vRMLLinkNodeType) {
        String[] stringArray = vRMLLinkNodeType.getUrl();
        int n = this.sensorStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                SensorStatusListener sensorStatusListener = (SensorStatusListener)this.sensorStatusListeners.get(i);
                sensorStatusListener.linkActivated(stringArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void updateCenterOfRotation(TrackerState trackerState) {
        BoundingBox boundingBox;
        Point3d point3d;
        Point3d point3d2;
        Object object;
        Node node;
        this.mouseEyePosition.x = trackerState.worldPos[0];
        this.mouseEyePosition.y = trackerState.worldPos[1];
        this.mouseEyePosition.z = trackerState.worldPos[2];
        this.mousePickDirection.x = trackerState.worldOri[0];
        this.mousePickDirection.y = trackerState.worldOri[1];
        this.mousePickDirection.z = trackerState.worldOri[2];
        this.mousePickShape.set(this.mouseEyePosition, this.mousePickDirection);
        SceneGraphPath[] sceneGraphPathArray = this.pickableWorld.pickAllSorted((PickShape)this.mousePickShape);
        if (sceneGraphPathArray == null) {
            return;
        }
        double d = -1.0;
        int n = -1;
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            Enumeration enumeration;
            node = sceneGraphPathArray[i].getObject();
            if (!(node instanceof Shape3D)) continue;
            Transform3D transform3D = sceneGraphPathArray[i].getTransform();
            try {
                enumeration = ((Shape3D)node).getAllGeometries();
            }
            catch (CapabilityNotSetException capabilityNotSetException) {
                continue;
            }
            while (enumeration.hasMoreElements()) {
                GeometryArray geometryArray = (GeometryArray)enumeration.nextElement();
                object = (J3DUserData)((Object)geometryArray.getUserData());
                boolean bl = false;
                if (object != null && object.geometryData != null && object.geometryData instanceof GeometryData) {
                    point3d2 = (GeometryData)object.geometryData;
                    bl = this.iutils.rayUnknownGeometry(this.mouseEyePosition, this.mousePickDirection, 0.0f, (GeometryData)point3d2, transform3D, this.wkPoint, false);
                } else {
                    bl = this.iutils.rayUnknownGeometry(this.mouseEyePosition, this.mousePickDirection, 0.0f, geometryArray, transform3D, this.wkPoint, false);
                }
                if (!bl) continue;
                this.diffVec.sub((Tuple3d)this.mouseEyePosition, (Tuple3d)this.wkPoint);
                if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) continue;
                n = i;
                d = this.diffVec.lengthSquared();
                this.sensorHitPoint[0] = (float)this.wkPoint.x;
                this.sensorHitPoint[1] = (float)this.wkPoint.y;
                this.sensorHitPoint[2] = (float)this.wkPoint.z;
            }
        }
        if (n == -1) {
            return;
        }
        node = sceneGraphPathArray[n].getObject();
        Transform3D transform3D = sceneGraphPathArray[n].getTransform();
        object = node.getBounds();
        object.transform(transform3D);
        float[] fArray = new float[3];
        if (object instanceof BoundingBox) {
            point3d2 = new Point3d();
            point3d = new Point3d();
            boundingBox = (BoundingBox)object;
            boundingBox.getLower(point3d2);
            boundingBox.getUpper(point3d);
            fArray[0] = (float)((point3d2.x + point3d.x) / 2.0);
            fArray[1] = (float)((point3d2.y + point3d.y) / 2.0);
            fArray[2] = (float)((point3d2.z + point3d.z) / 2.0);
        } else if (object instanceof BoundingSphere) {
            point3d2 = (BoundingSphere)object;
            point3d = new Point3d();
            point3d2.getCenter(point3d);
            fArray[0] = (float)point3d.x;
            fArray[1] = (float)point3d.y;
            fArray[2] = (float)point3d.z;
        } else {
            fArray[0] = this.sensorHitPoint[0];
            fArray[1] = this.sensorHitPoint[1];
            fArray[2] = this.sensorHitPoint[2];
        }
        point3d2 = new Point3d((double)fArray[0], (double)fArray[1], (double)fArray[2]);
        point3d = new Point3d((double)this.sensorHitPoint[0], (double)this.sensorHitPoint[1], (double)this.sensorHitPoint[2]);
        transform3D.transform(point3d2);
        boundingBox = new Vector3d();
        this.navHandler.getPosition((Vector3d)boundingBox);
        Vector3d vector3d = new Vector3d();
        vector3d.sub((Tuple3d)point3d, (Tuple3d)boundingBox);
        boundingBox.x += 0.5 * vector3d.x;
        boundingBox.y += 0.5 * vector3d.y;
        boundingBox.z += 0.5 * vector3d.z;
        fArray[0] = (float)point3d2.x;
        fArray[1] = (float)point3d2.y;
        fArray[2] = (float)point3d2.z;
        this.navHandler.setCenterOfRotation(fArray, new float[]{(float)boundingBox.x, (float)boundingBox.y, (float)boundingBox.z});
    }

    static {
        navigationTypes.put("EXAMINE", new Integer(5));
        navigationTypes.put(DEFAULT_NAV_STRING, new Integer(1));
        navigationTypes.put("FLY", new Integer(4));
        navigationTypes.put("NONE", new Integer(0));
        navigationTypes.put("LOOKAT", new Integer(6));
        navigationTypes.put("xj3d_PAN", new Integer(3));
        navigationTypes.put("xj3d_TILT", new Integer(2));
    }
}

