/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.input;

import java.awt.image.RenderedImage;
import java.nio.Buffer;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.j3d.renderer.java3d.terrain.AppearanceGenerator;
import org.j3d.renderer.java3d.terrain.roam.J3DSplitMergeLandscape;
import org.j3d.renderer.java3d.util.J3DViewFrustum;
import org.j3d.terrain.TerrainData;
import org.j3d.util.frustum.ViewFrustum;
import org.j3d.util.interpolator.ColorInterpolator;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTextureListener;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.renderer.j3d.input.StaticTerrainDataSource;
import org.web3d.vrml.renderer.j3d.nodes.J3DAppearanceListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DAppearanceNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DTerrainSource;

public class J3DTerrainManager
implements AppearanceGenerator,
J3DAppearanceListener,
VRMLTextureListener {
    private Canvas3D canvas;
    private J3DTerrainSource source;
    private StaticTerrainDataSource terrainData;
    private J3DViewFrustum viewFrustum;
    private J3DSplitMergeLandscape landscape;
    private BranchGroup landscapeGroup;
    private BranchGroup terrainHolder;
    private TransformGroup terrainTransform;
    private ColorInterpolator heightRamp;
    private PolygonAttributes polyAttr;
    private Material material;
    private Texture texture;
    private double[] geoOrigin;
    double[] spacing;
    int xSize;
    int zSize;
    double[] data;
    float[][][] tcs;

    public J3DTerrainManager(Canvas3D canvas3D) {
        this.canvas = canvas3D;
        this.viewFrustum = new J3DViewFrustum(canvas3D);
        this.terrainHolder = new BranchGroup();
        this.terrainTransform = new TransformGroup();
        this.terrainHolder.addChild((Node)this.terrainTransform);
        this.terrainTransform.setCapability(13);
        this.terrainTransform.setCapability(14);
        this.terrainTransform.setCapability(18);
        this.heightRamp = new ColorInterpolator(1);
        this.heightRamp.addRGBKeyFrame(-20.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.heightRamp.addRGBKeyFrame(0.0f, 0.0f, 0.7f, 0.95f, 0.0f);
        this.heightRamp.addRGBKeyFrame(4.0f, 1.0f, 1.0f, 0.0f, 0.0f);
        this.heightRamp.addRGBKeyFrame(8.0f, 0.0f, 0.6f, 0.0f, 0.0f);
        this.heightRamp.addRGBKeyFrame(12.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        this.heightRamp.addRGBKeyFrame(16.0f, 0.6f, 0.7f, 0.0f, 0.0f);
        this.material = new Material();
        this.material.setLightingEnable(true);
        this.polyAttr = new PolygonAttributes();
        this.polyAttr.setCapability(3);
        this.polyAttr.setCullFace(0);
        this.polyAttr.setBackFaceNormalFlip(true);
        this.polyAttr.setPolygonMode(2);
    }

    public void appearanceChanged(Appearance appearance) {
        System.out.println("new appearance: " + appearance);
    }

    public void textureImplChanged(VRMLTextureNodeType vRMLTextureNodeType, Texture[] textureArray, boolean[] blArray, TextureAttributes[] textureAttributesArray) {
        System.out.println("Texture arrived: " + vRMLTextureNodeType);
        this.newTexture((VRMLNodeType)vRMLTextureNodeType);
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, RenderedImage renderedImage, String string) {
        System.out.println("J3D TerrainManager need to update to latest texture handling");
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, RenderedImage[] renderedImageArray, String[] stringArray) {
        System.out.println("J3D TerrainManager need to update to latest texture handling");
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, Buffer buffer, String string) {
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, Buffer[] bufferArray, String[] stringArray) {
    }

    public void textureParamsChanged(int n, int n2, int n3, int n4, float f, float[] fArray) {
    }

    public void textureParamsChanged(int n, int[] nArray, int[] nArray2, int[] nArray3, float f, float[] fArray) {
    }

    public Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setMaterial(this.material);
        appearance.setPolygonAttributes(this.polyAttr);
        return appearance;
    }

    public BranchGroup getTerrainGroup() {
        return this.terrainHolder;
    }

    public void setViewMatrix(Transform3D transform3D) {
        if (this.landscape != null) {
            this.landscape.viewerPositionUpdated(transform3D);
        }
    }

    public void sectorsAdded(ObjectArray objectArray) {
        if (objectArray.size() >= 1) {
            int n;
            Object object;
            this.source = (J3DTerrainSource)objectArray.get(0);
            J3DAppearanceNodeType j3DAppearanceNodeType = this.source.getAppearance();
            this.geoOrigin = this.source.getGeoOrigin();
            this.spacing = this.source.getSpacing();
            this.tcs = this.source.getTextureCoords();
            if (j3DAppearanceNodeType != null) {
                j3DAppearanceNodeType.addAppearanceListener(this);
                object = j3DAppearanceNodeType.getTexture();
                this.newTexture((VRMLNodeType)object);
            }
            object = new double[objectArray.size()][1];
            int[] nArray = new int[objectArray.size()];
            int[] nArray2 = new int[objectArray.size()];
            int n2 = 4;
            if (objectArray.size() < 4) {
                n2 = objectArray.size();
            }
            int n3 = objectArray.size() / n2;
            for (n = 0; n < objectArray.size(); ++n) {
                J3DTerrainSource j3DTerrainSource = (J3DTerrainSource)objectArray.get(n);
                object[n] = j3DTerrainSource.getHeight();
                nArray[n] = j3DTerrainSource.getXSize();
                nArray2[n] = j3DTerrainSource.getZSize();
            }
            this.xSize = 64 * n2;
            this.zSize = 64 * n3;
            n = this.source.getXSize();
            int n4 = this.source.getZSize();
            int n5 = 64;
            int n6 = 64;
            float f = (float)n / (float)n5;
            float f2 = (float)n4 / (float)n6;
            n = n5;
            n4 = n6;
            int n7 = n2 * n;
            this.data = new double[n2 * n * n4 * n3];
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n4; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        int n8 = i * n2 + k;
                        f = (float)nArray[k] / (float)n5;
                        f2 = (float)nArray2[k] / (float)n6;
                        int n9 = k == 0 ? 0 : 0;
                        for (int i2 = n9; i2 < n + n9; ++i2) {
                            int n10 = (int)Math.floor((float)i2 * f);
                            int n11 = (int)Math.floor((float)j * f2);
                            if (n10 > 64) {
                                n10 = 64;
                            }
                            if (n11 > 64) {
                                n11 = 64;
                            }
                            this.data[i * (n7 * n4) + j * n7 + i2 + k * n - n9] = 0.0;
                        }
                    }
                }
            }
        }
    }

    public void sectorsRemoved(ObjectArray objectArray) {
    }

    private void newTexture(VRMLNodeType vRMLNodeType) {
    }

    private void buildRoam() {
        int n = this.xSize >= 127 ? 64 : 2;
        this.terrainData = new StaticTerrainDataSource(this.data, false, this.spacing, this.xSize, this.zSize, n, n);
        this.terrainData.tcMap = this.tcs;
        float[] fArray = new float[3];
        float[] fArray2 = new float[2];
        this.terrainData.getCoordinateWithTexture(fArray, fArray2, 6, 3, 0, 0);
        this.terrainData.getCoordinateWithTexture(fArray, fArray2, 5, 0, 0, 0);
        this.landscape = new J3DSplitMergeLandscape((ViewFrustum)this.viewFrustum, (TerrainData)this.terrainData, n + 1);
        this.landscape.setAppearanceGenerator((AppearanceGenerator)this);
        this.landscapeGroup = this.landscape.getSceneGraphObject();
        this.landscapeGroup.setCapability(17);
        this.viewFrustum.viewingPlatformMoved();
        Matrix3f matrix3f = new Matrix3f();
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f vector3f2 = new Vector3f();
        Transform3D transform3D = new Transform3D();
        transform3D.get(matrix3f, vector3f2);
        matrix3f.transform((Tuple3f)vector3f);
        this.landscape.initialize((Tuple3f)vector3f2, vector3f);
        System.out.println("geoOrigin: " + this.geoOrigin[0] + " 0 " + this.geoOrigin[1]);
        Transform3D transform3D2 = new Transform3D();
        Vector3d vector3d = new Vector3d();
        vector3d.set(this.geoOrigin[0], 0.0, this.geoOrigin[1]);
        transform3D2.set(vector3d);
        this.terrainTransform.setTransform(transform3D2);
        this.terrainTransform.removeAllChildren();
        this.terrainTransform.addChild((Node)this.landscapeGroup);
    }
}

