/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.input;

import java.awt.Rectangle;
import org.j3d.terrain.AbstractTiledTerrainData;
import org.j3d.util.interpolator.ColorInterpolator;

public class TerrainDataSource
extends AbstractTiledTerrainData {
    private int gridWidth;
    private int gridDepth;
    private int maxWidthTile;
    private int maxDepthTile;
    private double[] heightMap;
    private ColorInterpolator colorInterp;

    public TerrainDataSource(double[] dArray, boolean bl, double[] dArray2, int n, int n2) {
        if (bl) {
            int n3 = n * n2;
            this.heightMap = new double[n3];
            System.arraycopy(dArray, 0, this.heightMap, 0, n3);
            this.gridDepth = n2;
            this.gridWidth = n;
        } else {
            this.heightMap = dArray;
            this.gridDepth = n2;
            this.gridWidth = n;
        }
        this.gridStepX = dArray2[0];
        this.gridStepY = dArray2[1];
        this.calcTileSize();
    }

    public void getTilesAvailableBounds(Rectangle rectangle) {
        rectangle.x = 0;
        rectangle.y = 0;
        rectangle.width = this.maxWidthTile;
        rectangle.height = this.maxDepthTile;
    }

    public void setActiveBounds(Rectangle rectangle) {
    }

    public float getHeight(float f, float f2) {
        float f3 = f / (float)this.gridStepX;
        float f4 = f2 / (float)this.gridStepY;
        int n = (int)Math.floor(f3);
        int n2 = (int)Math.floor(f4);
        if (n < 0 || n2 < 0 || n + 1 >= this.gridWidth || n2 + 1 >= this.gridDepth) {
            return Float.NaN;
        }
        double d = this.heightMap[n + n2 * this.gridWidth];
        double d2 = this.heightMap[n + (n2 + 1) * this.gridWidth];
        double d3 = this.heightMap[n + 1 + n2 * this.gridWidth];
        double d4 = this.heightMap[n + 1 + (n2 + 1) * this.gridWidth];
        return (float)((d + d2 + d3 + d4) * 0.25);
    }

    public void getCoordinate(float[] fArray, int n, int n2) {
        fArray[0] = (float)n * (float)this.gridStepX;
        fArray[2] = (float)(-n2) * (float)this.gridStepY;
        int n3 = 0;
        int n4 = 0;
        if (n >= this.gridWidth) {
            n3 = this.gridWidth - 1;
        } else if (n > 0) {
            n3 = n;
        }
        if (n2 >= this.gridDepth) {
            n4 = this.gridDepth - 1;
        } else if (n2 > 0) {
            n4 = n2;
        }
        fArray[1] = (float)this.heightMap[n3 + n4 * this.gridWidth];
    }

    public void getCoordinate(float[] fArray, float[] fArray2, float[] fArray3, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n >= this.gridWidth) {
            n3 = this.gridWidth - 1;
        } else if (n > 0) {
            n3 = n;
        }
        if (n2 >= this.gridDepth) {
            n4 = this.gridDepth - 1;
        } else if (n2 > 0) {
            n4 = n2;
        }
        fArray[1] = (float)this.heightMap[n3 + n4 * this.gridWidth];
        fArray[0] = (float)n * (float)this.gridStepX;
        fArray[2] = (float)(-n2) * (float)this.gridStepY;
        fArray2[0] = (float)n / (float)(this.gridWidth - 1);
        fArray2[1] = (float)n2 / (float)(this.gridDepth - 1);
        if (n >= 0 && n2 >= 0 && n < this.gridWidth && n2 < this.gridDepth) {
            float[] fArray4 = this.colorInterp.floatRGBValue(fArray[1]);
            fArray3[0] = fArray4[0];
            fArray3[1] = fArray4[1];
            fArray3[2] = fArray4[2];
        } else {
            fArray3[0] = 1.0f;
            fArray3[1] = 1.0f;
            fArray3[2] = 1.0f;
        }
    }

    public void getCoordinateWithTexture(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        if (this.tileGenerator == null) {
            if (n >= this.gridWidth) {
                n5 = this.gridWidth - 1;
            } else if (n > 0) {
                n5 = n;
            }
            if (n2 >= this.gridDepth) {
                n6 = this.gridDepth - 1;
            } else if (n2 > 0) {
                n6 = n2;
            }
            fArray[1] = (float)this.heightMap[n5 + n6 * this.gridWidth];
            fArray[0] = (float)n * (float)this.gridStepX;
            fArray[2] = (float)(-n2) * (float)this.gridStepY;
            fArray2[0] = (float)n / (float)(this.gridWidth - 1);
            fArray2[1] = (float)n2 / (float)(this.gridDepth - 1);
        } else {
            if (n >= this.gridWidth) {
                n5 = this.gridWidth - 1;
            } else if (n > 0) {
                n5 = n;
            }
            if (n2 >= this.gridDepth) {
                n6 = this.gridDepth - 1;
            } else if (n2 > 0) {
                n6 = n2;
            }
            fArray[1] = (float)this.heightMap[n5 + n6 * this.gridWidth];
            fArray[0] = (float)n * (float)this.gridStepX;
            fArray[2] = (float)(-n2) * (float)this.gridStepY;
            fArray2[1] = n4 % 2 == 0 ? (n2 < 0 ? (n2 % 128 == 0 ? 0.0f : 1.0f + (float)(n2 % 64) / 64.0f) : (n2 % 64 == 0 && n2 % 128 != 0 ? 1.0f : (float)(n2 % 64) / 64.0f)) : (n2 <= 0 ? (n2 % 64 == 0 && n2 % 128 != 0 ? 0.0f : 1.0f + (float)(n2 % 64) / 64.0f) : (n2 % 128 == 0 ? 1.0f : (float)(n2 % 64) / 64.0f));
            fArray2[0] = n3 % 2 == 0 ? (n < 0 ? (n % 64 == 0 && n % 128 != 0 ? 0.0f : 1.0f + (float)(n % 64) / 64.0f) : (n % 128 == 0 ? 1.0f : (float)(n % 64) / 64.0f)) : (n <= 0 ? (n % 128 == 0 ? 0.0f : 1.0f + (float)(n % 64) / 64.0f) : (n % 64 == 0 && n % 128 != 0 ? 1.0f : (float)(n % 64) / 64.0f));
        }
    }

    public void getCoordinateWithColor(float[] fArray, float[] fArray2, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n >= this.gridWidth) {
            n3 = this.gridWidth - 1;
        } else if (n > 0) {
            n3 = n;
        }
        if (n2 >= this.gridDepth) {
            n4 = this.gridDepth - 1;
        } else if (n2 > 0) {
            n4 = n2;
        }
        float f = (float)this.heightMap[n3 + n4 * this.gridWidth];
        fArray[0] = (float)n * (float)this.gridStepX;
        fArray[1] = f;
        fArray[2] = (float)(-n2) * (float)this.gridStepY;
        if (n >= 0 && n2 >= 0 && n < this.gridWidth && n2 < this.gridDepth) {
            float[] fArray3 = this.colorInterp.floatRGBValue(fArray[1]);
            fArray2[0] = fArray3[0];
            fArray2[1] = fArray3[1];
            fArray2[2] = fArray3[2];
        } else {
            fArray2[0] = 1.0f;
            fArray2[1] = 1.0f;
            fArray2[2] = 1.0f;
        }
    }

    public float getHeightFromGrid(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n >= this.gridWidth) {
            n3 = this.gridWidth - 1;
        } else if (n > 0) {
            n3 = n;
        }
        if (n2 >= this.gridDepth) {
            n4 = this.gridDepth - 1;
        } else if (n2 > 0) {
            n4 = n2;
        }
        return (float)this.heightMap[n3 + n4 * this.gridWidth];
    }

    public void setColorInterpolator(ColorInterpolator colorInterpolator) {
        this.colorInterp = colorInterpolator;
        this.colorAvailable = this.colorInterp != null;
    }

    private void calcTileSize() {
        int n = 64;
        int n2 = this.gridDepth - 1;
        while (n2 % n != 0) {
            n >>= 1;
        }
        this.gridPointsPerTile = n;
        this.maxDepthTile = (this.gridDepth - 1) / n;
        this.maxWidthTile = (this.gridWidth - 1) / n;
    }
}

