/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.input;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Point3d;
import org.web3d.vrml.nodes.runtime.InputEventBuffer;

public class UserInputBehavior
extends Behavior
implements InputEventBuffer {
    private static final int DEFAULT_SIZE = 1024;
    private static final int INCREMENT_SIZE = 128;
    private Object keyMutex;
    private Object mouseMutex;
    private int numKeyEvents;
    private KeyEvent[] keyEvents;
    private int numMouseEvents;
    private MouseEvent[] mouseEvents;
    private WakeupOnAWTEvent criteria;

    public UserInputBehavior() {
        long l = 56L;
        this.criteria = new WakeupOnAWTEvent(l);
        Point3d point3d = new Point3d();
        BoundingSphere boundingSphere = new BoundingSphere(point3d, Double.POSITIVE_INFINITY);
        this.setSchedulingBounds((Bounds)boundingSphere);
        this.keyMutex = new Object();
        this.mouseMutex = new Object();
        this.numKeyEvents = 0;
        this.keyEvents = new KeyEvent[1024];
        this.numMouseEvents = 0;
        this.mouseEvents = new MouseEvent[1024];
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.criteria);
    }

    public void processStimulus(Enumeration enumeration) {
        WakeupOnAWTEvent wakeupOnAWTEvent = (WakeupOnAWTEvent)enumeration.nextElement();
        AWTEvent[] aWTEventArray = wakeupOnAWTEvent.getAWTEvent();
        for (int i = 0; i < aWTEventArray.length; ++i) {
            if (aWTEventArray[i] instanceof MouseEvent) {
                this.addMouseEvent((MouseEvent)aWTEventArray[i]);
                continue;
            }
            if (!(aWTEventArray[i] instanceof KeyEvent)) continue;
            this.addKeyEvent((KeyEvent)aWTEventArray[i]);
        }
        this.wakeupOn((WakeupCondition)this.criteria);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeyEvents(KeyEvent[] keyEventArray) {
        int n = this.numKeyEvents;
        if (this.numKeyEvents != 0) {
            Object object = this.keyMutex;
            synchronized (object) {
                int n2;
                int n3 = n2 = keyEventArray.length < this.numKeyEvents ? keyEventArray.length : this.numKeyEvents;
                while (--n3 >= 0) {
                    keyEventArray[n3] = this.keyEvents[n3];
                    this.keyEvents[n3] = null;
                }
                this.numKeyEvents = 0;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMouseEvents(MouseEvent[] mouseEventArray) {
        int n = this.numMouseEvents;
        if (this.numMouseEvents != 0) {
            Object object = this.mouseMutex;
            synchronized (object) {
                int n2;
                int n3 = n2 = mouseEventArray.length < this.numMouseEvents ? mouseEventArray.length : this.numMouseEvents;
                while (--n3 >= 0) {
                    mouseEventArray[n3] = this.mouseEvents[n3];
                    this.mouseEvents[n3] = null;
                }
                this.numMouseEvents = 0;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeyEvent(KeyEvent keyEvent) {
        Object object = this.keyMutex;
        synchronized (object) {
            if (this.numKeyEvents == this.keyEvents.length) {
                KeyEvent[] keyEventArray = new KeyEvent[this.numKeyEvents + 128];
                System.arraycopy(this.keyEvents, 0, keyEventArray, 0, this.numKeyEvents);
                this.keyEvents = keyEventArray;
            }
            this.keyEvents[this.numKeyEvents++] = keyEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMouseEvent(MouseEvent mouseEvent) {
        Object object = this.mouseMutex;
        synchronized (object) {
            if (this.numMouseEvents == this.mouseEvents.length) {
                MouseEvent[] mouseEventArray = new MouseEvent[this.numMouseEvents + 128];
                System.arraycopy(this.mouseEvents, 0, mouseEventArray, 0, this.numMouseEvents);
                this.mouseEvents = mouseEventArray;
            }
            this.mouseEvents[this.numMouseEvents++] = mouseEvent;
        }
    }
}

