/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.input;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.PickConeRay;
import javax.media.j3d.PickConeSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;
import org.web3d.vrml.renderer.j3d.nodes.J3DVisibilityListener;

class VisibilityManager {
    private static final int LIST_START_SIZE = 25;
    private static final int LIST_INCREMENT = 25;
    private BranchGroup worldRoot;
    private HashSet activeVisSensors;
    private HashSet newVisSensors;
    private J3DVisibilityListener[] list;
    private int lastListener = 0;
    private PickConeSegment limitedPicker = new PickConeSegment();
    private PickConeRay endlessPicker = new PickConeRay();
    private Point3d endPoint = new Point3d();

    VisibilityManager() {
        this.activeVisSensors = new HashSet();
        this.newVisSensors = new HashSet();
        this.list = new J3DVisibilityListener[25];
    }

    public void addSensor(VRMLSensorNodeType vRMLSensorNodeType) {
    }

    public void removeSensor(VRMLSensorNodeType vRMLSensorNodeType) {
    }

    public void setWorldRoot(BranchGroup branchGroup) {
        this.worldRoot = branchGroup;
    }

    public void clear() {
        this.activeVisSensors.clear();
        this.newVisSensors.clear();
    }

    public void processFrame(Point3d point3d, Vector3d vector3d, AxisAngle4d axisAngle4d, float f, float f2) {
        Object object;
        int n;
        if (this.worldRoot == null) {
            return;
        }
        SceneGraphPath[] sceneGraphPathArray = null;
        if (f != 0.0f) {
            this.endPoint.x = vector3d.x * (double)f + point3d.x;
            this.endPoint.y = vector3d.y * (double)f + point3d.y;
            this.endPoint.z = vector3d.z * (double)f + point3d.z;
            this.limitedPicker.set(point3d, this.endPoint, (double)f2);
            sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.limitedPicker);
        } else {
            this.endlessPicker.set(point3d, vector3d, (double)f2);
            sceneGraphPathArray = this.worldRoot.pickAll((PickShape)this.endlessPicker);
        }
        if (sceneGraphPathArray != null && sceneGraphPathArray.length != 0) {
            this.newVisSensors.clear();
            for (n = 0; n < sceneGraphPathArray.length; ++n) {
                Node node = sceneGraphPathArray[n].getObject();
                object = (J3DUserData)((Object)node.getUserData());
                if (object == null || object.visibilityListener == null) continue;
                J3DVisibilityListener j3DVisibilityListener = object.visibilityListener;
                Transform3D transform3D = sceneGraphPathArray[n].getTransform();
                if (this.activeVisSensors.contains((Object)j3DVisibilityListener)) {
                    j3DVisibilityListener.viewPositionChanged(point3d, axisAngle4d, transform3D);
                    this.activeVisSensors.remove((Object)j3DVisibilityListener);
                } else {
                    j3DVisibilityListener.visibilityStateChange(true, point3d, axisAngle4d, transform3D);
                }
                this.newVisSensors.add((Object)j3DVisibilityListener);
            }
        }
        if ((n = this.activeVisSensors.size()) != 0) {
            this.resizeList(n);
            this.activeVisSensors.toArray((Object[])this.list);
            for (int i = 0; i < n && this.list[i] != null; ++i) {
                object = this.list[i];
                object.visibilityStateChange(false, point3d, axisAngle4d, null);
                this.activeVisSensors.remove(object);
            }
        }
        HashSet hashSet = this.activeVisSensors;
        this.activeVisSensors = this.newVisSensors;
        this.newVisSensors = hashSet;
    }

    private final void resizeList(int n) {
        if (this.list.length < n) {
            int n2 = this.list.length;
            int n3 = n2 + 25;
            J3DVisibilityListener[] j3DVisibilityListenerArray = new J3DVisibilityListener[n3];
            System.arraycopy(this.list, 0, j3DVisibilityListenerArray, 0, n2);
            this.list = j3DVisibilityListenerArray;
        }
    }
}

