/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes;

import java.util.ArrayList;
import java.util.Map;
import org.web3d.vrml.renderer.common.nodes.BaseComponentGeometryNode;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNodeType;

public abstract class J3DComponentGeometryNode
extends BaseComponentGeometryNode
implements J3DGeometryNodeType {
    private ArrayList listeners = new ArrayList();

    public J3DComponentGeometryNode(String string) {
        super(string);
    }

    public void addGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.add(j3DGeometryListener);
    }

    public void removeGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || !this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.remove(j3DGeometryListener);
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    protected void fireGeometryAdded(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryAdded(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry add message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void fireGeometryChanged(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryChanged(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry change message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void fireGeometryRemoved(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryRemoved(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry remove message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

