/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.Appearance;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Vector3d;
import org.j3d.geom.BoxGenerator;
import org.j3d.geom.GeometryData;
import org.j3d.geom.SphereGenerator;

public class J3DGlobalStatus {
    public static final boolean haveFreqBitsAPI;
    public static final TriangleStripArray boxGeometry;
    public static final TriangleStripArray sphereGeometry;
    public static final Appearance invisibleAppearance;
    public static final Vector3d defaultOrientation;

    static {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("javax.media.j3d.SceneGraphObject");
                    Package package_ = clazz.getPackage();
                    return package_.isCompatibleWith("1.3");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Boolean.FALSE;
                }
            }
        });
        haveFreqBitsAPI = bl;
        int n = 1;
        BoxGenerator boxGenerator = new BoxGenerator(1.0f, 1.0f, 1.0f);
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 3;
        boxGenerator.generate(geometryData);
        boxGeometry = new TriangleStripArray(geometryData.vertexCount, n, geometryData.stripCounts);
        boxGeometry.setCoordinates(0, geometryData.coordinates);
        SphereGenerator sphereGenerator = new SphereGenerator(1.0f);
        geometryData.coordinates = null;
        geometryData.stripCounts = null;
        sphereGenerator.generate(geometryData);
        sphereGeometry = new TriangleStripArray(geometryData.vertexCount, n, geometryData.stripCounts);
        sphereGeometry.setCoordinates(0, geometryData.coordinates);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setVisible(false);
        invisibleAppearance = new Appearance();
        invisibleAppearance.setRenderingAttributes(renderingAttributes);
        defaultOrientation = new Vector3d(0.0, 0.0, -1.0);
    }
}

