/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes;

import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNode;

public abstract class J3DIndexedGeometry
extends J3DGeometryNode
implements VRMLComponentGeometryNodeType {
    protected static final int FIELD_COLOR = 1;
    protected static final int FIELD_COORD = 2;
    protected static final int FIELD_COLORINDEX = 3;
    protected static final int FIELD_SET_COLORINDEX = 4;
    protected static final int FIELD_COLORPERVERTEX = 5;
    protected static final int FIELD_COORDINDEX = 6;
    protected static final int FIELD_SET_COORDINDEX = 7;
    protected static final int LAST_INDEXEDGEOMETRY_INDEX = 7;
    protected static final String COORD_PROTO_MSG = "Proto does not describe a Coord object";
    protected static final String COORD_NODE_MSG = "Node does not describe a Coord object";
    protected static final String COLOR_PROTO_MSG = "Proto does not describe a Color object";
    protected static final String COLOR_NODE_MSG = "Node does not describe a Color object";
    protected VRMLProtoInstance pColor;
    protected VRMLColorNodeType vfColor;
    protected VRMLProtoInstance pCoord;
    protected VRMLCoordinateNodeType vfCoord;
    protected int[] vfColorIndex = FieldConstants.EMPTY_MFINT32;
    protected int numColorIndex;
    protected boolean vfColorPerVertex = true;
    protected int[] vfCoordIndex = FieldConstants.EMPTY_MFINT32;
    protected int numCoordIndex;
    protected int numPieces = 0;
    protected int numIndices = 0;
    protected boolean isConstSize = false;
    protected int constSize = 0;
    protected float[] lfColor;
    protected float[] lfCoord;
    protected int[] lfColorIndex;
    protected int[] lfCoordIndex;
    protected int[] pieceSizes;

    public J3DIndexedGeometry(String string) {
        super(string);
    }

    protected void copy(VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType) {
        try {
            int n = vRMLComponentGeometryNodeType.getFieldIndex("colorIndex");
            VRMLFieldData vRMLFieldData = vRMLComponentGeometryNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfColorIndex = new int[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfColorIndex, 0, vRMLFieldData.numElements);
            }
            n = vRMLComponentGeometryNodeType.getFieldIndex("coordIndex");
            vRMLFieldData = vRMLComponentGeometryNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfCoordIndex = new int[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfCoordIndex, 0, vRMLFieldData.numElements);
            }
            n = vRMLComponentGeometryNodeType.getFieldIndex("colorPerVertex");
            vRMLFieldData = vRMLComponentGeometryNodeType.getFieldValue(n);
            this.vfColorPerVertex = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean hasLocalColorAlpha() {
        return this.vfColor != null && this.vfColor.getNumColorComponents() == 4;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pCoord != null) {
            this.pCoord.setupFinished();
        } else if (this.vfCoord != null) {
            this.vfCoord.setupFinished();
        }
        if (this.pColor != null) {
            this.pColor.setupFinished();
        } else if (this.vfColor != null) {
            this.vfColor.setupFinished();
        }
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.vfColor;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.vfCoord;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfColorIndex;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.numColorIndex;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfColorPerVertex;
                this.fieldData.dataType = 1;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfCoordIndex;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.numCoordIndex;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    if (this.pColor != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pColor);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfColor);
                    break;
                }
                case 2: {
                    if (this.pCoord != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pCoord);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfCoord);
                    break;
                }
                default: {
                    System.err.println("J3DIndexedGeometry.sendRoute: No index: " + n);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldFormatException, InvalidFieldValueException {
        if (this.inSetup) {
            switch (n) {
                case 6: {
                    this.vfCoordIndex = nArray;
                    this.numCoordIndex = n2;
                    break;
                }
                case 3: {
                    this.vfColorIndex = nArray;
                    this.numColorIndex = n2;
                    break;
                }
                case 7: {
                    throw new InvalidFieldAccessException("set_coordIndex is write only");
                }
                case 4: {
                    throw new InvalidFieldAccessException("set_colorIndex is write only");
                }
                default: {
                    super.setValue(n, nArray, n2);
                    break;
                }
            }
        } else {
            switch (n) {
                case 7: {
                    this.vfCoordIndex = nArray;
                    this.numCoordIndex = n2;
                    break;
                }
                case 4: {
                    this.vfColorIndex = nArray;
                    this.numColorIndex = n2;
                    break;
                }
                case 6: {
                    throw new InvalidFieldAccessException("coordIndex is initializeOnly");
                }
                case 3: {
                    throw new InvalidFieldAccessException("colorIndex is initializeOnly");
                }
                default: {
                    super.setValue(n, nArray, n2);
                }
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("colorPerVertex is initializeOnly");
                }
                this.vfColorPerVertex = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    protected void countIndex() {
        boolean bl = false;
        int n = 0;
        this.numPieces = 0;
        this.numIndices = 0;
        this.isConstSize = true;
        this.constSize = 0;
        if (this.vfCoordIndex == null) {
            return;
        }
        for (int i = 0; i < this.numCoordIndex; ++i) {
            if (this.vfCoordIndex[i] == -1) {
                if (this.numPieces == 0) {
                    this.constSize = n;
                } else if (n != this.constSize) {
                    this.isConstSize = false;
                    this.constSize = n;
                }
                ++this.numPieces;
                n = 0;
                bl = false;
                continue;
            }
            ++this.numIndices;
            ++n;
            bl = true;
        }
        if (bl) {
            if (this.numPieces == 0) {
                this.isConstSize = true;
                this.constSize = n;
            } else if (n != this.constSize) {
                this.isConstSize = false;
            }
            ++this.numPieces;
        }
    }

    protected void fillImplArrays(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == -1) {
                nArray2[n2++] = n3;
                n3 = 0;
                bl = false;
                continue;
            }
            nArray3[n4++] = nArray[i];
            ++n3;
            bl = true;
        }
        if (bl) {
            nArray2[n2++] = n3;
        }
    }

    protected boolean fillImplArraysTest(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = nArray.length;
        boolean bl = true;
        while (n5 < nArray3.length) {
            int n7;
            if (n4 >= n6) {
                n7 = nArray[n6 - 1];
                bl = false;
                return false;
            }
            n7 = nArray[n4];
            if (n7 == -1) {
                if (nArray2[n2] != n3) {
                    bl = false;
                }
                if (++n2 >= nArray2.length) {
                    bl = false;
                    --n2;
                }
                n3 = 0;
            } else {
                nArray3[n5++] = n7;
                if (n3++ > nArray2[n2]) {
                    bl = false;
                }
            }
            ++n4;
        }
        return bl;
    }

    protected int[] setupIndex(int[] nArray, int n, boolean bl) {
        int[] nArray2;
        block6: {
            int[] nArray3;
            block4: {
                block5: {
                    nArray3 = nArray;
                    if (!bl) break block4;
                    if (nArray3 == null || n == 0) {
                        nArray3 = this.vfCoordIndex;
                    }
                    if (nArray3 != this.vfCoordIndex) break block5;
                    nArray2 = this.lfCoordIndex;
                    break block6;
                }
                nArray2 = new int[this.numIndices];
                if (this.fillImplArraysTest(nArray3, n, this.pieceSizes, nArray2)) break block6;
                System.out.println("Index does not match coordIndex");
                break block6;
            }
            if (n > 0 && n != this.numPieces) {
                System.out.println("Index size != num faces");
            }
            nArray2 = new int[this.numIndices];
            int n2 = 0;
            for (int i = 0; i < this.numPieces; ++i) {
                for (int j = 0; j < this.pieceSizes[i]; ++j) {
                    nArray2[n2++] = i < n ? nArray3[i] : i;
                }
            }
        }
        return nArray2;
    }
}

