/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes;

import javax.media.j3d.AmbientLight;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SharedGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.renderer.common.nodes.BaseLightNode;
import org.web3d.vrml.renderer.j3d.nodes.J3DLightNodeType;

public abstract class J3DLightNode
extends BaseLightNode
implements J3DLightNodeType {
    private static final Bounds infiniteBounds = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
    private AmbientLight implAmbLight;
    protected Light implLight;
    private Group j3dImplNode;
    private float[] flScratch = new float[3];
    private Color3f lightColor = new Color3f();

    public J3DLightNode(String string) {
        super(string);
        this.j3dImplNode = new BranchGroup();
        this.j3dImplNode.setCapability(17);
        this.implAmbLight = new AmbientLight();
        this.implAmbLight.setCapability(15);
        this.implAmbLight.setCapability(13);
        this.implAmbLight.setInfluencingBounds(infiniteBounds);
    }

    public Light[] getLights() {
        Light[] lightArray = new Light[]{this.implAmbLight, this.implLight};
        return lightArray;
    }

    public void setAmbientIntensity(float f) throws InvalidFieldValueException {
        super.setAmbientIntensity(f);
        this.implAmbLight.setColor(this.lightColor);
    }

    public void setColor(float[] fArray) throws InvalidFieldValueException {
        super.setColor(fArray);
        this.lightColor.x = this.vfColor[0] * this.vfAmbientIntensity;
        this.lightColor.y = this.vfColor[1] * this.vfAmbientIntensity;
        this.lightColor.z = this.vfColor[2] * this.vfAmbientIntensity;
        this.implAmbLight.setColor(this.lightColor);
        this.lightColor.x = this.vfColor[0] * this.vfIntensity;
        this.lightColor.y = this.vfColor[1] * this.vfIntensity;
        this.lightColor.z = this.vfColor[2] * this.vfIntensity;
        this.implLight.setColor(this.lightColor);
    }

    public void setIntensity(float f) throws InvalidFieldValueException {
        super.setIntensity(f);
        this.lightColor.x = this.vfColor[0] * this.vfIntensity;
        this.lightColor.y = this.vfColor[1] * this.vfIntensity;
        this.lightColor.z = this.vfColor[2] * this.vfIntensity;
        this.implLight.setColor(this.lightColor);
    }

    public void setOn(boolean bl) {
        super.setOn(bl);
        this.implLight.setEnable(this.vfOn);
        this.implAmbLight.setEnable(this.vfOn);
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.j3dImplNode;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.lightColor.x = this.vfColor[0] * this.vfAmbientIntensity;
        this.lightColor.y = this.vfColor[1] * this.vfAmbientIntensity;
        this.lightColor.z = this.vfColor[2] * this.vfAmbientIntensity;
        this.implAmbLight.setEnable(this.vfOn);
        this.implAmbLight.setColor(this.lightColor);
        this.j3dImplNode.addChild((Node)this.implLight);
        this.j3dImplNode.addChild((Node)this.implAmbLight);
    }

    public void setDEF() {
        super.setDEF();
        this.j3dImplNode = new SharedGroup();
    }
}

