/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.core;

import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SharedGroup;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.InvalidNodeTypeException;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.core.BaseWorldRoot;
import org.web3d.vrml.renderer.j3d.nodes.J3DParentPathRequestHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DPathAwareNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;

public class J3DWorldRoot
extends BaseWorldRoot
implements J3DVRMLNode,
J3DParentPathRequestHandler,
J3DPathAwareNodeType {
    private Group j3dImplGroup;
    private int j3dChildCount;
    private HashMap j3dLinkMap = new HashMap();
    private HashMap j3dChildMap = new HashMap();
    private J3DParentPathRequestHandler parentPathHandler;
    private ObjectArray allParentPaths = new ObjectArray();

    public boolean hasParentPathChanged() {
        if (this.parentPathHandler == null) {
            return true;
        }
        return this.parentPathHandler.hasParentPathChanged();
    }

    public ObjectArray getParentPath(J3DVRMLNode j3DVRMLNode) {
        if (this.parentPathHandler == null) {
            if (this.allParentPaths.size() == 0) {
                return null;
            }
            this.parentPathHandler = (J3DParentPathRequestHandler)this.allParentPaths.get(0);
        }
        Link link = (Link)this.j3dLinkMap.get(j3DVRMLNode);
        ObjectArray objectArray = this.parentPathHandler.getParentPath(this);
        if (objectArray != null && link != null) {
            objectArray.add((Object)link);
        }
        return objectArray;
    }

    public void addParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.add((Object)j3DParentPathRequestHandler);
    }

    public void removeParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.remove((Object)j3DParentPathRequestHandler);
        if (this.parentPathHandler == j3DParentPathRequestHandler) {
            this.parentPathHandler = null;
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.j3dImplGroup;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)vRMLNodeType;
        if (this.isStatic) {
            Node node = (Node)j3DVRMLNode.getSceneGraphObject();
            if (node == null) {
                return;
            }
            if (node instanceof SharedGroup) {
                node = new Link((SharedGroup)node);
                this.j3dLinkMap.put(j3DVRMLNode, node);
            }
            ++this.j3dChildCount;
            this.j3dImplGroup.addChild(node);
            this.j3dChildMap.put(vRMLNodeType, node);
        } else {
            Node node = (Node)j3DVRMLNode.getSceneGraphObject();
            if (node == null) {
                return;
            }
            if (node instanceof SharedGroup) {
                Link link = new Link((SharedGroup)node);
                BranchGroup branchGroup = new BranchGroup();
                branchGroup.setCapability(17);
                branchGroup.addChild((Node)link);
                this.j3dLinkMap.put(j3DVRMLNode, link);
                node = branchGroup;
            } else if (!node.isCompiled()) {
                node.setCapability(17);
            }
            ++this.j3dChildCount;
            this.j3dImplGroup.addChild(node);
            this.j3dChildMap.put(vRMLNodeType, node);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.j3dImplGroup != null) {
            throw new RuntimeException("j3d group is not null in setupFinish()");
        }
        if (this.isStatic) {
            this.j3dImplGroup = new Group();
        } else if (this.isDEF) {
            this.j3dImplGroup = new SharedGroup();
        } else {
            this.j3dImplGroup = new BranchGroup();
            this.j3dImplGroup.setCapability(17);
            this.j3dImplGroup.setCapability(13);
            this.j3dImplGroup.setCapability(14);
        }
        this.j3dImplGroup.setCapability(1);
        this.j3dImplGroup.setPickable(true);
        int n = this.vfChildren.size();
        if (this.isStatic) {
            for (int i = 0; i < n; ++i) {
                J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.vfChildren.get(i);
                if (!(j3DVRMLNode instanceof VRMLChildNodeType) && !(j3DVRMLNode instanceof VRMLProtoInstance)) {
                    throw new InvalidNodeTypeException(j3DVRMLNode.getVRMLNodeName(), "Scenes can only contain ChildNodes");
                }
                Node node = (Node)j3DVRMLNode.getSceneGraphObject();
                if (node == null) continue;
                if (node instanceof SharedGroup) {
                    node = new Link((SharedGroup)node);
                    this.j3dLinkMap.put(j3DVRMLNode, node);
                }
                ++this.j3dChildCount;
                this.j3dImplGroup.addChild(node);
                this.j3dChildMap.put(j3DVRMLNode, node);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.vfChildren.get(i);
                if (!(j3DVRMLNode instanceof VRMLChildNodeType) && !(j3DVRMLNode instanceof VRMLProtoInstance)) {
                    throw new InvalidNodeTypeException(j3DVRMLNode.getVRMLNodeName(), "Scenes can only contain ChildNodes");
                }
                Node node = null;
                node = (Node)j3DVRMLNode.getSceneGraphObject();
                if (node == null) continue;
                if (node instanceof SharedGroup) {
                    Link link = new Link((SharedGroup)node);
                    BranchGroup branchGroup = new BranchGroup();
                    branchGroup.setCapability(17);
                    branchGroup.addChild((Node)link);
                    this.j3dLinkMap.put(j3DVRMLNode, link);
                    node = branchGroup;
                } else if (!node.isCompiled()) {
                    node.setCapability(17);
                }
                ++this.j3dChildCount;
                this.j3dImplGroup.addChild(node);
                this.j3dChildMap.put(j3DVRMLNode, node);
            }
        }
    }

    protected void clearChildren() {
        int n = this.j3dChildCount;
        while (--n >= 0) {
            this.j3dImplGroup.removeChild(0);
        }
        this.j3dChildCount = 0;
        n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            Object e = this.vfChildren.get(i);
            if (!(e instanceof J3DPathAwareNodeType)) continue;
            ((J3DPathAwareNodeType)e).removeParentPathListener(this);
        }
        this.j3dLinkMap.clear();
        this.j3dChildMap.clear();
        super.clearChildren();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof J3DVRMLNode)) {
            throw new InvalidFieldValueException("Node is not a J3DVRMLNode");
        }
        super.addChildNode(vRMLNodeType);
        if (vRMLNodeType instanceof J3DPathAwareNodeType) {
            ((J3DPathAwareNodeType)vRMLNodeType).addParentPathListener(this);
        }
        if (this.inSetup) {
            return;
        }
        Node node = (Node)((J3DVRMLNode)vRMLNodeType).getSceneGraphObject();
        if (node == null) {
            return;
        }
        if (node instanceof SharedGroup) {
            Link link = new Link((SharedGroup)node);
            BranchGroup branchGroup = new BranchGroup();
            branchGroup.setCapability(17);
            branchGroup.addChild((Node)link);
            this.j3dLinkMap.put(vRMLNodeType, link);
            node = branchGroup;
        } else if (!node.isCompiled()) {
            node.setCapability(17);
        }
        ++this.j3dChildCount;
        this.j3dImplGroup.addChild(node);
        this.j3dChildMap.put(vRMLNodeType, node);
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof J3DVRMLNode)) {
            throw new InvalidFieldValueException("Node is not a J3DVRMLNode");
        }
        super.removeChildNode(vRMLNodeType);
        if (vRMLNodeType instanceof J3DPathAwareNodeType) {
            ((J3DPathAwareNodeType)vRMLNodeType).removeParentPathListener(this);
        }
        if (this.inSetup) {
            return;
        }
        Node node = (Node)this.j3dChildMap.get(vRMLNodeType);
        if (node != null) {
            this.j3dImplGroup.removeChild(node);
        }
        this.j3dChildMap.remove(vRMLNodeType);
        this.j3dLinkMap.remove(vRMLNodeType);
    }
}

