/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.dis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.MultipleParentException;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.InvalidNodeTypeException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.renderer.common.nodes.dis.BaseEspduTransform;
import org.web3d.vrml.renderer.j3d.nodes.J3DParentPathRequestHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DPathAwareNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DPickableTargetNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;

public class J3DEspduTransform
extends BaseEspduTransform
implements J3DVRMLNode,
J3DParentPathRequestHandler,
J3DPathAwareNodeType,
J3DPickableTargetNodeType {
    private static final float ZEROEPS = 1.0E-4f;
    protected TransformGroup implGroup;
    protected Group j3dImplGroup;
    protected HashMap j3dChildMap;
    private HashMap j3dLinkMap;
    protected ArrayList sensorList;
    protected int j3dChildCount;
    private J3DParentPathRequestHandler parentPathHandler;
    private ObjectArray allParentPaths;
    protected Matrix4f matrix;
    private Vector3f tempVec;
    private AxisAngle4f tempAxis;
    private Matrix4f tempMtx1;
    private Matrix4f tempMtx2;
    private Transform3D transform;

    public J3DEspduTransform() {
        this.init();
    }

    private void init() {
        this.j3dChildCount = 0;
        this.j3dChildMap = new HashMap();
        this.j3dLinkMap = new HashMap();
        this.sensorList = new ArrayList();
        this.allParentPaths = new ObjectArray();
        this.hasChanged = new boolean[73];
        this.implGroup = new TransformGroup();
        this.matrix = new Matrix4f();
        this.tempVec = new Vector3f();
        this.tempAxis = new AxisAngle4f();
        this.tempMtx1 = new Matrix4f();
        this.tempMtx2 = new Matrix4f();
        this.transform = new Transform3D();
    }

    public void allEventsComplete() {
        this.updateTransform();
        this.ignoreEspdu = false;
    }

    public J3DEspduTransform(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public boolean hasParentPathChanged() {
        if (this.parentPathHandler == null) {
            return true;
        }
        return this.parentPathHandler.hasParentPathChanged();
    }

    public ObjectArray getParentPath(J3DVRMLNode j3DVRMLNode) {
        if (this.parentPathHandler == null) {
            if (this.allParentPaths.size() == 0) {
                return null;
            }
            this.parentPathHandler = (J3DParentPathRequestHandler)this.allParentPaths.get(0);
        }
        Link link = (Link)this.j3dLinkMap.get(j3DVRMLNode);
        ObjectArray objectArray = this.parentPathHandler.getParentPath(this);
        if (objectArray != null && link != null) {
            objectArray.add((Object)link);
        }
        return objectArray;
    }

    public void addParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.add((Object)j3DParentPathRequestHandler);
    }

    public void removeParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.remove((Object)j3DParentPathRequestHandler);
        if (this.parentPathHandler == j3DParentPathRequestHandler) {
            this.parentPathHandler = null;
        }
    }

    public Group getPickableGroup() {
        return this.j3dImplGroup;
    }

    public SceneGraphObject getSceneGraphObject() {
        if (this.inSetup) {
            throw new RuntimeException(this.getVRMLNodeName());
        }
        return this.j3dImplGroup;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)vRMLNodeType;
        if (this.isStatic) {
            Node node = (Node)j3DVRMLNode.getSceneGraphObject();
            if (node == null) {
                return;
            }
            if (node instanceof SharedGroup) {
                node = new Link((SharedGroup)node);
                this.j3dLinkMap.put(j3DVRMLNode, node);
            }
            ++this.j3dChildCount;
            this.implGroup.addChild(node);
        } else {
            j3DVRMLNode.setupFinished();
            Node node = (Node)j3DVRMLNode.getSceneGraphObject();
            if (node == null) {
                return;
            }
            if (node instanceof SharedGroup) {
                Link link = new Link((SharedGroup)node);
                BranchGroup branchGroup = new BranchGroup();
                branchGroup.setCapability(17);
                branchGroup.addChild((Node)link);
                this.j3dLinkMap.put(j3DVRMLNode, link);
                node = branchGroup;
            } else if (!node.isCompiled()) {
                node.setCapability(17);
            }
            ++this.j3dChildCount;
            this.implGroup.addChild(node);
        }
    }

    public void setupFinished() {
        J3DVRMLNode j3DVRMLNode;
        J3DUserData j3DUserData;
        Node node;
        if (!this.inSetup) {
            return;
        }
        if (this.j3dImplGroup != null) {
            throw new RuntimeException("j3d group is not null in setupFinish()");
        }
        super.setupFinished();
        this.j3dImplGroup = this.isStatic ? (this.shareCount > 1 ? new SharedGroup() : new Group()) : (!this.hasBindables ? new SharedGroup() : new BranchGroup());
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f) {
            node = new Point3d();
            node.x = this.vfBboxCenter[0] - this.vfBboxSize[0] / 2.0f;
            node.y = this.vfBboxCenter[1] - this.vfBboxSize[1] / 2.0f;
            node.z = this.vfBboxCenter[2] - this.vfBboxSize[2] / 2.0f;
            j3DUserData = new Point3d();
            ((Point3d)j3DUserData).x = this.vfBboxCenter[0] + this.vfBboxSize[0] / 2.0f;
            ((Point3d)j3DUserData).y = this.vfBboxCenter[1] + this.vfBboxSize[1] / 2.0f;
            ((Point3d)j3DUserData).z = this.vfBboxCenter[2] + this.vfBboxSize[2] / 2.0f;
            j3DVRMLNode = new BoundingBox((Point3d)node, (Point3d)j3DUserData);
            this.j3dImplGroup.setBounds((Bounds)j3DVRMLNode);
            this.j3dImplGroup.setBoundsAutoCompute(false);
        }
        this.j3dImplGroup.setCapability(1);
        this.j3dImplGroup.setCapability(11);
        this.j3dImplGroup.setPickable(true);
        node = this.implGroup.getParent();
        if (node == null && this.j3dImplGroup != this.implGroup) {
            this.j3dImplGroup.addChild((Node)this.implGroup);
        }
        if (!this.isStatic && this.sensorList.size() != 0) {
            j3DUserData = (J3DUserData)((Object)this.j3dImplGroup.getUserData());
            if (j3DUserData == null) {
                j3DUserData = new J3DUserData();
                this.j3dImplGroup.setUserData((Object)j3DUserData);
            }
            j3DUserData.sensors = new VRMLPointingDeviceSensorNodeType[this.sensorList.size()];
            this.sensorList.toArray(j3DUserData.sensors);
        }
        this.sensorList = null;
        int n = this.vfChildren.size();
        if (this.isStatic) {
            for (int i = 0; i < n; ++i) {
                j3DVRMLNode = (J3DVRMLNode)this.vfChildren.get(i);
                if (j3DVRMLNode instanceof CRProtoInstance && !((CRProtoInstance)j3DVRMLNode).getComplete()) continue;
                if (!(j3DVRMLNode instanceof VRMLChildNodeType) && !(j3DVRMLNode instanceof VRMLProtoInstance)) {
                    throw new InvalidNodeTypeException(j3DVRMLNode.getVRMLNodeName(), "Groups can only contain ChildNodes");
                }
                j3DVRMLNode.setupFinished();
                Node node2 = (Node)j3DVRMLNode.getSceneGraphObject();
                if (node2 == null) continue;
                if (node2 instanceof SharedGroup) {
                    node2 = new Link((SharedGroup)node2);
                    this.j3dLinkMap.put(j3DVRMLNode, node2);
                }
                ++this.j3dChildCount;
                this.implGroup.addChild(node2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                j3DVRMLNode = (J3DVRMLNode)this.vfChildren.get(i);
                if (j3DVRMLNode instanceof CRProtoInstance && !((CRProtoInstance)j3DVRMLNode).getComplete()) continue;
                if (!(j3DVRMLNode instanceof VRMLChildNodeType) && !(j3DVRMLNode instanceof VRMLProtoInstance)) {
                    throw new InvalidNodeTypeException(j3DVRMLNode.getVRMLNodeName(), "Groups can only contain ChildNodes");
                }
                j3DVRMLNode.setupFinished();
                Node node3 = (Node)j3DVRMLNode.getSceneGraphObject();
                if (node3 == null) continue;
                if (node3 instanceof SharedGroup) {
                    Link link = new Link((SharedGroup)node3);
                    BranchGroup branchGroup = new BranchGroup();
                    branchGroup.setCapability(17);
                    branchGroup.addChild((Node)link);
                    this.j3dLinkMap.put(j3DVRMLNode, link);
                    node3 = branchGroup;
                } else if (!node3.isCompiled()) {
                    node3.setCapability(17);
                }
                ++this.j3dChildCount;
                this.implGroup.addChild(node3);
            }
        }
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        if (bl) {
            return;
        }
        if (this.j3dImplGroup instanceof BranchGroup) {
            this.j3dImplGroup.setCapability(17);
            this.j3dImplGroup.setCapability(13);
            this.j3dImplGroup.setCapability(14);
        }
        this.implGroup.setCapability(17);
        this.implGroup.setCapability(13);
        this.implGroup.setCapability(14);
        this.implGroup.setCapability(18);
        this.implGroup.setCapability(17);
        this.implGroup.setCapability(1);
    }

    public void setTranslation(float[] fArray) {
        if (this.ignoreEspdu) {
            return;
        }
        super.setTranslation(fArray);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void setRotation(float[] fArray) throws InvalidFieldValueException {
        if (this.ignoreEspdu) {
            return;
        }
        super.setRotation(fArray);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    protected void clearChildren() {
        if (this.j3dChildCount != 0) {
            this.implGroup.removeAllChildren();
        }
        this.j3dChildCount = 0;
        J3DUserData j3DUserData = (J3DUserData)((Object)this.j3dImplGroup.getUserData());
        if (this.j3dLinkMap.size() != 0) {
            Set set = this.j3dLinkMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!(k instanceof J3DPathAwareNodeType)) continue;
                ((J3DPathAwareNodeType)k).removeParentPathListener(this);
            }
        }
        this.j3dLinkMap.clear();
        if (j3DUserData != null) {
            j3DUserData.sensors = null;
        }
        super.clearChildren();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object;
        Node node;
        super.addChildNode(vRMLNodeType);
        J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)vRMLNodeType;
        if (!this.inSetup && (node = (Node)j3DVRMLNode.getSceneGraphObject()) != null) {
            if (node instanceof SharedGroup) {
                object = new Link((SharedGroup)node);
                BranchGroup branchGroup = new BranchGroup();
                branchGroup.setCapability(17);
                branchGroup.addChild((Node)object);
                this.j3dLinkMap.put(vRMLNodeType, object);
                node = branchGroup;
            } else if (!node.isCompiled()) {
                node.setCapability(17);
            }
            this.j3dChildMap.put(vRMLNodeType, node);
            ++this.j3dChildCount;
            try {
                this.implGroup.addChild(node);
            }
            catch (MultipleParentException multipleParentException) {
                System.out.println("**** Group multi parent. Node: " + vRMLNodeType.getVRMLNodeName());
            }
        }
        if (vRMLNodeType instanceof J3DPathAwareNodeType) {
            ((J3DPathAwareNodeType)vRMLNodeType).addParentPathListener(this);
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            if (this.inSetup) {
                this.sensorList.add(node);
            } else {
                object = (J3DUserData)((Object)this.j3dImplGroup.getUserData());
                if (object == null) {
                    object = new J3DUserData();
                    this.j3dImplGroup.setUserData(object);
                }
                if (object.sensors == null) {
                    object.sensors = new VRMLPointingDeviceSensorNodeType[1];
                    object.sensors[0] = node;
                } else {
                    int n = object.sensors.length;
                    VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n + 1];
                    System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n);
                    vRMLPointingDeviceSensorNodeTypeArray[n] = node;
                    object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
                }
            }
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        Object object;
        if (!this.j3dChildMap.containsKey(vRMLNodeType)) {
            return;
        }
        BranchGroup branchGroup = (BranchGroup)this.j3dChildMap.get(vRMLNodeType);
        this.j3dLinkMap.remove(vRMLNodeType);
        if (vRMLNodeType instanceof J3DPathAwareNodeType) {
            ((J3DPathAwareNodeType)vRMLNodeType).removeParentPathListener(this);
        }
        branchGroup.detach();
        this.j3dChildMap.remove(vRMLNodeType);
        --this.j3dChildCount;
        VRMLPointingDeviceSensorNodeType vRMLPointingDeviceSensorNodeType = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            vRMLPointingDeviceSensorNodeType = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            vRMLPointingDeviceSensorNodeType = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (vRMLPointingDeviceSensorNodeType != null) {
            object = (J3DUserData)((Object)this.j3dImplGroup.getUserData());
            int n = object.sensors.length;
            if (n == 1) {
                object.sensors = null;
            } else {
                int n2;
                for (n2 = 0; n2 < n && object.sensors[n2] != vRMLPointingDeviceSensorNodeType; ++n2) {
                }
                while (n2 < n - 1) {
                    object.sensors[n2] = object.sensors[n2 + 1];
                    ++n2;
                }
                VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n - 1];
                System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n - 1);
                object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
            }
        }
        super.removeChildNode(vRMLNodeType);
    }

    private boolean floatEq(float f, float f2) {
        float f3 = f - f2;
        if (f3 < 0.0f) {
            f3 *= -1.0f;
        }
        return f3 < 1.0E-4f;
    }

    private void updateTransform() {
        this.tempVec.x = -this.vfCenter[0];
        this.tempVec.y = -this.vfCenter[1];
        this.tempVec.z = -this.vfCenter[2];
        this.matrix.setIdentity();
        this.matrix.setTranslation(this.tempVec);
        float f = 1.0f;
        if (this.floatEq(this.vfScale[0], this.vfScale[1]) && this.floatEq(this.vfScale[0], this.vfScale[2])) {
            f = this.vfScale[0];
            this.tempMtx1.set(f);
        } else {
            this.tempAxis.x = this.vfScaleOrientation[0];
            this.tempAxis.y = this.vfScaleOrientation[1];
            this.tempAxis.z = this.vfScaleOrientation[2];
            this.tempAxis.angle = -this.vfScaleOrientation[3];
            double d = 1.0 / Math.sqrt(this.tempAxis.x * this.tempAxis.x + this.tempAxis.y * this.tempAxis.y + this.tempAxis.z * this.tempAxis.z);
            this.tempAxis.x = (float)((double)this.tempAxis.x * d);
            this.tempAxis.y = (float)((double)this.tempAxis.y * d);
            this.tempAxis.z = (float)((double)this.tempAxis.z * d);
            this.tempMtx1.set(this.tempAxis);
            this.tempMtx2.mul(this.tempMtx1, this.matrix);
            this.tempMtx1.setIdentity();
            this.tempMtx1.m00 = this.vfScale[0];
            this.tempMtx1.m11 = this.vfScale[1];
            this.tempMtx1.m22 = this.vfScale[2];
            this.matrix.mul(this.tempMtx1, this.tempMtx2);
            this.tempAxis.x = this.vfScaleOrientation[0];
            this.tempAxis.y = this.vfScaleOrientation[1];
            this.tempAxis.z = this.vfScaleOrientation[2];
            this.tempAxis.angle = this.vfScaleOrientation[3];
            this.tempMtx1.set(this.tempAxis);
        }
        this.tempMtx2.mul(this.tempMtx1, this.matrix);
        float f2 = this.vfRotation[0] * this.vfRotation[0] + this.vfRotation[1] * this.vfRotation[1] + this.vfRotation[2] * this.vfRotation[2];
        if (f2 < 1.0E-4f) {
            this.tempAxis.x = 0.0f;
            this.tempAxis.y = 0.0f;
            this.tempAxis.z = 1.0f;
            this.tempAxis.angle = 0.0f;
        } else {
            if ((double)f2 > 1.01 || (double)f2 < 0.99) {
                float f3 = (float)(1.0 / Math.sqrt(f2));
                this.tempAxis.x = this.vfRotation[0] * f3;
                this.tempAxis.y = this.vfRotation[1] * f3;
                this.tempAxis.z = this.vfRotation[2] * f3;
            } else {
                this.tempAxis.x = this.vfRotation[0];
                this.tempAxis.y = this.vfRotation[1];
                this.tempAxis.z = this.vfRotation[2];
            }
            this.tempAxis.angle = this.vfRotation[3];
        }
        this.tempMtx1.set(this.tempAxis);
        this.matrix.mul(this.tempMtx1, this.tempMtx2);
        this.tempVec.x = this.vfCenter[0];
        this.tempVec.y = this.vfCenter[1];
        this.tempVec.z = this.vfCenter[2];
        this.tempMtx1.setIdentity();
        this.tempMtx1.setTranslation(this.tempVec);
        this.tempMtx2.mul(this.tempMtx1, this.matrix);
        this.tempVec.x = this.vfTranslation[0];
        this.tempVec.y = this.vfTranslation[1];
        this.tempVec.z = this.vfTranslation[2];
        this.tempMtx1.setIdentity();
        this.tempMtx1.setTranslation(this.tempVec);
        this.matrix.mul(this.tempMtx1, this.tempMtx2);
        this.transform.set(this.matrix);
        this.implGroup.setTransform(this.transform);
    }
}

