/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.enveffects;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import org.j3d.renderer.java3d.texture.J3DTextureCache;
import org.j3d.renderer.java3d.texture.J3DTextureCacheFactory;
import org.j3d.util.ImageUtils;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.enveffects.BaseBackground;
import org.web3d.vrml.renderer.j3d.nodes.J3DBackgroundNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DParentPathRequestHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DPathAwareNodeType;

public class J3DBackground
extends BaseBackground
implements J3DBackgroundNodeType,
J3DPathAwareNodeType {
    private static final String MINFILTER_PROP = "org.web3d.vrml.nodes.loader.minfilter";
    private static final String MAGFILTER_PROP = "org.web3d.vrml.nodes.loader.maxfilter";
    private static final String RESCALE_PROP = "org.web3d.vrml.nodes.loader.rescale";
    private static final int DEFAULT_MAGFILTER = 1;
    private static final int DEFAULT_MINFILTER = 1;
    private static final int DEFAULT_RESCALE = 2;
    private static final int magfilter;
    private static final int minfilter;
    private static final int rescale;
    private Group backgroundImpl;
    private Texture2D[] textureList;
    private boolean[] textureChangeFlags;
    private J3DTextureCache cache;
    private J3DParentPathRequestHandler parentPathHandler;
    private ObjectArray allParentPaths;
    private Object[] tmpPathArray;
    private Node[] tmpNodeArray;

    public J3DBackground() {
        this.init();
    }

    public J3DBackground(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public boolean hasScenePathChanged() {
        if (this.parentPathHandler == null) {
            return true;
        }
        return this.parentPathHandler.hasParentPathChanged();
    }

    public SceneGraphPath getSceneGraphPath() {
        ObjectArray objectArray;
        if (this.parentPathHandler == null) {
            if (this.allParentPaths.size() == 0) {
                return null;
            }
            this.parentPathHandler = (J3DParentPathRequestHandler)this.allParentPaths.get(0);
        }
        if ((objectArray = this.parentPathHandler.getParentPath(this)) == null) {
            return null;
        }
        int n = objectArray.size();
        if (this.tmpPathArray == null || this.tmpPathArray.length < n) {
            this.tmpPathArray = new Object[n];
            this.tmpNodeArray = new Node[n - 1];
        }
        objectArray.toArray(this.tmpPathArray);
        Locale locale = (Locale)this.tmpPathArray[0];
        for (int i = 1; i < n; ++i) {
            this.tmpNodeArray[i - 1] = (Node)this.tmpPathArray[i];
        }
        return new SceneGraphPath(locale, this.tmpNodeArray, (Node)this.backgroundImpl);
    }

    public boolean getChangedTextures(Texture2D[] texture2DArray, boolean[] blArray) {
        boolean bl = false;
        for (int i = 0; i < 6; ++i) {
            blArray[i] = this.textureChangeFlags[i];
            if (!this.textureChangeFlags[i]) continue;
            texture2DArray[i] = this.textureList[i];
            bl = true;
            this.textureChangeFlags[i] = false;
        }
        return bl;
    }

    public Texture2D[] getBackgroundTextures() {
        return this.textureList;
    }

    public void addParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.add((Object)j3DParentPathRequestHandler);
    }

    public void removeParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.remove((Object)j3DParentPathRequestHandler);
        if (this.parentPathHandler == j3DParentPathRequestHandler) {
            this.parentPathHandler = null;
        }
    }

    public void setContent(int n, String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            return;
        }
        switch (n) {
            case 8: {
                if (!this.checkForCached(this.vfBackUrl, 0)) {
                    this.buildTexture(object, string, 0);
                    this.cache.registerTexture((Texture)this.textureList[0], this.loadedUri[8]);
                }
                this.textureChangeFlags[0] = true;
                break;
            }
            case 9: {
                if (!this.checkForCached(this.vfFrontUrl, 1)) {
                    this.buildTexture(object, string, 1);
                    this.cache.registerTexture((Texture)this.textureList[1], this.loadedUri[9]);
                }
                this.textureChangeFlags[1] = true;
                break;
            }
            case 10: {
                if (!this.checkForCached(this.vfLeftUrl, 2)) {
                    this.buildTexture(object, string, 2);
                    this.cache.registerTexture((Texture)this.textureList[2], this.loadedUri[10]);
                }
                this.textureChangeFlags[2] = true;
                break;
            }
            case 11: {
                if (!this.checkForCached(this.vfRightUrl, 3)) {
                    this.buildTexture(object, string, 3);
                    this.cache.registerTexture((Texture)this.textureList[3], this.loadedUri[11]);
                }
                this.textureChangeFlags[3] = true;
                break;
            }
            case 13: {
                if (!this.checkForCached(this.vfTopUrl, 4)) {
                    this.buildTexture(object, string, 4);
                    this.cache.registerTexture((Texture)this.textureList[4], this.loadedUri[13]);
                }
                this.textureChangeFlags[4] = true;
                break;
            }
            case 12: {
                if (!this.checkForCached(this.vfBottomUrl, 5)) {
                    this.buildTexture(object, string, 5);
                    this.cache.registerTexture((Texture)this.textureList[5], this.loadedUri[12]);
                }
                this.textureChangeFlags[5] = true;
            }
        }
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.backgroundImpl;
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        if (bl) {
            return;
        }
        this.backgroundImpl.setCapability(11);
        this.backgroundImpl.setCapability(17);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.checkForCached(this.vfBackUrl, 0);
        this.checkForCached(this.vfFrontUrl, 1);
        this.checkForCached(this.vfLeftUrl, 2);
        this.checkForCached(this.vfRightUrl, 3);
        this.checkForCached(this.vfTopUrl, 4);
        this.checkForCached(this.vfBottomUrl, 5);
    }

    private void init() {
        this.allParentPaths = new ObjectArray();
        this.backgroundImpl = new BranchGroup();
        this.textureList = new Texture2D[6];
        this.textureChangeFlags = new boolean[6];
        this.cache = J3DTextureCacheFactory.getCache((int)3);
    }

    private boolean checkForCached(String[] stringArray, int n) {
        boolean bl = false;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length && !bl; ++i) {
                if (!this.cache.checkTexture(stringArray[i])) continue;
                try {
                    this.textureList[n] = (Texture2D)this.cache.fetchTexture(stringArray[i]);
                    this.loadState[n] = 3;
                    bl = true;
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    private void buildTexture(Object object, String string, int n) {
        BufferedImage bufferedImage = null;
        boolean bl = false;
        boolean bl2 = false;
        if (object instanceof BufferedImage) {
            bufferedImage = (BufferedImage)object;
            if (string.equals("image/jpeg")) {
                bl = false;
            } else if (string.equals("image/png")) {
                bl = true;
            } else if (string.equals("image/gif")) {
                bl = false;
            } else {
                System.out.println("Unknown type for BufferedImage, assume alpa=false type:" + string);
                bl = false;
            }
        } else if (object instanceof ImageProducer) {
            bufferedImage = ImageUtils.createBufferedImage((ImageProducer)((ImageProducer)object));
            ColorModel colorModel = bufferedImage.getColorModel();
            bl = colorModel.hasAlpha();
            bl2 = colorModel.isAlphaPremultiplied();
        } else {
            System.out.println("Unknown content type: " + object + " for field " + this.getFieldDeclaration(n));
            return;
        }
        if (bl2) {
            System.out.println("J3DBackground: Unhandled case where isAlphaPremultiplied = true");
        }
        int n2 = 2;
        switch (bufferedImage.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 12: {
                n2 = 1;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
            case 10: 
            case 11: {
                n2 = 10;
                break;
            }
            case 13: {
                if (bl) {
                    n2 = 2;
                    break;
                }
                n2 = 1;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 3;
                break;
            }
            default: {
                System.out.println("Unknown FORMAT for image: " + bufferedImage);
            }
        }
        int n3 = this.nearestPowerTwo(bufferedImage.getWidth());
        int n4 = this.nearestPowerTwo(bufferedImage.getHeight());
        bufferedImage = this.scaleTexture(bufferedImage, n3, n4);
        ImageComponent2D imageComponent2D = null;
        try {
            imageComponent2D = new ImageComponent2D(n2, bufferedImage, false, false);
            imageComponent2D.setCapability(1);
            imageComponent2D.setCapability(0);
        }
        catch (Exception exception) {
            System.out.println("Error creating background image: ");
            exception.printStackTrace();
            return;
        }
        this.textureList[n] = this.createTexture((ImageComponent)imageComponent2D, bl);
    }

    private Texture2D createTexture(ImageComponent imageComponent, boolean bl) {
        int n = this.getTextureFormat(imageComponent);
        int n2 = imageComponent.getWidth();
        int n3 = imageComponent.getHeight();
        Texture2D texture2D = new Texture2D(1, n, n2, n3);
        texture2D.setMinFilter(minfilter);
        texture2D.setMagFilter(magfilter);
        texture2D.setBoundaryModeS(4);
        texture2D.setBoundaryModeT(4);
        texture2D.setImage(0, imageComponent);
        texture2D.setCapability(4);
        texture2D.setCapability(8);
        texture2D.setCapability(9);
        return texture2D;
    }

    private BufferedImage scaleTexture(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (n3 == n && n4 == n2) {
            return bufferedImage;
        }
        System.out.println("Rescaling background to: " + n + " x " + n2);
        double d = (float)n / (float)n3;
        double d2 = (float)n2 / (float)n4;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, rescale);
        return affineTransformOp.filter(bufferedImage, null);
    }

    private int getTextureFormat(ImageComponent imageComponent) {
        int n = 5;
        switch (imageComponent.getFormat()) {
            case 10: {
                n = 2;
                break;
            }
            case 7: 
            case 8: {
                n = 4;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                n = 5;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n = 6;
            }
        }
        return n;
    }

    private int nearestPowerTwo(int n) {
        int n2 = (int)Math.ceil(Math.log(n) / Math.log(2.0));
        return (int)Math.pow(2.0, n2);
    }

    static {
        final HashMap<String, Integer> hashMap = new HashMap<String, Integer>(8);
        hashMap.put("NICEST", new Integer(1));
        hashMap.put("FASTEST", new Integer(0));
        hashMap.put("BASE_LEVEL_POINT", new Integer(2));
        hashMap.put("BASE_LEVEL_LINEAR", new Integer(3));
        hashMap.put("LINEAR_SHARPEN", new Integer(9));
        hashMap.put("LINEAR_SHARPEN_RGB", new Integer(10));
        hashMap.put("LINEAR_SHARPEN_ALPHA", new Integer(11));
        hashMap.put("FILTER4", new Integer(12));
        final HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>(2);
        hashMap2.put("BILINEAR", new Integer(2));
        hashMap2.put("NEAREST_NEIGHBOR", new Integer(1));
        int[] nArray = (int[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Integer n;
                int[] nArray = new int[3];
                String string = System.getProperty(J3DBackground.MINFILTER_PROP);
                nArray[0] = string != null ? ((n = (Integer)hashMap.get(string)) != null ? n : 1) : 1;
                string = System.getProperty(J3DBackground.MAGFILTER_PROP);
                nArray[1] = string != null ? ((n = (Integer)hashMap.get(string)) != null ? n : 1) : 1;
                string = System.getProperty(J3DBackground.RESCALE_PROP);
                nArray[2] = string != null ? ((n = (Integer)hashMap2.get(string)) != null ? n : 2) : 2;
                return nArray;
            }
        });
        minfilter = nArray[0];
        magfilter = nArray[1];
        rescale = nArray[2];
    }
}

