/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.enveffects;

import java.util.Map;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphPath;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.enveffects.BaseFog;
import org.web3d.vrml.renderer.j3d.nodes.J3DFogNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DParentPathRequestHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DPathAwareNodeType;

public class J3DFog
extends BaseFog
implements J3DFogNodeType,
J3DPathAwareNodeType {
    private J3DParentPathRequestHandler parentPathHandler;
    private ObjectArray allParentPaths = new ObjectArray();
    private Object[] tmpPathArray;
    private Node[] tmpNodeArray;
    private BranchGroup fogImpl = new BranchGroup();

    public J3DFog() {
    }

    public J3DFog(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public boolean hasScenePathChanged() {
        if (this.parentPathHandler == null) {
            return true;
        }
        return this.parentPathHandler.hasParentPathChanged();
    }

    public SceneGraphPath getSceneGraphPath() {
        ObjectArray objectArray;
        if (this.parentPathHandler == null) {
            if (this.allParentPaths.size() == 0) {
                return null;
            }
            this.parentPathHandler = (J3DParentPathRequestHandler)this.allParentPaths.get(0);
        }
        if ((objectArray = this.parentPathHandler.getParentPath(this)) == null) {
            return null;
        }
        int n = objectArray.size();
        if (this.tmpPathArray == null || this.tmpPathArray.length < n) {
            this.tmpPathArray = new Object[n];
            this.tmpNodeArray = new Node[n - 1];
        }
        objectArray.toArray(this.tmpPathArray);
        Locale locale = (Locale)this.tmpPathArray[0];
        for (int i = 1; i < n; ++i) {
            this.tmpNodeArray[i - 1] = (Node)this.tmpPathArray[i];
        }
        return new SceneGraphPath(locale, this.tmpNodeArray, (Node)this.fogImpl);
    }

    public void addParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.add((Object)j3DParentPathRequestHandler);
    }

    public void removeParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.remove((Object)j3DParentPathRequestHandler);
        if (this.parentPathHandler == j3DParentPathRequestHandler) {
            this.parentPathHandler = null;
        }
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.fogImpl;
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        if (bl) {
            return;
        }
        this.fogImpl.setCapability(11);
        this.fogImpl.setCapability(17);
    }
}

