/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.geom2d;

import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TriangleArray;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.geom2d.BaseTriangleSet2D;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNodeType;

public class J3DTriangleSet2D
extends BaseTriangleSet2D
implements J3DGeometryNodeType {
    private TriangleArray implGeom;
    private float[] normals;
    private float[] coords;

    public J3DTriangleSet2D() {
    }

    public J3DTriangleSet2D(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public Geometry[] getGeometry() {
        return new Geometry[]{this.implGeom};
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public void addGeometryListener(J3DGeometryListener j3DGeometryListener) {
    }

    public void removeGeometryListener(J3DGeometryListener j3DGeometryListener) {
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void setupFinished() {
        int n;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n2 = this.numVertices * 3 / 2;
        this.normals = new float[n2];
        for (n = 0; n < this.numVertices / 2; ++n) {
            this.normals[n * 3 + 2] = 1.0f;
        }
        this.coords = new float[n2];
        for (n = 0; n < this.numVertices / 2; ++n) {
            this.coords[n * 3] = this.vfVertices[n * 2];
            this.coords[n * 3 + 1] = this.vfVertices[n * 2 + 1];
            this.coords[n * 3 + 2] = 0.0f;
        }
        n = 3;
        this.implGeom = new TriangleArray(this.numVertices / 2, n);
        this.implGeom.setCoordinates(0, this.coords);
        this.implGeom.setNormals(0, this.normals);
        this.implGeom.setCapability(1);
        this.implGeom.setCapability(5);
    }

    protected void setVertices(float[] fArray, int n) {
        int n2 = this.numVertices / 2;
        super.setVertices(fArray, n);
        if (!this.inSetup) {
            int n3;
            int n4 = this.numVertices * 3 / 2;
            if (this.normals.length < n4) {
                this.normals = new float[n4];
                for (n3 = 0; n3 < this.numVertices / 2; ++n3) {
                    this.normals[n3 * 3 + 1] = 1.0f;
                }
            }
            if (fArray.length < n4) {
                fArray = new float[n4];
            }
            for (n3 = 0; n3 < this.numVertices / 2; ++n3) {
                fArray[n3 * 3] = this.vfVertices[n3 * 2];
                fArray[n3 * 3 + 1] = this.vfVertices[n3 * 2 + 1];
                fArray[n3 * 3 + 2] = 0.0f;
            }
            if (n2 != n / 2) {
                System.out.println("J3DTriangleSet2D not handling vertex resize");
            } else {
                this.implGeom.setCoordinates(0, fArray, 0, n / 2);
            }
        }
    }
}

