/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.geom3d;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TriangleStripArray;
import org.j3d.geom.GeometryData;
import org.j3d.geom.terrain.ElevationGridGenerator;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.geom3d.BaseElevationGrid;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;

public class J3DElevationGrid
extends BaseElevationGrid
implements J3DGeometryNodeType {
    private GeometryArray implGeom;
    private ElevationGridGenerator generator;
    private GeometryData data = new GeometryData();
    private ArrayList listeners;
    private float[] v0 = new float[3];
    private float[] v1 = new float[3];
    private float[] v2 = new float[3];
    private float[] v3 = new float[3];

    public J3DElevationGrid() {
        this.listeners = new ArrayList();
    }

    public J3DElevationGrid(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.listeners = new ArrayList();
    }

    public Geometry[] getGeometry() {
        return new Geometry[]{this.implGeom};
    }

    public void addGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.add(j3DGeometryListener);
    }

    public void removeGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || !this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.remove(j3DGeometryListener);
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.buildImpl();
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 3: {
                if (this.vfNormal != null) {
                    float[] fArray = null;
                    switch (this.data.geometryType) {
                        case 2: {
                            fArray = new float[(this.vfXDimension - 1) * (this.vfZDimension - 1) * 4 * 3];
                            break;
                        }
                        case 3: {
                            fArray = new float[this.vfXDimension * (this.vfZDimension - 1) * 2 * 3];
                            break;
                        }
                        default: {
                            System.out.println("Invalid data.geometryType in J3DElevationGrid");
                        }
                    }
                    float[] fArray2 = new float[this.vfNormal.getNumNormals()];
                    this.vfNormal.getVector(fArray2);
                    this.setupArray(fArray2, fArray);
                    this.implGeom.setNormals(0, fArray);
                    break;
                }
                this.implGeom.setNormals(0, this.data.normals);
                break;
            }
            case 2: {
                if (this.vfColor != null) {
                    float[] fArray = null;
                    switch (this.data.geometryType) {
                        case 2: {
                            fArray = new float[(this.vfXDimension - 1) * (this.vfZDimension - 1) * 4 * 3];
                            break;
                        }
                        case 3: {
                            fArray = new float[this.vfXDimension * (this.vfZDimension - 1) * 2 * 3];
                            break;
                        }
                        default: {
                            System.out.println("Invalid data.geometryType in J3DElevationGrid");
                        }
                    }
                    float[] fArray3 = new float[this.vfColor.getNumColors()];
                    this.vfColor.getColor(fArray3);
                    this.setupArray(fArray3, fArray);
                    this.implGeom.setColors(0, fArray);
                    break;
                }
                this.buildImpl();
                break;
            }
            case 4: {
                this.buildImpl();
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setComponents(VRMLNodeType[] vRMLNodeTypeArray) throws InvalidFieldValueException {
        super.setComponents(vRMLNodeTypeArray);
        if (!this.inSetup) {
            this.buildImpl();
        }
    }

    public void setComponent(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setComponent(vRMLNodeType);
        if (!this.inSetup) {
            this.buildImpl();
        }
    }

    private void buildImpl() {
        float[] fArray;
        VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType;
        Object object;
        if (this.vfHeight == null || this.vfHeight.length == 0) {
            return;
        }
        this.data.geometryType = !this.vfColorPerVertex || !this.vfNormalPerVertex ? 2 : 3;
        this.data.geometrySubType = 2;
        int n = 0;
        if (this.vfTexCoord == null && this.pTexCoord == null) {
            this.data.geometryComponents = 4;
            n = 1;
        } else {
            object = this.pTexCoord != null ? (VRMLTextureCoordinateNodeType)this.pTexCoord.getImplementationNode() : this.vfTexCoord;
            n = object.getNumSets();
        }
        if (this.vfNormal == null && this.pNormal == null) {
            this.data.geometryComponents |= 2;
        }
        object = new J3DUserData();
        object.geometryData = this.data;
        this.implGeom.setUserData(object);
        if (this.vfHeight.length > 2) {
            this.generator.generate(this.data);
            this.generator = new ElevationGridGenerator((float)(this.vfXDimension - 1) * this.vfXSpacing, (float)(this.vfZDimension - 1) * this.vfZSpacing, this.vfXDimension, this.vfZDimension, this.vfHeight, 0.0f, false);
        } else {
            this.data.numStrips = 0;
            this.data.stripCounts = new int[0];
        }
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int n2 = 35;
        if (this.vfColor != null || this.pColor != null) {
            n2 |= 4;
        }
        switch (this.data.geometryType) {
            case 2: {
                this.implGeom = new QuadArray(this.data.vertexCount, n2, n, nArray);
                break;
            }
            case 3: {
                this.implGeom = new TriangleStripArray(this.data.vertexCount, n2, n, nArray, this.data.stripCounts);
                break;
            }
            default: {
                System.out.println("Invalid geometryType in J3DElevationGrid");
            }
        }
        this.implGeom.setCoordinates(0, this.data.coordinates);
        if (this.vfHeight.length <= 2) {
            return;
        }
        if ((this.data.geometryComponents & 4) != 0) {
            this.implGeom.setTextureCoordinates(0, 0, this.data.textureCoordinates);
        } else {
            vRMLTextureCoordinateNodeType = this.pTexCoord != null ? (VRMLTextureCoordinateNodeType)this.pTexCoord.getImplementationNode() : this.vfTexCoord;
            n = vRMLTextureCoordinateNodeType.getNumSets();
            fArray = null;
            float[] fArray2 = new float[vRMLTextureCoordinateNodeType.getSize(0) * 2];
            for (int i = 0; i < n; ++i) {
                int n3 = vRMLTextureCoordinateNodeType.getNumTextureComponents();
                int n4 = this.vfTexCoord.getSize(i);
                nArray[i] = this.vfTexCoord.isShared(i);
                int n5 = this.data.vertexCount * n3;
                if (n4 < n5) {
                    n4 = n5;
                }
                if (fArray == null || fArray.length < n4) {
                    fArray = new float[n4];
                }
                if (fArray2.length < n4) {
                    fArray2 = new float[n4];
                }
                vRMLTextureCoordinateNodeType.getPoint(i, fArray2);
                int n6 = this.vfZDimension * n3;
                int n7 = n5 - 1;
                int n8 = this.vfXDimension * this.vfZDimension * n3 - 1;
                for (int j = 0; j < this.vfXDimension - 1; ++j) {
                    for (int k = 0; k < this.vfZDimension; ++k) {
                        fArray[n7--] = fArray2[n8];
                        fArray[n7--] = fArray2[n8 - 1];
                        fArray[n7--] = fArray2[n8 - n6];
                        fArray[n7--] = fArray2[n8 - n6 - 1];
                        n8 -= n3;
                    }
                }
                if (n5 == 0) continue;
                this.implGeom.setTextureCoordinates(i, 0, fArray);
            }
        }
        if (this.vfNormal != null || this.pNormal != null) {
            vRMLTextureCoordinateNodeType = this.pNormal != null ? (VRMLNormalNodeType)this.pNormal.getImplementationNode() : this.vfNormal;
            float[] fArray3 = new float[vRMLTextureCoordinateNodeType.getNumNormals()];
            vRMLTextureCoordinateNodeType.getVector(fArray3);
            fArray = null;
            switch (this.data.geometryType) {
                case 2: {
                    fArray = new float[(this.vfXDimension - 1) * (this.vfZDimension - 1) * 4 * 3];
                    break;
                }
                case 3: {
                    fArray = new float[this.vfXDimension * (this.vfZDimension - 1) * 2 * 3];
                    break;
                }
                default: {
                    System.out.println("Invalid data.geometryType in J3DElevationGrid");
                }
            }
            this.setupArray(fArray3, fArray);
            this.implGeom.setNormals(0, fArray);
        } else if (this.vfCcw) {
            this.implGeom.setNormals(0, this.data.normals);
        } else {
            for (int i = 0; i < this.data.normals.length / 3; i += 2) {
                this.data.normals[++i] = -this.data.normals[i];
            }
            this.implGeom.setNormals(0, this.data.normals);
        }
        if (this.vfColor != null || this.pColor != null) {
            VRMLColorNodeType vRMLColorNodeType = this.pColor != null ? (VRMLColorNodeType)this.pColor.getImplementationNode() : this.vfColor;
            float[] fArray4 = new float[vRMLColorNodeType.getNumColors()];
            vRMLColorNodeType.getColor(fArray4);
            fArray = null;
            switch (this.data.geometryType) {
                case 2: {
                    fArray = new float[(this.vfXDimension - 1) * (this.vfZDimension - 1) * 4 * 3];
                    break;
                }
                case 3: {
                    fArray = new float[this.vfXDimension * (this.vfZDimension - 1) * 2 * 3];
                    break;
                }
                default: {
                    System.out.println("Invalid data.geometryType in J3DElevationGrid");
                }
            }
            this.setupArray(fArray4, fArray);
            this.implGeom.setColors(0, fArray);
        }
        this.implGeom.setCapability(0);
        this.implGeom.setCapability(1);
        this.implGeom.setCapability(4);
        this.implGeom.setCapability(6);
        this.implGeom.setCapability(8);
        this.implGeom.setCapability(17);
    }

    private void setupArray(float[] fArray, float[] fArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.vfXDimension * 3;
        switch (this.data.geometryType) {
            case 2: {
                int n5;
                n2 = n5 = (this.vfXDimension - 1) * (this.vfZDimension - 1);
                while (--n2 >= 0) {
                    this.v0[0] = fArray[n3];
                    this.v0[1] = fArray[n3 + 1];
                    this.v0[2] = fArray[n3 + 2];
                    if (this.vfColorPerVertex) {
                        this.v1[0] = fArray[n3 + n4];
                        this.v1[1] = fArray[n3 + n4 + 1];
                        this.v1[2] = fArray[n3 + n4 + 2];
                        this.v2[0] = fArray[n3 + n4 + 3];
                        this.v2[1] = fArray[n3 + n4 + 4];
                        this.v2[2] = fArray[n3 + n4 + 5];
                        this.v3[0] = fArray[n3 + 3];
                        this.v3[1] = fArray[n3 + 4];
                        this.v3[2] = fArray[n3 + 5];
                        if (this.vfCcw) {
                            fArray2[n++] = this.v0[0];
                            fArray2[n++] = this.v0[1];
                            fArray2[n++] = this.v0[2];
                            fArray2[n++] = this.v1[0];
                            fArray2[n++] = this.v1[1];
                            fArray2[n++] = this.v1[2];
                            fArray2[n++] = this.v2[0];
                            fArray2[n++] = this.v2[1];
                            fArray2[n++] = this.v2[2];
                            fArray2[n++] = this.v3[0];
                            fArray2[n++] = this.v3[1];
                            fArray2[n++] = this.v3[2];
                        } else {
                            fArray2[n++] = this.v0[0];
                            fArray2[n++] = this.v0[1];
                            fArray2[n++] = this.v0[2];
                            fArray2[n++] = this.v3[0];
                            fArray2[n++] = this.v3[1];
                            fArray2[n++] = this.v3[2];
                            fArray2[n++] = this.v2[0];
                            fArray2[n++] = this.v2[1];
                            fArray2[n++] = this.v2[2];
                            fArray2[n++] = this.v1[0];
                            fArray2[n++] = this.v1[1];
                            fArray2[n++] = this.v1[2];
                        }
                    } else {
                        fArray2[n++] = this.v0[0];
                        fArray2[n++] = this.v0[1];
                        fArray2[n++] = this.v0[2];
                        fArray2[n++] = this.v0[0];
                        fArray2[n++] = this.v0[1];
                        fArray2[n++] = this.v0[2];
                        fArray2[n++] = this.v0[0];
                        fArray2[n++] = this.v0[1];
                        fArray2[n++] = this.v0[2];
                        fArray2[n++] = this.v0[0];
                        fArray2[n++] = this.v0[1];
                        fArray2[n++] = this.v0[2];
                    }
                    n3 += 3;
                    if (!this.vfColorPerVertex || n2 % (this.vfXDimension - 1) != 0) continue;
                    n3 += 3;
                }
                break;
            }
            case 3: {
                int n6;
                n2 = n6 = this.vfXDimension * (this.vfZDimension - 1);
                while (--n2 >= 0) {
                    this.v0[0] = fArray[n3];
                    this.v0[1] = fArray[n3 + 1];
                    this.v0[2] = fArray[n3 + 2];
                    if (this.vfColorPerVertex) {
                        this.v1[0] = fArray[n3 + n4];
                        this.v1[1] = fArray[n3 + n4 + 1];
                        this.v1[2] = fArray[n3 + n4 + 2];
                        if (this.vfCcw) {
                            fArray2[n++] = this.v0[0];
                            fArray2[n++] = this.v0[1];
                            fArray2[n++] = this.v0[2];
                            fArray2[n++] = this.v1[0];
                            fArray2[n++] = this.v1[1];
                            fArray2[n++] = this.v1[2];
                        } else {
                            fArray2[n++] = this.v1[0];
                            fArray2[n++] = this.v1[1];
                            fArray2[n++] = this.v1[2];
                            fArray2[n++] = this.v0[0];
                            fArray2[n++] = this.v0[1];
                            fArray2[n++] = this.v0[2];
                        }
                        n3 += 3;
                        continue;
                    }
                    fArray2[n++] = this.v0[0];
                    fArray2[n++] = this.v0[1];
                    fArray2[n++] = this.v0[2];
                    fArray2[n++] = this.v0[0];
                    fArray2[n++] = this.v0[1];
                    fArray2[n++] = this.v0[2];
                    if (n2 % 2 == 0) continue;
                    n3 += 3;
                }
                break;
            }
            default: {
                System.out.println("Unknown DataType in  J3DElevationGrid.setupArray");
            }
        }
    }
}

