/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.geom3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.geom3d.BaseExtrusion;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DGlobalStatus;

public class J3DExtrusion
extends BaseExtrusion
implements J3DGeometryNodeType {
    private static final String SOR_ERR = "Invalid Extrusion data; looks like a solid of revolution";
    private GeometryArray impl;
    private ArrayList listeners = new ArrayList();
    private GeometryInfo gi;
    private Point3f[] coords;
    private int[] coordIndex;
    private int[] stripCounts;
    private Point3f[] spines;
    private Vector3f[] scales;
    private AxisAngle4f[] orientations;
    private Transform3D[] spineTransforms;
    private Point3f[] crossSectionPts;
    private Matrix3f[] rotations;
    private Transform3D[] transforms;
    private boolean collinear = false;
    private boolean closed = false;
    int numTris = 0;
    public static boolean hardDebug = false;
    private int[] capReqdBits;
    private int[] freqReqdBits;
    static /* synthetic */ Class class$javax$media$j3d$QuadArray;

    public J3DExtrusion() {
    }

    public J3DExtrusion(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void allEventsComplete() {
        this.buildImpl();
    }

    public Geometry[] getGeometry() {
        Geometry[] geometryArray = new Geometry[]{this.impl};
        return geometryArray;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public void addGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.add(j3DGeometryListener);
    }

    public void removeGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || !this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.remove(j3DGeometryListener);
    }

    protected void fireGeometryChanged(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryChanged(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry change message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, bl);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, f);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, fArray, n2);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        if (map != null && map.containsKey(class$javax$media$j3d$QuadArray == null ? (class$javax$media$j3d$QuadArray = J3DExtrusion.class$("javax.media.j3d.QuadArray")) : class$javax$media$j3d$QuadArray)) {
            this.capReqdBits = (int[])map.get(class$javax$media$j3d$QuadArray == null ? (class$javax$media$j3d$QuadArray = J3DExtrusion.class$("javax.media.j3d.QuadArray")) : class$javax$media$j3d$QuadArray);
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null || !map2.containsKey(class$javax$media$j3d$QuadArray == null ? (class$javax$media$j3d$QuadArray = J3DExtrusion.class$("javax.media.j3d.QuadArray")) : class$javax$media$j3d$QuadArray)) {
            return;
        }
        this.freqReqdBits = (int[])map2.get(class$javax$media$j3d$QuadArray == null ? (class$javax$media$j3d$QuadArray = J3DExtrusion.class$("javax.media.j3d.QuadArray")) : class$javax$media$j3d$QuadArray);
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.impl;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.buildImpl();
    }

    private void buildImpl() {
        int n;
        this.gi = new GeometryInfo(5);
        this.initSetup();
        if (!this.calculateSCP()) {
            return;
        }
        this.createExtrusion();
        this.createIndices();
        if (hardDebug) {
            int n2;
            System.out.println("coords");
            for (n2 = 0; n2 < this.coords.length; ++n2) {
                System.out.println(this.coords[n2]);
            }
            System.out.println("coordIndex");
            for (n2 = 0; n2 < this.coordIndex.length; ++n2) {
                System.out.println(this.coordIndex[n2]);
            }
            System.out.println("stripCounts");
            for (n2 = 0; n2 < this.stripCounts.length; ++n2) {
                System.out.println(this.stripCounts[n2]);
            }
        }
        this.gi.setCoordinates(this.coords);
        this.gi.setCoordinateIndices(this.coordIndex);
        this.gi.setStripCounts(this.stripCounts);
        float f = this.vfCreaseAngle;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > (float)Math.PI) {
            f -= (float)Math.PI;
        }
        NormalGenerator normalGenerator = new NormalGenerator((double)f);
        normalGenerator.generateNormals(this.gi);
        this.impl = this.gi.getGeometryArray();
        this.impl.setCapability(0);
        this.impl.setCapability(8);
        this.impl.setCapability(17);
        if (this.capReqdBits != null) {
            for (n = 0; n < this.capReqdBits.length; ++n) {
                this.impl.setCapability(this.capReqdBits[n]);
            }
        }
        if (J3DGlobalStatus.haveFreqBitsAPI && this.freqReqdBits != null) {
            for (n = 0; n < this.freqReqdBits.length; ++n) {
                this.impl.setCapabilityIsFrequent(this.freqReqdBits[n]);
            }
        }
        this.capReqdBits = null;
        this.freqReqdBits = null;
        this.fireGeometryChanged(new int[]{0});
    }

    private void initSetup() {
        int n;
        this.crossSectionPts = new Point3f[this.vfCrossSection.length / 2];
        if (hardDebug) {
            System.out.println(this.crossSectionPts.length);
        }
        for (n = 0; n < this.crossSectionPts.length; ++n) {
            this.crossSectionPts[n] = new Point3f(this.vfCrossSection[n * 2], 0.0f, this.vfCrossSection[n * 2 + 1]);
        }
        this.scales = new Vector3f[this.vfSpine.length / 3];
        for (n = 0; n < this.scales.length; ++n) {
            this.scales[n] = n * 2 < this.vfScale.length ? new Vector3f(this.vfScale[n * 2], 1.0f, this.vfScale[n * 2 + 1]) : new Vector3f(this.vfScale[this.vfScale.length - 2], 1.0f, this.vfScale[this.vfScale.length - 1]);
        }
        this.spines = new Point3f[this.vfSpine.length / 3];
        for (n = 0; n < this.spines.length; ++n) {
            this.spines[n] = new Point3f(this.vfSpine[n * 3], this.vfSpine[n * 3 + 1], this.vfSpine[n * 3 + 2]);
        }
        this.orientations = new AxisAngle4f[this.vfSpine.length / 3];
        for (n = 0; n < this.orientations.length; ++n) {
            this.orientations[n] = n * 4 < this.vfOrientation.length ? new AxisAngle4f(this.vfOrientation[n * 4], this.vfOrientation[n * 4 + 1], this.vfOrientation[n * 4 + 2], this.vfOrientation[n * 4 + 3]) : new AxisAngle4f(this.vfOrientation[this.vfOrientation.length - 4], this.vfOrientation[this.vfOrientation.length - 3], this.vfOrientation[this.vfOrientation.length - 2], this.vfOrientation[this.vfOrientation.length - 1]);
        }
        this.rotations = new Matrix3f[this.vfSpine.length / 3];
        if (this.spines[0].equals((Tuple3f)this.spines[this.spines.length - 1])) {
            this.closed = true;
        }
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        for (int i = 1; i < this.spines.length - 1; ++i) {
            vector3d.set((Tuple3f)this.spines[i + 1]);
            vector3d2.set((Tuple3f)this.spines[i]);
            vector3d3.set((Tuple3f)this.spines[i - 1]);
            vector3d.sub((Tuple3d)vector3d2);
            vector3d2.sub((Tuple3d)vector3d3);
            vector3d3.cross(vector3d, vector3d2);
            d += vector3d3.dot(vector3d3);
        }
        boolean bl = this.collinear = d == 0.0;
        if (hardDebug && this.collinear) {
            System.out.println("spine is straight");
        }
    }

    private boolean calculateSCP() {
        int n;
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        int n2 = this.spines.length - 1;
        Vector3f[] vector3fArray = new Vector3f[this.spines.length];
        Vector3f[] vector3fArray2 = new Vector3f[this.spines.length];
        Vector3f[] vector3fArray3 = new Vector3f[this.spines.length];
        if (this.collinear) {
            if (this.closed) {
                this.errorReporter.warningReport(SOR_ERR, null);
                StringBuffer stringBuffer = new StringBuffer("Spine data:");
                for (int i = 0; i < this.spines.length; ++i) {
                    stringBuffer.append(this.spines[i]);
                    stringBuffer.append(' ');
                }
                this.errorReporter.messageReport(stringBuffer.toString());
                return false;
            }
            Vector3f vector3f2 = null;
            for (int i = 0; i < this.spines.length; ++i) {
                if (this.spines[0].equals((Tuple3f)this.spines[i])) continue;
                vector3f2 = new Vector3f((Tuple3f)this.spines[i]);
            }
            vector3fArray2[0] = new Vector3f();
            vector3fArray2[0].sub(vector3f2, (Tuple3f)this.spines[0]);
            try {
                this.norm(vector3fArray2[0]);
            }
            catch (ArithmeticException arithmeticException) {
                arithmeticException.printStackTrace();
            }
            vector3fArray[0] = vector3fArray2[0].x == 1.0f ? new Vector3f(0.0f, -1.0f, 0.0f) : (vector3fArray2[0].x == -1.0f ? new Vector3f(0.0f, 1.0f, 0.0f) : new Vector3f(1.0f, 0.0f, 0.0f));
            vector3fArray3[0] = new Vector3f();
            vector3fArray3[0].cross(vector3fArray[0], vector3fArray2[0]);
            vector3fArray[0].cross(vector3fArray2[0], vector3fArray3[0]);
            for (n = 1; n < this.spines.length; ++n) {
                vector3fArray[n] = new Vector3f(vector3fArray[0]);
                vector3fArray2[n] = new Vector3f(vector3fArray2[0]);
                vector3fArray3[n] = new Vector3f(vector3fArray3[0]);
            }
        } else {
            Vector3f vector3f3;
            Vector3f vector3f4;
            for (int i = 1; i < n2; ++i) {
                vector3fArray2[i] = new Vector3f();
                vector3fArray2[i].sub((Tuple3f)this.spines[i + 1], (Tuple3f)this.spines[i - 1]);
                try {
                    this.norm(vector3fArray2[i]);
                    continue;
                }
                catch (ArithmeticException arithmeticException) {
                    if (hardDebug) {
                        System.out.println(arithmeticException + " " + vector3fArray2[i]);
                    }
                    try {
                        vector3fArray2[i].sub((Tuple3f)this.spines[i + 1], (Tuple3f)this.spines[i]);
                        this.norm(vector3fArray2[i]);
                        continue;
                    }
                    catch (ArithmeticException arithmeticException2) {
                        if (hardDebug) {
                            System.out.println(arithmeticException2 + " " + vector3fArray2[i]);
                        }
                        try {
                            vector3fArray2[i].sub((Tuple3f)this.spines[i], (Tuple3f)this.spines[i - 1]);
                            this.norm(vector3fArray2[i]);
                            continue;
                        }
                        catch (ArithmeticException arithmeticException3) {
                            int n3;
                            if (hardDebug) {
                                System.out.println(arithmeticException3 + " " + vector3fArray2[i]);
                            }
                            for (n3 = i + 2; n3 < n2 + 1 && this.spines[i - 1].equals((Tuple3f)this.spines[n3]); ++n3) {
                            }
                            if (n3 < n2 + 1) {
                                vector3fArray2[i].sub((Tuple3f)this.spines[n3], (Tuple3f)this.spines[i - 1]);
                                if (hardDebug) {
                                    System.out.println("did something " + vector3fArray2[i]);
                                }
                                this.norm(vector3fArray2[i]);
                                continue;
                            }
                            if (hardDebug) {
                                System.out.println("worst worst y " + vector3fArray2[i]);
                            }
                            vector3fArray2[i] = new Vector3f(0.0f, 1.0f, 0.0f);
                        }
                    }
                }
            }
            if (this.closed) {
                vector3fArray2[0] = new Vector3f();
                vector3fArray2[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[n2 - 1]);
                try {
                    this.norm(vector3fArray2[0]);
                }
                catch (ArithmeticException arithmeticException) {
                    int n4;
                    for (n4 = n2 - 2; n4 > 1 && this.spines[1].equals((Tuple3f)this.spines[n4]); --n4) {
                    }
                    if (n4 > 1) {
                        vector3fArray2[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[n4]);
                        this.norm(vector3fArray2[0]);
                    }
                    vector3fArray2[0].set(0.0f, 0.0f, 1.0f);
                }
                vector3fArray2[n2] = new Vector3f(vector3fArray2[0]);
            } else {
                vector3fArray2[0] = new Vector3f();
                vector3fArray2[n2] = new Vector3f();
                vector3fArray2[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[0]);
                try {
                    this.norm(vector3fArray2[0]);
                }
                catch (ArithmeticException arithmeticException) {
                    int n5;
                    for (n5 = 2; n5 < n2 && this.spines[0].equals((Tuple3f)this.spines[n5]); ++n5) {
                    }
                    if (n5 < n2) {
                        vector3fArray2[0].sub((Tuple3f)this.spines[n5], (Tuple3f)this.spines[0]);
                        this.norm(vector3fArray2[0]);
                    }
                    vector3fArray2[0].set(0.0f, 0.0f, 1.0f);
                }
                vector3fArray2[n2] = new Vector3f();
                vector3fArray2[n2].sub((Tuple3f)this.spines[n2], (Tuple3f)this.spines[n2 - 1]);
                try {
                    this.norm(vector3fArray2[n2]);
                }
                catch (ArithmeticException arithmeticException) {
                    int n6;
                    for (n6 = n2 - 2; n6 > -1 && this.spines[n2].equals((Tuple3f)this.spines[n6]); --n6) {
                    }
                    if (n6 > -1) {
                        vector3fArray2[n2].sub((Tuple3f)this.spines[n2], (Tuple3f)this.spines[n6]);
                        this.norm(vector3fArray2[n2]);
                    }
                    vector3fArray2[n2].set(0.0f, 0.0f, 1.0f);
                }
            }
            boolean bl = false;
            for (int i = 1; i < n2; ++i) {
                vector3f4 = new Vector3f();
                vector3f3 = new Vector3f();
                vector3fArray3[i] = new Vector3f();
                vector3f4.sub((Tuple3f)this.spines[i - 1], (Tuple3f)this.spines[i]);
                vector3f3.sub((Tuple3f)this.spines[i + 1], (Tuple3f)this.spines[i]);
                vector3fArray3[i].cross(vector3f4, vector3f3);
                try {
                    this.norm(vector3fArray3[i]);
                    continue;
                }
                catch (ArithmeticException arithmeticException) {
                    bl = true;
                }
            }
            if (this.closed) {
                vector3fArray3[0] = vector3fArray3[n2] = new Vector3f();
                vector3f4 = new Vector3f();
                vector3f3 = new Vector3f();
                vector3f4.sub((Tuple3f)this.spines[n2 - 1], (Tuple3f)this.spines[0]);
                vector3f3.sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[0]);
                try {
                    vector3fArray3[0].cross(vector3f4, vector3f3);
                }
                catch (ArithmeticException arithmeticException) {
                    bl = true;
                }
            } else {
                vector3fArray3[0] = new Vector3f(vector3fArray3[1]);
                vector3fArray3[n2] = new Vector3f(vector3fArray3[n2 - 1]);
            }
            if (bl) {
                if (hardDebug) {
                    System.out.println("rechecking, found adjacent collinear spines");
                }
                if (vector3fArray3[0].dot(vector3fArray3[0]) == 0.0f) {
                    for (int i = 1; i < this.spines.length; ++i) {
                        if (!(vector3fArray3[i].dot(vector3fArray3[i]) > 0.0f)) continue;
                        vector3fArray3[0] = new Vector3f(vector3fArray3[i]);
                    }
                    if (vector3fArray3[0].dot(vector3fArray3[0]) == 0.0f) {
                        vector3fArray3[0] = new Vector3f(0.0f, 0.0f, 1.0f);
                    }
                }
                for (int i = 1; i < n2 + 1; ++i) {
                    if (vector3fArray3[i].dot(vector3fArray3[i]) != 0.0f) continue;
                    vector3fArray3[i] = new Vector3f(vector3fArray3[i - 1]);
                }
            }
            for (n = 0; n < this.spines.length; ++n) {
                if (n > 0 && vector3fArray3[n].dot(vector3fArray3[n - 1]) < 0.0f) {
                    vector3fArray3[n].negate();
                }
                vector3fArray[n] = new Vector3f();
                vector3fArray[n].cross(vector3fArray2[n], vector3fArray3[n]);
                try {
                    this.norm(vector3fArray[n]);
                }
                catch (ArithmeticException arithmeticException) {
                    arithmeticException.printStackTrace();
                }
                if (!hardDebug) continue;
                System.out.println("x[" + n + "] " + vector3fArray[n]);
            }
        }
        Matrix3f matrix3f = new Matrix3f();
        this.transforms = new Transform3D[this.spines.length];
        for (n = 0; n < this.spines.length; ++n) {
            this.rotations[n] = new Matrix3f();
            if (hardDebug) {
                Vector3f vector3f5 = new Vector3f((Tuple3f)this.spines[n]);
                vector3f5.add((Tuple3f)vector3fArray[n]);
                Vector3f vector3f6 = new Vector3f((Tuple3f)this.spines[n]);
                vector3f6.add((Tuple3f)vector3fArray2[n]);
                Vector3f vector3f7 = new Vector3f((Tuple3f)this.spines[n]);
                vector3f7.add((Tuple3f)vector3fArray3[n]);
                System.out.println("\northos (ABS) " + n + " " + vector3f5 + " " + vector3f6 + " " + vector3f7 + " " + this.orientations[n]);
                System.out.println("orthos " + n + " " + vector3fArray[n] + " " + vector3fArray2[n] + " " + vector3fArray3[n] + " " + this.orientations[n]);
            }
            this.rotations[n].setColumn(0, vector3fArray[n]);
            this.rotations[n].setColumn(1, vector3fArray2[n]);
            this.rotations[n].setColumn(2, vector3fArray3[n]);
        }
        Matrix3f[] matrix3fArray = this.createCorrectionRotations(vector3fArray3);
        for (int i = 0; i < this.spines.length; ++i) {
            this.rotations[i].mul(matrix3fArray[i]);
            matrix3f.set(this.orientations[i]);
            this.rotations[i].mul(matrix3f);
            this.transforms[i] = new Transform3D();
            this.transforms[i].setScale(new Vector3d(this.scales[i]));
            this.transforms[i].setTranslation(new Vector3d((Tuple3f)this.spines[i]));
            this.transforms[i].setRotation(this.rotations[i]);
        }
        return false;
    }

    private Matrix3f[] createCorrectionRotations(Vector3f[] vector3fArray) {
        int n;
        Matrix3f[] matrix3fArray = new Matrix3f[this.spines.length];
        matrix3fArray[0] = new Matrix3f();
        matrix3fArray[0].setIdentity();
        AxisAngle4f axisAngle4f = new AxisAngle4f();
        Point3f point3f = this.crossSectionPts[0];
        for (n = 0; n < this.crossSectionPts.length; ++n) {
            if (this.crossSectionPts[n].x == 0.0f && this.crossSectionPts[n].z == 0.0f) continue;
            point3f = this.crossSectionPts[n];
            break;
        }
        for (n = 1; n < this.spines.length; ++n) {
            float f = vector3fArray[n].angle(vector3fArray[n - 1]);
            matrix3fArray[n] = matrix3fArray[n - 1];
            if (f == 0.0f) continue;
            matrix3fArray[n] = new Matrix3f(matrix3fArray[n - 1]);
            Point3f point3f2 = new Point3f();
            Matrix3f matrix3f = new Matrix3f(this.rotations[n - 1]);
            matrix3f.mul(matrix3fArray[n - 1]);
            matrix3f.transform((Tuple3f)point3f, (Tuple3f)point3f2);
            Matrix3f matrix3f2 = new Matrix3f();
            matrix3f2.setIdentity();
            matrix3f2.rotY(-f);
            matrix3fArray[n].mul(matrix3f2);
            Matrix3f matrix3f3 = new Matrix3f(this.rotations[n]);
            matrix3f3.mul(matrix3fArray[n]);
            Point3f point3f3 = new Point3f();
            matrix3f3.transform((Tuple3f)point3f, (Tuple3f)point3f3);
            float f2 = point3f3.distance(point3f2);
            matrix3f2.rotY(f * 2.0f);
            matrix3fArray[n].mul(matrix3f2);
            Matrix3f matrix3f4 = new Matrix3f(this.rotations[n]);
            matrix3f4.mul(matrix3fArray[n]);
            Point3f point3f4 = new Point3f();
            matrix3f4.transform((Tuple3f)point3f4);
            float f3 = point3f4.distance(point3f2);
            if (f3 > f2) {
                matrix3f2.rotY(-f * 2.0f);
                matrix3fArray[n].mul(matrix3f2);
            }
            if (hardDebug) {
                System.out.println("i = " + n + " Angle is " + (f3 > f2 ? "negative " : "positive ") + "\n previous = " + point3f2 + "\npointNegative =" + point3f3 + "\npointPositive =" + point3f4 + f + " dist+ = " + f3 + " dist- = " + f2 + "\n");
            }
            axisAngle4f.set(matrix3fArray[n]);
            if (!((double)((float)Math.PI - axisAngle4f.angle) < 0.001)) continue;
            matrix3fArray[n].rotY((float)((double)axisAngle4f.angle - Math.PI));
        }
        return matrix3fArray;
    }

    private void createExtrusion() {
        int n;
        this.coords = new Point3f[this.spines.length * this.crossSectionPts.length];
        if (hardDebug) {
            System.out.println("Transformations");
            for (n = 0; n < this.transforms.length; ++n) {
                Matrix3d matrix3d = new Matrix3d();
                Vector3d vector3d = new Vector3d();
                this.transforms[n].get(matrix3d, vector3d);
                System.out.println(matrix3d.toString() + "\n" + vector3d.toString() + "\n");
            }
        }
        for (n = 0; n < this.spines.length; ++n) {
            for (int i = 0; i < this.crossSectionPts.length; ++i) {
                int n2 = n * this.crossSectionPts.length + i;
                this.coords[n2] = new Point3f(this.crossSectionPts[i]);
                if (hardDebug) {
                    System.out.print("Transforming " + i + " " + this.crossSectionPts[i] + " i =" + n);
                }
                this.transforms[n].transform(this.coords[n2]);
                if (!hardDebug) continue;
                System.out.println("Result = " + this.coords[n2]);
            }
        }
    }

    private void createIndices() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.crossSectionPts.length;
        int n5 = this.coords.length;
        int n6 = 0;
        int n7 = 0;
        if (this.vfEndCap) {
            n3 += n4 - 1;
            ++n6;
        }
        if (this.vfBeginCap) {
            n3 += n4 - 1;
            ++n6;
        }
        this.coordIndex = new int[n3 += (this.spines.length - 1) * (4 * (n4 - 1))];
        this.stripCounts = new int[n6 + (this.spines.length - 1) * (n4 - 1)];
        n6 = 0;
        if (this.vfCCW) {
            for (n2 = 0; n2 < this.spines.length - 1; ++n2) {
                for (n = 0; n < n4 - 1; ++n) {
                    this.coordIndex[n7++] = n2 * n4 + n;
                    this.coordIndex[n7++] = n2 * n4 + n + 1;
                    this.coordIndex[n7++] = (n2 + 1) * n4 + n + 1;
                    this.coordIndex[n7++] = (n2 + 1) * n4 + n;
                    this.stripCounts[n6++] = 4;
                    this.numTris += 2;
                }
            }
        } else {
            for (n2 = 0; n2 < this.spines.length - 1; ++n2) {
                for (n = 0; n < n4 - 1; ++n) {
                    this.coordIndex[n7++] = n2 * n4 + n;
                    this.coordIndex[n7++] = (n2 + 1) * n4 + n;
                    this.coordIndex[n7++] = (n2 + 1) * n4 + n + 1;
                    this.coordIndex[n7++] = n2 * n4 + n + 1;
                    this.stripCounts[n6++] = 4;
                    this.numTris += 2;
                }
            }
        }
        if (this.vfBeginCap && this.vfEndCap) {
            n2 = n3 - 2 * (n4 - 1);
            n = n3 - (n4 - 1);
            if (!this.vfCCW) {
                int n8 = 0;
                while (n8 < n4 - 1) {
                    this.coordIndex[n2++] = n8++;
                }
                n8 = n5 - 1;
                while (n8 > n5 - n4) {
                    this.coordIndex[n++] = n8--;
                }
            } else {
                int n9 = n4 - 1;
                while (n9 > 0) {
                    this.coordIndex[n2++] = n9--;
                }
                for (n9 = 0; n9 < n4 - 1; ++n9) {
                    this.coordIndex[n++] = n5 - (n4 - 1) + n9;
                }
            }
            this.stripCounts[n6++] = n4 - 1;
            this.stripCounts[n6++] = n4 - 1;
            this.numTris += n4 - 1;
        } else if (this.vfBeginCap) {
            n2 = n3 - (n4 - 1);
            if (!this.vfCCW) {
                n = 0;
                while (n < n4 - 1) {
                    this.coordIndex[n2++] = n++;
                }
            } else {
                n = n4 - 1;
                while (n > 0) {
                    this.coordIndex[n2++] = n--;
                }
            }
            this.stripCounts[n6++] = n4 - 1;
            this.numTris += n4 - 1;
        } else if (this.vfEndCap) {
            n2 = n3 - (n4 - 1);
            if (this.vfCCW) {
                n = n5 - (n4 - 1);
                while (n < n5) {
                    this.coordIndex[n2++] = n++;
                }
            } else {
                n = n5 - 1;
                while (n > n5 - n4) {
                    this.coordIndex[n2++] = n--;
                }
            }
            this.stripCounts[n6++] = n4 - 1;
            this.numTris += n4 - 1;
        }
    }

    private void norm(Vector3f vector3f) {
        float f = (float)Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
        if (f == 0.0f) {
            throw new ArithmeticException();
        }
        vector3f.x /= f;
        vector3f.y /= f;
        vector3f.z /= f;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

