/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.geom3d;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TriangleArray;
import org.j3d.geom.GeometryData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.GeometryHolder;
import org.web3d.vrml.renderer.common.nodes.GeometryUtils;
import org.web3d.vrml.renderer.common.nodes.geom3d.BaseIndexedFaceSet;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;

public class J3DIndexedFaceSet
extends BaseIndexedFaceSet
implements J3DGeometryNodeType {
    private ArrayList listeners;
    private TriangleArray implGeom;
    private J3DUserData userData;
    private boolean compact;
    private float[][] texCoords;
    private int[] texTypes;
    private int[] texSetMap;
    private int numTexSets;
    private int numUniqueTexSets;
    private GeometryUtils gutils;
    private int numBuilds;
    private boolean initialBuild;

    public J3DIndexedFaceSet() {
        this.init();
    }

    public J3DIndexedFaceSet(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        this.buildImpl();
    }

    public Geometry[] getGeometry() {
        return new Geometry[]{this.implGeom};
    }

    public void addGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.add(j3DGeometryListener);
    }

    public void removeGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || !this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.remove(j3DGeometryListener);
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.geomData = new GeometryData();
        this.geomData.geometryType = 1;
        this.userData = new J3DUserData();
        this.userData.geometryData = this.geomData;
        if (this.isStatic) {
            this.compact = true;
        }
        this.buildImpl();
        this.inSetup = false;
    }

    private void init() {
        this.changeFlags = 0;
        this.listeners = new ArrayList();
    }

    private void buildImpl() {
        int n;
        int n2;
        if (this.vfCoordIndex == null || this.vfCoord == null || !this.inSetup && this.changeFlags == 0) {
            return;
        }
        int n3 = this.vfCoord.getNumPoints();
        if (n3 < 3) {
            return;
        }
        if (this.gutils == null) {
            this.gutils = new GeometryUtils();
        }
        GeometryHolder geometryHolder = new GeometryHolder();
        boolean bl = this.gutils.generateTriangleArrays(this.changeFlags, true, true, this.vfCoord, this.vfColor, this.vfNormal, this.vfTexCoord, this.vfCoordIndex, this.numCoordIndex, this.vfColorIndex, this.vfNormalIndex, this.vfTexCoordIndex, true, this.vfConvex, this.vfColorPerVertex, this.vfNormalPerVertex, this.vfCreaseAngle, this.initialBuild, geometryHolder);
        if (geometryHolder.coordinates == null) {
            return;
        }
        this.gutils.copyData(geometryHolder, this.geomData);
        if (bl) {
            n2 = 3;
            if (this.vfColor != null) {
                n = this.vfColor.getNumColorComponents();
                switch (n) {
                    case 1: 
                    case 2: {
                        System.out.println("Can't handle 1 or 2 component colors right now");
                    }
                    case 3: {
                        n2 |= 4;
                        break;
                    }
                    case 4: {
                        n2 |= 0xC;
                    }
                    default: {
                        System.out.println("Invalid number of color components " + this.vfColor.getNumColorComponents());
                    }
                }
            }
            if (this.vfTexCoord == null) {
                n2 |= 0x20;
            } else {
                n = this.vfTexCoord.getNumTextureComponents();
                switch (n) {
                    case 2: {
                        n2 |= 0x20;
                        break;
                    }
                    case 3: {
                        n2 |= 0x40;
                        break;
                    }
                    case 4: {
                        n2 |= 0x400;
                        break;
                    }
                    default: {
                        System.out.println("Invalid number of texture components " + this.vfTexCoord.getNumTextureComponents());
                    }
                }
            }
            n = this.vfTexCoord == null ? 1 : this.vfTexCoord.getNumSets();
            int[] nArray = new int[n >= 4 ? n : 4];
            if (this.vfTexCoord != null) {
                int n4;
                for (n4 = 0; n4 < n; ++n4) {
                    nArray[n4] = this.vfTexCoord.isShared(n4);
                }
                for (n4 = n; n4 < 4; ++n4) {
                    nArray[n4] = n - 1;
                }
            }
            int[] nArray2 = new int[4];
            this.gutils.getCounts(nArray2);
            int n5 = nArray2[2] == 0 ? 3 * nArray2[0] + 6 * nArray2[1] : nArray2[3] * 3;
            this.implGeom = new TriangleArray(n5, n2, n, nArray);
            if (!this.isStatic) {
                this.implGeom.setCapability(1);
                this.implGeom.setCapability(5);
                this.implGeom.setCapability(7);
                this.implGeom.setCapability(20);
                this.implGeom.clearCapabilityIsFrequent(20);
                if (this.vfColor != null) {
                    this.implGeom.setCapability(3);
                    this.implGeom.clearCapabilityIsFrequent(3);
                }
            }
            this.implGeom.setUserData((Object)this.userData);
            this.initialBuild = true;
        }
        this.texCoords = geometryHolder.textureCoordinates;
        this.numTexSets = geometryHolder.numTexSets;
        this.numUniqueTexSets = geometryHolder.numUniqueTexSets;
        if ((this.changeFlags & 1) != 0 || this.initialBuild) {
            this.implGeom.setCoordinates(0, this.geomData.coordinates);
        }
        if ((this.changeFlags & 1) != 0 && this.vfNormal == null || (this.changeFlags & 2) != 0 || this.initialBuild) {
            this.implGeom.setNormals(0, this.geomData.normals);
        }
        if ((this.changeFlags & 4) != 0 || this.initialBuild) {
            if (this.vfTexCoord == null) {
                this.implGeom.setTextureCoordinates(0, 0, this.geomData.textureCoordinates);
            } else {
                n2 = this.texCoords.length;
                for (n = 0; n < n2; ++n) {
                    this.implGeom.setTextureCoordinates(n, 0, this.texCoords[n]);
                }
            }
        }
        if (((this.changeFlags & 8) != 0 || this.initialBuild) && this.vfColor != null) {
            this.implGeom.setColors(0, this.geomData.colors);
        }
        this.changeFlags = 0;
        this.initialBuild = false;
        if (bl & !this.inSetup) {
            this.fireGeometryChanged(null);
        }
        if (this.isStatic || this.numBuilds < 1) {
            this.gutils.reset();
            this.gutils = null;
            if (this.inSetup) {
                this.texCoords = null;
                this.texTypes = null;
                this.texSetMap = null;
            }
        }
        ++this.numBuilds;
    }

    private void fireGeometryAdded(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryAdded(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry add message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void fireGeometryChanged(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryChanged(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry change message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void fireGeometryRemoved(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryRemoved(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry remove message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

