/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.geospatial;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TriangleStripArray;
import org.j3d.geom.GeometryData;
import org.opengis.referencing.operation.TransformException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoElevationGrid;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;
import org.web3d.vrml.renderer.common.nodes.geospatial.ElevationGridGenerator;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;

public class J3DGeoElevationGrid
extends BaseGeoElevationGrid
implements J3DGeometryNodeType {
    private TriangleStripArray implGeom;
    private ElevationGridGenerator generator;
    private GeometryData data;
    private ArrayList listeners;
    private float[] v0;
    private float[] v1;
    private float[] v2;
    private float[] v3;

    public J3DGeoElevationGrid() {
        this.init();
    }

    public J3DGeoElevationGrid(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Geometry[] getGeometry() {
        return new Geometry[]{this.implGeom};
    }

    public void addGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.add(j3DGeometryListener);
    }

    public void removeGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || !this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.remove(j3DGeometryListener);
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.buildImpl();
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 3: {
                if (this.vfNormal != null) {
                    float[] fArray = new float[this.vfXDimension * (this.vfZDimension - 1) * 2 * 3];
                    float[] fArray2 = new float[this.vfNormal.getNumNormals()];
                    this.vfNormal.getVector(fArray2);
                    this.setupArray(fArray2, fArray);
                    this.implGeom.setNormals(0, fArray);
                    break;
                }
                this.implGeom.setNormals(0, this.data.normals);
                break;
            }
            case 2: {
                if (this.vfColor != null) {
                    float[] fArray = new float[this.vfXDimension * (this.vfZDimension - 1) * 2 * 3];
                    float[] fArray3 = new float[this.vfColor.getNumColors()];
                    this.vfColor.getColor(fArray3);
                    this.setupArray(fArray3, fArray);
                    this.implGeom.setColors(0, fArray);
                    break;
                }
                this.buildImpl();
                break;
            }
            case 4: {
                this.buildImpl();
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setComponents(VRMLNodeType[] vRMLNodeTypeArray) throws InvalidFieldValueException {
        super.setComponents(vRMLNodeTypeArray);
        if (!this.inSetup) {
            this.buildImpl();
        }
    }

    public void setComponent(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setComponent(vRMLNodeType);
        if (!this.inSetup) {
            this.buildImpl();
        }
    }

    private void buildImpl() {
        float[] fArray;
        VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType;
        Object object;
        if (this.vfHeight == null || this.vfHeight.length == 0) {
            return;
        }
        this.generator = new ElevationGridGenerator((double)(this.vfXDimension - 1) * this.vfXSpacing, (double)(this.vfZDimension - 1) * this.vfZSpacing, this.vfXDimension, this.vfZDimension, this.vfYScale, this.vfHeight);
        this.data.geometryType = 3;
        int n = 0;
        if (this.vfTexCoord == null && this.pTexCoord == null) {
            this.data.geometryComponents = 4;
            n = 1;
        } else {
            object = this.pTexCoord != null ? (VRMLTextureCoordinateNodeType)this.pTexCoord.getImplementationNode() : this.vfTexCoord;
            n = object.getNumSets();
        }
        if (this.vfNormal == null && this.pNormal == null) {
            this.data.geometryComponents |= 2;
        }
        object = null;
        if (this.vfGeoOrigin != null) {
            object = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
        }
        try {
            if (this.geoCoordSwap) {
                double d = this.vfGeoGridOrigin[0];
                this.vfGeoGridOrigin[0] = this.vfGeoGridOrigin[1];
                this.vfGeoGridOrigin[1] = d;
                this.generator.generateIndexedQuads(this.data, this.geoTransform, this.vfGeoGridOrigin, (double[])object, false, this.vfCreaseAngle);
                d = this.vfGeoGridOrigin[0];
                this.vfGeoGridOrigin[0] = this.vfGeoGridOrigin[1];
                this.vfGeoGridOrigin[1] = d;
            } else {
                this.generator.generateIndexedQuads(this.data, this.geoTransform, this.vfGeoGridOrigin, (double[])object, false, this.vfCreaseAngle);
            }
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport("Unable to transform the coordinate values for some reason.", (Exception)((Object)transformException));
            return;
        }
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int n2 = 35;
        if (this.vfColor != null || this.pColor != null) {
            n2 |= 4;
        }
        this.implGeom = new TriangleStripArray(this.data.vertexCount, n2, n, nArray, this.data.stripCounts);
        J3DUserData j3DUserData = new J3DUserData();
        j3DUserData.geometryData = this.data;
        this.implGeom.setUserData((Object)j3DUserData);
        this.implGeom.setCoordinates(0, this.data.coordinates);
        if ((this.data.geometryComponents & 4) != 0) {
            this.implGeom.setTextureCoordinates(0, 0, this.data.textureCoordinates);
        } else {
            vRMLTextureCoordinateNodeType = this.pTexCoord != null ? (VRMLTextureCoordinateNodeType)this.pTexCoord.getImplementationNode() : this.vfTexCoord;
            n = vRMLTextureCoordinateNodeType.getNumSets();
            fArray = null;
            float[] fArray2 = new float[vRMLTextureCoordinateNodeType.getSize(0) * 2];
            for (int i = 0; i < n; ++i) {
                int n3 = vRMLTextureCoordinateNodeType.getNumTextureComponents();
                int n4 = this.vfTexCoord.getSize(i);
                nArray[i] = this.vfTexCoord.isShared(i);
                int n5 = this.data.vertexCount * n3;
                if (n4 < n5) {
                    n4 = n5;
                }
                if (fArray == null || fArray.length < n4) {
                    fArray = new float[n4];
                }
                if (fArray2.length < n4) {
                    fArray2 = new float[n4];
                }
                vRMLTextureCoordinateNodeType.getPoint(i, fArray2);
                int n6 = this.vfZDimension * n3;
                int n7 = n5 - 1;
                int n8 = this.vfXDimension * this.vfZDimension * n3 - 1;
                for (int j = 0; j < this.vfXDimension - 1; ++j) {
                    for (int k = 0; k < this.vfZDimension; ++k) {
                        fArray[n7--] = fArray2[n8];
                        fArray[n7--] = fArray2[n8 - 1];
                        fArray[n7--] = fArray2[n8 - n6];
                        fArray[n7--] = fArray2[n8 - n6 - 1];
                        n8 -= n3;
                    }
                }
                if (n5 == 0) continue;
                this.implGeom.setTextureCoordinates(i, 0, fArray);
            }
        }
        if (this.vfNormal != null || this.pNormal != null) {
            vRMLTextureCoordinateNodeType = this.pNormal != null ? (VRMLNormalNodeType)this.pNormal.getImplementationNode() : this.vfNormal;
            float[] fArray3 = new float[vRMLTextureCoordinateNodeType.getNumNormals()];
            vRMLTextureCoordinateNodeType.getVector(fArray3);
            fArray = new float[this.vfXDimension * (this.vfZDimension - 1) * 2 * 3];
            this.setupArray(fArray3, fArray);
            this.implGeom.setNormals(0, fArray);
        } else if (this.vfCcw) {
            this.implGeom.setNormals(0, this.data.normals);
        } else {
            for (int i = 0; i < this.data.normals.length / 3; i += 2) {
                this.data.normals[++i] = -this.data.normals[i];
            }
            this.implGeom.setNormals(0, this.data.normals);
        }
        if (this.vfColor != null || this.pColor != null) {
            VRMLColorNodeType vRMLColorNodeType = this.pColor != null ? (VRMLColorNodeType)this.pColor.getImplementationNode() : this.vfColor;
            float[] fArray4 = new float[vRMLColorNodeType.getNumColors()];
            vRMLColorNodeType.getColor(fArray4);
            fArray = new float[this.vfXDimension * (this.vfZDimension - 1) * 2 * 3];
            this.setupArray(fArray4, fArray);
            this.implGeom.setColors(0, fArray);
        }
        this.implGeom.setCapability(0);
        this.implGeom.setCapability(1);
        this.implGeom.setCapability(4);
        this.implGeom.setCapability(6);
        this.implGeom.setCapability(8);
        this.implGeom.setCapability(17);
    }

    private void setupArray(float[] fArray, float[] fArray2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.vfXDimension * 3;
        n3 = n = this.vfXDimension * (this.vfZDimension - 1);
        while (--n3 >= 0) {
            this.v0[0] = fArray[n4];
            this.v0[1] = fArray[n4 + 1];
            this.v0[2] = fArray[n4 + 2];
            if (this.vfColorPerVertex) {
                this.v1[0] = fArray[n4 + n5];
                this.v1[1] = fArray[n4 + n5 + 1];
                this.v1[2] = fArray[n4 + n5 + 2];
                if (this.vfCcw) {
                    fArray2[n2++] = this.v0[0];
                    fArray2[n2++] = this.v0[1];
                    fArray2[n2++] = this.v0[2];
                    fArray2[n2++] = this.v1[0];
                    fArray2[n2++] = this.v1[1];
                    fArray2[n2++] = this.v1[2];
                } else {
                    fArray2[n2++] = this.v1[0];
                    fArray2[n2++] = this.v1[1];
                    fArray2[n2++] = this.v1[2];
                    fArray2[n2++] = this.v0[0];
                    fArray2[n2++] = this.v0[1];
                    fArray2[n2++] = this.v0[2];
                }
                n4 += 3;
                continue;
            }
            fArray2[n2++] = this.v0[0];
            fArray2[n2++] = this.v0[1];
            fArray2[n2++] = this.v0[2];
            fArray2[n2++] = this.v0[0];
            fArray2[n2++] = this.v0[1];
            fArray2[n2++] = this.v0[2];
            if (n3 % 2 == 0) continue;
            n4 += 3;
        }
    }

    private void init() {
        this.v0 = new float[3];
        this.v1 = new float[3];
        this.v2 = new float[3];
        this.v3 = new float[3];
        this.listeners = new ArrayList();
        this.data = new GeometryData();
    }
}

