/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.group;

import java.util.HashMap;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.InvalidNodeTypeException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.renderer.j3d.nodes.J3DGroupingNode;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;

public class J3DSwitch
extends J3DGroupingNode {
    private static final int FIELD_WHICH_CHOICE = 6;
    private static final int LAST_SWITCH_INDEX = 6;
    private static final int NUM_FIELDS = 7;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private int vfWhichChoice = -1;
    private Switch implSwitch;

    public J3DSwitch() {
        super("Switch");
        this.hasChanged = new boolean[7];
        this.implSwitch = new Switch(-3);
        this.implGroup = this.implSwitch;
    }

    public J3DSwitch(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("whichChoice");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setWhichChoice(vRMLFieldData.intValue);
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        if (bl) {
            return;
        }
        this.implGroup.setCapability(17);
        this.implGroup.setCapability(13);
        this.implGroup.setCapability(14);
        this.implSwitch.setCapability(18);
        this.implSwitch.setCapability(13);
        this.implSwitch.setCapability(14);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfWhichChoice;
                this.fieldData.dataType = (short)2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfWhichChoice);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setWhichChoice(n2);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    private void setWhichChoice(int n) throws InvalidFieldValueException {
        if (n < -1) {
            throw new InvalidFieldValueException("whichChoice < -1");
        }
        this.vfWhichChoice = n;
        if (this.vfWhichChoice == -1) {
            this.implSwitch.setWhichChild(-1);
        } else {
            int n2 = this.vfChildren.size();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.vfChildren.get(i);
                if (j3DVRMLNode instanceof CRProtoInstance && !((CRProtoInstance)j3DVRMLNode).getComplete()) continue;
                if (!(j3DVRMLNode instanceof VRMLChildNodeType) && !(j3DVRMLNode instanceof VRMLProtoInstance)) {
                    throw new InvalidNodeTypeException(j3DVRMLNode.getVRMLNodeName(), "Groups can only contain ChildNodes");
                }
                Node node = (Node)j3DVRMLNode.getSceneGraphObject();
                if (i == this.vfWhichChoice && node == null) {
                    n3 = -1;
                    break;
                }
                if (node == null) continue;
                if (i == this.vfWhichChoice) break;
                ++n3;
            }
            this.implSwitch.setWhichChild(n3);
        }
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(7);
        J3DSwitch.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        J3DSwitch.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        J3DSwitch.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        J3DSwitch.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        J3DSwitch.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFInt32", "whichChoice");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        fieldMap.put("choice", n);
        fieldMap.put("set_choice", n);
        fieldMap.put("choice_changed", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("whichChoice", n);
        fieldMap.put("set_whichChoice", n);
        fieldMap.put("whichChoice_changed", n);
    }
}

