/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.lighting;

import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.DirectionalLight;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DGlobalStatus;
import org.web3d.vrml.renderer.j3d.nodes.J3DLightNode;

public class J3DDirectionalLight
extends J3DLightNode {
    private static final int FIELD_DIRECTION = 5;
    private static final int LAST_DIRECTIONALLIGHT_INDEX = 5;
    private static final int NUM_FIELDS = 6;
    private static final Bounds infiniteBounds = new BoundingSphere(new Point3d(), Double.MAX_VALUE);
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private Vector3f vfDirection;
    private float[] flScratch;
    private Color3f lightColor;
    static /* synthetic */ Class class$javax$media$j3d$DirectionalLight;

    public J3DDirectionalLight() {
        super("DirectionalLight");
        this.hasChanged = new boolean[6];
        this.flScratch = new float[3];
        this.lightColor = new Color3f();
        this.vfDirection = new Vector3f(0.0f, 0.0f, -1.0f);
        this.lightColor.x = this.vfColor[0] * this.vfIntensity;
        this.lightColor.y = this.vfColor[1] * this.vfIntensity;
        this.lightColor.z = this.vfColor[2] * this.vfIntensity;
        this.implLight = new DirectionalLight(this.vfOn, this.lightColor, this.vfDirection);
        this.implLight.setInfluencingBounds(infiniteBounds);
    }

    public J3DDirectionalLight(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLLightNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("direction");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDirection.x = vRMLFieldData.floatArrayValue[0];
            this.vfDirection.y = vRMLFieldData.floatArrayValue[1];
            this.vfDirection.z = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null && map.containsKey(class$javax$media$j3d$DirectionalLight == null ? (class$javax$media$j3d$DirectionalLight = J3DDirectionalLight.class$("javax.media.j3d.DirectionalLight")) : class$javax$media$j3d$DirectionalLight)) {
            nArray = (int[])map.get(class$javax$media$j3d$DirectionalLight == null ? (class$javax$media$j3d$DirectionalLight = J3DDirectionalLight.class$("javax.media.j3d.DirectionalLight")) : class$javax$media$j3d$DirectionalLight);
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implLight.clearCapability(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.implLight.clearCapability(15);
                this.implLight.clearCapability(13);
                this.implLight.clearCapability(19);
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null || !map2.containsKey(class$javax$media$j3d$DirectionalLight == null ? (class$javax$media$j3d$DirectionalLight = J3DDirectionalLight.class$("javax.media.j3d.DirectionalLight")) : class$javax$media$j3d$DirectionalLight)) {
            return;
        }
        nArray = (int[])map2.get(class$javax$media$j3d$DirectionalLight == null ? (class$javax$media$j3d$DirectionalLight = J3DDirectionalLight.class$("javax.media.j3d.DirectionalLight")) : class$javax$media$j3d$DirectionalLight);
        int n4 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.implLight.clearCapabilityIsFrequent(nArray[n]);
            }
        } else if (!this.isStatic) {
            this.implLight.clearCapabilityIsFrequent(15);
            this.implLight.clearCapabilityIsFrequent(13);
            this.implLight.clearCapabilityIsFrequent(19);
        }
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null) {
            nArray = (int[])map.get(class$javax$media$j3d$DirectionalLight == null ? (class$javax$media$j3d$DirectionalLight = J3DDirectionalLight.class$("javax.media.j3d.DirectionalLight")) : class$javax$media$j3d$DirectionalLight);
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implLight.setCapability(nArray[n]);
                }
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        nArray = (int[])map2.get(class$javax$media$j3d$DirectionalLight == null ? (class$javax$media$j3d$DirectionalLight = J3DDirectionalLight.class$("javax.media.j3d.DirectionalLight")) : class$javax$media$j3d$DirectionalLight);
        int n4 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.implLight.setCapabilityIsFrequent(nArray[n]);
            }
        }
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        if (bl) {
            return;
        }
        this.implLight.setCapability(15);
        this.implLight.setCapability(13);
        this.implLight.setCapability(19);
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 5: {
                this.vfDirection.get(this.flScratch);
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.flScratch;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 5: {
                    this.vfDirection.get(this.flScratch);
                    vRMLNodeType.setValue(n2, this.flScratch, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("DirLight sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("DirLight sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setDirection(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.lightColor.x = this.vfColor[0] * this.vfIntensity;
        this.lightColor.y = this.vfColor[1] * this.vfIntensity;
        this.lightColor.z = this.vfColor[2] * this.vfIntensity;
        this.implLight.setEnable(this.vfOn);
        ((DirectionalLight)this.implLight).setDirection(this.vfDirection);
        this.implLight.setColor(this.lightColor);
    }

    private void setDirection(float[] fArray) {
        this.vfDirection.x = fArray[0];
        this.vfDirection.y = fArray[1];
        this.vfDirection.z = fArray[2];
        if (!this.inSetup) {
            ((DirectionalLight)this.implLight).setDirection(this.vfDirection);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[6];
        fieldMap = new HashMap(18);
        J3DDirectionalLight.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "ambientIntensity");
        J3DDirectionalLight.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFColor", "color");
        J3DDirectionalLight.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFFloat", "intensity");
        J3DDirectionalLight.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFBool", "on");
        J3DDirectionalLight.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "direction");
        Integer n = new Integer(1);
        fieldMap.put("ambientIntensity", n);
        fieldMap.put("set_ambientIntensity", n);
        fieldMap.put("ambientIntensity_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(3);
        fieldMap.put("intensity", n);
        fieldMap.put("set_intensity", n);
        fieldMap.put("intensity_changed", n);
        n = new Integer(4);
        fieldMap.put("on", n);
        fieldMap.put("set_on", n);
        fieldMap.put("on_changed", n);
        n = new Integer(5);
        fieldMap.put("direction", n);
        fieldMap.put("set_direction", n);
        fieldMap.put("direction_changed", n);
    }
}

