/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.lighting;

import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.SpotLight;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DGlobalStatus;
import org.web3d.vrml.renderer.j3d.nodes.J3DLightNode;

public class J3DSpotLight
extends J3DLightNode {
    private static final int FIELD_ATTENUATION = 5;
    private static final int FIELD_BEAMWIDTH = 6;
    private static final int FIELD_CUTOFFANGLE = 7;
    private static final int FIELD_DIRECTION = 8;
    private static final int FIELD_LOCATION = 9;
    private static final int FIELD_RADIUS = 10;
    public static final int LAST_SPOTLIGHT_INDEX = 10;
    private static final int NUM_FIELDS = 11;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private Point3f vfAttenuation;
    private float vfBeamWidth;
    private float vfCutOffAngle;
    private Vector3f vfDirection;
    private Point3f vfLocation;
    private float vfRadius;
    private Bounds bounds;
    private float[] flScratch;
    private Color3f lightColor;
    static /* synthetic */ Class class$javax$media$j3d$SpotLight;

    public J3DSpotLight() {
        super("SpotLight");
        this.hasChanged = new boolean[11];
        this.vfDirection = new Vector3f(0.0f, 0.0f, -1.0f);
        this.vfAttenuation = new Point3f(1.0f, 0.0f, 0.0f);
        this.vfLocation = new Point3f(0.0f, 0.0f, 0.0f);
        this.vfRadius = 100.0f;
        this.vfBeamWidth = 1.570796f;
        this.vfCutOffAngle = 0.785398f;
        this.flScratch = new float[3];
        this.lightColor = new Color3f();
        this.lightColor.x = this.vfColor[0] * this.vfIntensity;
        this.lightColor.y = this.vfColor[1] * this.vfIntensity;
        this.lightColor.z = this.vfColor[2] * this.vfIntensity;
        this.implLight = new SpotLight(this.vfOn, this.lightColor, this.vfLocation, this.vfAttenuation, this.vfDirection, (float)((double)this.vfCutOffAngle / Math.PI * 180.0), (float)((double)this.vfBeamWidth / 1.5707963267948966 * 128.0));
        this.bounds = new BoundingSphere(new Point3d(), (double)this.vfRadius);
        this.implLight.setInfluencingBounds(this.bounds);
    }

    public J3DSpotLight(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLLightNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("attenuation");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAttenuation.x = vRMLFieldData.floatArrayValue[0];
            this.vfAttenuation.y = vRMLFieldData.floatArrayValue[1];
            this.vfAttenuation.z = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("location");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLocation.x = vRMLFieldData.floatArrayValue[0];
            this.vfLocation.y = vRMLFieldData.floatArrayValue[1];
            this.vfLocation.z = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("direction");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDirection.x = vRMLFieldData.floatArrayValue[0];
            this.vfDirection.y = vRMLFieldData.floatArrayValue[1];
            this.vfDirection.z = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("radius");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRadius = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("beamWidth");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBeamWidth = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("cuttOffAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCutOffAngle = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null && map.containsKey(class$javax$media$j3d$SpotLight == null ? (class$javax$media$j3d$SpotLight = J3DSpotLight.class$("javax.media.j3d.SpotLight")) : class$javax$media$j3d$SpotLight)) {
            nArray = (int[])map.get(class$javax$media$j3d$SpotLight == null ? (class$javax$media$j3d$SpotLight = J3DSpotLight.class$("javax.media.j3d.SpotLight")) : class$javax$media$j3d$SpotLight);
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implLight.clearCapability(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.implLight.clearCapability(15);
                this.implLight.clearCapability(13);
                this.implLight.clearCapability(26);
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null || !map2.containsKey(class$javax$media$j3d$SpotLight == null ? (class$javax$media$j3d$SpotLight = J3DSpotLight.class$("javax.media.j3d.SpotLight")) : class$javax$media$j3d$SpotLight)) {
            return;
        }
        nArray = (int[])map2.get(class$javax$media$j3d$SpotLight == null ? (class$javax$media$j3d$SpotLight = J3DSpotLight.class$("javax.media.j3d.SpotLight")) : class$javax$media$j3d$SpotLight);
        int n4 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.implLight.clearCapabilityIsFrequent(nArray[n]);
            }
        } else if (!this.isStatic) {
            this.implLight.clearCapabilityIsFrequent(15);
            this.implLight.clearCapabilityIsFrequent(13);
            this.implLight.clearCapabilityIsFrequent(26);
        }
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null) {
            nArray = (int[])map.get(class$javax$media$j3d$SpotLight == null ? (class$javax$media$j3d$SpotLight = J3DSpotLight.class$("javax.media.j3d.SpotLight")) : class$javax$media$j3d$SpotLight);
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implLight.setCapability(nArray[n]);
                }
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        nArray = (int[])map2.get(class$javax$media$j3d$SpotLight == null ? (class$javax$media$j3d$SpotLight = J3DSpotLight.class$("javax.media.j3d.SpotLight")) : class$javax$media$j3d$SpotLight);
        int n4 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.implLight.setCapabilityIsFrequent(nArray[n]);
            }
        }
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        if (bl) {
            return;
        }
        this.implLight.setCapability(15);
        this.implLight.setCapability(13);
        this.implLight.setCapability(26);
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 5: {
                this.vfAttenuation.get(this.flScratch);
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.flScratch;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfBeamWidth;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfCutOffAngle;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 8: {
                this.vfDirection.get(this.flScratch);
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.flScratch;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 9: {
                this.vfLocation.get(this.flScratch);
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.flScratch;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfRadius;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfBeamWidth);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfCutOffAngle);
                    break;
                }
                case 8: {
                    this.vfDirection.get(this.flScratch);
                    vRMLNodeType.setValue(n2, this.flScratch, 3);
                    break;
                }
                case 9: {
                    this.vfLocation.get(this.flScratch);
                    vRMLNodeType.setValue(n2, this.flScratch, 3);
                    break;
                }
                case 5: {
                    this.vfAttenuation.get(this.flScratch);
                    vRMLNodeType.setValue(n2, this.flScratch, 3);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfRadius);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("DirLight sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("DirLight sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setBeamWidth(f);
                break;
            }
            case 7: {
                this.setCutOffAngle(f);
            }
            case 10: {
                this.setRadius(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.setDirection(fArray);
                break;
            }
            case 9: {
                this.setLocation(fArray);
                break;
            }
            case 5: {
                this.setAttenuation(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private void setDirection(float[] fArray) {
        this.vfDirection.x = fArray[0];
        this.vfDirection.y = fArray[1];
        this.vfDirection.z = fArray[2];
        ((SpotLight)this.implLight).setDirection(this.vfDirection);
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    private void setLocation(float[] fArray) {
        this.vfLocation.x = fArray[0];
        this.vfLocation.y = fArray[1];
        this.vfLocation.z = fArray[2];
        ((SpotLight)this.implLight).setPosition(this.vfLocation);
        if (!this.inSetup) {
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void setBeamWidth(float f) {
        if (f <= 0.0f || (double)f > 1.5707963267948966) {
            throw new InvalidFieldValueException("beamWidth size out of range: " + f);
        }
        this.vfBeamWidth = f;
        ((SpotLight)this.implLight).setConcentration((float)((double)this.vfBeamWidth / 1.5707963267948966 * 128.0));
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void setRadius(float f) {
        if (f <= 0.0f) {
            throw new InvalidFieldValueException("radius out of range: " + f);
        }
        this.vfRadius = f;
        this.bounds = new BoundingSphere(new Point3d(), (double)this.vfRadius);
        this.implLight.setInfluencingBounds(this.bounds);
        if (!this.inSetup) {
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    private void setAttenuation(float[] fArray) {
        if (fArray[0] < 0.0f || fArray[1] < 0.0f || fArray[2] < 0.0f) {
            throw new InvalidFieldValueException("attenuation value out of range");
        }
        this.vfAttenuation.x = fArray[0];
        this.vfAttenuation.y = fArray[1];
        this.vfAttenuation.z = fArray[2];
        ((SpotLight)this.implLight).setAttenuation(this.vfAttenuation);
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setCutOffAngle(float f) {
        if (f <= 0.0f || (double)f > 1.5707963267948966) {
            throw new InvalidFieldValueException("cutOffAngle size out of range: " + f);
        }
        this.vfCutOffAngle = f;
        ((SpotLight)this.implLight).setSpreadAngle(this.vfCutOffAngle);
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        J3DSpotLight.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "ambientIntensity");
        J3DSpotLight.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFColor", "color");
        J3DSpotLight.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFFloat", "intensity");
        J3DSpotLight.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFBool", "on");
        J3DSpotLight.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "attenuation");
        J3DSpotLight.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "beamWidth");
        J3DSpotLight.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "cutOffAngle");
        J3DSpotLight.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec3f", "direction");
        J3DSpotLight.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFVec3f", "location");
        J3DSpotLight.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFFloat", "radius");
        Integer n = new Integer(1);
        fieldMap.put("ambientIntensity", n);
        fieldMap.put("set_ambientIntensity", n);
        fieldMap.put("ambientIntensity_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(3);
        fieldMap.put("intensity", n);
        fieldMap.put("set_intensity", n);
        fieldMap.put("intensity_changed", n);
        n = new Integer(4);
        fieldMap.put("on", n);
        fieldMap.put("set_on", n);
        fieldMap.put("on_changed", n);
        n = new Integer(9);
        fieldMap.put("location", n);
        fieldMap.put("set_location", n);
        fieldMap.put("location_changed", n);
        n = new Integer(10);
        fieldMap.put("radius", n);
        fieldMap.put("set_radius", n);
        fieldMap.put("radius_changed", n);
        n = new Integer(5);
        fieldMap.put("attenuation", n);
        fieldMap.put("set_attenuation", n);
        fieldMap.put("attenuation_changed", n);
        n = new Integer(8);
        fieldMap.put("direction", n);
        fieldMap.put("set_direction", n);
        fieldMap.put("direction_changed", n);
        n = new Integer(6);
        fieldMap.put("beamWidth", n);
        fieldMap.put("set_beamWidth", n);
        fieldMap.put("beamWidth_changed", n);
        n = new Integer(7);
        fieldMap.put("cutOffAngle", n);
        fieldMap.put("set_cutOffAngle", n);
        fieldMap.put("cutOffAngle_changed", n);
    }
}

