/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.navigation;

import java.util.HashMap;
import javax.media.j3d.Geometry;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.j3d.util.MatrixUtils;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DGlobalStatus;
import org.web3d.vrml.renderer.j3d.nodes.J3DGroupingNode;
import org.web3d.vrml.renderer.j3d.nodes.J3DParentPathRequestHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DPathAwareNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;
import org.web3d.vrml.renderer.j3d.nodes.J3DVisibilityListener;

public class J3DBillboard
extends J3DGroupingNode
implements J3DVisibilityListener,
J3DPathAwareNodeType {
    private static final Vector3f Y_UP = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f Z_UP = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Point3f ORIGIN = new Point3f(0.0f, 0.0f, 0.0f);
    private static final int FIELD_AXISOFROTATION = 6;
    private static final int LAST_BILLBOARD_INDEX = 6;
    protected static final int NUM_FIELDS = 7;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private float[] vfAxisOfRotation;
    private TransformGroup implTrans;
    private TransformGroup childTrans;
    private Transform3D implTransform;
    private Shape3D shape;
    private Vector3f axis;
    private J3DParentPathRequestHandler parentPathHandler;
    private ObjectArray allParentPaths;
    private Object[] tmpPathArray;
    private Node[] tmpNodeArray;
    private Matrix4f transform;
    private Matrix4f invertedTransform;
    private Transform3D parent;
    private Point3f posTmp;
    private Point3f eyepos;
    private Vector3f eyevec;
    private Vector3f right;
    private MatrixUtils matrixUtils;
    private Vector3f up;
    private Vector3f z;
    private Vector3f ax;
    private Point3f bbpos;
    private Vector3f vpos;
    private Vector3f arcp;
    private Vector3f cp;
    private Vector3f cp2;
    private AxisAngle4f aa;

    public J3DBillboard() {
        super("Billboard");
        this.init();
    }

    public J3DBillboard(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("axisOfRotation");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxisOfRotation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAxisOfRotation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAxisOfRotation[2] = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
        this.init();
    }

    public void visibilityStateChange(boolean bl, Point3d point3d, AxisAngle4d axisAngle4d, Transform3D transform3D) {
    }

    public void viewPositionChanged(Point3d point3d, AxisAngle4d axisAngle4d, Transform3D transform3D) {
        this.j3dImplGroup.getLocalToVworld(this.getSceneGraphPath(), this.parent);
        this.ax.x = this.axis.x;
        this.ax.y = this.axis.y;
        this.ax.z = this.axis.z;
        float f = this.ax.lengthSquared();
        boolean bl = (double)f <= 0.001;
        this.bbpos.x = 0.0f;
        this.bbpos.y = 0.0f;
        this.bbpos.z = 0.0f;
        this.parent.transform(this.bbpos);
        this.vpos.x = (float)(point3d.x - (double)this.bbpos.x);
        this.vpos.y = (float)(point3d.y - (double)this.bbpos.y);
        this.vpos.z = (float)(point3d.z - (double)this.bbpos.z);
        this.vpos.normalize();
        if (bl) {
            this.ax.x = (float)axisAngle4d.x;
            this.ax.y = (float)axisAngle4d.y;
            this.ax.z = (float)axisAngle4d.z;
        }
        this.parent.transform(Z_UP, this.up);
        this.arcp.cross(this.ax, this.up);
        if ((double)this.arcp.lengthSquared() < 0.001) {
            this.transform.setIdentity();
        }
        if ((double)this.ax.lengthSquared() < 0.001) {
            this.transform.setIdentity();
        }
        this.ax.normalize();
        this.cp.cross(this.vpos, this.ax);
        if ((double)this.cp.length() < 1.0E-7) {
            this.aa.x = this.ax.x;
            this.aa.y = this.ax.y;
            this.aa.z = this.ax.z;
            this.aa.angle = (float)(-axisAngle4d.angle);
            this.transform.setIdentity();
            this.transform.setRotation(this.aa);
            this.transform.setIdentity();
            this.transform.setRotation(this.aa);
            this.implTransform.set(this.transform);
            this.childTrans.setTransform(this.implTransform);
            return;
        }
        this.cp.normalize();
        this.cp2.cross(this.cp, this.up);
        double d = this.cp.dot(this.up);
        double d2 = this.cp2.length();
        double d3 = this.cp.dot(this.arcp) > 0.0f ? -1.0 : 1.0;
        float f2 = (float)Math.atan2(d, d3 * d2);
        this.aa.x = this.ax.x;
        this.aa.y = this.ax.y;
        this.aa.z = this.ax.z;
        this.aa.angle = f2;
        this.transform.setIdentity();
        this.transform.setRotation(this.aa);
        this.implTransform.set(this.transform);
        this.childTrans.setTransform(this.implTransform);
    }

    public void viewPositionChanged2(Point3d point3d, Vector3d vector3d, Transform3D transform3D) {
        this.j3dImplGroup.getLocalToVworld(this.getSceneGraphPath(), this.parent);
        double d = this.axis.lengthSquared();
        if (d <= 1.0E-4) {
            this.parent.transform(ORIGIN, this.eyepos);
            this.parent.transform(Y_UP, this.eyevec);
            this.posTmp.set((Tuple3d)point3d);
            this.matrixUtils.lookAt(this.eyepos, this.posTmp, this.eyevec, this.invertedTransform);
            this.matrixUtils.inverse(this.invertedTransform, this.transform);
            this.implTransform.set(this.transform);
        } else {
            this.right.set((Tuple3d)vector3d);
            this.parent.transform(this.right, this.eyevec);
            this.right.cross(this.eyevec, this.axis);
            this.right.normalize();
            this.eyevec.cross(this.right, this.axis);
            this.transform.m00 = this.right.x;
            this.transform.m01 = this.axis.x;
            this.transform.m02 = this.eyevec.x;
            this.transform.m03 = 0.0f;
            this.transform.m10 = this.right.y;
            this.transform.m11 = this.axis.y;
            this.transform.m12 = this.eyevec.y;
            this.transform.m13 = 0.0f;
            this.transform.m20 = this.right.z;
            this.transform.m21 = this.axis.z;
            this.transform.m22 = this.eyevec.z;
            this.transform.m23 = 0.0f;
            this.transform.m30 = 0.0f;
            this.transform.m31 = 0.0f;
            this.transform.m32 = 0.0f;
            this.transform.m33 = 1.0f;
            this.matrixUtils.inverse(this.transform, this.invertedTransform);
            this.implTransform.set(this.transform);
        }
        this.childTrans.setTransform(this.implTransform);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.axis.set(this.vfAxisOfRotation[0], this.vfAxisOfRotation[1], this.vfAxisOfRotation[2]);
        this.implGroup.setPickable(true);
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        this.childTrans.setCapability(18);
        if (bl) {
            return;
        }
        this.implTrans.setCapability(18);
        this.implGroup.setCapability(17);
        this.implGroup.setCapability(13);
        this.implGroup.setCapability(14);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 22;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.fieldData.clear();
                this.fieldData.numElements = 1;
                this.fieldData.dataType = (short)11;
                this.fieldData.floatArrayValue = this.vfAxisOfRotation;
                break;
            }
            default: {
                return super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfAxisOfRotation, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.vfAxisOfRotation[0] = fArray[0];
                this.vfAxisOfRotation[1] = fArray[1];
                this.vfAxisOfRotation[2] = fArray[2];
                if (this.inSetup) break;
                this.axis.set(this.vfAxisOfRotation[0], this.vfAxisOfRotation[1], this.vfAxisOfRotation[2]);
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public boolean hasScenePathChanged() {
        if (this.parentPathHandler == null) {
            return true;
        }
        return this.parentPathHandler.hasParentPathChanged();
    }

    public SceneGraphPath getSceneGraphPath() {
        ObjectArray objectArray;
        if (this.parentPathHandler == null) {
            if (this.allParentPaths.size() == 0) {
                return null;
            }
            this.parentPathHandler = (J3DParentPathRequestHandler)this.allParentPaths.get(0);
        }
        if ((objectArray = this.parentPathHandler.getParentPath(this)) == null) {
            return null;
        }
        int n = objectArray.size();
        if (this.tmpPathArray == null || this.tmpPathArray.length < n) {
            this.tmpPathArray = new Object[n];
            this.tmpNodeArray = new Node[n - 1];
        }
        objectArray.toArray(this.tmpPathArray);
        Locale locale = (Locale)this.tmpPathArray[0];
        for (int i = 1; i < n; ++i) {
            this.tmpNodeArray[i - 1] = (Node)this.tmpPathArray[i];
        }
        return new SceneGraphPath(locale, this.tmpNodeArray, (Node)this.j3dImplGroup);
    }

    public void addParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.add((Object)j3DParentPathRequestHandler);
    }

    public void removeParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.remove((Object)j3DParentPathRequestHandler);
        if (this.parentPathHandler == j3DParentPathRequestHandler) {
            this.parentPathHandler = null;
        }
    }

    private void init() {
        this.allParentPaths = new ObjectArray();
        this.implTransform = new Transform3D();
        this.parent = new Transform3D();
        this.transform = new Matrix4f();
        this.invertedTransform = new Matrix4f();
        this.eyepos = new Point3f();
        this.posTmp = new Point3f();
        this.axis = new Vector3f();
        this.eyevec = new Vector3f();
        this.right = new Vector3f(0.0f, 0.0f, 1.0f);
        this.up = new Vector3f();
        this.z = new Vector3f();
        this.ax = new Vector3f();
        this.bbpos = new Point3f();
        this.vpos = new Vector3f();
        this.arcp = new Vector3f();
        this.cp = new Vector3f();
        this.cp2 = new Vector3f();
        this.aa = new AxisAngle4f();
        this.hasChanged = new boolean[7];
        this.vfAxisOfRotation = new float[]{0.0f, 1.0f, 0.0f};
        this.transform.setIdentity();
        this.invertedTransform.setIdentity();
        this.matrixUtils = new MatrixUtils();
        J3DUserData j3DUserData = new J3DUserData();
        j3DUserData.collidable = false;
        j3DUserData.isTerrain = false;
        j3DUserData.visibilityListener = this;
        this.shape = new Shape3D();
        this.shape.setAppearance(J3DGlobalStatus.invisibleAppearance);
        this.shape.setGeometry((Geometry)J3DGlobalStatus.boxGeometry);
        this.shape.setUserData((Object)j3DUserData);
        this.implTrans = new TransformGroup();
        this.implTrans.setCapability(17);
        this.implTrans.addChild((Node)this.shape);
        this.childTrans = new TransformGroup();
        this.implGroup = this.childTrans;
        this.implGroup.addChild((Node)this.implTrans);
    }

    static {
        nodeFields = new int[]{1};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(14);
        J3DBillboard.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        J3DBillboard.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        J3DBillboard.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        J3DBillboard.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        J3DBillboard.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        J3DBillboard.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "axisOfRotation");
        Integer n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(6);
        fieldMap.put("axisOfRotation", n);
        fieldMap.put("set_axisOfRotation", n);
        fieldMap.put("axisOfRotation_changed", n);
        fieldMap.put("addChildren", new Integer(2));
        fieldMap.put("removeChildren", new Integer(3));
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
    }
}

