/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.navigation;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLViewDependentNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DGlobalStatus;
import org.web3d.vrml.renderer.j3d.nodes.J3DGroupingNode;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;
import org.web3d.vrml.renderer.j3d.nodes.J3DVisibilityListener;

public class J3DLOD
extends J3DGroupingNode
implements VRMLViewDependentNodeType,
J3DVisibilityListener {
    private static final Point3d ORIGIN;
    private static final int FIELD_CENTER = 6;
    private static final int FIELD_RANGE = 7;
    protected static final int FIELD_LEVEL_CHANGED = 8;
    protected static final int FIELD_FORCE_TRANSITIONS = 9;
    private static final int LAST_LOD_INDEX = 9;
    private static final int NUM_FIELDS = 10;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private float[] vfCenter;
    private float[] vfRange;
    private int rangeLen;
    private float[] rangeSquared;
    private Switch implSwitch;
    private Group implRoot;
    private TransformGroup implTrans;
    private Shape3D shape;
    private int activeObject;
    private BitSet viewableChild;
    private Vector3d translation;
    private Vector3d temp;
    protected boolean vfForceTransitions;
    protected int vfLevelChanged;
    static /* synthetic */ Class class$javax$media$j3d$BranchGroup;
    static /* synthetic */ Class class$javax$media$j3d$TransformGroup;
    static /* synthetic */ Class class$javax$media$j3d$Shape3D;
    static /* synthetic */ Class class$javax$media$j3d$Group;

    public J3DLOD() {
        super("LOD");
        this.hasChanged = new boolean[10];
        this.vfCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfRange = new float[3];
        this.rangeSquared = new float[3];
        this.rangeLen = 0;
        this.activeObject = 0;
        this.init();
    }

    public J3DLOD(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("center");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("range");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements > this.rangeLen) {
                this.vfRange = new float[vRMLFieldData.numElements];
                this.rangeSquared = new float[vRMLFieldData.numElements];
            }
            this.rangeLen = vRMLFieldData.numElements;
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfRange, 0, this.rangeLen);
            for (int i = 0; i < this.rangeLen; ++i) {
                this.rangeSquared[i] = this.vfRange[i] * this.vfRange[i];
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void visibilityStateChange(boolean bl, Point3d point3d, AxisAngle4d axisAngle4d, Transform3D transform3D) {
        if (!bl) {
            this.implSwitch.setWhichChild(-1);
            for (int i = 0; i < this.rangeLen; ++i) {
                this.viewableChild.clear(i);
            }
        } else {
            transform3D.get(this.translation);
            this.translation.sub((Tuple3d)point3d);
            double d = this.translation.lengthSquared();
            int n = this.activeObject;
            this.activeObject = this.rangeLen;
            for (int i = 0; i < this.rangeLen; ++i) {
                if (!(d <= (double)this.rangeSquared[i])) continue;
                this.activeObject = i;
                break;
            }
            if (n != this.activeObject) {
                this.viewableChild.clear(n);
                this.viewableChild.set(this.activeObject);
                this.implSwitch.setWhichChild(-3);
                this.implSwitch.setChildMask(this.viewableChild);
                this.setLevelChanged(this.activeObject);
            }
        }
    }

    public void viewPositionChanged(Point3d point3d, AxisAngle4d axisAngle4d, Transform3D transform3D) {
        transform3D.get(this.translation);
        this.translation.sub((Tuple3d)point3d);
        double d = this.translation.lengthSquared();
        int n = this.rangeLen;
        for (int i = 0; i < this.rangeLen; ++i) {
            if (!(d <= (double)this.rangeSquared[i])) continue;
            n = i;
            break;
        }
        if (n != this.activeObject) {
            this.viewableChild.clear(this.activeObject);
            this.viewableChild.set(n);
            this.implSwitch.setWhichChild(-3);
            this.implSwitch.setChildMask(this.viewableChild);
            this.activeObject = n;
            this.setLevelChanged(this.activeObject);
        }
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null && map.containsKey(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DLOD.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup)) {
            nArray = (int[])map.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DLOD.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implGroup.clearCapability(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.implGroup.clearCapability(17);
                this.implGroup.clearCapability(6);
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        if (map2.containsKey(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DLOD.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup)) {
            nArray = (int[])map2.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DLOD.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
            int n4 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implGroup.clearCapabilityIsFrequent(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.implGroup.clearCapabilityIsFrequent(17);
                this.implGroup.clearCapabilityIsFrequent(6);
            }
        }
        if (map2.containsKey(class$javax$media$j3d$TransformGroup == null ? (class$javax$media$j3d$TransformGroup = J3DLOD.class$("javax.media.j3d.TransformGroup")) : class$javax$media$j3d$TransformGroup)) {
            nArray = (int[])map2.get(class$javax$media$j3d$TransformGroup == null ? (class$javax$media$j3d$TransformGroup = J3DLOD.class$("javax.media.j3d.TransformGroup")) : class$javax$media$j3d$TransformGroup);
            int n5 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implGroup.clearCapabilityIsFrequent(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.implTrans.clearCapabilityIsFrequent(18);
            }
        }
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null) {
            nArray = (int[])map.get(class$javax$media$j3d$Shape3D == null ? (class$javax$media$j3d$Shape3D = J3DLOD.class$("javax.media.j3d.Shape3D")) : class$javax$media$j3d$Shape3D);
            n2 = nArray == null ? 0 : nArray.length;
            for (n = 0; n < n2; ++n) {
                this.shape.setCapability(nArray[n]);
            }
            nArray = (int[])map.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DLOD.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
            n2 = nArray == null ? 0 : nArray.length;
            for (n = 0; n < n2; ++n) {
                this.implGroup.setCapability(nArray[n]);
            }
            nArray = (int[])map.get(class$javax$media$j3d$TransformGroup == null ? (class$javax$media$j3d$TransformGroup = J3DLOD.class$("javax.media.j3d.TransformGroup")) : class$javax$media$j3d$TransformGroup);
            n2 = nArray == null ? 0 : nArray.length;
            for (n = 0; n < n2; ++n) {
                this.implTrans.setCapability(nArray[n]);
            }
            nArray = (int[])map.get(class$javax$media$j3d$Group == null ? (class$javax$media$j3d$Group = J3DLOD.class$("javax.media.j3d.Group")) : class$javax$media$j3d$Group);
            n2 = nArray == null ? 0 : nArray.length;
            for (n = 0; n < n2; ++n) {
                this.implRoot.setCapability(nArray[n]);
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        nArray = (int[])map2.get(class$javax$media$j3d$Shape3D == null ? (class$javax$media$j3d$Shape3D = J3DLOD.class$("javax.media.j3d.Shape3D")) : class$javax$media$j3d$Shape3D);
        n2 = nArray == null ? 0 : nArray.length;
        for (n = 0; n < n2; ++n) {
            this.shape.setCapabilityIsFrequent(nArray[n]);
        }
        nArray = (int[])map2.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DLOD.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
        n2 = nArray == null ? 0 : nArray.length;
        for (n = 0; n < n2; ++n) {
            this.implGroup.setCapabilityIsFrequent(nArray[n]);
        }
        nArray = (int[])map2.get(class$javax$media$j3d$TransformGroup == null ? (class$javax$media$j3d$TransformGroup = J3DLOD.class$("javax.media.j3d.TransformGroup")) : class$javax$media$j3d$TransformGroup);
        n2 = nArray == null ? 0 : nArray.length;
        for (n = 0; n < n2; ++n) {
            this.implTrans.setCapabilityIsFrequent(nArray[n]);
        }
        nArray = (int[])map2.get(class$javax$media$j3d$Group == null ? (class$javax$media$j3d$Group = J3DLOD.class$("javax.media.j3d.Group")) : class$javax$media$j3d$Group);
        n2 = nArray == null ? 0 : nArray.length;
        for (n = 0; n < n2; ++n) {
            this.implRoot.setCapabilityIsFrequent(nArray[n]);
        }
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        if (bl) {
            return;
        }
        this.implSwitch.setCapability(18);
        this.implSwitch.setCapability(13);
        this.implSwitch.setCapability(14);
        this.implRoot.setCapability(13);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        float f = this.rangeLen == 0 ? 0.0f : this.vfRange[this.rangeLen - 1] * 2.0f;
        Vector3d vector3d = new Vector3d((double)f, (double)f, (double)f);
        Vector3d vector3d2 = new Vector3d((double)this.vfCenter[0], (double)this.vfCenter[1], (double)this.vfCenter[2]);
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(vector3d);
        transform3D.setTranslation(vector3d2);
        this.implTrans.setTransform(transform3D);
        this.activeObject = this.rangeLen;
        this.viewableChild = new BitSet(this.rangeLen);
        if (this.activeObject < 0) {
            this.implSwitch.setWhichChild(-1);
        } else {
            this.viewableChild.set(this.activeObject);
            this.implSwitch.setChildMask(this.viewableChild);
        }
        this.j3dImplGroup.addChild((Node)this.implRoot);
    }

    public int getFieldIndex(String string) {
        int n;
        Integer n2 = (Integer)fieldMap.get(string);
        int n3 = n = n2 == null ? -1 : n2;
        if ((n == 9 || n == 8) && (this.vrmlMajorVersion == 2 || this.vrmlMajorVersion == 3 && this.vrmlMinorVersion == 0)) {
            n = -1;
        }
        return n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 9) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfCenter;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfRange;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.rangeLen;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfLevelChanged;
                this.fieldData.dataType = (short)2;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfCenter, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfRange, this.rangeLen);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfLevelChanged);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setCenter(fArray);
                break;
            }
            case 7: {
                this.setRange(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setLevelChanged(int n) {
        this.vfLevelChanged = n;
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    private void setCenter(float[] fArray) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldValueException("Center is an initialize-only field");
        }
        if (fArray == null) {
            throw new InvalidFieldValueException("Center value null");
        }
        this.vfCenter[0] = fArray[0];
        this.vfCenter[1] = fArray[1];
        this.vfCenter[2] = fArray[2];
        this.translation = new Vector3d((double)this.vfCenter[0], (double)this.vfCenter[1], (double)this.vfCenter[2]);
    }

    private void setRange(float[] fArray, int n) throws InvalidFieldValueException, InvalidFieldAccessException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("Range is an initialize-only field");
        }
        this.rangeLen = n;
        if (n != 0) {
            int n2 = fArray.length;
            while (--n2 >= 0) {
                if (!(fArray[n2] < 0.0f)) continue;
                throw new InvalidFieldValueException("Negative range value " + fArray[n2]);
            }
            if (n > this.vfRange.length) {
                this.vfRange = new float[n];
                this.rangeSquared = new float[n];
            }
            this.rangeLen = n;
            for (n2 = 0; n2 < this.rangeLen; ++n2) {
                this.vfRange[n2] = fArray[n2];
                this.rangeSquared[n2] = this.vfRange[n2] * this.vfRange[n2];
            }
        }
    }

    private void init() {
        this.translation = new Vector3d();
        J3DUserData j3DUserData = new J3DUserData();
        j3DUserData.collidable = false;
        j3DUserData.isTerrain = false;
        j3DUserData.visibilityListener = this;
        this.shape = new Shape3D();
        this.shape.setAppearance(J3DGlobalStatus.invisibleAppearance);
        this.shape.setGeometry((Geometry)J3DGlobalStatus.sphereGeometry);
        this.shape.setUserData((Object)j3DUserData);
        this.implTrans = new TransformGroup();
        this.implTrans.addChild((Node)this.shape);
        this.implSwitch = new Switch(-3);
        this.implGroup = this.implSwitch;
        this.implRoot = new Group();
        this.implRoot.addChild((Node)this.implGroup);
        this.implRoot.addChild((Node)this.implTrans);
        this.temp = new Vector3d();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nodeFields = new int[]{1};
        fieldDecl = new VRMLFieldDeclaration[10];
        fieldMap = new HashMap(10);
        J3DLOD.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        J3DLOD.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        J3DLOD.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        J3DLOD.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFVec3f", "center");
        J3DLOD.fieldDecl[7] = new VRMLFieldDeclaration(2, "MFFloat", "range");
        J3DLOD.fieldDecl[9] = new VRMLFieldDeclaration(2, "SFBool", "forceTransitions");
        J3DLOD.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFInt32", "level_changed");
        Integer n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        fieldMap.put("level", n);
        fieldMap.put("set_level", n);
        fieldMap.put("level_changed", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        fieldMap.put("center", new Integer(6));
        fieldMap.put("range", new Integer(7));
        fieldMap.put("level_changed", new Integer(8));
        fieldMap.put("forceTransitions", new Integer(9));
        ORIGIN = new Point3d();
    }
}

