/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.navigation;

import java.util.Map;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3f;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.navigation.BaseViewpoint;
import org.web3d.vrml.renderer.j3d.nodes.J3DGlobalStatus;
import org.web3d.vrml.renderer.j3d.nodes.J3DParentPathRequestHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DPathAwareNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DViewpointNodeType;

public class J3DViewpoint
extends BaseViewpoint
implements J3DViewpointNodeType,
J3DPathAwareNodeType {
    private TransformGroup transform;
    private Group j3dImplNode;
    private J3DParentPathRequestHandler parentPathHandler;
    private ObjectArray allParentPaths;
    private AxisAngle4f axis;
    private Vector3f trans;
    private Transform3D implTrans;
    private Object[] tmpPathArray;
    private Node[] tmpNodeArray;
    static /* synthetic */ Class class$javax$media$j3d$TransformGroup;
    static /* synthetic */ Class class$javax$media$j3d$BranchGroup;

    public J3DViewpoint() {
        this.init();
    }

    public J3DViewpoint(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public boolean hasScenePathChanged() {
        if (this.parentPathHandler == null) {
            return true;
        }
        return this.parentPathHandler.hasParentPathChanged();
    }

    public SceneGraphPath getSceneGraphPath() {
        ObjectArray objectArray;
        if (this.parentPathHandler == null) {
            if (this.allParentPaths.size() == 0) {
                return null;
            }
            this.parentPathHandler = (J3DParentPathRequestHandler)this.allParentPaths.get(0);
        }
        if ((objectArray = this.parentPathHandler.getParentPath(this)) == null) {
            return null;
        }
        int n = objectArray.size();
        if (this.tmpPathArray == null || this.tmpPathArray.length < n) {
            this.tmpPathArray = new Object[n];
            this.tmpNodeArray = new Node[n - 1];
        }
        objectArray.toArray(this.tmpPathArray);
        Locale locale = (Locale)this.tmpPathArray[0];
        for (int i = 1; i < n; ++i) {
            this.tmpNodeArray[i - 1] = (Node)this.tmpPathArray[i];
        }
        return new SceneGraphPath(locale, this.tmpNodeArray, (Node)this.transform);
    }

    public Transform3D getViewTransform() {
        return this.implTrans;
    }

    public TransformGroup getPlatformGroup() {
        return this.transform;
    }

    public void addParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.add((Object)j3DParentPathRequestHandler);
    }

    public void removeParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.remove((Object)j3DParentPathRequestHandler);
        if (this.parentPathHandler == j3DParentPathRequestHandler) {
            this.parentPathHandler = null;
        }
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null) {
            if (map.containsKey(class$javax$media$j3d$TransformGroup == null ? (class$javax$media$j3d$TransformGroup = J3DViewpoint.class$("javax.media.j3d.TransformGroup")) : class$javax$media$j3d$TransformGroup)) {
                nArray = (int[])map.get(class$javax$media$j3d$TransformGroup == null ? (class$javax$media$j3d$TransformGroup = J3DViewpoint.class$("javax.media.j3d.TransformGroup")) : class$javax$media$j3d$TransformGroup);
                int n3 = n2 = nArray == null ? 0 : nArray.length;
                if (n2 != 0) {
                    for (n = 0; n < n2; ++n) {
                        this.transform.clearCapability(nArray[n]);
                    }
                } else if (!this.isStatic) {
                    this.transform.clearCapability(17);
                    this.transform.clearCapability(18);
                    this.transform.clearCapability(11);
                    this.transform.clearCapability(14);
                    this.transform.clearCapability(13);
                }
            }
            if (map.containsKey(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DViewpoint.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup)) {
                nArray = (int[])map.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DViewpoint.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
                int n4 = n2 = nArray == null ? 0 : nArray.length;
                if (n2 != 0) {
                    for (n = 0; n < n2; ++n) {
                        this.j3dImplNode.clearCapability(nArray[n]);
                    }
                } else if (!this.isStatic) {
                    this.j3dImplNode.clearCapability(17);
                }
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        if (map2.containsKey(class$javax$media$j3d$TransformGroup == null ? (class$javax$media$j3d$TransformGroup = J3DViewpoint.class$("javax.media.j3d.TransformGroup")) : class$javax$media$j3d$TransformGroup)) {
            nArray = (int[])map2.get(class$javax$media$j3d$TransformGroup == null ? (class$javax$media$j3d$TransformGroup = J3DViewpoint.class$("javax.media.j3d.TransformGroup")) : class$javax$media$j3d$TransformGroup);
            int n5 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.transform.clearCapabilityIsFrequent(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.transform.clearCapabilityIsFrequent(17);
                this.transform.clearCapabilityIsFrequent(18);
                this.transform.clearCapabilityIsFrequent(11);
                this.transform.clearCapabilityIsFrequent(14);
                this.transform.clearCapabilityIsFrequent(13);
            }
        }
        if (map2.containsKey(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DViewpoint.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup)) {
            nArray = (int[])map2.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DViewpoint.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
            int n6 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.j3dImplNode.clearCapabilityIsFrequent(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.j3dImplNode.clearCapabilityIsFrequent(17);
            }
        }
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null) {
            nArray = (int[])map.get(class$javax$media$j3d$TransformGroup == null ? (class$javax$media$j3d$TransformGroup = J3DViewpoint.class$("javax.media.j3d.TransformGroup")) : class$javax$media$j3d$TransformGroup);
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.transform.setCapability(nArray[n]);
                }
            }
            nArray = (int[])map.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DViewpoint.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
            int n4 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.j3dImplNode.setCapability(nArray[n]);
                }
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        nArray = (int[])map2.get(class$javax$media$j3d$TransformGroup == null ? (class$javax$media$j3d$TransformGroup = J3DViewpoint.class$("javax.media.j3d.TransformGroup")) : class$javax$media$j3d$TransformGroup);
        int n5 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.transform.setCapabilityIsFrequent(nArray[n]);
            }
        }
        nArray = (int[])map2.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DViewpoint.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
        int n6 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.j3dImplNode.setCapabilityIsFrequent(nArray[n]);
            }
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.j3dImplNode;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.updateViewTrans();
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        if (bl) {
            return;
        }
        this.transform.setCapability(17);
        this.transform.setCapability(18);
        this.transform.setCapability(11);
        this.transform.setCapability(14);
        this.transform.setCapability(13);
        this.j3dImplNode.setCapability(17);
    }

    protected void setPosition(float[] fArray) {
        super.setPosition(fArray);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    protected void setOrientation(float[] fArray) {
        super.setOrientation(fArray);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void allEventsComplete() {
        this.updateViewTrans();
    }

    private void updateViewTrans() {
        this.axis.x = this.vfOrientation[0];
        this.axis.y = this.vfOrientation[1];
        this.axis.z = this.vfOrientation[2];
        double d = this.axis.x * this.axis.x + this.axis.y * this.axis.y + this.axis.z * this.axis.z;
        if (d < 1.0E-6) {
            this.axis.x = 0.0f;
            this.axis.y = 1.0f;
            this.axis.z = 0.0f;
        } else {
            d = 1.0 / Math.sqrt(d);
            this.axis.x = (float)((double)this.axis.x * d);
            this.axis.y = (float)((double)this.axis.y * d);
            this.axis.z = (float)((double)this.axis.z * d);
        }
        this.axis.angle = (float)Math.IEEEremainder(this.vfOrientation[3], Math.PI * 2);
        this.implTrans.setIdentity();
        this.implTrans.set(this.axis);
        this.trans.x = this.vfPosition[0];
        this.trans.y = this.vfPosition[1];
        this.trans.z = this.vfPosition[2];
        this.implTrans.setTranslation(this.trans);
        if ((this.implTrans.getType() & 0x40) != 0) {
            this.transform.setTransform(this.implTrans);
        } else {
            System.out.println("Trying to set non-congruent viewpoint for viewpoint '" + this.vfDescription + "'");
        }
    }

    private void init() {
        this.allParentPaths = new ObjectArray();
        this.transform = new TransformGroup();
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)this.transform);
        this.j3dImplNode = branchGroup;
        this.axis = new AxisAngle4f();
        this.trans = new Vector3f();
        this.implTrans = new Transform3D();
        this.implTrans.setIdentity();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

