/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.networking;

import java.util.HashMap;
import javax.media.j3d.BranchGroup;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLLinkNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DGroupingNode;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;
import org.web3d.vrml.util.URLChecker;

public class J3DAnchor
extends J3DGroupingNode
implements VRMLLinkNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{28};
    private static final int FIELD_DESCRIPTION = 6;
    private static final int FIELD_PARAMETER = 7;
    private static final int FIELD_URL = 8;
    private static final int LAST_ANCHOR_INDEX = 8;
    private static final int NUM_FIELDS = 9;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private String[] vfUrl;
    private String worldURL;
    private boolean urlRelativeCheck;
    private String[] vfParameter;
    private String vfDescription;

    public J3DAnchor() {
        super("Anchor");
        this.hasChanged = new boolean[9];
        this.vfUrl = FieldConstants.EMPTY_MFSTRING;
        this.implGroup = new BranchGroup();
    }

    public J3DAnchor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("description");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDescription = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("parameter");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfParameter = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfParameter, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfUrl, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public String getDescription() {
        return this.vfDescription;
    }

    public void setDescription(String string) {
        this.vfDescription = string;
        this.hasChanged[6] = true;
        this.fireFieldChanged(6);
    }

    public String[] getParameter() {
        return this.vfParameter;
    }

    public void setParameter(String[] stringArray) {
        this.vfParameter = stringArray;
        this.hasChanged[7] = true;
        this.fireFieldChanged(7);
    }

    public void setUrl(String[] stringArray, int n) {
        this.vfUrl = this.worldURL != null ? URLChecker.checkURLs((String)this.worldURL, (String[])stringArray, (boolean)true) : stringArray;
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public String[] getUrl() {
        return this.vfUrl;
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        if (this.vfUrl != null) {
            this.vfUrl = URLChecker.checkURLs((String)this.worldURL, (String[])this.vfUrl, (boolean)true);
        }
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.inSetup = false;
        J3DUserData j3DUserData = new J3DUserData();
        j3DUserData.linkReference = this;
        this.j3dImplGroup.setUserData((Object)j3DUserData);
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        if (bl) {
            return;
        }
        this.implGroup.setCapability(17);
        this.implGroup.setCapability(13);
        this.implGroup.setCapability(14);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfDescription;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfParameter;
                this.fieldData.dataType = (short)14;
                if (this.vfParameter == null) break;
                this.fieldData.numElements = this.vfParameter.length;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfUrl;
                this.fieldData.dataType = (short)14;
                if (this.vfUrl == null) break;
                this.fieldData.numElements = this.vfUrl.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfUrl, this.vfUrl.length);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfParameter, this.vfParameter.length);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfDescription);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.vfDescription = string;
                if (this.inSetup) break;
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 8: {
                this.setUrl(stringArray, n2);
                break;
            }
            case 7: {
                this.vfParameter = stringArray;
                if (this.inSetup) break;
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{1};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(9);
        J3DAnchor.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        J3DAnchor.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        J3DAnchor.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        J3DAnchor.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        J3DAnchor.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        J3DAnchor.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFString", "description");
        J3DAnchor.fieldDecl[7] = new VRMLFieldDeclaration(3, "MFString", "parameter");
        J3DAnchor.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFString", "url");
        Integer n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        fieldMap.put("addChildren", new Integer(2));
        fieldMap.put("removeChildren", new Integer(3));
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("description", n);
        fieldMap.put("set_description", n);
        fieldMap.put("description_changed", n);
        n = new Integer(7);
        fieldMap.put("parameter", n);
        fieldMap.put("set_parameter", n);
        fieldMap.put("parameter_changed", n);
        n = new Integer(8);
        fieldMap.put("url", n);
        fieldMap.put("set_url", n);
        fieldMap.put("url_changed", n);
    }
}

