/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.networking;

import java.util.Map;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.networking.BaseInline;
import org.web3d.vrml.renderer.j3d.nodes.J3DParentPathRequestHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DPathAwareNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;

public class J3DInline
extends BaseInline
implements J3DVRMLNode,
J3DParentPathRequestHandler,
J3DPathAwareNodeType {
    private J3DParentPathRequestHandler parentPathHandler;
    private ObjectArray allParentPaths;
    private BranchGroup j3dContentImpl;
    private SharedGroup j3dImpl;
    private static SharedGroup outlineBoxImpl;
    private BranchGroup boxGroup;

    public J3DInline() {
        this.init();
    }

    public J3DInline(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public boolean hasParentPathChanged() {
        if (this.parentPathHandler == null) {
            return true;
        }
        return this.parentPathHandler.hasParentPathChanged();
    }

    public ObjectArray getParentPath(J3DVRMLNode j3DVRMLNode) {
        if (this.parentPathHandler == null) {
            if (this.allParentPaths.size() == 0) {
                return null;
            }
            this.parentPathHandler = (J3DParentPathRequestHandler)this.allParentPaths.get(0);
        }
        ObjectArray objectArray = this.parentPathHandler.getParentPath(this);
        return objectArray;
    }

    public void addParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.add((Object)j3DParentPathRequestHandler);
    }

    public void removeParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.remove((Object)j3DParentPathRequestHandler);
        if (this.parentPathHandler == j3DParentPathRequestHandler) {
            this.parentPathHandler = null;
        }
    }

    public void allEventsComplete() {
        J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.scene.getRootNode();
        if (j3DVRMLNode instanceof J3DPathAwareNodeType) {
            ((J3DPathAwareNodeType)((Object)j3DVRMLNode)).addParentPathListener(this);
        }
        BranchGroup branchGroup = (BranchGroup)j3DVRMLNode.getSceneGraphObject();
        this.boxGroup.detach();
        this.j3dContentImpl.addChild((Node)branchGroup);
    }

    public void setUrl(String[] stringArray, int n) {
        super.setUrl(stringArray, n);
        if (!this.inSetup) {
            J3DVRMLNode j3DVRMLNode = (J3DVRMLNode)this.scene.getRootNode();
            if (j3DVRMLNode instanceof J3DPathAwareNodeType) {
                ((J3DPathAwareNodeType)((Object)j3DVRMLNode)).removeParentPathListener(this);
            }
            this.j3dContentImpl.setChild((Node)this.boxGroup, 0);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.j3dImpl;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        Link link = new Link(outlineBoxImpl);
        Transform3D transform3D = new Transform3D();
        Vector3f vector3f = new Vector3f(this.vfBboxCenter);
        Vector3d vector3d = this.vfBboxSize[0] != -1.0f ? new Vector3d((double)this.vfBboxSize[0], (double)this.vfBboxSize[1], (double)this.vfBboxSize[2]) : new Vector3d(1.0, 1.0, 1.0);
        transform3D.setTranslation(vector3f);
        transform3D.setScale(vector3d);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)link);
        this.boxGroup = new BranchGroup();
        this.boxGroup.setCapability(17);
        this.boxGroup.setPickable(false);
        this.boxGroup.addChild((Node)transformGroup);
        this.j3dContentImpl.addChild((Node)this.boxGroup);
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        this.j3dContentImpl.setCapability(13);
        this.j3dContentImpl.setCapability(14);
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
        super.setContent(string, object);
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    protected void setLoad(boolean bl) throws InvalidFieldException {
        if (!this.inSetup && !bl) {
            this.j3dContentImpl.setChild((Node)this.boxGroup, 0);
        }
        super.setLoad(bl);
    }

    private void init() {
        this.allParentPaths = new ObjectArray();
        this.j3dContentImpl = new BranchGroup();
        this.j3dImpl = new SharedGroup();
        this.j3dImpl.addChild((Node)this.j3dContentImpl);
    }

    private static void createOutlineGeometry() {
        outlineBoxImpl = new SharedGroup();
        Shape3D shape3D = new Shape3D();
        J3DUserData j3DUserData = new J3DUserData();
        j3DUserData.collidable = false;
        j3DUserData.isTerrain = false;
        shape3D.setUserData((Object)j3DUserData);
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f};
        int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 0, 3, 7, 4, 5, 6, 2, 1, 5, 1, 0, 4, 3, 7, 6, 2};
        int[] nArray2 = new int[]{4, 4, 4, 4, 4, 4};
        int n = 1;
        IndexedLineStripArray indexedLineStripArray = new IndexedLineStripArray(8, n, 24, nArray2);
        indexedLineStripArray.setCoordinates(0, fArray);
        indexedLineStripArray.setCoordinateIndices(0, nArray);
        shape3D.addGeometry((Geometry)indexedLineStripArray);
        outlineBoxImpl.addChild((Node)shape3D);
    }

    static {
        J3DInline.createOutlineGeometry();
    }
}

