/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.nurbs;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TriangleStripArray;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.nurbs.BaseNurbsSurface;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DGlobalStatus;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;

public class J3DNurbsSurface
extends BaseNurbsSurface
implements J3DGeometryNodeType {
    private static final int[] TEX_SET_MAP = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] CHANGED_GEOM_INDEX = new int[]{0};
    private ArrayList listeners;
    private TriangleStripArray impl;
    private Geometry[] geomList;
    private int[] capReqdBits;
    private int[] freqReqdBits;
    private int maxVertexCount;
    static /* synthetic */ Class class$javax$media$j3d$TriangleStripArray;

    public J3DNurbsSurface() {
        this.init();
    }

    public J3DNurbsSurface(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        if (!this.regenerateSurface()) {
            System.err.println("Bad curve data. Surface removed");
            if (this.impl != null) {
                this.fireGeometryRemoved();
                this.impl = null;
                this.geomList[0] = null;
            }
        } else if (this.impl == null || this.maxVertexCount > this.geometryData.vertexCount) {
            this.generateGeometry();
            this.geomList[0] = this.impl;
            if (this.impl != null) {
                if (this.maxVertexCount > this.geometryData.vertexCount) {
                    this.fireGeometryChanged();
                } else {
                    this.fireGeometryAdded();
                }
            }
        } else {
            this.impl.setCoordinates(0, this.geometryData.coordinates);
        }
    }

    public Geometry[] getGeometry() {
        return this.geomList;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public void addGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.add(j3DGeometryListener);
    }

    public void removeGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || !this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.remove(j3DGeometryListener);
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        if (map != null && map.containsKey(class$javax$media$j3d$TriangleStripArray == null ? (class$javax$media$j3d$TriangleStripArray = J3DNurbsSurface.class$("javax.media.j3d.TriangleStripArray")) : class$javax$media$j3d$TriangleStripArray)) {
            this.capReqdBits = (int[])map.get(class$javax$media$j3d$TriangleStripArray == null ? (class$javax$media$j3d$TriangleStripArray = J3DNurbsSurface.class$("javax.media.j3d.TriangleStripArray")) : class$javax$media$j3d$TriangleStripArray);
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null || !map2.containsKey(class$javax$media$j3d$TriangleStripArray == null ? (class$javax$media$j3d$TriangleStripArray = J3DNurbsSurface.class$("javax.media.j3d.TriangleStripArray")) : class$javax$media$j3d$TriangleStripArray)) {
            return;
        }
        this.freqReqdBits = (int[])map2.get(class$javax$media$j3d$TriangleStripArray == null ? (class$javax$media$j3d$TriangleStripArray = J3DNurbsSurface.class$("javax.media.j3d.TriangleStripArray")) : class$javax$media$j3d$TriangleStripArray);
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.impl;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.inSetup = false;
        if (!this.regenerateSurface()) {
            return;
        }
        this.generateGeometry();
        this.geomList[0] = this.impl;
    }

    private void init() {
        this.listeners = new ArrayList();
        this.geomList = new Geometry[1];
    }

    private void generateGeometry() {
        int n;
        this.maxVertexCount = this.geometryData.vertexCount;
        int n2 = 35;
        this.impl = new TriangleStripArray(this.geometryData.vertexCount, n2, 1, TEX_SET_MAP, this.geometryData.stripCounts);
        this.impl.setCapability(20);
        this.impl.setCapability(1);
        this.impl.setCapability(5);
        this.impl.setCapability(7);
        this.impl.setCoordinates(0, this.geometryData.coordinates);
        this.impl.setNormals(0, this.geometryData.normals);
        this.impl.setTextureCoordinates(0, 0, this.geometryData.textureCoordinates);
        J3DUserData j3DUserData = new J3DUserData();
        j3DUserData.geometryData = this.geometryData;
        this.impl.setUserData((Object)j3DUserData);
        if (this.capReqdBits != null) {
            for (n = 0; n < this.capReqdBits.length; ++n) {
                this.impl.setCapability(this.capReqdBits[n]);
            }
        }
        if (J3DGlobalStatus.haveFreqBitsAPI && this.freqReqdBits != null) {
            for (n = 0; n < this.freqReqdBits.length; ++n) {
                this.impl.setCapabilityIsFrequent(this.freqReqdBits[n]);
            }
        }
    }

    protected void fireGeometryAdded() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryAdded(CHANGED_GEOM_INDEX);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry add message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void fireGeometryChanged() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryChanged(CHANGED_GEOM_INDEX);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry change message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void fireGeometryRemoved() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryRemoved(CHANGED_GEOM_INDEX);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry remove message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

