/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.picking;

import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SharedGroup;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.picking.BaseVolumePicker;
import org.web3d.vrml.renderer.j3d.nodes.J3DParentPathRequestHandler;
import org.web3d.vrml.renderer.j3d.nodes.J3DPathAwareNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DPickableTargetNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DPickingSensorNodeType;

public class J3DVolumePicker
extends BaseVolumePicker
implements J3DPickingSensorNodeType,
J3DPathAwareNodeType {
    private HashMap targetSet = new HashMap();
    private J3DParentPathRequestHandler parentPathHandler;
    private ObjectArray allParentPaths = new ObjectArray();
    private Object[] tmpPathArray;
    private Node[] tmpNodeArray;
    private SharedGroup impl;

    public J3DVolumePicker() {
    }

    public J3DVolumePicker(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void addParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.add((Object)j3DParentPathRequestHandler);
    }

    public void removeParentPathListener(J3DParentPathRequestHandler j3DParentPathRequestHandler) {
        this.allParentPaths.remove((Object)j3DParentPathRequestHandler);
        if (this.parentPathHandler == j3DParentPathRequestHandler) {
            this.parentPathHandler = null;
        }
    }

    public boolean hasScenePathChanged() {
        if (this.parentPathHandler == null) {
            return true;
        }
        return this.parentPathHandler.hasParentPathChanged();
    }

    public SceneGraphPath getSceneGraphPath() {
        ObjectArray objectArray;
        if (this.parentPathHandler == null) {
            if (this.allParentPaths.size() == 0) {
                return null;
            }
            this.parentPathHandler = (J3DParentPathRequestHandler)this.allParentPaths.get(0);
        }
        if ((objectArray = this.parentPathHandler.getParentPath(this)) == null || objectArray.size() < 2) {
            return null;
        }
        int n = objectArray.size();
        if (this.tmpPathArray == null || this.tmpPathArray.length < n) {
            this.tmpPathArray = new Object[n];
            this.tmpNodeArray = new Node[n - 1];
        }
        objectArray.toArray(this.tmpPathArray);
        Locale locale = (Locale)this.tmpPathArray[0];
        for (int i = 1; i < n; ++i) {
            this.tmpNodeArray[i - 1] = (Node)this.tmpPathArray[i];
        }
        return new SceneGraphPath(locale, this.tmpNodeArray, (Node)this.impl);
    }

    public Map getTargetGroups() {
        return this.targetSet;
    }

    public SceneGraphObject getSceneGraphObject() {
        if (this.impl == null) {
            this.impl = new SharedGroup();
            this.impl.setCapability(1);
            this.impl.setCapability(11);
            this.impl.setPickable(true);
        }
        return this.impl;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    protected void updateChildren(VRMLNodeType[] vRMLNodeTypeArray, int n) {
        this.targetSet.clear();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType;
            if (vRMLNodeTypeArray[i] instanceof VRMLProtoInstance) {
                vRMLNodeType = ((VRMLProtoInstance)vRMLNodeTypeArray[i]).getImplementationNode();
                if (vRMLNodeType instanceof VRMLProtoInstance) {
                    System.out.println("PROTO walk not implemented in J3DVolumePicker");
                }
                this.targetSet.put(((J3DPickableTargetNodeType)vRMLNodeType).getPickableGroup(), vRMLNodeTypeArray[i]);
                continue;
            }
            vRMLNodeType = vRMLNodeTypeArray[i];
            J3DPickableTargetNodeType j3DPickableTargetNodeType = (J3DPickableTargetNodeType)vRMLNodeType;
            this.targetSet.put(j3DPickableTargetNodeType.getPickableGroup(), vRMLNodeTypeArray[i]);
        }
    }
}

