/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.render;

import java.util.HashMap;
import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLNodeComponentListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.j3d.nodes.J3DIndexedGeometry;

public class J3DIndexedLineSet
extends J3DIndexedGeometry
implements VRMLComponentGeometryNodeType,
VRMLNodeComponentListener {
    private static final int NUM_FIELDS = 8;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private IndexedLineStripArray implGeom;

    public J3DIndexedLineSet() {
        super("IndexedLineSet");
        this.hasChanged = new boolean[8];
    }

    public J3DIndexedLineSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLComponentGeometryNodeType)vRMLNodeType);
    }

    public void allEventsComplete() {
        this.buildImpl();
    }

    public float getCreaseAngle() {
        return 0.0f;
    }

    public boolean hasColorPerVertex() {
        return this.vfColorPerVertex;
    }

    public boolean hasNormalPerVertex() {
        return true;
    }

    public Geometry[] getGeometry() {
        return new Geometry[]{this.implGeom};
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public boolean requiresUnlitColor() {
        return false;
    }

    public void setUnlitColor(float[] fArray) {
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 1: {
                int[] nArray = vRMLNodeType.getSecondaryType();
                boolean bl = false;
                for (int i = 0; i < nArray.length && !bl; ++i) {
                    if (nArray[i] != 9) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new InvalidFieldValueException("Proto does not describe a Color object");
                }
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                break;
            }
            case 2: {
                int[] nArray = vRMLNodeType.getSecondaryType();
                boolean bl = false;
                for (int i = 0; i < nArray.length && !bl; ++i) {
                    if (nArray[i] != 11) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new InvalidFieldValueException("Proto does not describe a Coord object");
                }
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                break;
            }
            default: {
                System.out.println("J3DIndexedLineSet: Unknown field for notifyExternProtoLoaded");
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.buildImpl();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 7) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 58;
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 2: {
                if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pCoord = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pCoord.getImplementationNode();
                    if (vRMLNodeType2 == null) {
                        return;
                    }
                    if (!(vRMLNodeType2 instanceof VRMLCoordinateNodeType)) {
                        this.pCoord = null;
                        throw new InvalidFieldValueException("Proto does not describe a Coord object");
                    }
                } else {
                    if (!(vRMLNodeType2 instanceof VRMLCoordinateNodeType)) {
                        throw new InvalidFieldValueException("Node does not describe a Coord object");
                    }
                    this.pCoord = null;
                }
                this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType2;
                if (this.vfCoord != null) {
                    this.vfCoord.addComponentListener((VRMLNodeComponentListener)this);
                }
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                break;
            }
            case 1: {
                if (vRMLNodeType instanceof VRMLProtoInstance) {
                    this.pColor = (VRMLProtoInstance)vRMLNodeType;
                    vRMLNodeType2 = this.pColor.getImplementationNode();
                    if (vRMLNodeType2 == null) {
                        return;
                    }
                    if (!(vRMLNodeType2 instanceof VRMLColorNodeType)) {
                        this.pColor = null;
                        throw new InvalidFieldValueException("Proto does not describe a Color object");
                    }
                } else {
                    if (!(vRMLNodeType2 instanceof VRMLColorNodeType)) {
                        throw new InvalidFieldValueException("Node does not describe a Color object");
                    }
                    this.pColor = null;
                }
                this.vfColor = (VRMLColorNodeType)vRMLNodeType2;
                if (this.vfColor != null) {
                    this.vfColor.addComponentListener((VRMLNodeComponentListener)this);
                }
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: 
            case 6: {
                super.setValue(n, nArray, n2);
                break;
            }
            case 4: 
            case 7: {
                super.setValue(n, nArray, n2);
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    public VRMLNodeType[] getComponents() {
        int n = 2;
        if (this.vfCoord == null && this.pCoord == null) {
            --n;
        }
        if (this.vfColor == null && this.pColor == null) {
            --n;
        }
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n];
        n = 0;
        if (this.pCoord != null) {
            vRMLNodeTypeArray[n++] = this.pCoord;
        } else if (this.vfCoord != null) {
            vRMLNodeTypeArray[n++] = this.vfCoord;
        }
        if (this.pColor != null) {
            vRMLNodeTypeArray[n++] = this.pColor;
        } else if (this.vfColor != null) {
            vRMLNodeTypeArray[n++] = this.vfColor;
        }
        return vRMLNodeTypeArray;
    }

    public void setComponents(VRMLNodeType[] vRMLNodeTypeArray) throws InvalidFieldValueException {
        block4: for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
            VRMLProtoInstance vRMLProtoInstance;
            VRMLNodeType vRMLNodeType = vRMLNodeTypeArray[i];
            if (vRMLNodeType instanceof VRMLProtoInstance) {
                vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                vRMLNodeType = vRMLProtoInstance.getImplementationNode();
            } else {
                vRMLProtoInstance = null;
            }
            switch (vRMLNodeType.getPrimaryType()) {
                case 11: {
                    this.pCoord = vRMLProtoInstance;
                    this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType;
                    if (this.vfCoord == null) continue block4;
                    this.vfCoord.addComponentListener((VRMLNodeComponentListener)this);
                    continue block4;
                }
                case 9: {
                    this.pColor = vRMLProtoInstance;
                    this.vfColor = (VRMLColorNodeType)vRMLNodeType;
                    if (this.vfColor == null) continue block4;
                    this.vfColor.addComponentListener((VRMLNodeComponentListener)this);
                    continue block4;
                }
                default: {
                    throw new InvalidFieldValueException("Unknown component type");
                }
            }
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void setComponent(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLProtoInstance vRMLProtoInstance;
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        if (vRMLNodeType2 instanceof VRMLProtoInstance) {
            vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType2;
            vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
        } else {
            vRMLProtoInstance = null;
        }
        switch (vRMLNodeType2.getPrimaryType()) {
            case 11: {
                this.pCoord = vRMLProtoInstance;
                this.vfCoord = (VRMLCoordinateNodeType)vRMLNodeType2;
                if (this.vfCoord == null) break;
                this.vfCoord.addComponentListener((VRMLNodeComponentListener)this);
                break;
            }
            case 9: {
                this.pColor = vRMLProtoInstance;
                this.vfColor = (VRMLColorNodeType)vRMLNodeType2;
                if (this.vfColor == null) break;
                this.vfColor.addComponentListener((VRMLNodeComponentListener)this);
                break;
            }
            default: {
                throw new InvalidFieldValueException("Unknown component type");
            }
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    private void buildImpl() {
        int n = 0;
        if (this.vfCoord != null) {
            n = this.vfCoord.getNumPoints();
            if (n == 0) {
                return;
            }
        } else {
            return;
        }
        this.lfCoord = this.vfCoord.getPointRef();
        this.vfCoord.addComponentListener((VRMLNodeComponentListener)this);
        int n2 = 3;
        this.countIndex();
        if (this.vfColor != null) {
            n = this.vfColor.getNumColors();
            this.lfColor = new float[n];
            this.vfColor.getColor(this.lfColor);
        }
        if (this.numPieces == 0) {
            return;
        }
        this.pieceSizes = new int[this.numPieces];
        this.lfCoordIndex = new int[this.numIndices];
        this.fillImplArrays(this.vfCoordIndex, this.numCoordIndex, this.pieceSizes, this.lfCoordIndex);
        this.lfColorIndex = this.setupIndex(this.vfColorIndex, this.numColorIndex, this.vfColorPerVertex);
        if (this.vfColor != null) {
            n2 |= 4;
        }
        this.implGeom = new IndexedLineStripArray(this.lfCoord.length, n2, this.numIndices, this.pieceSizes);
        this.implGeom.setCoordinates(0, this.lfCoord, 0, this.lfCoord.length / 3);
        this.implGeom.setCoordinateIndices(0, this.lfCoordIndex);
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f};
        int[] nArray = new int[this.lfCoordIndex.length];
        this.implGeom.setNormals(0, fArray);
        this.implGeom.setNormalIndices(0, nArray);
        if (this.vfColor != null) {
            this.implGeom.setColors(0, this.lfColor);
            this.implGeom.setColorIndices(0, this.lfColorIndex);
        } else {
            this.implGeom.setCapability(3);
            this.implGeom.setCapability(12);
        }
        if (!this.inSetup) {
            this.fireGeometryChanged(null);
        }
        this.lfCoord = null;
        this.lfCoordIndex = null;
        this.lfColor = null;
        this.lfColorIndex = null;
        this.pieceSizes = null;
    }

    static {
        nodeFields = new int[]{2, 1};
        fieldDecl = new VRMLFieldDeclaration[8];
        fieldMap = new HashMap(24);
        J3DIndexedLineSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "color");
        J3DIndexedLineSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "coord");
        J3DIndexedLineSet.fieldDecl[4] = new VRMLFieldDeclaration(1, "MFInt32", "set_colorIndex");
        J3DIndexedLineSet.fieldDecl[3] = new VRMLFieldDeclaration(2, "MFInt32", "colorIndex");
        J3DIndexedLineSet.fieldDecl[6] = new VRMLFieldDeclaration(2, "MFInt32", "coordIndex");
        J3DIndexedLineSet.fieldDecl[7] = new VRMLFieldDeclaration(1, "MFInt32", "set_coordIndex");
        J3DIndexedLineSet.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "colorPerVertex");
        Integer n = new Integer(1);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(2);
        fieldMap.put("coord", n);
        fieldMap.put("set_coord", n);
        fieldMap.put("coord_changed", n);
        fieldMap.put("colorIndex", new Integer(3));
        fieldMap.put("set_colorIndex", new Integer(4));
        fieldMap.put("colorPerVertex", new Integer(5));
        fieldMap.put("coordIndex", new Integer(6));
        fieldMap.put("set_coordIndex", new Integer(7));
    }
}

