/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.render;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.PointArray;
import javax.media.j3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.render.BasePointSet;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNodeType;

public class J3DPointSet
extends BasePointSet
implements J3DGeometryNodeType {
    private static final int[] GEOM_CHANGED_INDEX = new int[]{0};
    private PointArray implGeom;
    private ArrayList listeners = new ArrayList();
    private int numPoints;
    private boolean usedColor = false;
    private boolean colorChanged = false;
    private boolean coordChanged = false;

    public J3DPointSet() {
    }

    public J3DPointSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
    }

    public void allEventsComplete() {
        int n;
        float[] fArray;
        if (this.coordChanged) {
            if (this.vfCoord == null) {
                this.fireGeometryRemoved(GEOM_CHANGED_INDEX);
            } else {
                fArray = this.vfCoord.getPointRef();
                PointArray pointArray = this.updateGeometry(fArray, n = this.vfCoord.getNumPoints());
                if (pointArray != this.implGeom) {
                    this.implGeom = pointArray;
                    if (this.implGeom == null) {
                        this.numPoints = n;
                        this.fireGeometryAdded(GEOM_CHANGED_INDEX);
                    } else if (pointArray == null) {
                        this.numPoints = 0;
                        this.fireGeometryRemoved(GEOM_CHANGED_INDEX);
                    } else {
                        this.numPoints = n;
                        this.fireGeometryChanged(GEOM_CHANGED_INDEX);
                    }
                }
            }
            this.coordChanged = false;
        }
        if (this.colorChanged) {
            PointArray pointArray;
            fArray = null;
            if (this.vfColor != null) {
                n = this.vfColor.getNumColors();
                fArray = new float[n];
                this.vfColor.getColor(fArray);
            }
            if ((pointArray = this.updateColor(fArray)) != this.implGeom) {
                this.implGeom = pointArray;
                this.fireGeometryChanged(GEOM_CHANGED_INDEX);
            }
            this.colorChanged = false;
        }
    }

    public Geometry[] getGeometry() {
        Geometry[] geometryArray = null;
        if (this.implGeom != null) {
            geometryArray = new Geometry[]{this.implGeom};
        }
        return geometryArray;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public void addGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.add(j3DGeometryListener);
    }

    public void removeGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || !this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.remove(j3DGeometryListener);
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 2: {
                int[] nArray = vRMLNodeType.getSecondaryType();
                boolean bl = false;
                for (int i = 0; i < nArray.length && !bl; ++i) {
                    if (nArray[i] != 9) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new InvalidFieldValueException("Proto does not describe a X3DColorNode object");
                }
                this.colorChanged = true;
                this.pColor = (VRMLProtoInstance)vRMLNodeType;
                this.vfColor = (VRMLColorNodeType)this.pColor.getImplementationNode();
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                break;
            }
            case 1: {
                int[] nArray = vRMLNodeType.getSecondaryType();
                boolean bl = false;
                for (int i = 0; i < nArray.length && !bl; ++i) {
                    if (nArray[i] != 11) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new InvalidFieldValueException("Proto does not describe a X3DCoordinateNode object");
                }
                this.coordChanged = true;
                this.pCoord = (VRMLProtoInstance)vRMLNodeType;
                this.vfCoord = (VRMLCoordinateNodeType)this.pCoord.getImplementationNode();
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                break;
            }
            default: {
                System.out.println("J3DPointSet: Unknown field for notifyExternProtoLoaded");
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.vfCoord == null || this.vfCoord.getNumPoints() < 1) {
            return;
        }
        float[] fArray = this.vfCoord.getPointRef();
        float[] fArray2 = null;
        this.numPoints = fArray.length;
        if (this.vfColor != null) {
            fArray2 = new float[this.vfColor.getNumColors()];
            this.vfColor.getColor(fArray2);
            this.usedColor = fArray2.length >= this.numPoints;
        } else {
            this.usedColor = false;
        }
        this.implGeom = this.createPointArray(this.numPoints);
        this.implGeom.setCoordinates(0, fArray);
        if (this.usedColor) {
            this.implGeom.setColors(0, fArray2, 0, this.numPoints / 3);
        }
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
        switch (n) {
            case 1: {
                this.coordChanged = true;
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                break;
            }
            case 2: {
                this.colorChanged = true;
                if (this.inSetup) break;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            }
        }
    }

    protected void setCoordinateNode(VRMLCoordinateNodeType vRMLCoordinateNodeType) {
        if (this.inSetup) {
            return;
        }
        if (vRMLCoordinateNodeType == null) {
            this.fireGeometryRemoved(null);
        } else {
            int n;
            float[] fArray = this.vfCoord.getPointRef();
            PointArray pointArray = this.updateGeometry(fArray, n = this.vfCoord.getNumPoints());
            if (pointArray != this.implGeom) {
                if (this.implGeom == null) {
                    this.numPoints = n;
                    this.fireGeometryAdded(null);
                } else if (pointArray == null) {
                    this.numPoints = 0;
                    this.fireGeometryRemoved(GEOM_CHANGED_INDEX);
                } else {
                    this.numPoints = n;
                    this.fireGeometryChanged(GEOM_CHANGED_INDEX);
                }
            }
        }
    }

    protected void setColorNode(VRMLColorNodeType vRMLColorNodeType) {
        PointArray pointArray;
        if (!this.inSetup) {
            return;
        }
        float[] fArray = null;
        if (vRMLColorNodeType != null) {
            fArray = new float[vRMLColorNodeType.getNumColors()];
            vRMLColorNodeType.getColor(fArray);
        }
        if ((pointArray = this.updateColor(fArray)) != this.implGeom) {
            this.implGeom = pointArray;
            this.fireGeometryChanged(GEOM_CHANGED_INDEX);
        }
    }

    private PointArray updateGeometry(float[] fArray, int n) {
        float[] fArray2 = null;
        PointArray pointArray = this.implGeom;
        if (fArray == null || n < 3) {
            pointArray = null;
        } else {
            if (this.vfColor != null) {
                fArray2 = new float[this.vfColor.getNumColors()];
                this.vfColor.getColor(fArray2);
                boolean bl = this.usedColor = fArray2.length >= fArray.length;
            }
            if (n != this.numPoints && this.numPoints > 0) {
                pointArray = this.createPointArray(this.numPoints);
            }
            if (pointArray != null) {
                pointArray.setCoordinates(0, fArray);
                if (this.usedColor) {
                    pointArray.setColors(0, fArray2, 0, this.numPoints);
                }
            }
        }
        return pointArray;
    }

    private PointArray updateColor(float[] fArray) {
        PointArray pointArray = this.implGeom;
        if (fArray == null || fArray.length < this.numPoints) {
            if (this.usedColor && this.numPoints > 0) {
                this.usedColor = false;
                pointArray = this.createPointArray(this.numPoints);
                float[] fArray2 = this.vfCoord.getPointRef();
                pointArray.setCoordinates(0, fArray2);
            }
        } else {
            if (!this.usedColor && this.numPoints > 0) {
                this.usedColor = true;
                pointArray = this.createPointArray(this.numPoints);
                float[] fArray3 = this.vfCoord.getPointRef();
                pointArray.setCoordinates(0, fArray3);
            }
            if (pointArray != null) {
                pointArray.setColors(0, fArray, 0, this.numPoints / 3);
            }
        }
        return pointArray;
    }

    private PointArray createPointArray(int n) {
        int n2 = 3;
        if (this.usedColor) {
            n2 |= 4;
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n / 3; ++i) {
            fArray[i++] = 1.0f;
            fArray[i++] = 0.0f;
            fArray[i++] = 0.0f;
        }
        PointArray pointArray = new PointArray(n / 3, n2);
        pointArray.setNormals(0, fArray);
        if (!this.isStatic) {
            pointArray.setCapability(1);
            pointArray.setCapability(3);
        }
        return pointArray;
    }

    protected void fireGeometryAdded(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryAdded(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry add message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void fireGeometryChanged(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryChanged(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry change message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void fireGeometryRemoved(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryRemoved(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry remove message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

