/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.render;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TriangleArray;
import org.j3d.geom.GeometryData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.GeometryHolder;
import org.web3d.vrml.renderer.common.nodes.GeometryUtils;
import org.web3d.vrml.renderer.common.nodes.render.BaseTriangleSet;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DUserData;

public class J3DTriangleSet
extends BaseTriangleSet
implements J3DGeometryNodeType {
    private ArrayList listeners;
    private TriangleArray implGeom;
    private J3DUserData userData;
    private float[][] texCoords;
    private int[] texTypes;
    private int[] texSetMap;
    private int numTexSets;
    private int numUniqueTexSets;
    private boolean coordChanged;
    private boolean colorChanged;
    private boolean texCoordChanged;
    private boolean normalChanged;
    private GeometryUtils gutils;
    private int numBuilds;
    private int[] indexes;

    public J3DTriangleSet() {
        this.init();
    }

    public J3DTriangleSet(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Geometry[] getGeometry() {
        return new Geometry[]{this.implGeom};
    }

    public int getNumSets() {
        if (this.vfTexCoord == null) {
            return 0;
        }
        return this.vfTexCoord.getNumSets();
    }

    public String getTexCoordGenMode(int n) {
        if (this.vfTexCoord == null) {
            return null;
        }
        return this.vfTexCoord.getTexCoordGenMode(n);
    }

    public void addGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.add(j3DGeometryListener);
    }

    public void removeGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || !this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.remove(j3DGeometryListener);
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    private void init() {
        this.changeFlags = 0;
        this.listeners = new ArrayList();
        this.geomData = new GeometryData();
    }

    protected void buildImpl() {
        int n;
        boolean bl = false;
        if (this.vfNormal != null) {
            int n2;
            this.geomData.geometryType = 1;
            if (this.implGeom == null) {
                n2 = this.vfTexCoord == null ? 1 : this.vfTexCoord.getNumSets();
                int[] nArray = new int[n2 >= 4 ? n2 : 4];
                if (this.vfTexCoord != null) {
                    int n3;
                    for (n3 = 0; n3 < n2; ++n3) {
                        nArray[n3] = this.vfTexCoord.isShared(n3);
                    }
                    for (n3 = n2; n3 < 4; ++n3) {
                        nArray[n3] = n2 - 1;
                    }
                }
                this.implGeom = new TriangleArray(this.vfCoord.getNumPoints() / 3, this.getFormat(), n2, nArray);
                this.setCapabilities();
                J3DUserData j3DUserData = new J3DUserData();
                j3DUserData.geometryData = this.geomData;
                this.implGeom.setUserData((Object)j3DUserData);
                bl = true;
            }
            if ((this.changeFlags & 1) != 0) {
                this.updateCoordinateArray();
            }
            if ((this.changeFlags & 8) != 0) {
                this.updateColorArray();
            }
            if ((this.changeFlags & 2) != 0) {
                if (!this.vfNormalPerVertex) {
                    this.errorReporter.warningReport("Normal per face not supported in IndexedTriangleFanSet", null);
                } else {
                    this.updateNormalArray();
                }
            }
            if ((this.changeFlags & 4) != 0) {
                int n4;
                int n5;
                n2 = this.numTexSets = this.vfTexCoord.getNumSets();
                int n6 = this.vfTexCoord.getSize(0);
                int n7 = this.vfTexCoord.getNumTextureComponents();
                n = 0;
                for (n5 = 0; n5 < this.numTexSets; ++n5) {
                    if (n5 == this.vfTexCoord.isShared(n5)) continue;
                    --n2;
                }
                for (n5 = 1; n5 < this.numTexSets; ++n5) {
                    n4 = this.vfTexCoord.getSize(n5);
                    if (n6 <= n4) continue;
                    n6 = n4;
                }
                if (n6 < this.geomData.vertexCount * n7) {
                    n6 = this.geomData.vertexCount * n7;
                }
                if (this.texCoords == null || this.texCoords.length != n2) {
                    this.texCoords = new float[n2][];
                }
                if (this.texSetMap == null || this.texSetMap.length != this.numTexSets) {
                    this.texSetMap = new int[this.numTexSets];
                }
                for (n5 = 0; n5 < this.numTexSets; ++n5) {
                    this.texSetMap[n5] = this.vfTexCoord.isShared(n5);
                }
                if (this.texTypes == null || this.texTypes.length != this.numUniqueTexSets) {
                    this.texTypes = new int[this.numUniqueTexSets];
                }
                switch (n7) {
                    case 2: {
                        n = 32;
                        break;
                    }
                    case 3: {
                        n = 64;
                        break;
                    }
                    case 4: {
                        n = 1024;
                        break;
                    }
                    default: {
                        System.out.println("Invalid number of texture components " + this.vfTexCoord.getNumTextureComponents());
                    }
                }
                for (n5 = 0; n5 < this.numUniqueTexSets; ++n5) {
                    this.texTypes[n5] = n;
                }
                n5 = 0;
                for (n4 = 0; n4 < this.numTexSets; ++n4) {
                    this.texSetMap[n4] = this.vfTexCoord.isShared(n4);
                    if (this.texSetMap[n4] != n5) continue;
                    this.texCoords[n5] = new float[n6];
                    this.vfTexCoord.getPoint(n4, this.texCoords[n5++]);
                }
            }
        } else {
            int n8;
            int n9;
            this.geomData.geometryType = 1;
            if (this.gutils == null) {
                this.gutils = new GeometryUtils();
            }
            GeometryHolder geometryHolder = new GeometryHolder();
            float f = this.vfNormalPerVertex ? (float)Math.PI : 0.0f;
            if (this.indexes == null || (this.changeFlags & 1) != 0) {
                n9 = this.vfCoord.getNumPoints() / 3;
                n = n9 + n9 / 3;
                if (this.indexes == null || this.indexes.length < n) {
                    this.indexes = new int[n];
                }
                int n10 = 0;
                for (n8 = 0; n8 < n9 / 3; ++n8) {
                    this.indexes[n8 * 4] = n10++;
                    this.indexes[n8 * 4 + 1] = n10++;
                    this.indexes[n8 * 4 + 2] = n10++;
                    this.indexes[n8 * 4 + 3] = -1;
                }
            }
            n9 = this.gutils.generateTriangleArrays(this.changeFlags, false, true, this.vfCoord, this.vfColor, this.vfNormal, this.vfTexCoord, this.indexes, this.indexes.length, this.indexes, this.indexes, this.indexes, true, true, this.vfColorPerVertex, this.vfNormalPerVertex, f, bl, geometryHolder) ? 1 : 0;
            if (geometryHolder.coordinates == null) {
                return;
            }
            this.gutils.copyData(geometryHolder, this.geomData);
            this.texCoords = geometryHolder.textureCoordinates;
            this.numTexSets = geometryHolder.numTexSets;
            this.numUniqueTexSets = geometryHolder.numUniqueTexSets;
            if (n9 != 0 || this.implGeom == null) {
                n = this.vfTexCoord == null ? 1 : this.vfTexCoord.getNumSets();
                int[] nArray = new int[n >= 4 ? n : 4];
                if (this.vfTexCoord != null) {
                    for (n8 = 0; n8 < n; ++n8) {
                        nArray[n8] = this.vfTexCoord.isShared(n8);
                    }
                    for (n8 = n; n8 < 4; ++n8) {
                        nArray[n8] = n - 1;
                    }
                }
                this.implGeom = new TriangleArray(this.geomData.coordinates.length / 3, this.getFormat(), n, nArray);
                J3DUserData j3DUserData = new J3DUserData();
                j3DUserData.geometryData = this.geomData;
                this.implGeom.setUserData((Object)j3DUserData);
                this.setCapabilities();
                bl = true;
            }
            if (this.vfTexCoord == null) {
                if (this.implGeom.isLive()) {
                    this.texTypes = null;
                    this.texCoords = null;
                }
            } else {
                int n11;
                n = 0;
                int n12 = this.vfTexCoord.getNumTextureComponents();
                switch (n12) {
                    case 2: {
                        n = 32;
                        break;
                    }
                    case 3: {
                        n = 64;
                        break;
                    }
                    case 4: {
                        n = 1024;
                        break;
                    }
                    default: {
                        System.out.println("Invalid number of texture components " + this.vfTexCoord.getNumTextureComponents());
                    }
                }
                if (this.texSetMap == null || this.texSetMap.length != this.numTexSets) {
                    this.texSetMap = new int[this.numTexSets];
                }
                for (n11 = 0; n11 < this.numTexSets; ++n11) {
                    this.texSetMap[n11] = this.vfTexCoord.isShared(n11);
                }
                if (this.texTypes == null || this.texTypes.length != this.numTexSets) {
                    this.texTypes = new int[this.numTexSets];
                }
                for (n11 = 0; n11 < this.numTexSets; ++n11) {
                    this.texTypes[n11] = n;
                }
            }
        }
        if (bl) {
            this.coordChanged = true;
            this.colorChanged = true;
            this.normalChanged = true;
            this.texCoordChanged = true;
            this.implGeom.setCoordinates(0, this.geomData.coordinates);
            if (this.geomData.normals != null) {
                this.implGeom.setNormals(0, this.geomData.normals);
            }
            if (this.vfTexCoord != null) {
                int n13 = this.texCoords.length;
                for (int i = 0; i < n13; ++i) {
                    this.implGeom.setTextureCoordinates(i, 0, this.texCoords[i]);
                }
            }
            if (this.geomData.colors != null) {
                this.implGeom.setColors(0, this.geomData.colors);
            }
        } else {
            if ((this.changeFlags & 1) != 0) {
                this.implGeom.setCoordinates(0, this.geomData.coordinates);
            }
            if (((this.changeFlags & 1) != 0 && this.vfNormal == null || (this.changeFlags & 2) != 0) && this.geomData.colors != null) {
                this.implGeom.setColors(0, this.geomData.colors);
            }
            if ((this.changeFlags & 4) != 0 && this.vfTexCoord != null) {
                int n14 = this.texCoords.length;
                for (int i = 0; i < n14; ++i) {
                    this.implGeom.setTextureCoordinates(i, 0, this.texCoords[i]);
                }
            }
            if ((this.changeFlags & 8) != 0 && this.geomData.colors != null) {
                this.implGeom.setColors(0, this.geomData.colors);
            }
        }
        this.changeFlags = 0;
        if (bl && !this.inSetup) {
            this.fireGeometryChanged(null);
        }
        if (this.isStatic || this.numBuilds < 1) {
            if (this.gutils != null) {
                this.gutils.reset();
                this.gutils = null;
                this.indexes = null;
            }
            if (this.inSetup) {
                this.texCoords = null;
                this.texTypes = null;
                this.texSetMap = null;
            }
        }
        ++this.numBuilds;
    }

    private int getFormat() {
        int n = 3;
        if (this.vfColor != null) {
            switch (this.vfColor.getNumColorComponents()) {
                case 1: 
                case 2: {
                    System.out.println("Can't handle 1 or 2 component colors right now");
                }
                case 3: {
                    n |= 4;
                    break;
                }
                case 4: {
                    n |= 0xC;
                }
                default: {
                    System.out.println("Invalid number of color components " + this.vfColor.getNumColorComponents());
                }
            }
        }
        if (this.vfTexCoord != null) {
            switch (this.vfTexCoord.getNumTextureComponents()) {
                case 2: {
                    n |= 0x20;
                    break;
                }
                case 3: {
                    n |= 0x40;
                    break;
                }
                case 4: {
                    n |= 0x400;
                    break;
                }
                default: {
                    System.out.println("Invalid number of texture components " + this.vfTexCoord.getNumTextureComponents());
                }
            }
        }
        return n;
    }

    private void setCapabilities() {
        if (!this.isStatic) {
            this.implGeom.setCapability(1);
            this.implGeom.setCapability(5);
            this.implGeom.setCapability(7);
            this.implGeom.setCapability(20);
            this.implGeom.setCapability(10);
            this.implGeom.clearCapabilityIsFrequent(20);
            if (this.vfColor != null) {
                this.implGeom.setCapability(3);
                this.implGeom.clearCapabilityIsFrequent(3);
            }
        }
    }

    private void fireGeometryChanged(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryChanged(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry change message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

