/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.shape;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.Appearance;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributes;
import org.j3d.renderer.java3d.texture.J3DTextureCache;
import org.j3d.renderer.java3d.texture.J3DTextureCacheFactory;
import org.j3d.texture.TextureCache;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLComposedTextureNodeType;
import org.web3d.vrml.nodes.VRMLMultiTextureNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.nodes.VRMLTexture3DNodeType;
import org.web3d.vrml.nodes.VRMLTextureListener;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.nodes.VRMLTextureProperties2DNodeType;
import org.web3d.vrml.renderer.common.nodes.shape.BaseAppearance;
import org.web3d.vrml.renderer.common.nodes.shape.TextureStage;
import org.web3d.vrml.renderer.j3d.nodes.J3DAppearanceListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DAppearanceNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DGlobalStatus;
import org.web3d.vrml.renderer.j3d.nodes.J3DLinePropertiesNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DMaterialNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DTextureConstConverter;
import org.web3d.vrml.renderer.j3d.nodes.J3DTextureCoordinateTransformNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DTextureTransformListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DTransparencyListener;

public class J3DAppearance
extends BaseAppearance
implements J3DAppearanceNodeType,
J3DTransparencyListener,
J3DTextureTransformListener {
    private static final int TRANSPMODE = 2;
    private Appearance j3dImplNode;
    private TransparencyAttributes implTransp;
    private PolygonAttributes implPA;
    private float materialTransparency;
    private boolean textureAlpha;
    private TextureAttributes[] texAttrs;
    private TextureUnitState[] texUnits;
    private HashMap texGenMap;
    private static HashMap texGenModeMap = new HashMap(3);
    private Texture2D alphaTexture;
    private TextureAttributes alphaTA;
    private ArrayList listeners;
    private Texture[] texObjs;
    private VRMLTextureNodeType[] vrmlTexs;
    private int[] modes = null;
    private int[] functions = null;
    private int[] sources = null;
    private boolean lightingState;
    private boolean solid;
    private boolean ccw;
    static /* synthetic */ Class class$javax$media$j3d$Appearance;
    static /* synthetic */ Class class$javax$media$j3d$TransparencyAttributes;
    static /* synthetic */ Class class$javax$media$j3d$TextureAttributes;
    static /* synthetic */ Class class$javax$media$j3d$PolygonAttributes;

    public J3DAppearance() {
        this.init();
    }

    public J3DAppearance(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void transparencyChanged(float f) {
        this.materialTransparency = f;
        this.implTransp.setTransparency(f);
        this.updateTransparencyState();
    }

    public void setMaterial(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        J3DMaterialNodeType j3DMaterialNodeType = (J3DMaterialNodeType)this.vfMaterial;
        super.setMaterial(vRMLNodeType);
        if (j3DMaterialNodeType != null) {
            j3DMaterialNodeType.removeTransparencyListener(this);
        }
        if (this.vfMaterial != null) {
            this.materialTransparency = this.vfMaterial.getTransparency();
        }
        this.updateTransparencyState();
        if (!this.inSetup) {
            this.createMaterial();
        }
    }

    public void setSolid(boolean bl) {
        this.solid = bl;
        if (bl) {
            if (this.ccw) {
                this.implPA.setCullFace(1);
                this.implPA.setBackFaceNormalFlip(false);
            } else {
                this.implPA.setCullFace(2);
                this.implPA.setBackFaceNormalFlip(true);
            }
        } else {
            this.implPA.setCullFace(0);
            this.implPA.setBackFaceNormalFlip(true);
        }
    }

    public void setLightingEnabled(boolean bl) {
        this.lightingState = bl;
        if (this.vfMaterial != null) {
            ((J3DMaterialNodeType)this.vfMaterial).setLightingEnable(bl);
        }
    }

    public void setCCW(boolean bl) {
        this.ccw = bl;
        if (this.solid) {
            if (bl) {
                this.implPA.setCullFace(1);
                this.implPA.setBackFaceNormalFlip(false);
            } else {
                this.implPA.setCullFace(2);
                this.implPA.setBackFaceNormalFlip(true);
            }
        } else {
            this.implPA.setCullFace(0);
            this.implPA.setBackFaceNormalFlip(true);
        }
    }

    public void setTexCoordGenMode(int n, String string) {
        this.texGenMap.put(new Integer(n), string);
    }

    public void setTexture(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLTextureNodeType vRMLTextureNodeType = this.vfTexture;
        super.setTexture(vRMLNodeType);
        if (vRMLTextureNodeType != null) {
            vRMLTextureNodeType.removeTextureListener((VRMLTextureListener)this);
        }
        if (!this.inSetup) {
            this.processImages(0, (VRMLTextureNodeType)vRMLNodeType);
            this.createTextureUnits();
        }
        this.vfTexture.addTextureListener((VRMLTextureListener)this);
    }

    public void setTextureTransform(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        J3DTextureCoordinateTransformNodeType j3DTextureCoordinateTransformNodeType = (J3DTextureCoordinateTransformNodeType)this.vfTextureTransform;
        super.setTextureTransform(vRMLNodeType);
        J3DTextureCoordinateTransformNodeType j3DTextureCoordinateTransformNodeType2 = (J3DTextureCoordinateTransformNodeType)this.vfTextureTransform;
        if (!this.inSetup) {
            this.createTextureTransform();
        }
        j3DTextureCoordinateTransformNodeType2.addTransformListener(this);
        if (j3DTextureCoordinateTransformNodeType != null) {
            j3DTextureCoordinateTransformNodeType.removeTransformListener(this);
        }
    }

    public Appearance getAppearance() {
        return this.j3dImplNode;
    }

    public void setAlphaTexture(Texture2D texture2D) {
        if (this.alphaTexture != texture2D) {
            if (this.alphaTexture == null && texture2D != null) {
                this.insureStageSize(this.numStages + 1, true);
                for (int i = 0; i < this.numStages - 1; ++i) {
                    this.stages[i + 1] = this.stages[i];
                    this.urls[i + 1] = this.urls[i + 1];
                }
            } else if (texture2D == null) {
                --this.numStages;
            }
            this.alphaTexture = texture2D;
            if (this.alphaTA == null) {
                this.alphaTA = new TextureAttributes();
                this.alphaTA.setCapability(9);
                this.alphaTA.setCapability(1);
                this.alphaTA.setCapability(5);
            }
            this.createTextureUnits();
        }
    }

    public void textureTransformChanged(Transform3D[] transform3DArray) {
        int n = transform3DArray.length;
        this.insureStageSize(n, false);
        for (int i = 0; i < n; ++i) {
            this.stages[i].transform = transform3DArray[i];
            this.texAttrs[i].setTextureTransform(transform3DArray[i]);
        }
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, RenderedImage renderedImage, String string) {
        super.textureImageChanged(n, vRMLNodeType, renderedImage, string);
        if (n < this.numStages) {
            int n2 = this.vfTexture.getTextureType();
            switch (n2) {
                case 0: 
                case 2: {
                    this.texObjs[n] = this.createTexture(n, this.stages[n], string, this.vrmlTexs[n].getTextureType());
                    this.texUnits[n].setTexture(this.texObjs[n]);
                    break;
                }
                case 1: {
                    int n3 = this.alphaTexture == null ? 0 : 1;
                    this.texObjs[n3] = this.createTexture(n3, this.stages[n3], string, n2);
                    if (this.texObjs[n3] == null) break;
                    this.texUnits[n3].setTexture(this.texObjs[n3]);
                }
            }
        } else {
            this.createTextureUnits();
        }
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, RenderedImage[] renderedImageArray, String[] stringArray) {
        super.textureImageChanged(n, vRMLNodeTypeArray, renderedImageArray, stringArray);
        if (n <= this.numStages) {
            int n2 = this.vfTexture.getTextureType();
            if (n2 == 1) {
                int n3 = this.alphaTexture == null ? 0 : 1;
                this.stages[n3].mode = this.getMode(renderedImageArray[0], true);
                this.texObjs[n3] = this.createTexture(n3, this.stages[n3], null, n2);
                this.texUnits[n3].setTexture(this.texObjs[n3]);
            } else {
                for (int i = 0; i < n; ++i) {
                    this.stages[i].mode = this.getMode(renderedImageArray[i], i == 0);
                    this.texObjs[i] = this.createTexture(i, this.stages[i], stringArray[i], this.vrmlTexs[i].getTextureType());
                    this.texUnits[i].setTexture(this.texObjs[i]);
                }
            }
        } else {
            this.createTextureUnits();
        }
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, Buffer buffer, String string) {
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, Buffer[] bufferArray, String[] stringArray) {
    }

    public void textureParamsChanged(int n, int n2, int n3, int n4, float f, float[] fArray) {
        super.textureParamsChanged(n, n2, n3, n4, f, fArray);
    }

    public void textureParamsChanged(int n, int[] nArray, int[] nArray2, int[] nArray3, float f, float[] fArray) {
        super.textureParamsChanged(n, nArray, nArray2, nArray3, f, fArray);
        if (n <= this.numStages) {
            for (int i = 0; i < n; ++i) {
                this.stages[i].mode = nArray[i];
                this.setTextureMode(i, this.stages[i], this.texAttrs[i]);
            }
        } else {
            this.createTextureUnits();
        }
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null) {
            if (map.containsKey(class$javax$media$j3d$Appearance == null ? (class$javax$media$j3d$Appearance = J3DAppearance.class$("javax.media.j3d.Appearance")) : class$javax$media$j3d$Appearance)) {
                nArray = (int[])map.get(class$javax$media$j3d$Appearance == null ? (class$javax$media$j3d$Appearance = J3DAppearance.class$("javax.media.j3d.Appearance")) : class$javax$media$j3d$Appearance);
                int n3 = n2 = nArray == null ? 0 : nArray.length;
                if (n2 != 0) {
                    for (n = 0; n < n2; ++n) {
                        this.j3dImplNode.clearCapability(nArray[n]);
                    }
                } else if (!this.isStatic) {
                    this.j3dImplNode.clearCapability(3);
                    this.j3dImplNode.clearCapability(1);
                    this.j3dImplNode.clearCapability(7);
                    this.j3dImplNode.clearCapability(11);
                    this.j3dImplNode.clearCapability(15);
                }
            }
            if (map.containsKey(class$javax$media$j3d$TransparencyAttributes == null ? (class$javax$media$j3d$TransparencyAttributes = J3DAppearance.class$("javax.media.j3d.TransparencyAttributes")) : class$javax$media$j3d$TransparencyAttributes)) {
                nArray = (int[])map.get(class$javax$media$j3d$TransparencyAttributes == null ? (class$javax$media$j3d$TransparencyAttributes = J3DAppearance.class$("javax.media.j3d.TransparencyAttributes")) : class$javax$media$j3d$TransparencyAttributes);
                int n4 = n2 = nArray == null ? 0 : nArray.length;
                if (n2 != 0) {
                    for (n = 0; n < n2; ++n) {
                        this.implTransp.clearCapability(nArray[n]);
                    }
                } else if (!this.isStatic) {
                    this.implTransp.clearCapability(3);
                    this.implTransp.clearCapability(1);
                }
            }
            if (map.containsKey(class$javax$media$j3d$TextureAttributes == null ? (class$javax$media$j3d$TextureAttributes = J3DAppearance.class$("javax.media.j3d.TextureAttributes")) : class$javax$media$j3d$TextureAttributes)) {
                nArray = (int[])map.get(class$javax$media$j3d$TextureAttributes == null ? (class$javax$media$j3d$TextureAttributes = J3DAppearance.class$("javax.media.j3d.TextureAttributes")) : class$javax$media$j3d$TextureAttributes);
                int n5 = n2 = nArray == null ? 0 : nArray.length;
                if (n2 != 0) {
                    for (n = 0; n < n2; ++n) {
                        this.texAttrs[0].clearCapability(nArray[n]);
                    }
                } else if (!this.isStatic) {
                    this.texAttrs[0].clearCapability(5);
                }
            }
            if (map.containsKey(class$javax$media$j3d$PolygonAttributes == null ? (class$javax$media$j3d$PolygonAttributes = J3DAppearance.class$("javax.media.j3d.PolygonAttributes")) : class$javax$media$j3d$PolygonAttributes)) {
                nArray = (int[])map.get(class$javax$media$j3d$PolygonAttributes == null ? (class$javax$media$j3d$PolygonAttributes = J3DAppearance.class$("javax.media.j3d.PolygonAttributes")) : class$javax$media$j3d$PolygonAttributes);
                int n6 = n2 = nArray == null ? 0 : nArray.length;
                if (n2 != 0) {
                    for (n = 0; n < n2; ++n) {
                        this.implPA.clearCapability(nArray[n]);
                    }
                } else if (!this.isStatic) {
                    this.implPA.clearCapability(1);
                    this.implPA.clearCapability(7);
                }
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        if (map2.containsKey(class$javax$media$j3d$Appearance == null ? (class$javax$media$j3d$Appearance = J3DAppearance.class$("javax.media.j3d.Appearance")) : class$javax$media$j3d$Appearance)) {
            nArray = (int[])map2.get(class$javax$media$j3d$Appearance == null ? (class$javax$media$j3d$Appearance = J3DAppearance.class$("javax.media.j3d.Appearance")) : class$javax$media$j3d$Appearance);
            int n7 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.j3dImplNode.clearCapabilityIsFrequent(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.j3dImplNode.clearCapabilityIsFrequent(3);
                this.j3dImplNode.clearCapabilityIsFrequent(1);
                this.j3dImplNode.clearCapabilityIsFrequent(7);
                this.j3dImplNode.clearCapabilityIsFrequent(11);
                this.j3dImplNode.clearCapabilityIsFrequent(15);
            }
        }
        if (map2.containsKey(class$javax$media$j3d$TransparencyAttributes == null ? (class$javax$media$j3d$TransparencyAttributes = J3DAppearance.class$("javax.media.j3d.TransparencyAttributes")) : class$javax$media$j3d$TransparencyAttributes)) {
            nArray = (int[])map2.get(class$javax$media$j3d$TransparencyAttributes == null ? (class$javax$media$j3d$TransparencyAttributes = J3DAppearance.class$("javax.media.j3d.TransparencyAttributes")) : class$javax$media$j3d$TransparencyAttributes);
            int n8 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implTransp.clearCapabilityIsFrequent(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.implTransp.clearCapabilityIsFrequent(3);
                this.implTransp.clearCapabilityIsFrequent(1);
            }
        }
        if (map2.containsKey(class$javax$media$j3d$TextureAttributes == null ? (class$javax$media$j3d$TextureAttributes = J3DAppearance.class$("javax.media.j3d.TextureAttributes")) : class$javax$media$j3d$TextureAttributes)) {
            nArray = (int[])map2.get(class$javax$media$j3d$TextureAttributes == null ? (class$javax$media$j3d$TextureAttributes = J3DAppearance.class$("javax.media.j3d.TextureAttributes")) : class$javax$media$j3d$TextureAttributes);
            int n9 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.texAttrs[0].clearCapabilityIsFrequent(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.texAttrs[0].clearCapabilityIsFrequent(5);
            }
        }
        if (map2.containsKey(class$javax$media$j3d$PolygonAttributes == null ? (class$javax$media$j3d$PolygonAttributes = J3DAppearance.class$("javax.media.j3d.PolygonAttributes")) : class$javax$media$j3d$PolygonAttributes)) {
            nArray = (int[])map2.get(class$javax$media$j3d$PolygonAttributes == null ? (class$javax$media$j3d$PolygonAttributes = J3DAppearance.class$("javax.media.j3d.PolygonAttributes")) : class$javax$media$j3d$PolygonAttributes);
            int n10 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implPA.clearCapabilityIsFrequent(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.implPA.clearCapabilityIsFrequent(1);
                this.implPA.clearCapabilityIsFrequent(7);
            }
        }
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null) {
            nArray = (int[])map.get(class$javax$media$j3d$Appearance == null ? (class$javax$media$j3d$Appearance = J3DAppearance.class$("javax.media.j3d.Appearance")) : class$javax$media$j3d$Appearance);
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.j3dImplNode.setCapability(nArray[n]);
                }
            }
            nArray = (int[])map.get(class$javax$media$j3d$TransparencyAttributes == null ? (class$javax$media$j3d$TransparencyAttributes = J3DAppearance.class$("javax.media.j3d.TransparencyAttributes")) : class$javax$media$j3d$TransparencyAttributes);
            int n4 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implTransp.setCapability(nArray[n]);
                }
            }
            nArray = (int[])map.get(class$javax$media$j3d$TextureAttributes == null ? (class$javax$media$j3d$TextureAttributes = J3DAppearance.class$("javax.media.j3d.TextureAttributes")) : class$javax$media$j3d$TextureAttributes);
            int n5 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.texAttrs[0].setCapability(nArray[n]);
                }
            }
            nArray = (int[])map.get(class$javax$media$j3d$PolygonAttributes == null ? (class$javax$media$j3d$PolygonAttributes = J3DAppearance.class$("javax.media.j3d.PolygonAttributes")) : class$javax$media$j3d$PolygonAttributes);
            int n6 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implPA.setCapability(nArray[n]);
                }
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        nArray = (int[])map2.get(class$javax$media$j3d$Appearance == null ? (class$javax$media$j3d$Appearance = J3DAppearance.class$("javax.media.j3d.Appearance")) : class$javax$media$j3d$Appearance);
        int n7 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.j3dImplNode.setCapabilityIsFrequent(nArray[n]);
            }
        }
        nArray = (int[])map2.get(class$javax$media$j3d$TransparencyAttributes == null ? (class$javax$media$j3d$TransparencyAttributes = J3DAppearance.class$("javax.media.j3d.TransparencyAttributes")) : class$javax$media$j3d$TransparencyAttributes);
        int n8 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.implTransp.setCapabilityIsFrequent(nArray[n]);
            }
        }
        nArray = (int[])map2.get(class$javax$media$j3d$TextureAttributes == null ? (class$javax$media$j3d$TextureAttributes = J3DAppearance.class$("javax.media.j3d.TextureAttributes")) : class$javax$media$j3d$TextureAttributes);
        int n9 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.texAttrs[0].setCapabilityIsFrequent(nArray[n]);
            }
        }
        nArray = (int[])map2.get(class$javax$media$j3d$PolygonAttributes == null ? (class$javax$media$j3d$PolygonAttributes = J3DAppearance.class$("javax.media.j3d.PolygonAttributes")) : class$javax$media$j3d$PolygonAttributes);
        int n10 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.implPA.setCapabilityIsFrequent(nArray[n]);
            }
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.j3dImplNode;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.solid) {
            if (this.ccw) {
                this.implPA.setCullFace(1);
                this.implPA.setBackFaceNormalFlip(false);
            } else {
                this.implPA.setCullFace(2);
                this.implPA.setBackFaceNormalFlip(true);
            }
        } else {
            this.implPA.setCullFace(0);
            this.implPA.setBackFaceNormalFlip(true);
        }
        this.createMaterial();
        this.createTextureTransform();
        this.createTextureUnits();
        if (this.vfLineProperties != null) {
            this.j3dImplNode.setLineAttributes(((J3DLinePropertiesNodeType)this.vfLineProperties).getLineAttributes());
        }
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        this.j3dImplNode.setCapability(3);
        this.j3dImplNode.setCapability(21);
        for (int i = 0; i < this.texUnits.length; ++i) {
            this.texUnits[i].setCapability(1);
            this.texAttrs[i].setCapability(1);
        }
        this.implTransp.setCapability(3);
        this.implTransp.setCapability(1);
        this.implTransp.setCapability(5);
        this.implPA.setCapability(1);
        this.implPA.setCapability(7);
        if (bl) {
            return;
        }
        this.j3dImplNode.setCapability(1);
        this.j3dImplNode.setCapability(7);
        this.j3dImplNode.setCapability(15);
        this.j3dImplNode.setCapability(11);
    }

    private void init() {
        this.materialTransparency = 0.0f;
        this.textureAlpha = false;
        this.lightingState = true;
        this.j3dImplNode = new Appearance();
        this.implTransp = new TransparencyAttributes();
        this.implPA = new PolygonAttributes();
        this.texAttrs = new TextureAttributes[1];
        this.texAttrs[0] = new TextureAttributes();
        this.texUnits = new TextureUnitState[1];
        this.texUnits[0] = new TextureUnitState();
        this.texGenMap = new HashMap(2);
        this.solid = false;
        this.ccw = true;
        this.j3dImplNode.setTransparencyAttributes(this.implTransp);
        this.j3dImplNode.setPolygonAttributes(this.implPA);
        this.listeners = new ArrayList(1);
        if (useTextureCache) {
            J3DTextureCache j3DTextureCache = J3DTextureCacheFactory.getCache((int)3);
            this.setTextureCache((TextureCache)j3DTextureCache);
        }
    }

    public void addAppearanceListener(J3DAppearanceListener j3DAppearanceListener) {
        if (j3DAppearanceListener == null || this.listeners.contains(j3DAppearanceListener)) {
            return;
        }
        this.listeners.add(j3DAppearanceListener);
    }

    public void removeAppearanceListener(J3DAppearanceListener j3DAppearanceListener) {
        if (j3DAppearanceListener == null || !this.listeners.contains(j3DAppearanceListener)) {
            return;
        }
        this.listeners.remove(j3DAppearanceListener);
    }

    protected void fireAppearanceChanged(Appearance appearance) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DAppearanceListener j3DAppearanceListener = (J3DAppearanceListener)this.listeners.get(i);
                j3DAppearanceListener.appearanceChanged(appearance);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending appearance changed message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        super.notifyExternProtoLoaded(n, vRMLNodeType);
        switch (n) {
            case 1: {
                this.createMaterial();
                break;
            }
            case 2: {
                this.createTextureUnits();
                break;
            }
            case 3: {
                this.createTextureTransform();
                break;
            }
            default: {
                System.out.println("J3DAppearance: Unknown field for notifyExternProtoLoaded");
            }
        }
    }

    private void createMaterial() {
        int n = 4;
        if (this.vfMaterial != null) {
            J3DMaterialNodeType j3DMaterialNodeType = (J3DMaterialNodeType)this.vfMaterial;
            j3DMaterialNodeType.setLightingEnable(this.lightingState);
            this.j3dImplNode.setMaterial(j3DMaterialNodeType.getMaterial());
            this.materialTransparency = j3DMaterialNodeType.getTransparency();
            n = this.materialTransparency > 0.0f || this.textureAlpha ? 2 : 4;
            j3DMaterialNodeType.addTransparencyListener(this);
        } else {
            this.j3dImplNode.setMaterial(null);
            n = 4;
        }
        this.implTransp.setTransparency(this.materialTransparency);
        this.implTransp.setTransparencyMode(n);
    }

    private void createTextureUnits() {
        Object object;
        this.numStages = this.alphaTexture != null ? 1 : 0;
        int n = this.numStages++;
        if (this.vfTexture != null) {
            switch (this.vfTexture.getTextureType()) {
                case 0: {
                    this.vrmlTexs = new VRMLTextureNodeType[this.numStages];
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    this.vrmlTexs[this.numStages - 1] = this.vfTexture;
                    VRMLTexture2DNodeType vRMLTexture2DNodeType = (VRMLTexture2DNodeType)this.vfTexture;
                    this.modes[this.numStages - 1] = this.getMode(vRMLTexture2DNodeType.getImage(), true);
                    break;
                }
                case 2: {
                    VRMLMultiTextureNodeType vRMLMultiTextureNodeType = (VRMLMultiTextureNodeType)this.vfTexture;
                    this.numStages += vRMLMultiTextureNodeType.getNumberTextures();
                    this.vrmlTexs = new VRMLTextureNodeType[this.numStages];
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    vRMLMultiTextureNodeType.getTextures(n, this.vrmlTexs);
                    vRMLMultiTextureNodeType.getTextureParams(n, this.modes, this.functions, this.sources);
                    break;
                }
                case 1: {
                    object = (VRMLComposedTextureNodeType)this.vfTexture;
                    int n2 = this.numStages + object.getNumberTextures();
                    this.vrmlTexs = new VRMLTextureNodeType[n2];
                    ++this.numStages;
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    object.getTextures(n, this.vrmlTexs);
                    break;
                }
            }
        }
        this.texObjs = new Texture[this.numStages];
        this.texUnits = new TextureUnitState[this.numStages];
        this.texAttrs = new TextureAttributes[this.numStages];
        this.insureStageSize(this.numStages, true);
        int n3 = 0;
        if (this.alphaTexture != null) {
            this.stages[n3].source = 0;
            switch (this.alphaTexture.getFormat()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.stages[n3].mode = 0;
                    this.alphaTA.setCombineRgbMode(2);
                    break;
                }
                default: {
                    this.stages[n3].mode = 1;
                    this.alphaTA.setCombineRgbMode(5);
                }
            }
            this.alphaTA.setTextureMode(6);
            this.alphaTA.setCombineRgbSource(1, 3);
            this.textureAlpha = true;
            this.updateTransparencyState();
            this.texObjs[n3] = this.alphaTexture;
            this.texAttrs[n3] = this.alphaTA;
            this.texUnits[n3] = new TextureUnitState(this.texObjs[n3], this.texAttrs[n3], null);
            this.texUnits[n3].setCapability(1);
            ++n3;
        }
        for (int i = n3; i < this.numStages; ++i) {
            object = this.stages[i];
            TexCoordGeneration texCoordGeneration = null;
            if (this.vfTextureProperties != null) {
                VRMLTextureProperties2DNodeType vRMLTextureProperties2DNodeType = this.vfTextureProperties;
                object.boundaryModeS = vRMLTextureProperties2DNodeType.getBoundaryModeS();
                object.boundaryModeT = vRMLTextureProperties2DNodeType.getBoundaryModeT();
                object.boundaryColor = new float[4];
                vRMLTextureProperties2DNodeType.getBoundaryColor(object.boundaryColor);
                object.minFilter = vRMLTextureProperties2DNodeType.getMinificationFilter();
                object.magFilter = vRMLTextureProperties2DNodeType.getMagnificationFilter();
            }
            object.yUp = this.vrmlTexs[i].getYUp();
            int n4 = this.vfTexture.getTextureType();
            switch (n4) {
                case 0: 
                case 2: {
                    int n5;
                    String string;
                    n4 = this.vrmlTexs[i].getTextureType();
                    object.mode = this.modes[i];
                    if (this.vfTextureProperties == null) {
                        VRMLTexture2DNodeType vRMLTexture2DNodeType = (VRMLTexture2DNodeType)this.vrmlTexs[i];
                        boolean bl = vRMLTexture2DNodeType.getRepeatS();
                        object.boundaryModeS = bl ? 0 : 1;
                        boolean bl2 = vRMLTexture2DNodeType.getRepeatT();
                        object.boundaryModeT = bl2 ? 0 : 1;
                    }
                    if ((string = (String)this.texGenMap.get(new Integer(n5 = this.alphaTexture == null ? n3 : n3 - 1))) == null) break;
                    Integer n6 = (Integer)texGenModeMap.get(string);
                    if (n6 != null) {
                        texCoordGeneration = new TexCoordGeneration(n6.intValue(), 0);
                        break;
                    }
                    System.out.println("TexCoordGen mode not found: " + n6);
                    break;
                }
                case 1: {
                    Object object2;
                    if (this.vfTextureProperties != null) {
                        object2 = this.vfTextureProperties;
                    } else {
                        object2 = (VRMLTexture3DNodeType)this.vfTexture;
                        object.boundaryModeS = object2.getRepeatS() ? 0 : 1;
                        object.boundaryModeT = object2.getRepeatT() ? 0 : 1;
                        object.boundaryModeR = object2.getRepeatR() ? 0 : 1;
                        object.depth = object2.getDepth();
                    }
                    int n5 = this.alphaTexture == null ? n3 : n3 - 1;
                    String string = (String)this.texGenMap.get(new Integer(n5));
                    if (string == null) break;
                    object2 = (Integer)texGenModeMap.get(string);
                    if (object2 != null) {
                        texCoordGeneration = new TexCoordGeneration(((Integer)object2).intValue(), 1);
                        break;
                    }
                    System.out.println("TexCoordGen mode not found: " + object2);
                    break;
                }
            }
            this.texObjs[i] = this.createTexture(i, (TextureStage)object, this.urls[i], n4);
            this.texAttrs[i] = this.createTextureAttributes(i, (TextureStage)object);
            this.texUnits[i] = new TextureUnitState(this.texObjs[i], this.texAttrs[i], texCoordGeneration);
            this.texUnits[i].setCapability(1);
        }
        this.j3dImplNode.setTextureUnitState(this.texUnits);
    }

    private void createTextureTransform() {
        if (this.vfTextureTransform != null) {
            int n;
            J3DTextureCoordinateTransformNodeType j3DTextureCoordinateTransformNodeType = (J3DTextureCoordinateTransformNodeType)this.vfTextureTransform;
            Transform3D[] transform3DArray = j3DTextureCoordinateTransformNodeType.getTransformMatrix();
            int n2 = transform3DArray.length;
            this.insureStageSize(n2, false);
            if (n2 > this.texAttrs.length) {
                this.texAttrs = new TextureAttributes[n2];
                for (n = 0; n < n2; ++n) {
                    this.texAttrs[n] = new TextureAttributes();
                }
            }
            for (n = 0; n < n2; ++n) {
                this.stages[n].transform = transform3DArray[n];
                this.texAttrs[n].setTextureTransform(transform3DArray[n]);
            }
        }
    }

    private Texture createTexture(int n, TextureStage textureStage, String string, int n2) {
        ImageComponent2D[] imageComponent2DArray;
        Texture2D texture2D = null;
        if (useTextureCache && this.cache.checkTexture(string)) {
            try {
                texture2D = (Texture2D)((J3DTextureCache)this.cache).fetchTexture(string);
                Boolean bl = (Boolean)alphaMap.get(texture2D);
                this.textureAlpha = bl;
                this.updateTransparencyState();
                return texture2D;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (textureStage.images == null || textureStage.images.length < 1 || textureStage.images[0] == null) {
            return null;
        }
        int n3 = this.getFormat(textureStage.images[0]);
        int n4 = 0;
        if (this.vfTextureProperties != null) {
            imageComponent2DArray = this.vfTextureProperties;
            textureStage.generateMipMaps = imageComponent2DArray.getGenerateMipMaps();
            textureStage.boundaryModeS = imageComponent2DArray.getBoundaryModeS();
            textureStage.boundaryModeT = imageComponent2DArray.getBoundaryModeT();
            textureStage.minFilter = imageComponent2DArray.getMinificationFilter();
            textureStage.magFilter = imageComponent2DArray.getMagnificationFilter();
            textureStage.anisotropicMode = imageComponent2DArray.getAnisotropicMode();
            textureStage.anisotropicDegree = imageComponent2DArray.getAnisotropicDegree();
        } else {
            switch (this.vfTexture.getTextureType()) {
                case 0: {
                    imageComponent2DArray = (VRMLTexture2DNodeType)this.vfTexture;
                    textureStage.boundaryModeS = imageComponent2DArray.getRepeatS() ? 0 : 1;
                    if (imageComponent2DArray.getRepeatT()) {
                        textureStage.boundaryModeT = 0;
                        break;
                    }
                    textureStage.boundaryModeT = 1;
                    break;
                }
                case 1: {
                    VRMLTexture3DNodeType vRMLTexture3DNodeType = (VRMLTexture3DNodeType)this.vfTexture;
                    textureStage.boundaryModeS = vRMLTexture3DNodeType.getRepeatS() ? 0 : 1;
                    textureStage.boundaryModeT = vRMLTexture3DNodeType.getRepeatT() ? 0 : 1;
                    textureStage.boundaryModeR = vRMLTexture3DNodeType.getRepeatR() ? 0 : 1;
                }
            }
            if (useMipMaps) {
                textureStage.minFilter = 5;
            }
            if (anisotropicDegree > 1) {
                textureStage.anisotropicMode = 1;
                textureStage.anisotropicDegree = anisotropicDegree;
            }
        }
        try {
            switch (n2) {
                case 0: {
                    int n5;
                    int n6 = textureStage.images.length;
                    if (this.containsAlpha(textureStage.images[0])) {
                        this.textureAlpha = true;
                    }
                    imageComponent2DArray = new ImageComponent2D[n6];
                    for (n5 = 0; n5 < n6; ++n5) {
                        imageComponent2DArray[n5] = new ImageComponent2D(n3, textureStage.images[n5], false, textureStage.yUp);
                        imageComponent2DArray[n5].setCapability(1);
                        imageComponent2DArray[n5].setCapability(0);
                    }
                    int n7 = imageComponent2DArray[0].getWidth();
                    int n8 = imageComponent2DArray[0].getHeight();
                    n4 = this.getTextureFormat((ImageComponent)imageComponent2DArray[0]);
                    texture2D = !textureStage.generateMipMaps && !useMipMaps ? new Texture2D(1, n4, n7, n8) : new Texture2D(2, n4, n7, n8);
                    n5 = J3DTextureConstConverter.convertAnisotropicMode(textureStage.anisotropicMode);
                    texture2D.setAnisotropicFilterMode(n5);
                    texture2D.setAnisotropicFilterDegree(textureStage.anisotropicDegree);
                    n5 = J3DTextureConstConverter.convertBoundary(textureStage.boundaryModeS);
                    texture2D.setBoundaryModeS(n5);
                    n5 = J3DTextureConstConverter.convertBoundary(textureStage.boundaryModeT);
                    texture2D.setBoundaryModeT(n5);
                    n5 = J3DTextureConstConverter.convertMinFilter(textureStage.minFilter);
                    texture2D.setMinFilter(n5);
                    n5 = J3DTextureConstConverter.convertMagFilter(textureStage.magFilter);
                    texture2D.setMagFilter(n5);
                    texture2D.setImages((ImageComponent[])imageComponent2DArray);
                    texture2D.setCapability(9);
                    textureStage.images = null;
                    break;
                }
                case 1: {
                    if (textureStage.images.length < textureStage.depth) {
                        return null;
                    }
                    for (int i = 0; i < textureStage.depth; ++i) {
                        if (textureStage.images[i] == null) {
                            return null;
                        }
                        if (this.getFormat(textureStage.images[i]) == n3) continue;
                        return null;
                    }
                    int n9 = textureStage.images[0].getWidth();
                    int n10 = textureStage.images[0].getHeight();
                    ImageComponent3D imageComponent3D = new ImageComponent3D(n3, n9, n10, textureStage.depth, false, textureStage.yUp);
                    for (int i = 0; i < textureStage.depth; ++i) {
                        if (!this.containsAlpha(textureStage.images[i])) continue;
                        this.textureAlpha = true;
                    }
                    imageComponent3D.set(textureStage.images);
                    imageComponent3D.setCapability(1);
                    imageComponent3D.setCapability(0);
                    n4 = this.getTextureFormat((ImageComponent)imageComponent3D);
                    texture2D = !textureStage.generateMipMaps ? new Texture3D(1, n4, n9, n10, textureStage.depth) : new Texture3D(2, n4, n9, n10, textureStage.depth);
                    int n11 = J3DTextureConstConverter.convertAnisotropicMode(textureStage.anisotropicMode);
                    texture2D.setAnisotropicFilterMode(1);
                    texture2D.setAnisotropicFilterDegree(textureStage.anisotropicDegree);
                    n11 = J3DTextureConstConverter.convertBoundary(textureStage.boundaryModeS);
                    texture2D.setBoundaryModeS(n11);
                    n11 = J3DTextureConstConverter.convertBoundary(textureStage.boundaryModeT);
                    texture2D.setBoundaryModeT(n11);
                    n11 = J3DTextureConstConverter.convertBoundary(textureStage.boundaryModeR);
                    ((Texture3D)texture2D).setBoundaryModeR(n11);
                    n11 = J3DTextureConstConverter.convertMinFilter(textureStage.minFilter);
                    texture2D.setMinFilter(n11);
                    n11 = J3DTextureConstConverter.convertMagFilter(textureStage.magFilter);
                    texture2D.setMagFilter(n11);
                    texture2D.setImage(0, (ImageComponent)imageComponent3D);
                    texture2D.setCapability(9);
                    textureStage.images = null;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error creating image: " + string);
            exception.printStackTrace();
            return texture2D;
        }
        if (useTextureCache && string != null) {
            ((J3DTextureCache)this.cache).registerTexture((Texture)texture2D, string);
            alphaMap.put(texture2D, this.textureAlpha ? Boolean.TRUE : Boolean.FALSE);
        }
        this.updateTransparencyState();
        return texture2D;
    }

    private TextureAttributes createTextureAttributes(int n, TextureStage textureStage) {
        TextureAttributes textureAttributes = new TextureAttributes();
        this.setTextureMode(n, textureStage, textureAttributes);
        if (textureStage.transform != null) {
            textureAttributes.setTextureTransform((Transform3D)textureStage.transform);
        }
        textureAttributes.setCapability(9);
        textureAttributes.setCapability(1);
        textureAttributes.setCapability(5);
        return textureAttributes;
    }

    private void setTextureMode(int n, TextureStage textureStage, TextureAttributes textureAttributes) {
        switch (textureStage.mode) {
            case 1: {
                textureAttributes.setTextureMode(5);
                break;
            }
            case 0: {
                textureAttributes.setTextureMode(6);
                textureAttributes.setCombineRgbMode(1);
                textureAttributes.setCombineRgbSource(1, 1);
                textureAttributes.setCombineRgbSource(0, 0);
                break;
            }
            case 2: {
                textureAttributes.setTextureMode(2);
                textureAttributes.setCombineRgbScale(2);
                break;
            }
            case 3: {
                textureAttributes.setTextureMode(2);
                textureAttributes.setCombineRgbScale(4);
                break;
            }
            case 4: {
                textureAttributes.setTextureMode(6);
                textureAttributes.setCombineRgbMode(2);
                textureAttributes.setCombineRgbSource(1, 3);
                break;
            }
            case 18: {
                textureAttributes.setTextureMode(6);
                textureAttributes.setCombineRgbMode(6);
                textureAttributes.setCombineRgbSource(1, 3);
                break;
            }
            case 7: {
                textureAttributes.setTextureMode(6);
                textureAttributes.setCombineRgbMode(4);
                textureAttributes.setCombineRgbSource(1, 3);
                break;
            }
            case 5: {
                textureAttributes.setTextureMode(6);
                textureAttributes.setCombineRgbMode(3);
                break;
            }
            case 6: {
                textureAttributes.setTextureMode(6);
                textureAttributes.setCombineRgbMode(3);
                textureAttributes.setCombineRgbScale(2);
                break;
            }
            case 15: {
                if (this.texObjs[n] == null) break;
                this.texUnits[n].setTexture(null);
                break;
            }
            default: {
                System.out.println("Unknown TextureConstants.Mode: " + textureStage.mode);
            }
        }
    }

    protected int getTextureFormat(ImageComponent imageComponent) {
        int n = 5;
        switch (imageComponent.getFormat()) {
            case 10: {
                n = 1;
                break;
            }
            case 7: 
            case 8: {
                n = 4;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                n = 5;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n = 6;
            }
        }
        return n;
    }

    protected int getFormat(RenderedImage renderedImage) {
        int n = 0;
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            switch (bufferedImage.getType()) {
                case 1: 
                case 4: 
                case 5: 
                case 12: {
                    n = 1;
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    n = 2;
                    break;
                }
                case 10: 
                case 11: {
                    n = 10;
                    break;
                }
                case 13: {
                    ColorModel colorModel = bufferedImage.getColorModel();
                    if (colorModel.hasAlpha()) {
                        n = 2;
                        break;
                    }
                    n = 1;
                    break;
                }
                case 9: {
                    n = 3;
                    break;
                }
                case 8: {
                    n = 3;
                    break;
                }
                default: {
                    System.out.println("Unknown FORMAT for image: " + bufferedImage);
                    break;
                }
            }
        } else {
            System.out.println("RenderedImage assumed to be RGBA: " + renderedImage);
            n = 2;
        }
        return n;
    }

    protected boolean containsAlpha(RenderedImage renderedImage) {
        boolean bl = false;
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            ColorModel colorModel = bufferedImage.getColorModel();
            bl = colorModel.hasAlpha();
        } else if (renderedImage instanceof RenderedImage) {
            System.out.println("RenderedImage assumed to be RGBA");
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private int getMode(RenderedImage renderedImage, boolean bl) {
        int n;
        boolean bl2 = false;
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            switch (bufferedImage.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    n = 0;
                    bl = true;
                    break;
                }
                case 10: 
                case 11: {
                    n = 0;
                    break;
                }
                default: {
                    System.out.println("Unknown FORMAT for image: " + bufferedImage);
                    n = 0;
                    bl = true;
                    break;
                }
            }
        } else if (renderedImage instanceof RenderedImage) {
            System.out.println("RenderedImage assumed to be RGBA");
            n = 0;
            bl = true;
        } else {
            n = 0;
            bl = true;
        }
        if (bl && this.vfMaterial != null) {
            this.vfMaterial.setIgnoreDiffuse(bl);
        }
        return n;
    }

    private void updateTransparencyState() {
        if (this.textureAlpha || this.materialTransparency > 0.0f) {
            this.implTransp.setTransparencyMode(2);
        } else {
            this.implTransp.setTransparencyMode(4);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        texGenModeMap.put("SPHERE", new Integer(2));
        texGenModeMap.put("CAMERASPACENORMAL", new Integer(3));
        texGenModeMap.put("CAMERASPACEREFLECTIONVECTOR", new Integer(4));
    }
}

