/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.shape;

import java.util.Map;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.shape.BaseLineProperties;
import org.web3d.vrml.renderer.j3d.nodes.J3DLinePropertiesNodeType;

public class J3DLineProperties
extends BaseLineProperties
implements J3DLinePropertiesNodeType {
    private static final int J3D_DASH_DOT_DOT = 117;
    private static final int J3D_SINGLE_DOT = 85;
    private LineAttributes j3dAttribs;

    public J3DLineProperties() {
        this.init();
    }

    public J3DLineProperties(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public LineAttributes getLineAttributes() {
        return this.j3dAttribs;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.j3dAttribs;
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        if (bl) {
            return;
        }
        this.j3dAttribs.setCapability(1);
        this.j3dAttribs.setCapability(3);
    }

    protected void setLineWidthScale(float f) throws InvalidFieldValueException {
        super.setLineWidthScale(f);
        this.j3dAttribs.setLineWidth(this.vfLinewidthScaleFactor);
    }

    protected void setLineType(int n) throws InvalidFieldValueException {
        super.setLineType(n);
        switch (n) {
            case 1: {
                this.j3dAttribs.setLinePattern(0);
                break;
            }
            case 2: {
                this.j3dAttribs.setLinePattern(1);
                break;
            }
            case 3: {
                this.j3dAttribs.setLinePattern(2);
                break;
            }
            case 4: {
                this.j3dAttribs.setLinePattern(3);
                break;
            }
            case 5: {
                this.j3dAttribs.setLinePattern(4);
                this.j3dAttribs.setPatternMask(117);
                break;
            }
            case 6: {
                System.out.println("J3D cannot handle this line style: 6");
                break;
            }
            case 7: {
                this.j3dAttribs.setLinePattern(4);
                this.j3dAttribs.setPatternMask(85);
                break;
            }
            default: {
                System.out.println("J3D cannot handle this line style: " + n);
            }
        }
    }

    private void init() {
        this.j3dAttribs = new LineAttributes();
    }
}

