/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.shape;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.Material;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.shape.BaseMaterial;
import org.web3d.vrml.renderer.j3d.nodes.J3DGlobalStatus;
import org.web3d.vrml.renderer.j3d.nodes.J3DMaterialNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DTransparencyListener;

public class J3DMaterial
extends BaseMaterial
implements J3DMaterialNodeType {
    private static Color3f ignoreColor = new Color3f(1.0f, 1.0f, 1.0f);
    private Material j3dImplNode;
    private Color3f ambColor;
    private Color3f diffuseColor;
    private Color3f emissiveColor;
    private Color3f specularColor;
    private ArrayList listenerList;
    static /* synthetic */ Class class$javax$media$j3d$Material;

    public J3DMaterial() {
        this.init();
    }

    public J3DMaterial(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Material getMaterial() {
        return this.j3dImplNode;
    }

    public void addTransparencyListener(J3DTransparencyListener j3DTransparencyListener) {
        if (!this.listenerList.contains(j3DTransparencyListener)) {
            this.listenerList.add(j3DTransparencyListener);
        }
    }

    public void removeTransparencyListener(J3DTransparencyListener j3DTransparencyListener) {
        this.listenerList.remove(j3DTransparencyListener);
    }

    public void setLightingEnable(boolean bl) {
        this.j3dImplNode.setLightingEnable(bl);
    }

    public void setAmbientIntensity(float f) throws InvalidFieldValueException {
        super.setAmbientIntensity(f);
        this.ambColor.set(this.vfAmbientIntensity * this.vfDiffuseColor[0], this.vfAmbientIntensity * this.vfDiffuseColor[1], this.vfAmbientIntensity * this.vfDiffuseColor[2]);
        this.j3dImplNode.setAmbientColor(this.ambColor);
    }

    public void setDiffuseColor(float[] fArray) throws InvalidFieldValueException {
        super.setDiffuseColor(fArray);
        this.diffuseColor.x = this.vfDiffuseColor[0];
        this.diffuseColor.y = this.vfDiffuseColor[1];
        this.diffuseColor.z = this.vfDiffuseColor[2];
        this.ambColor.set(this.vfAmbientIntensity * this.vfDiffuseColor[0], this.vfAmbientIntensity * this.vfDiffuseColor[1], this.vfAmbientIntensity * this.vfDiffuseColor[2]);
        this.j3dImplNode.setAmbientColor(this.ambColor);
        if (this.ignoreDiffuse) {
            this.j3dImplNode.setDiffuseColor(ignoreColor);
        } else {
            this.j3dImplNode.setDiffuseColor(this.diffuseColor);
        }
    }

    public void setIgnoreDiffuse(boolean bl) {
        super.setIgnoreDiffuse(bl);
        if (this.inSetup) {
            return;
        }
        if (this.ignoreDiffuse) {
            this.j3dImplNode.setDiffuseColor(ignoreColor);
        } else {
            this.j3dImplNode.setDiffuseColor(this.diffuseColor);
        }
    }

    public void setEmissiveColor(float[] fArray) throws InvalidFieldValueException {
        super.setEmissiveColor(fArray);
        this.emissiveColor.x = this.vfEmissiveColor[0];
        this.emissiveColor.y = this.vfEmissiveColor[1];
        this.emissiveColor.z = this.vfEmissiveColor[2];
        this.j3dImplNode.setEmissiveColor(this.emissiveColor);
    }

    public void setShininess(float f) throws InvalidFieldValueException {
        super.setShininess(f);
        float f2 = this.vfShininess * 127.0f + 1.0f;
        this.j3dImplNode.setShininess(f2);
    }

    public void setSpecularColor(float[] fArray) throws InvalidFieldValueException {
        super.setSpecularColor(fArray);
        this.specularColor.x = this.vfSpecularColor[0];
        this.specularColor.y = this.vfSpecularColor[1];
        this.specularColor.z = this.vfSpecularColor[2];
        this.j3dImplNode.setSpecularColor(this.specularColor);
    }

    public void setTransparency(float f) throws InvalidFieldValueException {
        super.setTransparency(f);
        if (!this.inSetup) {
            int n = this.listenerList.size();
            for (int i = 0; i < n; ++i) {
                J3DTransparencyListener j3DTransparencyListener = (J3DTransparencyListener)this.listenerList.get(i);
                j3DTransparencyListener.transparencyChanged(f);
            }
        }
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null && map.containsKey(class$javax$media$j3d$Material == null ? (class$javax$media$j3d$Material = J3DMaterial.class$("javax.media.j3d.Material")) : class$javax$media$j3d$Material)) {
            nArray = (int[])map.get(class$javax$media$j3d$Material == null ? (class$javax$media$j3d$Material = J3DMaterial.class$("javax.media.j3d.Material")) : class$javax$media$j3d$Material);
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.j3dImplNode.clearCapability(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.j3dImplNode.clearCapability(1);
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null || !map2.containsKey(class$javax$media$j3d$Material == null ? (class$javax$media$j3d$Material = J3DMaterial.class$("javax.media.j3d.Material")) : class$javax$media$j3d$Material)) {
            return;
        }
        nArray = (int[])map2.get(class$javax$media$j3d$Material == null ? (class$javax$media$j3d$Material = J3DMaterial.class$("javax.media.j3d.Material")) : class$javax$media$j3d$Material);
        int n4 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.j3dImplNode.clearCapabilityIsFrequent(nArray[n]);
            }
        } else if (!this.isStatic) {
            this.j3dImplNode.clearCapabilityIsFrequent(1);
        }
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null) {
            nArray = (int[])map.get(class$javax$media$j3d$Material == null ? (class$javax$media$j3d$Material = J3DMaterial.class$("javax.media.j3d.Material")) : class$javax$media$j3d$Material);
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.j3dImplNode.setCapability(nArray[n]);
                }
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        nArray = (int[])map2.get(class$javax$media$j3d$Material == null ? (class$javax$media$j3d$Material = J3DMaterial.class$("javax.media.j3d.Material")) : class$javax$media$j3d$Material);
        int n4 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.j3dImplNode.setCapabilityIsFrequent(nArray[n]);
            }
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.j3dImplNode;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.ambColor.set(this.vfAmbientIntensity * this.vfDiffuseColor[0], this.vfAmbientIntensity * this.vfDiffuseColor[1], this.vfAmbientIntensity * this.vfDiffuseColor[2]);
        this.diffuseColor.x = this.vfDiffuseColor[0];
        this.diffuseColor.y = this.vfDiffuseColor[1];
        this.diffuseColor.z = this.vfDiffuseColor[2];
        this.emissiveColor.x = this.vfEmissiveColor[0];
        this.emissiveColor.y = this.vfEmissiveColor[1];
        this.emissiveColor.z = this.vfEmissiveColor[2];
        this.specularColor.x = this.vfSpecularColor[0];
        this.specularColor.y = this.vfSpecularColor[1];
        this.specularColor.z = this.vfSpecularColor[2];
        this.j3dImplNode.setDiffuseColor(this.diffuseColor);
        this.j3dImplNode.setEmissiveColor(this.emissiveColor);
        this.j3dImplNode.setSpecularColor(this.specularColor);
        this.j3dImplNode.setAmbientColor(this.ambColor);
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        this.j3dImplNode.setCapability(1);
        if (bl) {
            return;
        }
    }

    private void init() {
        float f = 0.16000001f;
        float f2 = this.vfShininess * 127.0f + 1.0f;
        this.ambColor = new Color3f(f, f, f);
        this.diffuseColor = new Color3f(0.8f, 0.8f, 0.8f);
        this.emissiveColor = new Color3f(0.0f, 0.0f, 0.0f);
        this.specularColor = new Color3f(0.0f, 0.0f, 0.0f);
        this.listenerList = new ArrayList();
        this.j3dImplNode = new Material(this.ambColor, this.emissiveColor, this.diffuseColor, this.specularColor, f2);
        if (this.ignoreDiffuse) {
            this.j3dImplNode.setDiffuseColor(ignoreColor);
        }
        this.j3dImplNode.setLightingEnable(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

