/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.shape;

import java.util.Map;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLAppearanceNodeType;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTextNodeType;
import org.web3d.vrml.renderer.common.nodes.shape.BaseShape;
import org.web3d.vrml.renderer.j3d.nodes.J3DAppearanceListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DAppearanceNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DGlobalStatus;
import org.web3d.vrml.renderer.j3d.nodes.J3DPickableTargetNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DTerrainSource;
import org.web3d.vrml.renderer.j3d.nodes.J3DTextNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;

public class J3DShape
extends BaseShape
implements J3DVRMLNode,
J3DGeometryListener,
J3DAppearanceListener,
J3DPickableTargetNodeType {
    private Shape3D impl;
    private SharedGroup implSG;
    private BranchGroup implBG;
    private int geomCount;
    private Appearance proxyAppearance;
    private PolygonAttributes proxyPolyAttr;
    static /* synthetic */ Class class$javax$media$j3d$Shape3D;
    static /* synthetic */ Class class$javax$media$j3d$BranchGroup;
    static /* synthetic */ Class class$javax$media$j3d$SharedGroup;

    public J3DShape() {
        this.init();
    }

    public J3DShape(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void appearanceChanged(Appearance appearance) {
        J3DAppearanceNodeType j3DAppearanceNodeType = (J3DAppearanceNodeType)this.vfAppearance;
        if (this.vfAppearance != null) {
            if (this.vfGeometry != null) {
                J3DGeometryNodeType j3DGeometryNodeType = (J3DGeometryNodeType)this.vfGeometry;
                int n = ((J3DGeometryNodeType)this.vfGeometry).getNumSets();
                for (int i = 0; i < n; ++i) {
                    j3DAppearanceNodeType.setTexCoordGenMode(i, ((J3DGeometryNodeType)this.vfGeometry).getTexCoordGenMode(i));
                }
            }
            j3DAppearanceNodeType.addAppearanceListener(this);
            this.impl.setAppearance(j3DAppearanceNodeType.getAppearance());
        } else {
            this.impl.setAppearance(null);
        }
    }

    public void geometryAdded(int[] nArray) {
        J3DGeometryNodeType j3DGeometryNodeType = (J3DGeometryNodeType)this.vfGeometry;
        Geometry[] geometryArray = j3DGeometryNodeType.getGeometry();
        for (int i = 0; i < nArray.length; ++i) {
            this.impl.insertGeometry(geometryArray[nArray[i]], nArray[i]);
        }
        this.geomCount = geometryArray.length;
    }

    public void geometryChanged(int[] nArray) {
        int n;
        J3DGeometryNodeType j3DGeometryNodeType = (J3DGeometryNodeType)this.vfGeometry;
        Geometry[] geometryArray = j3DGeometryNodeType.getGeometry();
        int n2 = n = nArray == null ? geometryArray.length : nArray.length;
        if (nArray == null) {
            if (geometryArray == null) {
                this.impl.setGeometry(null);
            } else {
                this.impl.setGeometry(geometryArray[0]);
            }
        } else {
            for (int i = 0; i < geometryArray.length; ++i) {
                this.impl.setGeometry(geometryArray[nArray[i]], nArray[i]);
            }
        }
        J3DAppearanceNodeType j3DAppearanceNodeType = (J3DAppearanceNodeType)this.vfAppearance;
        if (j3DAppearanceNodeType != null && this.vfGeometry instanceof VRMLTextNodeType) {
            j3DAppearanceNodeType.setAlphaTexture(((J3DTextNodeType)this.vfGeometry).getTextTexture());
        }
        this.geomCount = geometryArray.length;
    }

    public void geometryRemoved(int[] nArray) {
        if (nArray == null) {
            int n = this.geomCount;
            while (--n > 0) {
                this.impl.removeGeometry(n);
            }
        } else {
            int n = nArray.length;
            while (--n > 0) {
                this.impl.removeGeometry(nArray[n]);
            }
        }
    }

    public void setAppearance(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setAppearance(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        this.checkForProxy();
        this.createAppearance();
    }

    public void setGeometry(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        J3DGeometryNodeType j3DGeometryNodeType = (J3DGeometryNodeType)this.vfGeometry;
        super.setGeometry(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        if (j3DGeometryNodeType != null) {
            int n = this.geomCount;
            while (--n > 0) {
                this.impl.removeGeometry(n);
            }
            j3DGeometryNodeType.removeGeometryListener(this);
        }
        this.createGeometry();
    }

    public Group getPickableGroup() {
        return this.implBG;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null) {
            if (map.containsKey(class$javax$media$j3d$Shape3D == null ? (class$javax$media$j3d$Shape3D = J3DShape.class$("javax.media.j3d.Shape3D")) : class$javax$media$j3d$Shape3D)) {
                nArray = (int[])map.get(class$javax$media$j3d$Shape3D == null ? (class$javax$media$j3d$Shape3D = J3DShape.class$("javax.media.j3d.Shape3D")) : class$javax$media$j3d$Shape3D);
                int n3 = n2 = nArray == null ? 0 : nArray.length;
                if (n2 != 0) {
                    for (n = 0; n < n2; ++n) {
                        this.impl.clearCapability(nArray[n]);
                    }
                } else if (!this.isStatic) {
                    this.impl.clearCapability(12);
                    this.impl.clearCapability(13);
                    this.impl.clearCapability(15);
                    this.impl.clearCapability(3);
                }
            }
            if (map.containsKey(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DShape.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup)) {
                nArray = (int[])map.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DShape.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
                int n4 = n2 = nArray == null ? 0 : nArray.length;
                if (n2 != 0) {
                    for (n = 0; n < n2; ++n) {
                        this.implBG.clearCapability(nArray[n]);
                    }
                } else if (!this.isStatic) {
                    this.implBG.clearCapability(17);
                }
            }
            if (map.containsKey(class$javax$media$j3d$SharedGroup == null ? (class$javax$media$j3d$SharedGroup = J3DShape.class$("javax.media.j3d.SharedGroup")) : class$javax$media$j3d$SharedGroup)) {
                nArray = (int[])map.get(class$javax$media$j3d$SharedGroup == null ? (class$javax$media$j3d$SharedGroup = J3DShape.class$("javax.media.j3d.SharedGroup")) : class$javax$media$j3d$SharedGroup);
                int n5 = n2 = nArray == null ? 0 : nArray.length;
                if (n2 != 0) {
                    for (n = 0; n < n2; ++n) {
                        this.implSG.clearCapability(nArray[n]);
                    }
                }
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        if (map2.containsKey(class$javax$media$j3d$Shape3D == null ? (class$javax$media$j3d$Shape3D = J3DShape.class$("javax.media.j3d.Shape3D")) : class$javax$media$j3d$Shape3D)) {
            nArray = (int[])map2.get(class$javax$media$j3d$Shape3D == null ? (class$javax$media$j3d$Shape3D = J3DShape.class$("javax.media.j3d.Shape3D")) : class$javax$media$j3d$Shape3D);
            int n6 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.impl.clearCapabilityIsFrequent(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.impl.clearCapabilityIsFrequent(12);
                this.impl.clearCapabilityIsFrequent(13);
                this.impl.clearCapabilityIsFrequent(15);
                this.impl.clearCapabilityIsFrequent(3);
            }
        }
        if (map2.containsKey(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DShape.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup)) {
            nArray = (int[])map2.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DShape.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
            int n7 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implBG.clearCapabilityIsFrequent(nArray[n]);
                }
            } else if (!this.isStatic) {
                this.implBG.clearCapabilityIsFrequent(17);
            }
        }
        if (map2.containsKey(class$javax$media$j3d$SharedGroup == null ? (class$javax$media$j3d$SharedGroup = J3DShape.class$("javax.media.j3d.SharedGroup")) : class$javax$media$j3d$SharedGroup)) {
            nArray = (int[])map2.get(class$javax$media$j3d$SharedGroup == null ? (class$javax$media$j3d$SharedGroup = J3DShape.class$("javax.media.j3d.SharedGroup")) : class$javax$media$j3d$SharedGroup);
            int n8 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implSG.clearCapabilityIsFrequent(nArray[n]);
                }
            }
        }
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
        int n;
        int n2;
        int[] nArray;
        if (map != null) {
            nArray = (int[])map.get(class$javax$media$j3d$Shape3D == null ? (class$javax$media$j3d$Shape3D = J3DShape.class$("javax.media.j3d.Shape3D")) : class$javax$media$j3d$Shape3D);
            int n3 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.impl.setCapability(nArray[n]);
                }
            }
            nArray = (int[])map.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DShape.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
            int n4 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implBG.setCapability(nArray[n]);
                }
            }
            nArray = (int[])map.get(class$javax$media$j3d$SharedGroup == null ? (class$javax$media$j3d$SharedGroup = J3DShape.class$("javax.media.j3d.SharedGroup")) : class$javax$media$j3d$SharedGroup);
            int n5 = n2 = nArray == null ? 0 : nArray.length;
            if (n2 != 0) {
                for (n = 0; n < n2; ++n) {
                    this.implSG.setCapability(nArray[n]);
                }
            }
        }
        if (!J3DGlobalStatus.haveFreqBitsAPI || map2 == null) {
            return;
        }
        nArray = (int[])map2.get(class$javax$media$j3d$Shape3D == null ? (class$javax$media$j3d$Shape3D = J3DShape.class$("javax.media.j3d.Shape3D")) : class$javax$media$j3d$Shape3D);
        int n6 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.impl.setCapabilityIsFrequent(nArray[n]);
            }
        }
        nArray = (int[])map2.get(class$javax$media$j3d$BranchGroup == null ? (class$javax$media$j3d$BranchGroup = J3DShape.class$("javax.media.j3d.BranchGroup")) : class$javax$media$j3d$BranchGroup);
        int n7 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.implBG.setCapabilityIsFrequent(nArray[n]);
            }
        }
        nArray = (int[])map2.get(class$javax$media$j3d$SharedGroup == null ? (class$javax$media$j3d$SharedGroup = J3DShape.class$("javax.media.j3d.SharedGroup")) : class$javax$media$j3d$SharedGroup);
        int n8 = n2 = nArray == null ? 0 : nArray.length;
        if (n2 != 0) {
            for (n = 0; n < n2; ++n) {
                this.implSG.setCapabilityIsFrequent(nArray[n]);
            }
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implSG;
    }

    public void setVersion(int n, int n2, boolean bl) {
        super.setVersion(n, n2, bl);
        this.impl.setCapability(15);
        this.impl.setCapability(12);
        this.impl.setCapability(3);
        this.impl.clearCapabilityIsFrequent(3);
        if (bl) {
            return;
        }
        this.impl.setCapability(13);
        this.implBG.setCapability(17);
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        boolean bl = false;
        switch (n) {
            case 2: {
                int n2 = vRMLNodeType.getPrimaryType();
                switch (n2) {
                    case 21: 
                    case 58: {
                        this.vfGeometry = (VRMLGeometryNodeType)vRMLNodeType;
                        bl = true;
                        break;
                    }
                    case 38: {
                        int[] nArray = vRMLNodeType.getSecondaryType();
                        for (int i = 0; i < nArray.length; ++i) {
                            if (nArray[i] != 21 && nArray[i] != 58) continue;
                            bl = true;
                            break;
                        }
                        this.pGeometry = (VRMLProtoInstance)vRMLNodeType;
                        this.vfGeometry = (VRMLGeometryNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                    }
                }
                if (!bl) {
                    throw new InvalidFieldValueException("Proto does not describe a Geometry object");
                }
                this.createGeometry();
                break;
            }
            case 1: {
                int n3 = vRMLNodeType.getPrimaryType();
                switch (n3) {
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 38: {
                        int[] nArray = vRMLNodeType.getSecondaryType();
                        for (int i = 0; i < nArray.length; ++i) {
                            if (nArray[i] != 2) continue;
                            bl = true;
                            break;
                        }
                        this.pAppearance = (VRMLProtoInstance)vRMLNodeType;
                        this.vfAppearance = (VRMLAppearanceNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                    }
                }
                if (!bl) {
                    throw new InvalidFieldValueException("Proto does not describe a Appearance object");
                }
                this.createAppearance();
                break;
            }
            default: {
                System.out.println("J3DShape: Unknown field for notifyExternProtoLoaded");
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.createGeometry();
        this.createAppearance();
        this.implBG.setCapability(1);
    }

    private void init() {
        this.impl = new Shape3D();
        this.impl.setPickable(true);
        this.implBG = new BranchGroup();
        this.implBG.addChild((Node)this.impl);
        this.implSG = new SharedGroup();
        this.implSG.addChild((Node)this.implBG);
        this.geomCount = 0;
    }

    private void createAppearance() {
        J3DGeometryNodeType j3DGeometryNodeType;
        J3DAppearanceNodeType j3DAppearanceNodeType = (J3DAppearanceNodeType)this.vfAppearance;
        if (j3DAppearanceNodeType == null) {
            this.checkForProxy();
            this.impl.setAppearance(this.proxyAppearance);
            return;
        }
        j3DAppearanceNodeType.addAppearanceListener(this);
        if (this.vfGeometry != null) {
            j3DGeometryNodeType = (J3DGeometryNodeType)this.vfGeometry;
            int n = ((J3DGeometryNodeType)this.vfGeometry).getNumSets();
            for (int i = 0; i < n; ++i) {
                j3DAppearanceNodeType.setTexCoordGenMode(i, ((J3DGeometryNodeType)this.vfGeometry).getTexCoordGenMode(i));
            }
        }
        j3DAppearanceNodeType.addAppearanceListener(this);
        this.impl.setAppearance(j3DAppearanceNodeType.getAppearance());
        if (this.vfGeometry instanceof J3DTextNodeType) {
            j3DGeometryNodeType = (J3DTextNodeType)this.vfGeometry;
            j3DAppearanceNodeType.setAlphaTexture(j3DGeometryNodeType.getTextTexture());
        } else if (this.vfGeometry instanceof J3DTerrainSource) {
            ((J3DTerrainSource)this.vfGeometry).setAppearance(j3DAppearanceNodeType);
        }
    }

    private void createGeometry() {
        J3DGeometryNodeType j3DGeometryNodeType = (J3DGeometryNodeType)this.vfGeometry;
        if (j3DGeometryNodeType == null) {
            this.impl.setGeometry(null);
            return;
        }
        j3DGeometryNodeType.addGeometryListener(this);
        Geometry[] geometryArray = j3DGeometryNodeType.getGeometry();
        if (geometryArray != null) {
            for (int i = 0; i < geometryArray.length; ++i) {
                this.impl.setGeometry(geometryArray[i], i);
            }
            this.geomCount = geometryArray.length;
        } else {
            this.geomCount = 0;
        }
        if (this.vfAppearance != null) {
            J3DAppearanceNodeType j3DAppearanceNodeType = (J3DAppearanceNodeType)this.vfAppearance;
            int n = j3DGeometryNodeType.getNumSets();
            for (int i = 0; i < n; ++i) {
                j3DAppearanceNodeType.setTexCoordGenMode(i, j3DGeometryNodeType.getTexCoordGenMode(i));
            }
        }
    }

    private void checkForProxy() {
        if (this.vfAppearance == null) {
            this.proxyPolyAttr = new PolygonAttributes();
            this.proxyAppearance = new Appearance();
            this.proxyAppearance.setPolygonAttributes(this.proxyPolyAttr);
            boolean bl = true;
            boolean bl2 = true;
            if (this.vfGeometry != null) {
                bl = this.vfGeometry.isSolid();
                bl2 = this.vfGeometry.isCCW();
            }
            if (!bl) {
                if (bl2) {
                    this.proxyPolyAttr.setCullFace(1);
                    this.proxyPolyAttr.setBackFaceNormalFlip(false);
                } else {
                    this.proxyPolyAttr.setCullFace(2);
                    this.proxyPolyAttr.setBackFaceNormalFlip(true);
                }
            } else {
                this.proxyPolyAttr.setCullFace(0);
                this.proxyPolyAttr.setBackFaceNormalFlip(true);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

