/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.sound;

import java.util.Map;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.ConeSound;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTimeListener;
import org.web3d.vrml.renderer.common.nodes.sound.BaseSound;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;
import org.web3d.vrml.renderer.j3d.nodes.sound.J3DAudioClip;

public class J3DSound
extends BaseSound
implements J3DVRMLNode,
VRMLTimeListener {
    private static final int DISTANCEGAIN_RESOLUTION = 10;
    private ConeSound sound;
    private float[] frontDistance;
    private float[] backDistance;
    private float[] gainRamp;
    private boolean isActive;
    private boolean loop;
    private float pitch;

    public J3DSound() {
        Package package_ = Package.getPackage("javax.media.j3d");
        if (package_ != null && !package_.getImplementationVersion().equals("1.3.1")) {
            System.out.println("WARNING: Sound support is dodgy prior to Java3D 1.3.1");
        }
        this.loop = false;
        this.isActive = false;
        this.pitch = 1.0f;
        this.frontDistance = new float[12];
        this.backDistance = new float[12];
        this.gainRamp = new float[12];
        for (int i = 0; i < 10; ++i) {
            this.gainRamp[i + 1] = 1.0f - (float)i / 10.0f;
        }
        this.gainRamp[0] = 1.0f;
        this.gainRamp[11] = 0.0f;
        this.frontDistance[0] = 0.0f;
        this.backDistance[0] = 0.0f;
        this.frontDistance[11] = Float.POSITIVE_INFINITY;
        this.backDistance[11] = Float.POSITIVE_INFINITY;
        this.sound = new ConeSound();
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        this.sound.setPosition(point3f);
        Point2f[] point2fArray = new Point2f[]{new Point2f(0.0f, 1.0f), new Point2f(1.5f, 1.0f)};
        this.sound.setAngularAttenuation(point2fArray);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this.sound.setSchedulingBounds((Bounds)boundingSphere);
        this.sound.setCapability(13);
        this.sound.setCapability(23);
        this.sound.setCapability(17);
        this.sound.setCapability(33);
        this.sound.setCapability(25);
        this.sound.setCapability(25);
        this.sound.setCapability(30);
        this.sound.setCapability(43);
        this.sound.setCapability(42);
        this.sound.setCapability(19);
        this.sound.setCapability(17);
        this.sound.setCapability(28);
        this.sound.setCapability(45);
        this.sound.setCapability(37);
        this.sound.setCapability(15);
        this.sound.setCapability(35);
        this.sound.setCapability(27);
        this.sound.setCapability(34);
    }

    public J3DSound(VRMLNodeType vRMLNodeType) {
        this();
        this.copy(vRMLNodeType);
    }

    public boolean setDirection(float[] fArray) {
        if (super.setDirection(fArray) && !this.inSetup) {
            this.sound.setDirection(fArray[0], fArray[1], fArray[2]);
            return true;
        }
        return false;
    }

    public boolean setIntensity(float f) {
        if (super.setIntensity(f) && !this.inSetup) {
            this.sound.setInitialGain(f);
            return true;
        }
        return false;
    }

    public boolean setLocation(float[] fArray) {
        if (super.setLocation(fArray) && !this.inSetup) {
            this.sound.setPosition(fArray[0], fArray[1], fArray[2]);
            return true;
        }
        return false;
    }

    public boolean setMaxBack(float f) {
        if (super.setMaxBack(f) && !this.inSetup) {
            this.recomputeGain();
            return true;
        }
        return false;
    }

    public boolean setMaxFront(float f) {
        if (super.setMaxFront(f) && !this.inSetup) {
            this.recomputeGain();
            return true;
        }
        return false;
    }

    public boolean setMinBack(float f) {
        if (super.setMinBack(f) && !this.inSetup) {
            this.recomputeGain();
            return true;
        }
        return false;
    }

    public boolean setMinFront(float f) {
        if (super.setMinFront(f) && !this.inSetup) {
            this.recomputeGain();
            return true;
        }
        return false;
    }

    public boolean setPriority(float f) {
        if (super.setPriority(f)) {
            this.sound.setPriority(f);
            return true;
        }
        return false;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.sound;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public void contentStateChanged(VRMLNodeType vRMLNodeType, int n, int n2) {
        super.contentStateChanged(vRMLNodeType, n, n2);
        if (n2 == 3) {
            J3DAudioClip j3DAudioClip = (J3DAudioClip)this.vfSource;
            MediaContainer mediaContainer = j3DAudioClip.getMediaContainer();
            this.sound.setSoundData(mediaContainer);
            mediaContainer.setCacheEnable(true);
            long l = this.sound.getDuration();
            double d = l == -1L ? -1.0 : (double)l / 1000.0;
            this.vfSource.setDuration(d);
        }
    }

    public void soundStateChanged(VRMLNodeType vRMLNodeType, boolean bl, boolean bl2, float f, double d) {
        if (bl2 != this.loop) {
            this.loop = bl2;
            if (this.isActive) {
                if (!bl2) {
                    this.sound.setLoop(1);
                    this.sound.setReleaseEnable(true);
                    this.sound.setEnable(false);
                }
                this.vrmlClock.addTimeListener((VRMLTimeListener)this);
            }
        }
        if (f != this.pitch) {
            this.pitch = f;
            if (this.isActive) {
                this.sound.setRateScaleFactor(this.pitch);
            }
        }
        if (bl != this.isActive) {
            this.isActive = bl;
            if (bl) {
                if (this.loop) {
                    this.sound.setLoop(950000);
                    if (this.vrmlClock == null) {
                        System.out.println("vrmlClock Null in Sound");
                    } else {
                        this.vrmlClock.addTimeListener((VRMLTimeListener)this);
                    }
                } else {
                    this.sound.setLoop(0);
                    this.vrmlClock.addTimeListener((VRMLTimeListener)this);
                }
                this.soundSetup();
                this.sound.setEnable(true);
            } else {
                this.sound.setReleaseEnable(false);
                this.sound.setEnable(false);
                this.sound.setLoop(0);
                this.vrmlClock.removeTimeListener((VRMLTimeListener)this);
            }
        }
    }

    public void timeClick(long l) {
        boolean bl = this.sound.isPlaying();
        boolean bl2 = this.sound.isPlayingSilently();
        if (!this.sound.isPlaying() && !this.sound.isPlayingSilently()) {
            if (this.loop) {
                this.sound.setLoop(950000);
                this.sound.setEnable(true);
            } else {
                this.vfSource.setIsActive(false);
            }
        }
    }

    private void recomputeGain() {
        float f = this.vfMinFront;
        float f2 = this.vfMaxFront;
        float f3 = this.vfMinBack;
        float f4 = this.vfMaxBack;
        if (f <= f3) {
            f = f3 + 0.1f;
        }
        if (f2 <= f4) {
            f2 = f4 + 0.1f;
        }
        for (int i = 0; i < 10; ++i) {
            float f5 = (float)i / 10.0f;
            this.frontDistance[i + 1] = f + f5 * (f2 - f);
            this.backDistance[i + 1] = f3 + f5 * (f4 - f3);
        }
        this.sound.setDistanceGain(this.frontDistance, this.gainRamp);
        this.sound.setBackDistanceGain(this.backDistance, this.gainRamp);
    }

    private void soundSetup() {
        this.sound.setDirection(this.vfDirection[0], this.vfDirection[1], this.vfDirection[2]);
        this.sound.setInitialGain(this.vfIntensity);
        this.sound.setRateScaleFactor(this.pitch);
        this.sound.setPosition(this.vfLocation[0], this.vfLocation[1], this.vfLocation[2]);
        this.recomputeGain();
    }
}

