/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.surface;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.nio.Buffer;
import java.util.Map;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import org.j3d.renderer.java3d.overlay.InteractiveTextureOverlay;
import org.j3d.renderer.java3d.overlay.Overlay;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.nodes.VRMLTextureListener;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.renderer.common.nodes.shape.TextureStage;
import org.web3d.vrml.renderer.common.nodes.surface.BaseImage2D;
import org.web3d.vrml.renderer.j3d.nodes.J3DOverlayItemNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DTextureConstConverter;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;

public class J3DImage2D
extends BaseImage2D
implements J3DOverlayItemNodeType,
VRMLTextureListener,
VRMLTimeDependentNodeType,
MouseListener,
MouseMotionListener {
    private InteractiveTextureOverlay overlay;
    private VRMLTexture2DNodeType jTexture;
    private VRMLClock vrmlClock;

    public J3DImage2D() {
    }

    public J3DImage2D(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.overlay.addMouseListener((MouseListener)this);
            this.overlay.addMouseMotionListener((MouseMotionListener)this);
        } else {
            this.overlay.removeMouseListener((MouseListener)this);
            this.overlay.removeMouseMotionListener((MouseMotionListener)this);
        }
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.vrmlClock = vRMLClock;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.overlay != null) {
            this.overlay.setVisible(bl && this.parentVisibility);
        }
    }

    public void setParentVisible(boolean bl) {
        super.setParentVisible(bl);
        if (this.overlay != null) {
            if (!this.parentVisibility) {
                this.overlay.setVisible(false);
            } else if (this.vfVisible) {
                this.overlay.setVisible(true);
            }
        }
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        if (!this.inSetup) {
            this.overlay.setLocation(n, n2);
        }
    }

    public void textureImplChanged(VRMLTextureNodeType vRMLTextureNodeType, Texture[] textureArray, boolean[] blArray, TextureAttributes[] textureAttributesArray) {
        if (this.inSetup) {
            return;
        }
        int n = textureArray[0].getWidth();
        int n2 = textureArray[0].getHeight();
        this.overlay.setSize(n, n2);
        this.overlay.setTexture((Texture2D)textureArray[0]);
        this.overlay.setVisible(this.vfVisible && this.parentVisibility);
        if (this.vfBboxSize[0] == -1.0f) {
            this.screenBounds.width = n;
        }
        if (this.vfBboxSize[1] == -1.0f) {
            this.screenBounds.height = n2;
        }
        if (this.vfBboxSize[0] == -1.0f || this.vfBboxSize[1] == -1.0f) {
            this.fireSizeChange(this.screenBounds.width, this.screenBounds.height);
        }
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, RenderedImage renderedImage, String string) {
        Texture texture = this.createTexture((VRMLTextureNodeType)vRMLNodeType, renderedImage);
        if (texture == null) {
            return;
        }
        int n2 = texture.getWidth();
        int n3 = texture.getHeight();
        this.overlay.setSize(n2, n3);
        this.overlay.setTexture((Texture2D)texture);
        this.overlay.setVisible(this.vfVisible && this.parentVisibility);
        if (this.vfBboxSize[0] == -1.0f) {
            this.screenBounds.width = n2;
        }
        if (this.vfBboxSize[1] == -1.0f) {
            this.screenBounds.height = n3;
        }
        if (this.vfBboxSize[0] == -1.0f || this.vfBboxSize[1] == -1.0f) {
            this.fireSizeChange(this.screenBounds.width, this.screenBounds.height);
        }
        System.out.println("Image2D not setup well for dynamic changes");
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, RenderedImage[] renderedImageArray, String[] stringArray) {
        Texture texture = this.createTexture((VRMLTextureNodeType)vRMLNodeTypeArray[0], renderedImageArray[0]);
        int n2 = texture.getWidth();
        int n3 = texture.getHeight();
        this.overlay.setSize(n2, n3);
        this.overlay.setTexture((Texture2D)texture);
        this.overlay.setVisible(this.vfVisible && this.parentVisibility);
        if (this.vfBboxSize[0] == -1.0f) {
            this.screenBounds.width = n2;
        }
        if (this.vfBboxSize[1] == -1.0f) {
            this.screenBounds.height = n3;
        }
        if (this.vfBboxSize[0] == -1.0f || this.vfBboxSize[1] == -1.0f) {
            this.fireSizeChange(this.screenBounds.width, this.screenBounds.height);
        }
        System.out.println("Image2D not setup well for dynamic changes");
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, Buffer buffer, String string) {
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, Buffer[] bufferArray, String[] stringArray) {
    }

    public void textureParamsChanged(int n, int n2, int n3, int n4, float f, float[] fArray) {
    }

    public void textureParamsChanged(int n, int[] nArray, int[] nArray2, int[] nArray3, float f, float[] fArray) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.vfIsActive = true;
        this.hasChanged[5] = true;
        this.fireFieldChanged(5);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.vfIsActive = false;
        this.vfTouchTime = this.vrmlClock.getTime();
        this.hasChanged[5] = true;
        this.hasChanged[8] = true;
        this.fireFieldChanged(5);
        this.fireFieldChanged(8);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.vfTouchTime = this.vrmlClock.getTime();
        this.hasChanged[8] = true;
        this.fireFieldChanged(8);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.vfIsOver = true;
        this.hasChanged[7] = true;
        this.fireFieldChanged(7);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.vfIsOver = false;
        this.hasChanged[7] = true;
        this.fireFieldChanged(7);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.vfTrackPoint[0] = mouseEvent.getX();
        this.vfTrackPoint[1] = mouseEvent.getY();
        if (this.vfWindowRelative) {
            this.vfTrackPoint[0] = this.vfTrackPoint[0] + this.screenLocation[0];
            this.vfTrackPoint[1] = this.vfTrackPoint[1] + this.screenLocation[1];
        }
        this.hasChanged[9] = true;
        this.fireFieldChanged(9);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.vfTrackPoint[0] = mouseEvent.getX();
        this.vfTrackPoint[1] = mouseEvent.getY();
        if (this.vfWindowRelative) {
            this.vfTrackPoint[0] = this.vfTrackPoint[0] + this.screenLocation[0];
            this.vfTrackPoint[1] = this.vfTrackPoint[1] + this.screenLocation[1];
        }
        this.hasChanged[9] = true;
        this.fireFieldChanged(9);
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public void setupFinished() {
        Object object;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        Dimension dimension = new Dimension();
        Texture2D texture2D = null;
        this.overlay = new InteractiveTextureOverlay(null, dimension, texture2D);
        this.overlay.initialize();
        if (this.jTexture != null && (object = this.createTexture((VRMLTextureNodeType)this.jTexture, null)) != null) {
            this.overlay.setTexture((Texture2D)object);
        }
        if (this.jTexture == null) {
            this.overlay.setVisible(false);
        } else {
            this.overlay.setVisible(this.vfVisible && this.parentVisibility);
        }
        if (this.vfEnabled) {
            this.overlay.addMouseListener((MouseListener)this);
            this.overlay.addMouseMotionListener((MouseMotionListener)this);
        }
        if (this.vfBboxSize[0] == -1.0f && this.vfBboxSize[1] == -1.0f) {
            object = this.overlay.getBounds();
            this.screenBounds.setBounds((Rectangle)object);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.overlay.getRoot();
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    protected void setTextureNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType != null && !(vRMLNodeType instanceof J3DVRMLNode)) {
            throw new InvalidFieldValueException("Texture not a J3D node");
        }
        super.setTextureNode(vRMLNodeType);
        if (this.jTexture != null) {
            this.jTexture.removeTextureListener((VRMLTextureListener)this);
        }
        this.jTexture = this.vfTexture;
        this.jTexture.addTextureListener((VRMLTextureListener)this);
        if (this.inSetup) {
            return;
        }
        Texture texture = this.createTexture((VRMLTextureNodeType)this.jTexture, null);
        if (texture == null) {
            return;
        }
        this.overlay.setTexture((Texture2D)texture);
        int n = texture.getWidth();
        int n2 = texture.getHeight();
        if (this.vfBboxSize[0] == -1.0f) {
            this.screenBounds.width = n;
        }
        if (this.vfBboxSize[1] == -1.0f) {
            this.screenBounds.height = n2;
        }
        if (this.vfBboxSize[0] == -1.0f || this.vfBboxSize[1] == -1.0f) {
            this.fireSizeChange(this.screenBounds.width, this.screenBounds.height);
        }
    }

    private Texture createTexture(VRMLTextureNodeType vRMLTextureNodeType, RenderedImage renderedImage) {
        int n;
        int n2 = vRMLTextureNodeType.getTextureType();
        RenderedImage[] renderedImageArray = null;
        switch (n2) {
            case 0: {
                RenderedImage renderedImage2 = renderedImage != null ? renderedImage : ((VRMLTexture2DNodeType)vRMLTextureNodeType).getImage();
                if (renderedImage2 == null) break;
                renderedImageArray = new RenderedImage[]{renderedImage2};
                break;
            }
            default: {
                System.out.println("Unsupported Texture type in Image2D: " + n2);
            }
        }
        if (renderedImageArray == null) {
            return null;
        }
        Texture2D texture2D = null;
        int n3 = this.getFormat(renderedImageArray[0]);
        TextureStage textureStage = new TextureStage(0);
        textureStage.images = renderedImageArray;
        textureStage.minFilter = 1;
        textureStage.minFilter = 1;
        int n4 = 0;
        VRMLTexture2DNodeType vRMLTexture2DNodeType = this.jTexture;
        textureStage.boundaryModeS = vRMLTexture2DNodeType.getRepeatS() ? 0 : 1;
        textureStage.boundaryModeT = vRMLTexture2DNodeType.getRepeatT() ? 0 : 1;
        int n5 = textureStage.images.length;
        ImageComponent2D[] imageComponent2DArray = new ImageComponent2D[n5];
        for (n = 0; n < n5; ++n) {
            imageComponent2DArray[n] = new ImageComponent2D(n3, textureStage.images[n], false, textureStage.yUp);
            imageComponent2DArray[n].setCapability(1);
            imageComponent2DArray[n].setCapability(0);
        }
        int n6 = imageComponent2DArray[0].getWidth();
        int n7 = imageComponent2DArray[0].getHeight();
        n4 = this.getTextureFormat((ImageComponent)imageComponent2DArray[0]);
        texture2D = !textureStage.generateMipMaps ? new Texture2D(1, n4, n6, n7) : new Texture2D(2, n4, n6, n7);
        n = J3DTextureConstConverter.convertBoundary(textureStage.boundaryModeS);
        texture2D.setBoundaryModeS(n);
        n = J3DTextureConstConverter.convertBoundary(textureStage.boundaryModeT);
        texture2D.setBoundaryModeT(n);
        n = J3DTextureConstConverter.convertMinFilter(textureStage.minFilter);
        texture2D.setMinFilter(n);
        n = J3DTextureConstConverter.convertMagFilter(textureStage.magFilter);
        texture2D.setMagFilter(n);
        texture2D.setImages((ImageComponent[])imageComponent2DArray);
        texture2D.setCapability(9);
        for (int i = 0; i < n5; ++i) {
            if (!(textureStage.images[i] instanceof BufferedImage)) continue;
            ((BufferedImage)textureStage.images[i]).flush();
        }
        textureStage.images = null;
        return texture2D;
    }

    protected int getTextureFormat(ImageComponent imageComponent) {
        int n = 5;
        switch (imageComponent.getFormat()) {
            case 10: {
                n = 2;
                break;
            }
            case 7: 
            case 8: {
                n = 4;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                n = 5;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n = 6;
            }
        }
        return n;
    }

    protected int getFormat(RenderedImage renderedImage) {
        int n = 0;
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            boolean bl = false;
            ColorModel colorModel = bufferedImage.getColorModel();
            bl = colorModel.hasAlpha();
            switch (bufferedImage.getType()) {
                case 1: 
                case 4: 
                case 5: 
                case 12: {
                    n = 1;
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    n = 2;
                    break;
                }
                case 10: 
                case 11: {
                    n = 10;
                    break;
                }
                case 13: {
                    if (bl) {
                        n = 2;
                        break;
                    }
                    n = 1;
                    break;
                }
                case 9: {
                    n = 3;
                    break;
                }
                case 8: {
                    n = 3;
                    break;
                }
                default: {
                    System.out.println("Unknown FORMAT for image: " + bufferedImage);
                    break;
                }
            }
        } else {
            System.out.println("RenderedImage assumed to be RGBA");
            n = 2;
        }
        return n;
    }
}

