/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.surface;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Map;
import javax.media.j3d.SceneGraphObject;
import org.j3d.renderer.java3d.overlay.LabelOverlay;
import org.j3d.renderer.java3d.overlay.Overlay;
import org.web3d.vrml.nodes.VRMLFontStyleNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.surface.BaseText2D;
import org.web3d.vrml.renderer.common.nodes.text.DefaultFontStyle;
import org.web3d.vrml.renderer.j3d.nodes.J3DOverlayItemNodeType;

public class J3DText2D
extends BaseText2D
implements J3DOverlayItemNodeType {
    private LabelOverlay overlay;

    public J3DText2D() {
    }

    public J3DText2D(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!this.inSetup) {
            this.overlay.setVisible(bl && this.parentVisibility);
        }
    }

    public void setParentVisible(boolean bl) {
        super.setParentVisible(bl);
        if (this.overlay != null) {
            if (!this.parentVisibility) {
                this.overlay.setVisible(false);
            } else if (this.vfVisible) {
                this.overlay.setVisible(true);
            }
        }
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        if (!this.inSetup) {
            this.overlay.setLocation(n, n2);
        }
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        Dimension dimension = null;
        boolean bl = false;
        if (this.screenBounds.width != 0 && this.screenBounds.height != 0) {
            dimension = new Dimension(this.screenBounds.width, this.screenBounds.height);
            bl = true;
        }
        Color color = new Color(this.vfTextColor[0], this.vfTextColor[1], this.vfTextColor[2]);
        Color color2 = new Color(this.vfBackgroundColor[0], this.vfBackgroundColor[1], this.vfBackgroundColor[2], this.vfTransparency);
        VRMLFontStyleNodeType vRMLFontStyleNodeType = this.vfFontStyle == null ? DefaultFontStyle.getDefaultFontStyle() : this.vfFontStyle;
        Font font = vRMLFontStyleNodeType.getFont();
        int n = 0;
        int n2 = 0;
        switch (vRMLFontStyleNodeType.getHorizontalJustification()) {
            case 1: 
            case 4: {
                n = 1;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 2: {
                n = 2;
            }
        }
        switch (vRMLFontStyleNodeType.getVerticalJustification()) {
            case 1: 
            case 4: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 5;
            }
        }
        this.overlay = new LabelOverlay(null, dimension, this.vfString);
        this.overlay.setColor(color);
        this.overlay.setBackgroundColor(color2);
        this.overlay.setAntialiased(ANTIALIAS);
        this.overlay.setVisible(this.vfVisible && this.parentVisibility);
        this.overlay.setFont(font);
        this.overlay.setHorizontalAlignment(n);
        this.overlay.setVerticalAlignment(n2);
        this.overlay.initialize();
        if (this.vfBboxSize[0] == -1.0f && this.vfBboxSize[1] == -1.0f) {
            Rectangle rectangle = this.overlay.getBounds();
            this.screenBounds.setBounds(rectangle);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.overlay.getRoot();
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    protected void updateSurface(int n) {
        if (this.overlay == null) {
            System.out.println("Updating surface with a null no overlay, ignoring");
            return;
        }
        switch (n) {
            case 4: {
                this.overlay.setVisibleLength(-1);
                this.overlay.setText(this.vfString);
                if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f) break;
                Rectangle rectangle = this.overlay.getBounds();
                this.screenBounds.setBounds(rectangle);
                this.fireSizeChange(this.screenBounds.width, this.screenBounds.height);
                break;
            }
            case 5: {
                Color color = new Color(this.vfTextColor[0], this.vfTextColor[1], this.vfTextColor[2]);
                this.overlay.setColor(color);
                break;
            }
            case 6: 
            case 7: {
                Color color = new Color(this.vfBackgroundColor[0], this.vfBackgroundColor[1], this.vfBackgroundColor[2], this.vfTransparency);
                this.overlay.setBackgroundColor(color);
            }
        }
        this.overlay.repaint();
    }
}

