/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.text;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TriangleStripArray;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.text.BaseText;
import org.web3d.vrml.renderer.j3d.nodes.J3DGeometryListener;
import org.web3d.vrml.renderer.j3d.nodes.J3DTextNodeType;

public class J3DText
extends BaseText
implements J3DTextNodeType,
ImageComponent2D.Updater {
    private static final float[] DEFAULT_COORDS = new float[]{-0.0f, -0.5f, 0.0f, 0.9f, -0.5f, 0.0f, -0.0f, 0.5f, 0.0f, 0.9f, 0.5f, 0.0f};
    private static final float[] DEFAULT_TEXCOORDS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] DEFAULT_TEXCOORDS_REV = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    private static final float[] DEFAULT_NORMALS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private static final int[] DEFAULT_STRIPS = new int[]{4};
    private ImageComponent2D imgComponent;
    private Texture2D j3dTexture;
    private TriangleStripArray j3dGeometry;
    private float[] coords;
    private float[] texCoords;
    private float[] texCoords2;
    private ArrayList listeners = new ArrayList();

    public J3DText() {
        super(true);
    }

    public J3DText(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType, true);
    }

    public Texture2D getTextTexture() {
        return this.j3dTexture;
    }

    public Geometry[] getGeometry() {
        Geometry[] geometryArray = new Geometry[]{this.j3dGeometry};
        return geometryArray;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public void addGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.add(j3DGeometryListener);
    }

    public void removeGeometryListener(J3DGeometryListener j3DGeometryListener) {
        if (j3DGeometryListener == null || !this.listeners.contains(j3DGeometryListener)) {
            return;
        }
        this.listeners.remove(j3DGeometryListener);
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.j3dGeometry;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.createString();
    }

    public void updateData(ImageComponent2D imageComponent2D, int n, int n2, int n3, int n4) {
    }

    protected void textUpdated(boolean bl) {
        if (this.inSetup) {
            return;
        }
        if (!bl) {
            this.imgComponent.updateData((ImageComponent2D.Updater)this, 0, 0, this.imgWidth, this.imgHeight);
        } else {
            this.createString();
            this.fireGeometryChanged(null);
        }
    }

    private void createString() {
        int n;
        this.coords = new float[DEFAULT_COORDS.length];
        System.arraycopy(DEFAULT_COORDS, 0, this.coords, 0, DEFAULT_COORDS.length);
        float f = this.vfFontStyle == null ? 1.0f : this.vfFontStyle.getSpacing();
        float f2 = 1.0f + (float)(this.numString - 1) * (1.0f + f);
        float f3 = (float)this.usedPixelWidth / (float)this.imgWidth;
        for (n = 0; n < this.coords.length; ++n) {
            int n2 = n++;
            this.coords[n2] = this.coords[n2] * f3;
            int n3 = n++;
            this.coords[n3] = this.coords[n3] * f2;
        }
        float f4 = (float)this.usedPixelWidth / 30.0f;
        boolean bl = true;
        if (bl) {
            for (n = 0; n < this.coords.length; ++n) {
                int n4 = n++;
                this.coords[n4] = this.coords[n4] * f4;
                int n5 = n++;
                this.coords[n5] = this.coords[n5] * f2;
            }
        }
        float f5 = (float)this.usedPixelWidth / (float)this.imgWidth;
        float f6 = (float)this.usedPixelHeight / (float)this.imgHeight;
        this.texCoords = new float[DEFAULT_TEXCOORDS.length];
        this.texCoords2 = new float[DEFAULT_TEXCOORDS.length];
        if (this.vfFontStyle != null && !this.vfFontStyle.isLeftToRight()) {
            System.arraycopy(DEFAULT_TEXCOORDS_REV, 0, this.texCoords, 0, DEFAULT_TEXCOORDS_REV.length);
            System.arraycopy(DEFAULT_TEXCOORDS, 0, this.texCoords2, 0, DEFAULT_TEXCOORDS_REV.length);
        } else {
            System.arraycopy(DEFAULT_TEXCOORDS, 0, this.texCoords, 0, DEFAULT_TEXCOORDS.length);
            System.arraycopy(DEFAULT_TEXCOORDS, 0, this.texCoords2, 0, DEFAULT_TEXCOORDS.length);
        }
        n = 0;
        while (n < this.texCoords.length) {
            int n6 = n++;
            this.texCoords[n6] = this.texCoords[n6] * f5;
            int n7 = n++;
            this.texCoords[n7] = this.texCoords[n7] * f6;
        }
        int n8 = 35;
        int[] nArray = new int[]{0, 1, 1, 1, 1, 1, 1, 1};
        this.j3dGeometry = new TriangleStripArray(4, n8, 2, nArray, DEFAULT_STRIPS);
        this.j3dGeometry.setCoordinates(0, this.coords);
        this.j3dGeometry.setTextureCoordinates(0, 0, this.texCoords);
        this.j3dGeometry.setTextureCoordinates(1, 0, this.texCoords2);
        this.j3dGeometry.setNormals(0, DEFAULT_NORMALS);
        this.j3dGeometry.setCapability(0);
        this.j3dGeometry.setCapability(17);
        this.j3dGeometry.setCapability(8);
        if (!this.isStatic) {
            this.j3dGeometry.setCapability(1);
            this.j3dGeometry.setCapability(7);
        }
        this.imgComponent = new ImageComponent2D(10, this.texturedImage, true, false);
        this.imgComponent.setCapability(3);
        this.j3dTexture = new Texture2D(1, 3, this.imgWidth, this.imgHeight);
        this.j3dTexture.setImage(0, (ImageComponent)this.imgComponent);
    }

    private void fireGeometryChanged(int[] nArray) {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DGeometryListener j3DGeometryListener = (J3DGeometryListener)this.listeners.get(i);
                j3DGeometryListener.geometryChanged(nArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending geometry change message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

