/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.texture;

import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.j3d.SceneGraphObject;
import org.j3d.renderer.java3d.texture.J3DTextureCache;
import org.j3d.renderer.java3d.texture.J3DTextureCacheFactory;
import org.j3d.util.ImageUtils;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.texture.BaseImageTexture;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;

public class J3DImageTexture
extends BaseImageTexture
implements J3DVRMLNode {
    private static J3DTextureCache cache = J3DTextureCacheFactory.getCache((int)3);

    public J3DImageTexture() {
    }

    public J3DImageTexture(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void setUrl(String[] stringArray, int n) {
        super.setUrl(stringArray, n);
        if (n == 0 && !this.inSetup) {
            this.fireTextureImageChanged(0, this, null, null);
        }
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
        RenderedImage renderedImage;
        if (object == null) {
            return;
        }
        if (cache.checkTexture(this.loadedURI)) {
            this.fireTextureImageChanged(0, this, null, this.loadedURI);
            return;
        }
        if (object instanceof BufferedImage) {
            renderedImage = (RenderedImage)object;
        } else if (object instanceof ImageProducer) {
            renderedImage = ImageUtils.createBufferedImage((ImageProducer)((ImageProducer)object));
            if (renderedImage == null) {
                System.out.println("Failed to create buffered image for: " + this.loadedURI);
                this.fireTextureImageChanged(0, this, null, null);
                return;
            }
        } else {
            System.out.println("Unknown content type: " + object + " URL: " + this.loadedURI);
            this.fireTextureImageChanged(0, this, null, null);
            return;
        }
        this.fireTextureImageChanged(0, this, renderedImage, this.loadedURI);
        this.loadState = 3;
        this.fireContentStateChanged();
    }

    public String getCacheString(int n) {
        return this.loadedURI;
    }

    public SceneGraphObject getSceneGraphObject() {
        return null;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }
}

