/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.texture;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import org.web3d.util.PropertyTools;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.renderer.common.nodes.texture.BaseMovieTexture;
import org.web3d.vrml.renderer.j3d.nodes.J3DVRMLNode;

public class J3DMovieTexture
extends BaseMovieTexture
implements J3DVRMLNode {
    private ArrayList textureListeners = new ArrayList();
    private static final String RESCALE_PROP = "org.web3d.vrml.nodes.loader.rescale";
    private static final int DEFAULT_RESCALE = 2;
    private AffineTransformOp textureRescale;
    private BufferedImage nextFrame;
    private ImageComponent2D textureImageComponent;
    int textureWidth;
    int textureHeight;
    Texture2D textureImpl;
    BufferedImage textureImage;
    Texture[] textureArray;
    TextureAttributes[] textureAttributeArray;
    boolean[] textureAlphaArray;
    boolean firstFrame = true;

    public J3DMovieTexture() {
    }

    public J3DMovieTexture(VRMLNodeType vRMLNodeType) {
        this();
        this.copy(vRMLNodeType);
    }

    public SceneGraphObject getSceneGraphObject() {
        return null;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public void videoStreamFrame(BufferedImage bufferedImage) {
        this.fireTextureImageChanged(0, (VRMLTextureNodeType)this, bufferedImage, null);
    }

    public void videoStreamFormat(int n, int n2) {
        this.textureWidth = J3DMovieTexture.nearestPowerTwo(n);
        this.textureHeight = J3DMovieTexture.nearestPowerTwo(n2);
        this.initScale(n, n2, this.textureWidth, this.textureHeight);
        this.initTexture();
    }

    public void videoStreamStart() {
        super.videoStreamStart();
    }

    public void videoStreamStop() {
        super.videoStreamStop();
    }

    public void allEventsComplete() {
        try {
            this.updateTextureImage(this.nextFrame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private BufferedImage scaleVideoFrame(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = this.textureRescale == null ? bufferedImage : this.textureRescale.filter(bufferedImage, null);
        return bufferedImage2;
    }

    private void initScale(int n, int n2, int n3, int n4) {
        if (n == n3 && n2 == n4) {
            this.textureRescale = null;
        } else {
            double d = (float)n3 / (float)n;
            double d2 = (float)n4 / (float)n2;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(2);
            hashMap.put("BILINEAR", new Integer(2));
            hashMap.put("NEAREST_NEIGBOR", new Integer(1));
            int n5 = PropertyTools.fetchSystemProperty((String)RESCALE_PROP, (int)2, hashMap);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d2);
            this.textureRescale = new AffineTransformOp(affineTransform, n5);
        }
    }

    private void initTexture() {
        this.textureImage = new BufferedImage(this.textureWidth, this.textureHeight, 1);
        this.textureImageComponent = new ImageComponent2D(1, this.textureImage);
        this.textureImageComponent.setCapability(3);
        this.textureImpl = new Texture2D(1, 5, this.textureWidth, this.textureHeight);
        this.textureImpl.setImage(0, (ImageComponent)this.textureImageComponent);
        this.textureImpl.setBoundaryModeS(this.vfRepeatS ? 3 : 2);
        this.textureImpl.setBoundaryModeT(this.vfRepeatT ? 3 : 2);
        this.textureArray = new Texture[]{this.textureImpl};
        this.textureAlphaArray = new boolean[]{false};
        TextureAttributes textureAttributes = new TextureAttributes();
        this.textureAttributeArray = new TextureAttributes[]{textureAttributes};
        this.firstFrame = true;
    }

    private void updateTextureImage(BufferedImage bufferedImage) {
        System.out.println("Updating texture");
        this.textureImageComponent.setSubImage((RenderedImage)bufferedImage, this.textureWidth, this.textureHeight, 0, 0, 0, 0);
    }
}

