/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.texture;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Transform3D;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.texture.BaseMultiTextureTransform;
import org.web3d.vrml.renderer.j3d.nodes.J3DTextureCoordinateTransformNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DTextureTransformListener;

public class J3DMultiTextureTransform
extends BaseMultiTextureTransform
implements J3DTextureCoordinateTransformNodeType,
J3DTextureTransformListener {
    private ArrayList listenerList;

    public J3DMultiTextureTransform() {
        this.init();
    }

    public J3DMultiTextureTransform(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return null;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public void textureTransformChanged(Transform3D[] transform3DArray) {
        this.fireTextureTransformChanged(this.getTransformMatrix());
    }

    public Transform3D[] getTransformMatrix() {
        J3DTextureCoordinateTransformNodeType[] j3DTextureCoordinateTransformNodeTypeArray = new J3DTextureCoordinateTransformNodeType[this.vfTextureTransform.size()];
        this.vfTextureTransform.toArray(j3DTextureCoordinateTransformNodeTypeArray);
        Transform3D[] transform3DArray = new Transform3D[j3DTextureCoordinateTransformNodeTypeArray.length];
        for (int i = 0; i < j3DTextureCoordinateTransformNodeTypeArray.length; ++i) {
            Transform3D[] transform3DArray2 = j3DTextureCoordinateTransformNodeTypeArray[i].getTransformMatrix();
            transform3DArray[i] = transform3DArray2[0];
        }
        return transform3DArray;
    }

    public void addTransformListener(J3DTextureTransformListener j3DTextureTransformListener) {
        if (!this.listenerList.contains(j3DTextureTransformListener)) {
            this.listenerList.add(j3DTextureTransformListener);
        }
    }

    public void removeTransformListener(J3DTextureTransformListener j3DTextureTransformListener) {
        this.listenerList.remove(j3DTextureTransformListener);
    }

    protected void addTextureTransformNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.addTextureTransformNode(vRMLNodeType);
        ((J3DTextureCoordinateTransformNodeType)vRMLNodeType).addTransformListener(this);
    }

    protected void fireTextureTransformChanged(Transform3D[] transform3DArray) {
        int n = this.listenerList.size();
        for (int i = 0; i < n; ++i) {
            try {
                J3DTextureTransformListener j3DTextureTransformListener = (J3DTextureTransformListener)this.listenerList.get(i);
                j3DTextureTransformListener.textureTransformChanged(transform3DArray);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending textureImpl changed message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void init() {
        this.listenerList = new ArrayList();
    }
}

