/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.j3d.nodes.texture;

import java.util.ArrayList;
import java.util.Map;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3d;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.texture.BaseTextureTransform3D;
import org.web3d.vrml.renderer.j3d.nodes.J3DTextureCoordinateTransformNodeType;
import org.web3d.vrml.renderer.j3d.nodes.J3DTextureTransformListener;

public class J3DTextureTransform3D
extends BaseTextureTransform3D
implements J3DTextureCoordinateTransformNodeType {
    private Transform3D j3dImplNode;
    private ArrayList listenerList;
    private Vector3d v1;
    private Vector3d v2;
    private Vector3d v3;
    private Transform3D T;
    private Transform3D C;
    private Transform3D R;
    private Transform3D S;
    private AxisAngle4f al;
    private Transform3D[] changedTransform;

    public J3DTextureTransform3D() {
        this.init();
    }

    public J3DTextureTransform3D(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return null;
    }

    public void setCapabilityOverrideMap(Map map, Map map2) {
    }

    public void setCapabilityRequiredMap(Map map, Map map2) {
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.updateTransform();
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, f);
        if (!this.inSetup) {
            this.updateTransform();
            this.fireTransformChanged();
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, fArray, n2);
        if (!this.inSetup) {
            this.updateTransform();
            this.fireTransformChanged();
        }
    }

    public Transform3D[] getTransformMatrix() {
        return this.changedTransform;
    }

    public void addTransformListener(J3DTextureTransformListener j3DTextureTransformListener) {
        if (!this.listenerList.contains(j3DTextureTransformListener)) {
            this.listenerList.add(j3DTextureTransformListener);
        }
    }

    public void removeTransformListener(J3DTextureTransformListener j3DTextureTransformListener) {
        this.listenerList.remove(j3DTextureTransformListener);
    }

    private void updateTransform() {
        this.v1.set((double)this.vfTranslation[0], (double)this.vfTranslation[1], (double)this.vfTranslation[2]);
        this.T.set(this.v1);
        this.v2.set((double)this.vfCenter[0], (double)this.vfCenter[1], (double)this.vfCenter[2]);
        this.C.set(this.v2);
        this.al.set(this.vfOrientation);
        this.R.setRotation(this.al);
        this.v3.set((double)this.vfScale[0], (double)this.vfScale[1], (double)this.vfScale[2]);
        this.S.setScale(this.v3);
        this.j3dImplNode.setIdentity();
        this.j3dImplNode.mul(this.T);
        this.j3dImplNode.mul(this.C);
        this.j3dImplNode.mul(this.R);
        this.j3dImplNode.mul(this.S);
        this.v2.negate();
        this.C.set(this.v2);
        this.j3dImplNode.mul(this.C);
    }

    private void fireTransformChanged() {
        int n = this.listenerList.size();
        for (int i = 0; i < n; ++i) {
            J3DTextureTransformListener j3DTextureTransformListener = (J3DTextureTransformListener)this.listenerList.get(i);
            try {
                j3DTextureTransformListener.textureTransformChanged(this.changedTransform);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending Texture transform");
                exception.printStackTrace();
            }
        }
    }

    private void init() {
        this.j3dImplNode = new Transform3D();
        this.listenerList = new ArrayList(1);
        this.v1 = new Vector3d();
        this.v2 = new Vector3d();
        this.v3 = new Vector3d();
        this.T = new Transform3D();
        this.C = new Transform3D();
        this.R = new Transform3D();
        this.S = new Transform3D();
        this.al = new AxisAngle4f();
        this.changedTransform = new Transform3D[1];
        this.changedTransform[0] = this.j3dImplNode;
    }
}

