/*
 * Decompiled with CFR 0.152.
 */
package drasys.or;

import drasys.or.ComplexI;

public class Complex
implements ComplexI {
    public double real = 0.0;
    public double imag = 0.0;

    public Complex() {
    }

    public Complex(double d) {
        this.real = d;
    }

    public Complex(double d, double d2) {
        this.real = d;
        this.imag = d2;
    }

    public Complex(ComplexI complexI) {
        this.real = complexI.getReal();
        this.imag = complexI.getImag();
    }

    public Complex add(double d) {
        this.real += d;
        return this;
    }

    public Complex add(double d, double d2) {
        this.real += d;
        this.imag += d2;
        return this;
    }

    public static Complex add(double d, double d2, double d3, double d4, Complex complex) {
        if (complex == null) {
            complex = new Complex();
        }
        complex.real = d + d3;
        complex.imag = d2 + d4;
        return complex;
    }

    public Complex add(ComplexI complexI) {
        this.real += complexI.getReal();
        this.imag += complexI.getImag();
        return this;
    }

    public static Complex add(ComplexI complexI, ComplexI complexI2) {
        Complex complex = new Complex();
        complex.real = complexI.getReal() + complexI2.getReal();
        complex.imag = complexI.getImag() + complexI2.getImag();
        return complex;
    }

    public static Complex add(ComplexI complexI, ComplexI complexI2, Complex complex) {
        if (complex == null) {
            complex = new Complex();
        }
        complex.real = complexI.getReal() + complexI2.getReal();
        complex.imag = complexI.getImag() + complexI2.getImag();
        return complex;
    }

    public Complex conjugate() {
        this.imag = -this.imag;
        return this;
    }

    public Complex divide(double d) {
        return Complex.divide(this.real, this.imag, d, 0.0, this);
    }

    public Complex divide(double d, double d2) {
        return Complex.divide(this.real, this.imag, d, d2, this);
    }

    public static Complex divide(double d, double d2, double d3, double d4, Complex complex) {
        if (complex == null) {
            complex = new Complex();
        }
        double d5 = d3 < 0.0 ? -d3 : d3;
        double d6 = d4 < 0.0 ? -d4 : d4;
        if (d5 >= d6) {
            double d7 = d4 / d3;
            double d8 = d3 + d4 * d7;
            complex.real = (d + d2 * d7) / d8;
            complex.imag = (d2 - d * d7) / d8;
        } else {
            double d9 = d3 / d4;
            double d10 = d3 * d9 + d4;
            complex.real = (d * d9 + d2) / d10;
            complex.imag = (d2 * d9 - d) / d10;
        }
        return complex;
    }

    public Complex divide(ComplexI complexI) {
        return Complex.divide(this.real, this.imag, complexI.getReal(), complexI.getImag(), this);
    }

    public static Complex divide(ComplexI complexI, ComplexI complexI2) {
        return Complex.divide(complexI.getReal(), complexI.getImag(), complexI2.getReal(), complexI2.getImag(), null);
    }

    public static Complex divide(ComplexI complexI, ComplexI complexI2, Complex complex) {
        return Complex.divide(complexI.getReal(), complexI.getImag(), complexI2.getReal(), complexI2.getImag(), complex);
    }

    public boolean equals(double d, double d2) {
        return this.real == d && this.imag == d2;
    }

    public boolean equals(double d, double d2, double d3) {
        return Complex.equals(this.real, this.imag, d, d2, d3);
    }

    public static boolean equals(double d, double d2, double d3, double d4, double d5) {
        double d6;
        if (d == d && d2 == d4) {
            return true;
        }
        if (d5 == 0.0) {
            return false;
        }
        double d7 = d - d3;
        if (d7 < 0.0) {
            d7 = -d7;
        }
        if (d < 0.0) {
            d = -d;
        }
        if (d3 < 0.0) {
            d3 = -d3;
        }
        double d8 = d6 = d > d3 ? d : d3;
        if (d7 > d5 * d6) {
            return false;
        }
        d7 = d2 - d4;
        if (d7 < 0.0) {
            d7 = -d7;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d4 < 0.0) {
            d4 = -d4;
        }
        double d9 = d6 = d2 > d4 ? d2 : d4;
        return !(d7 > d5 * d6);
    }

    public boolean equals(ComplexI complexI) {
        return this.real == complexI.getReal() && this.imag == complexI.getImag();
    }

    public boolean equals(ComplexI complexI, double d) {
        return Complex.equals(this.real, this.imag, complexI.getReal(), complexI.getImag(), d);
    }

    public static boolean equals(ComplexI complexI, ComplexI complexI2, double d) {
        return Complex.equals(complexI.getReal(), complexI.getImag(), complexI2.getReal(), complexI2.getImag(), d);
    }

    public boolean equals(Object object) {
        if (object instanceof ComplexI) {
            return this.equals((ComplexI)object);
        }
        return false;
    }

    public double getImag() {
        return this.imag;
    }

    public double getReal() {
        return this.real;
    }

    public Complex invert() {
        return Complex.invert(this.real, this.imag, this);
    }

    public static Complex invert(double d, double d2, Complex complex) {
        if (complex == null) {
            complex = new Complex();
        }
        double d3 = d < 0.0 ? -d : d;
        double d4 = d2 < 0.0 ? -d2 : d2;
        if (d3 >= d4) {
            double d5 = d2 / d;
            double d6 = d + d2 * d5;
            complex.real = 1.0 / d6;
            complex.imag = -d5 / d6;
        } else {
            double d7 = d / d2;
            double d8 = d * d7 + d2;
            complex.real = d7 / d8;
            complex.imag = -1.0 / d8;
        }
        return complex;
    }

    public static Complex invert(ComplexI complexI) {
        return Complex.invert(complexI, null);
    }

    public static Complex invert(ComplexI complexI, Complex complex) {
        return Complex.invert(complexI.getReal(), complexI.getImag(), complex);
    }

    public double modulus() {
        return Complex.modulus(this.real, this.imag);
    }

    public static double modulus(double d, double d2) {
        double d3;
        double d4 = d < 0.0 ? -d : d;
        double d5 = d3 = d2 < 0.0 ? -d2 : d2;
        if (d4 >= d3) {
            double d6 = d2 / d;
            return d4 * Math.sqrt(1.0 + d6 * d6);
        }
        double d7 = d / d2;
        return d3 * Math.sqrt(1.0 + d7 * d7);
    }

    public static double modulus(ComplexI complexI) {
        return Complex.modulus(complexI.getReal(), complexI.getImag());
    }

    public Complex multiply(double d) {
        return Complex.multiply(this.real, this.imag, d, 0.0, this);
    }

    public Complex multiply(double d, double d2) {
        return Complex.multiply(this.real, this.imag, d, d2, this);
    }

    public static Complex multiply(double d, double d2, double d3, double d4, Complex complex) {
        if (complex == null) {
            complex = new Complex();
        }
        if (d2 == 0.0) {
            complex.real = d * d3;
            complex.imag = d * d4;
        } else if (d4 == 0.0) {
            complex.real = d * d3;
            complex.imag = d3 * d2;
        } else {
            complex.real = d * d3 - d2 * d4;
            complex.imag = d * d4 + d3 * d2;
        }
        return complex;
    }

    public Complex multiply(ComplexI complexI) {
        return Complex.multiply(this.real, this.imag, complexI.getReal(), complexI.getImag(), this);
    }

    public static Complex multiply(ComplexI complexI, ComplexI complexI2) {
        return Complex.multiply(complexI.getReal(), complexI.getImag(), complexI2.getReal(), complexI2.getImag(), null);
    }

    public static Complex multiply(ComplexI complexI, ComplexI complexI2, Complex complex) {
        return Complex.multiply(complexI.getReal(), complexI.getImag(), complexI2.getReal(), complexI2.getImag(), complex);
    }

    public Complex set(double d, double d2) {
        this.real = d;
        this.imag = d2;
        return this;
    }

    public Complex set(ComplexI complexI) {
        this.real = complexI.getReal();
        this.imag = complexI.getImag();
        return this;
    }

    public Complex sqrt() {
        return Complex.sqrt(this.real, this.imag, this);
    }

    public static Complex sqrt(double d, double d2, Complex complex) {
        double d3;
        double d4;
        if (complex == null) {
            complex = new Complex();
        }
        double d5 = d < 0.0 ? -d : d;
        double d6 = d4 = d2 < 0.0 ? -d2 : d2;
        if (d == 0.0 && d2 == 0.0) {
            d3 = 0.0;
        } else if (d5 >= d4) {
            double d7 = d2 / d;
            d3 = Math.sqrt(d5) * Math.sqrt((1.0 + Math.sqrt(1.0 + d7 * d7)) / 2.0);
        } else {
            double d8 = d / d2;
            d3 = Math.sqrt(d4) * Math.sqrt(((d8 < 0.0 ? -d8 : d8) + Math.sqrt(1.0 + d8 * d8)) / 2.0);
        }
        if (d3 == 0.0) {
            complex.real = 0.0;
            complex.imag = 0.0;
        } else if (d >= 0.0) {
            complex.real = d3;
            complex.imag = d2 / (d3 + d3);
        } else if (d2 >= 0.0) {
            complex.real = d4 / (d3 + d3);
            complex.imag = d3;
        } else {
            complex.real = d4 / (d3 + d3);
            complex.imag = -d3;
        }
        return complex;
    }

    public static Complex sqrt(ComplexI complexI) {
        return Complex.sqrt(complexI, null);
    }

    public static Complex sqrt(ComplexI complexI, Complex complex) {
        return Complex.sqrt(complexI.getReal(), complexI.getImag(), complex);
    }

    public Complex subtract(double d) {
        this.real -= d;
        return this;
    }

    public Complex subtract(double d, double d2) {
        this.real -= d;
        this.imag -= d2;
        return this;
    }

    public static Complex subtract(double d, double d2, double d3, double d4, Complex complex) {
        if (complex == null) {
            complex = new Complex();
        }
        complex.real = d - d3;
        complex.imag = d2 - d4;
        return complex;
    }

    public Complex subtract(ComplexI complexI) {
        this.real -= complexI.getReal();
        this.imag -= complexI.getImag();
        return this;
    }

    public static Complex subtract(ComplexI complexI, ComplexI complexI2) {
        Complex complex = new Complex();
        complex.real = complexI.getReal() - complexI2.getReal();
        complex.imag = complexI.getImag() - complexI2.getImag();
        return complex;
    }

    public static Complex subtract(ComplexI complexI, ComplexI complexI2, Complex complex) {
        if (complex == null) {
            complex = new Complex();
        }
        complex.real = complexI.getReal() - complexI2.getReal();
        complex.imag = complexI.getImag() - complexI2.getImag();
        return complex;
    }

    public String toString() {
        return "(" + this.real + ", " + this.imag + ")";
    }
}

