/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.rect2;

import drasys.or.geom.GeomError;
import drasys.or.geom.rect2.LineSegment;
import drasys.or.geom.rect2.Point;
import drasys.or.geom.rect2.PointI;
import drasys.or.geom.rect2.PolygonI;
import drasys.or.geom.rect2.Range;
import drasys.or.geom.rect2.RangeI;
import drasys.or.geom.rect2.Rect2;
import drasys.or.geom.rect2.Rect2I;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Polygon
extends Rect2
implements PolygonI,
Serializable {
    Vector _holes;
    Vector _vertices;

    public Polygon(PointI[] pointIArray) {
        this._holes = new Vector();
        this._vertices = new Vector(pointIArray.length);
        int n = 0;
        while (n < pointIArray.length) {
            this._vertices.addElement(pointIArray[n]);
            ++n;
        }
    }

    public Polygon(PointI[] pointIArray, PolygonI[] polygonIArray) {
        this._holes = new Vector(polygonIArray.length);
        this._vertices = new Vector(pointIArray.length);
        int n = 0;
        while (n < pointIArray.length) {
            this._vertices.addElement(pointIArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < polygonIArray.length) {
            this._holes.addElement(polygonIArray[n2]);
            ++n2;
        }
    }

    public PointI centroid() {
        Enumeration enumeration = this.vertices();
        if (!enumeration.hasMoreElements()) {
            throw new GeomError("There are no vertices");
        }
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        while (enumeration.hasMoreElements()) {
            PointI pointI = (PointI)enumeration.nextElement();
            d += pointI.x();
            d2 += pointI.y();
            ++n;
        }
        return new Point(d / (double)n, d2 / (double)n);
    }

    public double distanceProxyTo(PointI pointI) {
        PointI pointI2 = this.nearestPointTo(pointI);
        return pointI2 == null ? Double.POSITIVE_INFINITY : pointI2.distanceProxyTo(pointI);
    }

    public double distanceTo(PointI pointI) {
        PointI pointI2 = this.nearestPointTo(pointI);
        return pointI2 == null ? Double.POSITIVE_INFINITY : pointI2.distanceTo(pointI);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PolygonI)) {
            return false;
        }
        PolygonI polygonI = (PolygonI)object;
        if (polygonI.sizeOfVertices() != this.sizeOfVertices()) {
            return false;
        }
        if (polygonI.sizeOfHoles() != this.sizeOfHoles()) {
            return false;
        }
        if (Polygon.hashCode(this) != Polygon.hashCode(polygonI)) {
            return false;
        }
        return !(Math.abs(this.length() - polygonI.length()) > this.coordinateSystem().getAccuracy());
    }

    public drasys.or.geom.PointI getPoint(int n) {
        return (drasys.or.geom.PointI)this._vertices.elementAt(n);
    }

    public int hashCode() {
        long l = Polygon.hashCode(this);
        return (int)(l ^ l >> 32);
    }

    private static long hashCode(PolygonI polygonI) {
        Object object;
        long l = 0L;
        Enumeration enumeration = polygonI.vertices();
        while (enumeration.hasMoreElements()) {
            object = (PointI)enumeration.nextElement();
            l += Double.doubleToLongBits(object.x());
            l += Double.doubleToLongBits(object.y());
        }
        object = polygonI.holes();
        while (object.hasMoreElements()) {
            l += Polygon.hashCode((PolygonI)object.nextElement());
        }
        return l;
    }

    public Enumeration holes() {
        return this._holes.elements();
    }

    public double length() {
        double d = 0.0;
        Enumeration enumeration = this.vertices();
        PointI pointI = null;
        PointI pointI2 = enumeration.hasMoreElements() ? (PointI)enumeration.nextElement() : null;
        PointI pointI3 = pointI2;
        while (enumeration.hasMoreElements()) {
            pointI = (PointI)enumeration.nextElement();
            d += pointI2.distanceTo(pointI);
            pointI2 = pointI;
        }
        if (pointI != null) {
            d += pointI.distanceTo(pointI3);
        }
        Enumeration enumeration2 = this.holes();
        while (enumeration2.hasMoreElements()) {
            d += ((PolygonI)enumeration2.nextElement()).length();
        }
        return d;
    }

    public PointI nearestPointTo(PointI pointI) {
        double d;
        Rect2I rect2I = null;
        double d2 = Double.POSITIVE_INFINITY;
        Enumeration enumeration = this.vertices();
        LineSegment lineSegment = null;
        PointI pointI2 = null;
        PointI pointI3 = enumeration.hasMoreElements() ? (PointI)enumeration.nextElement() : null;
        PointI pointI4 = pointI3;
        while (enumeration.hasMoreElements()) {
            pointI2 = (PointI)enumeration.nextElement();
            lineSegment = new LineSegment(pointI3, pointI2);
            d = lineSegment.distanceProxyTo(pointI);
            if (d < d2) {
                rect2I = lineSegment;
                d2 = d;
            }
            pointI3 = pointI2;
        }
        if (pointI2 != null && (d = (lineSegment = new LineSegment(pointI2, pointI4)).distanceProxyTo(pointI)) < d2) {
            rect2I = lineSegment;
            d2 = d;
        }
        PointI pointI5 = rect2I == null ? null : rect2I.nearestPointTo(pointI);
        Enumeration enumeration2 = this.holes();
        while (enumeration2.hasMoreElements()) {
            PointI pointI6 = ((PolygonI)enumeration2.nextElement()).nearestPointTo(pointI);
            double d3 = pointI6.distanceProxyTo(pointI);
            if (!(d3 < d2)) continue;
            pointI5 = pointI6;
            d2 = d3;
        }
        return pointI5;
    }

    public PointI point(int n) {
        return (PointI)this._vertices.elementAt(n);
    }

    public RangeI range() {
        Enumeration enumeration = this.vertices();
        if (!enumeration.hasMoreElements()) {
            throw new GeomError("There are no vertices");
        }
        PointI pointI = (PointI)enumeration.nextElement();
        double d = pointI.x();
        double d2 = pointI.x();
        double d3 = pointI.y();
        double d4 = pointI.y();
        while (enumeration.hasMoreElements()) {
            pointI = (PointI)enumeration.nextElement();
            d = Math.min(d, pointI.x());
            d2 = Math.max(d2, pointI.x());
            d3 = Math.min(d3, pointI.y());
            d4 = Math.max(d4, pointI.y());
        }
        return new Range(d, d3, d2, d4);
    }

    public int sizeOfHoles() {
        int n = this._holes.size();
        Enumeration enumeration = this.holes();
        while (enumeration.hasMoreElements()) {
            n += ((PolygonI)enumeration.nextElement()).sizeOfHoles();
        }
        return n;
    }

    public int sizeOfVertices() {
        int n = this._vertices.size();
        Enumeration enumeration = this.holes();
        while (enumeration.hasMoreElements()) {
            n += ((PolygonI)enumeration.nextElement()).sizeOfVertices();
        }
        return n;
    }

    public String toString() {
        return "rect2.Polygon";
    }

    public Enumeration vertices() {
        return this._vertices.elements();
    }
}

