/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.rect2;

import drasys.or.geom.GeomError;
import drasys.or.geom.rect2.Point;
import drasys.or.geom.rect2.PointI;
import drasys.or.geom.rect2.RangeI;
import drasys.or.geom.rect2.Rect2;
import java.io.Serializable;

public class Range
extends Rect2
implements RangeI,
Serializable {
    Point _min;
    Point _max;

    public Range(double d, double d2, double d3, double d4) {
        double d5 = Math.min(d, d3);
        double d6 = Math.max(d, d3);
        double d7 = Math.min(d2, d4);
        double d8 = Math.max(d2, d4);
        this._min = new Point(d5, d7);
        this._max = new Point(d6, d8);
    }

    public Range(PointI pointI, PointI pointI2) {
        this(pointI.x(), pointI.y(), pointI2.x(), pointI2.y());
    }

    public Range(RangeI rangeI) {
        this(rangeI.min(), rangeI.max());
    }

    public PointI bound(PointI pointI) {
        boolean bl = false;
        double d = pointI.x();
        double d2 = pointI.y();
        if (d < this.minX()) {
            d = this.minX();
            bl = true;
        } else if (d > this.maxX()) {
            d = this.maxX();
            bl = true;
        }
        if (d2 < this.minY()) {
            d2 = this.minY();
            bl = true;
        } else if (d2 > this.maxY()) {
            d2 = this.maxY();
            bl = true;
        }
        return bl ? new Point(d, d2) : pointI;
    }

    public drasys.or.geom.PointI boundPoint(drasys.or.geom.PointI pointI) {
        return this.bound((PointI)pointI);
    }

    public PointI centroid() {
        return new Point((this.minX() + this.maxX()) * 0.5, (this.minY() + this.maxY()) * 0.5);
    }

    public double distanceProxyTo(PointI pointI) {
        return pointI.distanceProxyTo(this.nearestPointTo(pointI));
    }

    public double distanceTo(PointI pointI) {
        return pointI.distanceTo(this.nearestPointTo(pointI));
    }

    public boolean equals(Object object) {
        if (!(object instanceof RangeI)) {
            return false;
        }
        RangeI rangeI = (RangeI)object;
        if (!this._min.equals(rangeI.min())) {
            return false;
        }
        return this._max.equals(rangeI.max());
    }

    public drasys.or.geom.RangeI getExpandedRange(drasys.or.geom.PointI pointI) {
        if (this.includes(pointI)) {
            return this;
        }
        PointI pointI2 = (PointI)pointI;
        return new Range(Math.min(this._min.x(), pointI2.x()), Math.min(this._min.y(), pointI2.y()), Math.max(this._max.x(), pointI2.x()), Math.max(this._max.y(), pointI2.y()));
    }

    public drasys.or.geom.PointI getMax() {
        return this.max();
    }

    public drasys.or.geom.PointI getMin() {
        return this.min();
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.minX()) + Double.doubleToLongBits(this.minY()) + Double.doubleToLongBits(this.maxX()) + Double.doubleToLongBits(this.maxY());
        return (int)(l ^ l >> 32);
    }

    public boolean includes(drasys.or.geom.PointI pointI) {
        if (!(pointI instanceof PointI)) {
            throw new GeomError("The point must be on the same coordinate system as the range.");
        }
        PointI pointI2 = (PointI)pointI;
        return this._min.x() <= pointI2.x() && pointI2.x() <= this._max.x() && this._min.y() <= pointI2.y() && pointI2.y() <= this._max.y();
    }

    public PointI lowerLeft() {
        return this.min();
    }

    public PointI lowerRight() {
        return new Point(this.maxX(), this.minY());
    }

    public PointI max() {
        return this._max;
    }

    public double maxX() {
        return this._max.x();
    }

    public double maxY() {
        return this._max.y();
    }

    public PointI min() {
        return this._min;
    }

    public double minX() {
        return this._min.x();
    }

    public double minY() {
        return this._min.y();
    }

    public PointI nearestPointTo(PointI pointI) {
        PointI pointI2 = this.bound(pointI);
        if (pointI2 != pointI) {
            return pointI2;
        }
        double d = pointI2.x();
        double d2 = pointI2.y();
        double d3 = this.maxX() - d;
        double d4 = d - this.minX();
        double d5 = this.maxY() - d2;
        double d6 = d2 - this.minY();
        double d7 = Math.min(Math.min(d3, d4), Math.min(d5, d6));
        if (d3 == d7) {
            return new Point(this.maxX(), d2);
        }
        if (d4 == d7) {
            return new Point(this.minX(), d2);
        }
        if (d5 == d7) {
            return new Point(d, this.maxY());
        }
        return new Point(d, this.minY());
    }

    public RangeI range() {
        return this;
    }

    public String toString() {
        return "rect2.Range{" + this._min.toString() + "; " + this._max.toString() + "}";
    }

    public PointI upperLeft() {
        return new Point(this.minX(), this.maxY());
    }

    public PointI upperRight() {
        return this.max();
    }
}

