/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.rect2;

import drasys.or.geom.CoordinateSystemI;
import drasys.or.geom.GeomError;
import drasys.or.geom.GeomException;
import drasys.or.geom.rect2.CoordinateSystem;
import drasys.or.geom.rect2.Point;
import drasys.or.geom.rect2.PointI;
import drasys.or.geom.rect2.Range;
import drasys.or.geom.rect2.RangeI;
import drasys.or.geom.rect2.TransformI;

public class Transform
implements TransformI {
    double _r11;
    double _r12;
    double _r21;
    double _r22;
    double _tx;
    double _ty;
    double _ir11;
    double _ir12;
    double _ir21;
    double _ir22;
    double _itx;
    double _ity;

    public Transform() {
        this.set(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public Transform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.set(d, d2, d3, d4, d5, d6);
    }

    public Transform(PointI pointI, PointI pointI2, PointI pointI3, PointI pointI4) {
        this(pointI, pointI2, pointI3, pointI4, true);
    }

    public Transform(PointI pointI, PointI pointI2, PointI pointI3, PointI pointI4, boolean bl) {
        double d = (pointI4.x() - pointI3.x()) / (pointI2.x() - pointI.x());
        double d2 = (pointI4.y() - pointI3.y()) / (pointI2.y() - pointI.y());
        if (bl) {
            double d3 = d < 0.0 ? -1.0 : 1.0;
            double d4 = d2 < 0.0 ? -1.0 : 1.0;
            d = d2 = Math.min(Math.abs(d), Math.abs(d2));
            d *= d3;
            d2 *= d4;
        }
        this.set(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.translate(-0.5 * (pointI.x() + pointI2.x()), -0.5 * (pointI.y() + pointI2.y()));
        this.scale(d, d2);
        this.translate(0.5 * (pointI3.x() + pointI4.x()), 0.5 * (pointI3.y() + pointI4.y()));
    }

    public Transform(RangeI rangeI, RangeI rangeI2) {
        this(rangeI, rangeI2, true);
    }

    public Transform(RangeI rangeI, RangeI rangeI2, boolean bl) {
        this(rangeI.min(), rangeI.max(), rangeI2.min(), rangeI2.max(), bl);
    }

    public void combine(TransformI transformI) {
        double d = this._r11 * transformI.r11() + this._r12 * transformI.r21();
        double d2 = this._r11 * transformI.r12() + this._r12 * transformI.r22();
        double d3 = this._r21 * transformI.r11() + this._r22 * transformI.r21();
        double d4 = this._r21 * transformI.r12() + this._r22 * transformI.r22();
        double d5 = this._tx * transformI.r11() + this._ty * transformI.r21() + transformI.tx();
        double d6 = this._tx * transformI.r12() + this._ty * transformI.r22() + transformI.ty();
        this.set(d, d2, d3, d4, d5, d6);
    }

    public PointI forward(PointI pointI) throws GeomException {
        double d = pointI.x();
        double d2 = pointI.y();
        return new Point(d * this._r11 + d2 * this._r21 + this._tx, d * this._r12 + d2 * this._r22 + this._ty);
    }

    public RangeI forward(RangeI rangeI) throws GeomException {
        return new Range(this.forward(rangeI.min()), this.forward(rangeI.max()));
    }

    public drasys.or.geom.PointI forwardTransform(drasys.or.geom.PointI pointI) throws GeomException {
        if (!(pointI instanceof PointI)) {
            throw new GeomError("The argument must be a 'rect2.PointI'.");
        }
        return this.forward((PointI)pointI);
    }

    public drasys.or.geom.RangeI forwardTransform(drasys.or.geom.RangeI rangeI) throws GeomException {
        if (!(rangeI instanceof RangeI)) {
            throw new GeomError("The argument must be a 'rect2.RangeI'.");
        }
        return this.forward((RangeI)rangeI);
    }

    public CoordinateSystemI inputCoordinateSystem() {
        return CoordinateSystem.getInstance();
    }

    public PointI inverse(PointI pointI) throws GeomException {
        double d = pointI.x();
        double d2 = pointI.y();
        return new Point(d * this._ir11 + d2 * this._ir21 + this._itx, d * this._ir12 + d2 * this._ir22 + this._ity);
    }

    public RangeI inverse(RangeI rangeI) throws GeomException {
        return new Range(this.inverse(rangeI.min()), this.inverse(rangeI.max()));
    }

    public drasys.or.geom.PointI inverseTransform(drasys.or.geom.PointI pointI) throws GeomException {
        if (!(pointI instanceof PointI)) {
            throw new GeomError("The argument must be a 'rect2.PointI'.");
        }
        return this.inverse((PointI)pointI);
    }

    public drasys.or.geom.RangeI inverseTransform(drasys.or.geom.RangeI rangeI) throws GeomException {
        if (!(rangeI instanceof RangeI)) {
            throw new GeomError("The argument must be a 'rect2.RangeI'.");
        }
        return this.inverse((RangeI)rangeI);
    }

    public CoordinateSystemI outputCoordinateSystem() {
        return CoordinateSystem.getInstance();
    }

    public double r11() {
        return this._r11;
    }

    public double r12() {
        return this._r12;
    }

    public double r21() {
        return this._r21;
    }

    public double r22() {
        return this._r22;
    }

    public void rotate(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        this.combine(new Transform(d3, d2, -d2, d3, 0.0, 0.0));
    }

    public void scale(double d, double d2) {
        this.combine(new Transform(d, 0.0, 0.0, d2, 0.0, 0.0));
    }

    public void set(double d, double d2, double d3, double d4, double d5, double d6) {
        this._r11 = d;
        this._r12 = d2;
        this._r21 = d3;
        this._r22 = d4;
        this._tx = d5;
        this._ty = d6;
        double d7 = d * d4 - d2 * d3;
        this._ir11 = d4 / d7;
        this._ir21 = -d3 / d7;
        this._itx = (d3 * d6 - d4 * d5) / d7;
        this._ir22 = d / d7;
        this._ir12 = -d2 / d7;
        this._ity = (d2 * d5 - d * d6) / d7;
    }

    public String toString() {
        return "rect2.TranslateScaleRotate(" + this._r11 + ", " + this._r12 + ", " + this._r21 + ", " + this._r22 + ", " + this._tx + ", " + this._ty + ")";
    }

    public void translate(double d, double d2) {
        this.combine(new Transform(1.0, 0.0, 0.0, 1.0, d, d2));
    }

    public double tx() {
        return this._tx;
    }

    public double ty() {
        return this._ty;
    }
}

